/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.memory;

import org.apache.arrow.memory.AllocationManager;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.ReferenceManager;
import org.apache.arrow.memory.util.MemoryUtil;

public class DefaultAllocationManagerFactory
implements AllocationManager.Factory {
    public static final AllocationManager.Factory FACTORY = new DefaultAllocationManagerFactory();
    private static final ArrowBuf EMPTY = new ArrowBuf(ReferenceManager.NO_OP, null, 0L, MemoryUtil.UNSAFE.allocateMemory(0L));

    public AllocationManager create(BufferAllocator accountingAllocator, final long size) {
        return new AllocationManager(accountingAllocator){
            private final long allocatedSize;
            private final long address;
            {
                super(accountingAllocator);
                this.allocatedSize = size;
                this.address = MemoryUtil.UNSAFE.allocateMemory(size);
            }

            public long getSize() {
                return this.allocatedSize;
            }

            protected long memoryAddress() {
                return this.address;
            }

            protected void release0() {
                MemoryUtil.UNSAFE.freeMemory(this.address);
            }
        };
    }

    public ArrowBuf empty() {
        return EMPTY;
    }
}

