/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.memory;

import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.RootAllocator;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ITTestLargeArrowBuf {
    private static final Logger logger = LoggerFactory.getLogger(ITTestLargeArrowBuf.class);

    private void run(long bufSize) {
        try (RootAllocator allocator = new RootAllocator(Long.MAX_VALUE);
             ArrowBuf largeBuf = allocator.buffer(bufSize);){
            long i;
            Assert.assertEquals((long)bufSize, (long)largeBuf.capacity());
            logger.trace("Successfully allocated a buffer with capacity {}", (Object)largeBuf.capacity());
            for (i = 0L; i < bufSize / 8L; ++i) {
                largeBuf.setLong(i * 8L, i);
                if ((i + 1L) % 10000L != 0L) continue;
                logger.trace("Successfully written {} long words", (Object)(i + 1L));
            }
            logger.trace("Successfully written {} long words", (Object)(bufSize / 8L));
            for (i = 0L; i < bufSize / 8L; ++i) {
                long val = largeBuf.getLong(i * 8L);
                Assert.assertEquals((long)i, (long)val);
                if ((i + 1L) % 10000L != 0L) continue;
                logger.trace("Successfully read {} long words", (Object)(i + 1L));
            }
            logger.trace("Successfully read {} long words", (Object)(bufSize / 8L));
        }
        logger.trace("Successfully released the large buffer.");
    }

    @Test
    public void testLargeArrowBuf() {
        this.run(0x100000000L);
    }

    @Test
    public void testMaxIntArrowBuf() {
        this.run(Integer.MAX_VALUE);
    }
}

