/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.memory;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BaseAllocator;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.LoggerFactory;

public class TestArrowBuf {
    @Test(expected=IndexOutOfBoundsException.class)
    public void testSliceOutOfBoundsLength_RaisesIndexOutOfBoundsException() {
        try (RootAllocator allocator = new RootAllocator(128L);
             ArrowBuf buf = allocator.buffer(2L);){
            Assert.assertEquals((long)2L, (long)buf.capacity());
            buf.slice(0L, 3L);
        }
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testSliceOutOfBoundsIndexPlusLength_RaisesIndexOutOfBoundsException() {
        try (RootAllocator allocator = new RootAllocator(128L);
             ArrowBuf buf = allocator.buffer(2L);){
            Assert.assertEquals((long)2L, (long)buf.capacity());
            buf.slice(1L, 2L);
        }
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testSliceOutOfBoundsIndex_RaisesIndexOutOfBoundsException() {
        try (RootAllocator allocator = new RootAllocator(128L);
             ArrowBuf buf = allocator.buffer(2L);){
            Assert.assertEquals((long)2L, (long)buf.capacity());
            buf.slice(3L, 0L);
        }
    }

    @Test
    public void testSliceWithinBoundsLength_ReturnsSlice() {
        try (RootAllocator allocator = new RootAllocator(128L);
             ArrowBuf buf = allocator.buffer(2L);){
            Assert.assertEquals((long)2L, (long)buf.capacity());
            Assert.assertEquals((long)1L, (long)buf.slice(1L, 1L).capacity());
            Assert.assertEquals((long)2L, (long)buf.slice(0L, 2L).capacity());
        }
    }

    @Test
    public void testSetBytesSliced() {
        int arrLength = 64;
        byte[] expected = new byte[arrLength];
        for (int i = 0; i < expected.length; ++i) {
            expected[i] = (byte)i;
        }
        ByteBuffer data = ByteBuffer.wrap(expected);
        try (RootAllocator allocator = new RootAllocator(128L);
             ArrowBuf buf = allocator.buffer((long)expected.length);){
            buf.setBytes(0L, data, 0, data.capacity());
            byte[] actual = new byte[expected.length];
            buf.getBytes(0L, actual);
            Assert.assertArrayEquals((byte[])expected, (byte[])actual);
        }
    }

    @Test
    public void testSetBytesUnsliced() {
        int arrLength = 64;
        byte[] arr = new byte[arrLength];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = (byte)i;
        }
        ByteBuffer data = ByteBuffer.wrap(arr);
        int from = 10;
        int to = arrLength;
        byte[] expected = Arrays.copyOfRange(arr, from, to);
        try (RootAllocator allocator = new RootAllocator(128L);
             ArrowBuf buf = allocator.buffer((long)expected.length);){
            buf.setBytes(0L, data, from, to - from);
            byte[] actual = new byte[expected.length];
            buf.getBytes(0L, actual);
            Assert.assertArrayEquals((byte[])expected, (byte[])actual);
        }
    }

    @Test
    public void testSetBytesBigEndian() {
        byte[] expected = new byte[64];
        for (int i = 0; i < expected.length; ++i) {
            expected[i] = (byte)i;
        }
        ByteBuffer data = ByteBuffer.wrap(expected).asReadOnlyBuffer();
        Assert.assertFalse((boolean)data.hasArray());
        Assert.assertFalse((boolean)data.isDirect());
        Assert.assertEquals((Object)ByteOrder.BIG_ENDIAN, (Object)data.order());
        try (RootAllocator allocator = new RootAllocator(128L);
             ArrowBuf buf = allocator.buffer((long)expected.length);){
            buf.setBytes(0L, data);
            byte[] actual = new byte[expected.length];
            buf.getBytes(0L, actual);
            Assert.assertArrayEquals((byte[])expected, (byte[])actual);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEnabledAssertion() {
        ((Logger)LoggerFactory.getLogger((String)"org.apache.arrow")).setLevel(Level.TRACE);
        try (RootAllocator allocator = new RootAllocator(128L);){
            allocator.buffer(2L);
            Exception e = (Exception)Assert.assertThrows(IllegalStateException.class, () -> TestArrowBuf.lambda$testEnabledAssertion$0((BufferAllocator)allocator));
            Assert.assertFalse((boolean)e.getMessage().contains("event log for:"));
        }
        finally {
            ((Logger)LoggerFactory.getLogger((String)"org.apache.arrow")).setLevel(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEnabledHistoricalLog() {
        ((Logger)LoggerFactory.getLogger((String)"org.apache.arrow")).setLevel(Level.TRACE);
        try {
            Field fieldDebug = BaseAllocator.class.getField("DEBUG");
            fieldDebug.setAccessible(true);
            Field modifiersDebug = Field.class.getDeclaredField("modifiers");
            modifiersDebug.setAccessible(true);
            modifiersDebug.setInt(fieldDebug, fieldDebug.getModifiers() & 0xFFFFFFEF);
            fieldDebug.set(null, true);
            try (RootAllocator allocator = new RootAllocator(128L);){
                allocator.buffer(2L);
                Exception e = (Exception)Assert.assertThrows(IllegalStateException.class, () -> TestArrowBuf.lambda$testEnabledHistoricalLog$1((BufferAllocator)allocator));
                Assert.assertTrue((boolean)e.getMessage().contains("event log for:"));
            }
            finally {
                fieldDebug.set(null, false);
            }
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.toString().contains("java.lang.NoSuchFieldException: modifiers"));
        }
        finally {
            ((Logger)LoggerFactory.getLogger((String)"org.apache.arrow")).setLevel(null);
        }
    }

    private static /* synthetic */ void lambda$testEnabledHistoricalLog$1(BufferAllocator allocator) throws Throwable {
        allocator.close();
    }

    private static /* synthetic */ void lambda$testEnabledAssertion$0(BufferAllocator allocator) throws Throwable {
        allocator.close();
    }
}

