/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.memory;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.read.ListAppender;
import io.netty.buffer.PooledByteBufAllocatorL;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.stream.Collectors;
import org.apache.arrow.memory.AllocationListener;
import org.apache.arrow.memory.AllocationManager;
import org.apache.arrow.memory.AllocationOutcomeDetails;
import org.apache.arrow.memory.AllocationReservation;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BaseAllocator;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.ChildAllocator;
import org.apache.arrow.memory.CountingAllocationListener;
import org.apache.arrow.memory.OutOfMemoryException;
import org.apache.arrow.memory.OwnershipTransferResult;
import org.apache.arrow.memory.ReferenceManager;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.memory.rounding.RoundingPolicy;
import org.apache.arrow.memory.rounding.SegmentRoundingPolicy;
import org.apache.arrow.memory.util.AssertionUtil;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.slf4j.LoggerFactory;
import sun.misc.Unsafe;

public class TestBaseAllocator {
    private static final int MAX_ALLOCATION = 8192;

    @Test
    public void test_privateMax() throws Exception {
        try (RootAllocator rootAllocator = new RootAllocator(8192L);){
            ArrowBuf arrowBuf1 = rootAllocator.buffer(4096L);
            Assert.assertNotNull((String)"allocation failed", (Object)arrowBuf1);
            try (BufferAllocator childAllocator = rootAllocator.newChildAllocator("noLimits", 0L, 8192L);){
                ArrowBuf arrowBuf2 = childAllocator.buffer(4096L);
                Assert.assertNotNull((String)"allocation failed", (Object)arrowBuf2);
                arrowBuf2.getReferenceManager().release();
            }
            arrowBuf1.getReferenceManager().release();
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testRootAllocator_closeWithOutstanding() throws Exception {
        try (RootAllocator rootAllocator = new RootAllocator(8192L);){
            ArrowBuf arrowBuf = rootAllocator.buffer(512L);
            Assert.assertNotNull((String)"allocation failed", (Object)arrowBuf);
        }
    }

    @Test
    public void testRootAllocator_getEmpty() throws Exception {
        try (RootAllocator rootAllocator = new RootAllocator(8192L);){
            ArrowBuf arrowBuf = rootAllocator.buffer(0L);
            Assert.assertNotNull((String)"allocation failed", (Object)arrowBuf);
            Assert.assertEquals((String)"capacity was non-zero", (long)0L, (long)arrowBuf.capacity());
            Assert.assertTrue((String)"address should be valid", (arrowBuf.memoryAddress() != 0L ? 1 : 0) != 0);
            arrowBuf.getReferenceManager().release();
        }
    }

    @Ignore
    @Test(expected=IllegalStateException.class)
    public void testAllocator_unreleasedEmpty() throws Exception {
        try (RootAllocator rootAllocator = new RootAllocator(8192L);){
            ArrowBuf arrowBuf = rootAllocator.buffer(0L);
        }
    }

    @Test
    public void testAllocator_transferOwnership() throws Exception {
        try (RootAllocator rootAllocator = new RootAllocator(8192L);){
            BufferAllocator childAllocator1 = rootAllocator.newChildAllocator("changeOwnership1", 0L, 8192L);
            BufferAllocator childAllocator2 = rootAllocator.newChildAllocator("changeOwnership2", 0L, 8192L);
            ArrowBuf arrowBuf1 = childAllocator1.buffer(2048L);
            rootAllocator.verify();
            ReferenceManager referenceManager = arrowBuf1.getReferenceManager();
            OwnershipTransferResult transferOwnership = referenceManager.transferOwnership(arrowBuf1, childAllocator2);
            this.assertEquiv(arrowBuf1, transferOwnership.getTransferredBuffer());
            boolean allocationFit = transferOwnership.getAllocationFit();
            rootAllocator.verify();
            Assert.assertTrue((boolean)allocationFit);
            arrowBuf1.getReferenceManager().release();
            childAllocator1.close();
            rootAllocator.verify();
            transferOwnership.getTransferredBuffer().getReferenceManager().release();
            childAllocator2.close();
        }
    }

    static <T> boolean equalsIgnoreOrder(Collection<T> c1, Collection<T> c2) {
        return c1.size() == c2.size() && c1.containsAll(c2);
    }

    @Test
    public void testAllocator_getParentAndChild() throws Exception {
        try (RootAllocator rootAllocator = new RootAllocator(8192L);){
            Assert.assertEquals((Object)rootAllocator.getParentAllocator(), null);
            try (BufferAllocator childAllocator1 = rootAllocator.newChildAllocator("child1", 0L, 8192L);){
                Assert.assertEquals((Object)childAllocator1.getParentAllocator(), (Object)rootAllocator);
                Assert.assertTrue((boolean)TestBaseAllocator.equalsIgnoreOrder(Arrays.asList(childAllocator1), rootAllocator.getChildAllocators()));
                try (BufferAllocator childAllocator2 = rootAllocator.newChildAllocator("child2", 0L, 8192L);){
                    Assert.assertEquals((Object)childAllocator2.getParentAllocator(), (Object)rootAllocator);
                    Assert.assertTrue((boolean)TestBaseAllocator.equalsIgnoreOrder(Arrays.asList(childAllocator1, childAllocator2), rootAllocator.getChildAllocators()));
                    try (BufferAllocator grandChildAllocator = childAllocator1.newChildAllocator("grand-child", 0L, 8192L);){
                        Assert.assertEquals((Object)grandChildAllocator.getParentAllocator(), (Object)childAllocator1);
                        Assert.assertTrue((boolean)TestBaseAllocator.equalsIgnoreOrder(Arrays.asList(grandChildAllocator), childAllocator1.getChildAllocators()));
                    }
                }
            }
        }
    }

    @Test
    public void testAllocator_childRemovedOnClose() throws Exception {
        try (RootAllocator rootAllocator = new RootAllocator(8192L);){
            try (BufferAllocator childAllocator1 = rootAllocator.newChildAllocator("child1", 0L, 8192L);){
                try (BufferAllocator childAllocator2 = rootAllocator.newChildAllocator("child2", 0L, 8192L);){
                    Assert.assertTrue((boolean)TestBaseAllocator.equalsIgnoreOrder(Arrays.asList(childAllocator1, childAllocator2), rootAllocator.getChildAllocators()));
                    try (BufferAllocator grandChildAllocator = childAllocator1.newChildAllocator("grand-child", 0L, 8192L);){
                        Assert.assertTrue((boolean)TestBaseAllocator.equalsIgnoreOrder(Arrays.asList(grandChildAllocator), childAllocator1.getChildAllocators()));
                    }
                    Assert.assertTrue((boolean)TestBaseAllocator.equalsIgnoreOrder(Collections.EMPTY_SET, childAllocator1.getChildAllocators()));
                }
                Assert.assertTrue((boolean)TestBaseAllocator.equalsIgnoreOrder(Arrays.asList(childAllocator1), rootAllocator.getChildAllocators()));
            }
            Assert.assertTrue((boolean)TestBaseAllocator.equalsIgnoreOrder(Collections.EMPTY_SET, rootAllocator.getChildAllocators()));
        }
    }

    @Test
    public void testAllocator_shareOwnership() throws Exception {
        try (RootAllocator rootAllocator = new RootAllocator(8192L);){
            BufferAllocator childAllocator1 = rootAllocator.newChildAllocator("shareOwnership1", 0L, 8192L);
            BufferAllocator childAllocator2 = rootAllocator.newChildAllocator("shareOwnership2", 0L, 8192L);
            ArrowBuf arrowBuf1 = childAllocator1.buffer(2048L);
            rootAllocator.verify();
            ArrowBuf arrowBuf2 = arrowBuf1.getReferenceManager().retain(arrowBuf1, childAllocator2);
            rootAllocator.verify();
            Assert.assertNotNull((Object)arrowBuf2);
            Assert.assertNotEquals((Object)arrowBuf2, (Object)arrowBuf1);
            this.assertEquiv(arrowBuf1, arrowBuf2);
            arrowBuf1.getReferenceManager().release();
            rootAllocator.verify();
            childAllocator1.close();
            rootAllocator.verify();
            BufferAllocator childAllocator3 = rootAllocator.newChildAllocator("shareOwnership3", 0L, 8192L);
            ArrowBuf arrowBuf3 = arrowBuf1.getReferenceManager().retain(arrowBuf1, childAllocator3);
            Assert.assertNotNull((Object)arrowBuf3);
            Assert.assertNotEquals((Object)arrowBuf3, (Object)arrowBuf1);
            Assert.assertNotEquals((Object)arrowBuf3, (Object)arrowBuf2);
            this.assertEquiv(arrowBuf1, arrowBuf3);
            rootAllocator.verify();
            arrowBuf2.getReferenceManager().release();
            rootAllocator.verify();
            childAllocator2.close();
            rootAllocator.verify();
            arrowBuf3.getReferenceManager().release();
            rootAllocator.verify();
            childAllocator3.close();
        }
    }

    @Test
    public void testRootAllocator_createChildAndUse() throws Exception {
        try (RootAllocator rootAllocator = new RootAllocator(8192L);
             BufferAllocator childAllocator = rootAllocator.newChildAllocator("createChildAndUse", 0L, 8192L);){
            ArrowBuf arrowBuf = childAllocator.buffer(512L);
            Assert.assertNotNull((String)"allocation failed", (Object)arrowBuf);
            arrowBuf.getReferenceManager().release();
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testRootAllocator_createChildDontClose() throws Exception {
        try (RootAllocator rootAllocator = new RootAllocator(8192L);){
            BufferAllocator childAllocator = rootAllocator.newChildAllocator("createChildDontClose", 0L, 8192L);
            ArrowBuf arrowBuf = childAllocator.buffer(512L);
            Assert.assertNotNull((String)"allocation failed", (Object)arrowBuf);
        }
    }

    @Test
    public void testSegmentAllocator() {
        SegmentRoundingPolicy policy = new SegmentRoundingPolicy(1024);
        try (RootAllocator allocator = new RootAllocator(AllocationListener.NOOP, 0x100000L, (RoundingPolicy)policy);){
            ArrowBuf buf = allocator.buffer(798L);
            Assert.assertEquals((long)1024L, (long)buf.capacity());
            buf.setInt(333L, 959);
            Assert.assertEquals((long)959L, (long)buf.getInt(333L));
            buf.close();
            buf = allocator.buffer(1025L);
            Assert.assertEquals((long)2048L, (long)buf.capacity());
            buf.setInt(193L, 939);
            Assert.assertEquals((long)939L, (long)buf.getInt(193L));
            buf.close();
        }
    }

    @Test
    public void testSegmentAllocator_childAllocator() {
        SegmentRoundingPolicy policy = new SegmentRoundingPolicy(1024);
        try (RootAllocator allocator = new RootAllocator(AllocationListener.NOOP, 0x100000L, (RoundingPolicy)policy);
             BufferAllocator childAllocator = allocator.newChildAllocator("child", 0L, 524288L);){
            Assert.assertEquals((Object)"child", (Object)childAllocator.getName());
            ArrowBuf buf = childAllocator.buffer(798L);
            Assert.assertEquals((long)1024L, (long)buf.capacity());
            buf.setInt(333L, 959);
            Assert.assertEquals((long)959L, (long)buf.getInt(333L));
            buf.close();
            buf = childAllocator.buffer(1025L);
            Assert.assertEquals((long)2048L, (long)buf.capacity());
            buf.setInt(193L, 939);
            Assert.assertEquals((long)939L, (long)buf.getInt(193L));
            buf.close();
        }
    }

    @Test
    public void testSegmentAllocator_smallSegment() {
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> new SegmentRoundingPolicy(128));
        Assert.assertEquals((Object)"The segment size cannot be smaller than 1024", (Object)e.getMessage());
    }

    @Test
    public void testSegmentAllocator_segmentSizeNotPowerOf2() {
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> new SegmentRoundingPolicy(4097));
        Assert.assertEquals((Object)"The segment size must be a power of 2", (Object)e.getMessage());
    }

    @Test
    public void testCustomizedAllocationManager() {
        try (BaseAllocator allocator = this.createAllocatorWithCustomizedAllocationManager();){
            ArrowBuf arrowBuf1 = allocator.buffer(8192L);
            Assert.assertNotNull((String)"allocation failed", (Object)arrowBuf1);
            arrowBuf1.setInt(0L, 1);
            Assert.assertEquals((long)1L, (long)arrowBuf1.getInt(0L));
            try {
                ArrowBuf arrowBuf2 = allocator.buffer(1L);
                Assert.fail((String)"allocated memory beyond max allowed");
            }
            catch (OutOfMemoryException outOfMemoryException) {
                // empty catch block
            }
            arrowBuf1.getReferenceManager().release();
            try {
                arrowBuf1.getInt(0L);
                Assert.fail((String)"data read from released buffer");
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    private BaseAllocator createAllocatorWithCustomizedAllocationManager() {
        return new RootAllocator((BaseAllocator.Config)BaseAllocator.configBuilder().maxAllocation(8192L).allocationManagerFactory(new AllocationManager.Factory(){

            public AllocationManager create(BufferAllocator accountingAllocator, final long requestedSize) {
                return new AllocationManager(accountingAllocator){
                    private final Unsafe unsafe;
                    private final long address;
                    {
                        super(accountingAllocator);
                        this.unsafe = this.getUnsafe();
                        this.address = this.unsafe.allocateMemory(requestedSize);
                    }

                    protected long memoryAddress() {
                        return this.address;
                    }

                    protected void release0() {
                        this.unsafe.setMemory(this.address, requestedSize, (byte)0);
                        this.unsafe.freeMemory(this.address);
                    }

                    public long getSize() {
                        return requestedSize;
                    }

                    private Unsafe getUnsafe() {
                        Field f = null;
                        try {
                            f = Unsafe.class.getDeclaredField("theUnsafe");
                            f.setAccessible(true);
                            Unsafe unsafe = (Unsafe)f.get(null);
                            return unsafe;
                        }
                        catch (IllegalAccessException | NoSuchFieldException e) {
                            throw new RuntimeException(e);
                        }
                        finally {
                            if (f != null) {
                                f.setAccessible(false);
                            }
                        }
                    }
                };
            }

            public ArrowBuf empty() {
                return null;
            }
        }).build());
    }

    @Test
    public void testRootAllocator_listeners() throws Exception {
        CountingAllocationListener l1 = new CountingAllocationListener();
        Assert.assertEquals((long)0L, (long)l1.getNumPreCalls());
        Assert.assertEquals((long)0L, (long)l1.getNumCalls());
        Assert.assertEquals((long)0L, (long)l1.getNumReleaseCalls());
        Assert.assertEquals((long)0L, (long)l1.getNumChildren());
        Assert.assertEquals((long)0L, (long)l1.getTotalMem());
        CountingAllocationListener l2 = new CountingAllocationListener();
        Assert.assertEquals((long)0L, (long)l2.getNumPreCalls());
        Assert.assertEquals((long)0L, (long)l2.getNumCalls());
        Assert.assertEquals((long)0L, (long)l2.getNumReleaseCalls());
        Assert.assertEquals((long)0L, (long)l2.getNumChildren());
        Assert.assertEquals((long)0L, (long)l2.getTotalMem());
        try (RootAllocator rootAllocator = new RootAllocator((AllocationListener)l1, 8192L);){
            try (BufferAllocator c1 = rootAllocator.newChildAllocator("c1", 0L, 8192L);){
                Assert.assertEquals((long)1L, (long)l1.getNumChildren());
                ArrowBuf buf1 = c1.buffer(16L);
                Assert.assertNotNull((String)"allocation failed", (Object)buf1);
                Assert.assertEquals((long)1L, (long)l1.getNumPreCalls());
                Assert.assertEquals((long)1L, (long)l1.getNumCalls());
                Assert.assertEquals((long)0L, (long)l1.getNumReleaseCalls());
                Assert.assertEquals((long)16L, (long)l1.getTotalMem());
                buf1.getReferenceManager().release();
                try (BufferAllocator c2 = c1.newChildAllocator("c2", (AllocationListener)l2, 0L, 8192L);){
                    Assert.assertEquals((long)2L, (long)l1.getNumChildren());
                    Assert.assertEquals((long)0L, (long)l2.getNumChildren());
                    ArrowBuf buf2 = c2.buffer(32L);
                    Assert.assertNotNull((String)"allocation failed", (Object)buf2);
                    Assert.assertEquals((long)1L, (long)l1.getNumCalls());
                    Assert.assertEquals((long)16L, (long)l1.getTotalMem());
                    Assert.assertEquals((long)1L, (long)l2.getNumPreCalls());
                    Assert.assertEquals((long)1L, (long)l2.getNumCalls());
                    Assert.assertEquals((long)0L, (long)l2.getNumReleaseCalls());
                    Assert.assertEquals((long)32L, (long)l2.getTotalMem());
                    buf2.getReferenceManager().release();
                    try (BufferAllocator c3 = c2.newChildAllocator("c3", 0L, 8192L);){
                        Assert.assertEquals((long)2L, (long)l1.getNumChildren());
                        Assert.assertEquals((long)1L, (long)l2.getNumChildren());
                        ArrowBuf buf3 = c3.buffer(64L);
                        Assert.assertNotNull((String)"allocation failed", (Object)buf3);
                        Assert.assertEquals((long)1L, (long)l1.getNumPreCalls());
                        Assert.assertEquals((long)1L, (long)l1.getNumCalls());
                        Assert.assertEquals((long)1L, (long)l1.getNumReleaseCalls());
                        Assert.assertEquals((long)16L, (long)l1.getTotalMem());
                        Assert.assertEquals((long)2L, (long)l2.getNumPreCalls());
                        Assert.assertEquals((long)2L, (long)l2.getNumCalls());
                        Assert.assertEquals((long)1L, (long)l2.getNumReleaseCalls());
                        Assert.assertEquals((long)96L, (long)l2.getTotalMem());
                        buf3.getReferenceManager().release();
                    }
                    Assert.assertEquals((long)2L, (long)l1.getNumChildren());
                    Assert.assertEquals((long)0L, (long)l2.getNumChildren());
                }
                Assert.assertEquals((long)1L, (long)l1.getNumChildren());
                Assert.assertEquals((long)0L, (long)l2.getNumChildren());
            }
            Assert.assertEquals((long)0L, (long)l1.getNumChildren());
            Assert.assertEquals((long)2L, (long)l2.getNumReleaseCalls());
        }
    }

    @Test
    public void testRootAllocator_listenerAllocationFail() throws Exception {
        CountingAllocationListener l1 = new CountingAllocationListener();
        Assert.assertEquals((long)0L, (long)l1.getNumCalls());
        Assert.assertEquals((long)0L, (long)l1.getTotalMem());
        try (RootAllocator rootAllocator = new RootAllocator(8192L);
             BufferAllocator c1 = rootAllocator.newChildAllocator("c1", (AllocationListener)l1, 0L, 4096L);){
            try {
                c1.buffer(8192L);
                Assert.fail((String)"allocated memory beyond max allowed");
            }
            catch (OutOfMemoryException outOfMemoryException) {
                // empty catch block
            }
            Assert.assertEquals((long)0L, (long)l1.getNumCalls());
            Assert.assertEquals((long)0L, (long)l1.getTotalMem());
            l1.setExpandOnFail(c1, 8192L);
            ArrowBuf arrowBuf = c1.buffer(8192L);
            Assert.assertNotNull((String)"allocation failed", (Object)arrowBuf);
            Assert.assertEquals((long)1L, (long)l1.getNumCalls());
            Assert.assertEquals((long)8192L, (long)l1.getTotalMem());
            arrowBuf.getReferenceManager().release();
        }
    }

    private static void allocateAndFree(BufferAllocator allocator) {
        ArrowBuf arrowBuf = allocator.buffer(512L);
        Assert.assertNotNull((String)"allocation failed", (Object)arrowBuf);
        arrowBuf.getReferenceManager().release();
        ArrowBuf arrowBuf2 = allocator.buffer(8192L);
        Assert.assertNotNull((String)"allocation failed", (Object)arrowBuf2);
        arrowBuf2.getReferenceManager().release();
        int nBufs = 8;
        ArrowBuf[] arrowBufs = new ArrowBuf[8];
        for (int i = 0; i < arrowBufs.length; ++i) {
            ArrowBuf arrowBufi = allocator.buffer(1024L);
            Assert.assertNotNull((String)"allocation failed", (Object)arrowBufi);
            arrowBufs[i] = arrowBufi;
        }
        for (ArrowBuf arrowBufi : arrowBufs) {
            arrowBufi.getReferenceManager().release();
        }
    }

    @Test
    public void testAllocator_manyAllocations() throws Exception {
        try (RootAllocator rootAllocator = new RootAllocator(8192L);
             BufferAllocator childAllocator = rootAllocator.newChildAllocator("manyAllocations", 0L, 8192L);){
            TestBaseAllocator.allocateAndFree(childAllocator);
        }
    }

    @Test
    public void testAllocator_overAllocate() throws Exception {
        try (RootAllocator rootAllocator = new RootAllocator(8192L);
             BufferAllocator childAllocator = rootAllocator.newChildAllocator("overAllocate", 0L, 8192L);){
            TestBaseAllocator.allocateAndFree(childAllocator);
            try {
                childAllocator.buffer(8193L);
                Assert.fail((String)"allocated memory beyond max allowed");
            }
            catch (OutOfMemoryException outOfMemoryException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testAllocator_overAllocateParent() throws Exception {
        try (RootAllocator rootAllocator = new RootAllocator(8192L);
             BufferAllocator childAllocator = rootAllocator.newChildAllocator("overAllocateParent", 0L, 8192L);){
            ArrowBuf arrowBuf1 = rootAllocator.buffer(4096L);
            Assert.assertNotNull((String)"allocation failed", (Object)arrowBuf1);
            ArrowBuf arrowBuf2 = childAllocator.buffer(4096L);
            Assert.assertNotNull((String)"allocation failed", (Object)arrowBuf2);
            try {
                childAllocator.buffer(2048L);
                Assert.fail((String)"allocated memory beyond max allowed");
            }
            catch (OutOfMemoryException outOfMemoryException) {
                // empty catch block
            }
            arrowBuf1.getReferenceManager().release();
            arrowBuf2.getReferenceManager().release();
        }
    }

    @Test
    public void testAllocator_failureAtParentLimitOutcomeDetails() throws Exception {
        try (RootAllocator rootAllocator = new RootAllocator(8192L);
             BufferAllocator childAllocator = rootAllocator.newChildAllocator("child", 0L, 4096L);
             BufferAllocator grandChildAllocator = childAllocator.newChildAllocator("grandchild", 2048L, 8192L);){
            OutOfMemoryException e = (OutOfMemoryException)Assertions.assertThrows(OutOfMemoryException.class, () -> grandChildAllocator.buffer(8192L));
            Assert.assertTrue((boolean)e.getMessage().contains("Unable to allocate buffer"));
            Assert.assertTrue((String)"missing outcome details", (boolean)e.getOutcomeDetails().isPresent());
            AllocationOutcomeDetails outcomeDetails = (AllocationOutcomeDetails)e.getOutcomeDetails().get();
            Assert.assertEquals((Object)outcomeDetails.getFailedAllocator(), (Object)childAllocator);
            Iterator iterator = outcomeDetails.allocEntries.iterator();
            AllocationOutcomeDetails.Entry first = (AllocationOutcomeDetails.Entry)iterator.next();
            Assert.assertEquals((long)2048L, (long)first.getAllocatedSize());
            Assert.assertEquals((long)8192L, (long)first.getRequestedSize());
            Assert.assertEquals((Object)false, (Object)first.isAllocationFailed());
            AllocationOutcomeDetails.Entry second = (AllocationOutcomeDetails.Entry)iterator.next();
            Assert.assertEquals((long)6144L, (long)second.getRequestedSize());
            Assert.assertEquals((long)0L, (long)second.getAllocatedSize());
            Assert.assertEquals((Object)true, (Object)second.isAllocationFailed());
            Assertions.assertFalse((boolean)iterator.hasNext());
        }
    }

    @Test
    public void testAllocator_failureAtRootLimitOutcomeDetails() throws Exception {
        try (RootAllocator rootAllocator = new RootAllocator(8192L);
             BufferAllocator childAllocator = rootAllocator.newChildAllocator("child", 4096L, Long.MAX_VALUE);
             BufferAllocator grandChildAllocator = childAllocator.newChildAllocator("grandchild", 2048L, Long.MAX_VALUE);){
            OutOfMemoryException e = (OutOfMemoryException)Assertions.assertThrows(OutOfMemoryException.class, () -> grandChildAllocator.buffer(16384L));
            Assert.assertTrue((boolean)e.getMessage().contains("Unable to allocate buffer"));
            Assert.assertTrue((String)"missing outcome details", (boolean)e.getOutcomeDetails().isPresent());
            AllocationOutcomeDetails outcomeDetails = (AllocationOutcomeDetails)e.getOutcomeDetails().get();
            Assert.assertEquals((Object)outcomeDetails.getFailedAllocator(), (Object)rootAllocator);
            Iterator iterator = outcomeDetails.allocEntries.iterator();
            AllocationOutcomeDetails.Entry first = (AllocationOutcomeDetails.Entry)iterator.next();
            Assert.assertEquals((long)2048L, (long)first.getAllocatedSize());
            Assert.assertEquals((long)16384L, (long)first.getRequestedSize());
            Assert.assertEquals((Object)false, (Object)first.isAllocationFailed());
            AllocationOutcomeDetails.Entry second = (AllocationOutcomeDetails.Entry)iterator.next();
            Assert.assertEquals((long)2048L, (long)second.getAllocatedSize());
            Assert.assertEquals((long)14336L, (long)second.getRequestedSize());
            Assert.assertEquals((Object)false, (Object)second.isAllocationFailed());
            AllocationOutcomeDetails.Entry third = (AllocationOutcomeDetails.Entry)iterator.next();
            Assert.assertEquals((long)0L, (long)third.getAllocatedSize());
            Assert.assertEquals((Object)true, (Object)third.isAllocationFailed());
            Assertions.assertFalse((boolean)iterator.hasNext());
        }
    }

    private static void testAllocator_sliceUpBufferAndRelease(RootAllocator rootAllocator, BufferAllocator bufferAllocator) {
        ArrowBuf arrowBuf1 = bufferAllocator.buffer(4096L);
        rootAllocator.verify();
        ArrowBuf arrowBuf2 = arrowBuf1.slice(16L, arrowBuf1.capacity() - 32L);
        rootAllocator.verify();
        ArrowBuf arrowBuf3 = arrowBuf2.slice(16L, arrowBuf2.capacity() - 32L);
        rootAllocator.verify();
        ArrowBuf arrowBuf4 = arrowBuf3.slice(16L, arrowBuf3.capacity() - 32L);
        rootAllocator.verify();
        arrowBuf3.getReferenceManager().release();
        rootAllocator.verify();
    }

    @Test
    public void testAllocator_createSlices() throws Exception {
        try (RootAllocator rootAllocator = new RootAllocator(8192L);){
            TestBaseAllocator.testAllocator_sliceUpBufferAndRelease(rootAllocator, (BufferAllocator)rootAllocator);
            try (BufferAllocator childAllocator = rootAllocator.newChildAllocator("createSlices", 0L, 8192L);){
                TestBaseAllocator.testAllocator_sliceUpBufferAndRelease(rootAllocator, childAllocator);
            }
            rootAllocator.verify();
            TestBaseAllocator.testAllocator_sliceUpBufferAndRelease(rootAllocator, (BufferAllocator)rootAllocator);
            childAllocator = rootAllocator.newChildAllocator("createSlices", 0L, 8192L);
            var4_5 = null;
            try {
                try (BufferAllocator childAllocator2 = childAllocator.newChildAllocator("createSlices", 0L, 8192L);){
                    ArrowBuf arrowBuf1 = childAllocator2.buffer(1024L);
                    ArrowBuf arrowBuf2 = arrowBuf1.slice(512L, 512L);
                    TestBaseAllocator.testAllocator_sliceUpBufferAndRelease(rootAllocator, childAllocator);
                    arrowBuf1.getReferenceManager().release();
                    rootAllocator.verify();
                }
                rootAllocator.verify();
                TestBaseAllocator.testAllocator_sliceUpBufferAndRelease(rootAllocator, childAllocator);
            }
            catch (Throwable throwable) {
                var4_5 = throwable;
                throw throwable;
            }
            finally {
                if (childAllocator != null) {
                    TestBaseAllocator.$closeResource(var4_5, (AutoCloseable)childAllocator);
                }
            }
            rootAllocator.verify();
        }
    }

    @Test
    public void testAllocator_sliceRanges() throws Exception {
        try (RootAllocator rootAllocator = new RootAllocator(8192L);){
            int i;
            ArrowBuf arrowBuf = rootAllocator.buffer(256L);
            Assert.assertEquals((long)256L, (long)arrowBuf.capacity());
            Assert.assertEquals((long)0L, (long)arrowBuf.readerIndex());
            Assert.assertEquals((long)0L, (long)arrowBuf.readableBytes());
            Assert.assertEquals((long)0L, (long)arrowBuf.writerIndex());
            Assert.assertEquals((long)256L, (long)arrowBuf.writableBytes());
            ArrowBuf slice3 = arrowBuf.slice();
            Assert.assertEquals((long)0L, (long)slice3.readerIndex());
            Assert.assertEquals((long)0L, (long)slice3.readableBytes());
            Assert.assertEquals((long)0L, (long)slice3.writerIndex());
            for (int i2 = 0; i2 < 256; ++i2) {
                arrowBuf.writeByte(i2);
            }
            Assert.assertEquals((long)0L, (long)arrowBuf.readerIndex());
            Assert.assertEquals((long)256L, (long)arrowBuf.readableBytes());
            Assert.assertEquals((long)256L, (long)arrowBuf.writerIndex());
            Assert.assertEquals((long)0L, (long)arrowBuf.writableBytes());
            ArrowBuf slice1 = arrowBuf.slice();
            Assert.assertEquals((long)0L, (long)slice1.readerIndex());
            Assert.assertEquals((long)256L, (long)slice1.readableBytes());
            for (i = 0; i < 10; ++i) {
                Assert.assertEquals((long)i, (long)slice1.readByte());
            }
            Assert.assertEquals((long)246L, (long)slice1.readableBytes());
            for (i = 0; i < 256; ++i) {
                Assert.assertEquals((long)((byte)i), (long)slice1.getByte((long)i));
            }
            ArrowBuf slice2 = arrowBuf.slice(25L, 25L);
            Assert.assertEquals((long)0L, (long)slice2.readerIndex());
            Assert.assertEquals((long)25L, (long)slice2.readableBytes());
            for (int i3 = 25; i3 < 50; ++i3) {
                Assert.assertEquals((long)i3, (long)slice2.readByte());
            }
            arrowBuf.getReferenceManager().release();
        }
    }

    @Test
    public void testAllocator_slicesOfSlices() throws Exception {
        try (RootAllocator rootAllocator = new RootAllocator(8192L);){
            ArrowBuf arrowBuf = rootAllocator.buffer(256L);
            for (int i = 0; i < 256; ++i) {
                arrowBuf.writeByte(i);
            }
            ArrowBuf slice0 = arrowBuf.slice(0L, arrowBuf.capacity());
            for (int i = 0; i < 256; ++i) {
                Assert.assertEquals((long)((byte)i), (long)arrowBuf.getByte((long)i));
            }
            ArrowBuf slice10 = slice0.slice(10L, arrowBuf.capacity() - 10L);
            for (int i = 10; i < 256; ++i) {
                Assert.assertEquals((long)((byte)i), (long)slice10.getByte((long)(i - 10)));
            }
            ArrowBuf slice20 = slice10.slice(10L, arrowBuf.capacity() - 20L);
            for (int i = 20; i < 256; ++i) {
                Assert.assertEquals((long)((byte)i), (long)slice20.getByte((long)(i - 20)));
            }
            ArrowBuf slice30 = slice20.slice(10L, arrowBuf.capacity() - 30L);
            for (int i = 30; i < 256; ++i) {
                Assert.assertEquals((long)((byte)i), (long)slice30.getByte((long)(i - 30)));
            }
            arrowBuf.getReferenceManager().release();
        }
    }

    @Test
    public void testAllocator_transferSliced() throws Exception {
        try (RootAllocator rootAllocator = new RootAllocator(8192L);){
            BufferAllocator childAllocator1 = rootAllocator.newChildAllocator("transferSliced1", 0L, 8192L);
            BufferAllocator childAllocator2 = rootAllocator.newChildAllocator("transferSliced2", 0L, 8192L);
            ArrowBuf arrowBuf1 = childAllocator1.buffer(1024L);
            ArrowBuf arrowBuf2 = childAllocator2.buffer(1024L);
            ArrowBuf arrowBuf1s = arrowBuf1.slice(0L, arrowBuf1.capacity() / 2L);
            ArrowBuf arrowBuf2s = arrowBuf2.slice(0L, arrowBuf2.capacity() / 2L);
            rootAllocator.verify();
            OwnershipTransferResult result1 = arrowBuf2s.getReferenceManager().transferOwnership(arrowBuf2s, childAllocator1);
            this.assertEquiv(arrowBuf2s, result1.getTransferredBuffer());
            rootAllocator.verify();
            OwnershipTransferResult result2 = arrowBuf1s.getReferenceManager().transferOwnership(arrowBuf1s, childAllocator2);
            this.assertEquiv(arrowBuf1s, result2.getTransferredBuffer());
            rootAllocator.verify();
            result1.getTransferredBuffer().getReferenceManager().release();
            result2.getTransferredBuffer().getReferenceManager().release();
            arrowBuf1s.getReferenceManager().release();
            arrowBuf2s.getReferenceManager().release();
            childAllocator1.close();
            childAllocator2.close();
        }
    }

    @Test
    public void testAllocator_shareSliced() throws Exception {
        try (RootAllocator rootAllocator = new RootAllocator(8192L);){
            BufferAllocator childAllocator1 = rootAllocator.newChildAllocator("transferSliced", 0L, 8192L);
            BufferAllocator childAllocator2 = rootAllocator.newChildAllocator("transferSliced", 0L, 8192L);
            ArrowBuf arrowBuf1 = childAllocator1.buffer(1024L);
            ArrowBuf arrowBuf2 = childAllocator2.buffer(1024L);
            ArrowBuf arrowBuf1s = arrowBuf1.slice(0L, arrowBuf1.capacity() / 2L);
            ArrowBuf arrowBuf2s = arrowBuf2.slice(0L, arrowBuf2.capacity() / 2L);
            rootAllocator.verify();
            ArrowBuf arrowBuf2s1 = arrowBuf2s.getReferenceManager().retain(arrowBuf2s, childAllocator1);
            this.assertEquiv(arrowBuf2s, arrowBuf2s1);
            ArrowBuf arrowBuf1s2 = arrowBuf1s.getReferenceManager().retain(arrowBuf1s, childAllocator2);
            this.assertEquiv(arrowBuf1s, arrowBuf1s2);
            rootAllocator.verify();
            arrowBuf1s.getReferenceManager().release();
            arrowBuf2s.getReferenceManager().release();
            rootAllocator.verify();
            arrowBuf2s1.getReferenceManager().release();
            arrowBuf1s2.getReferenceManager().release();
            childAllocator1.close();
            childAllocator2.close();
        }
    }

    @Test
    public void testAllocator_transferShared() throws Exception {
        try (RootAllocator rootAllocator = new RootAllocator(8192L);){
            BufferAllocator childAllocator1 = rootAllocator.newChildAllocator("transferShared1", 0L, 8192L);
            BufferAllocator childAllocator2 = rootAllocator.newChildAllocator("transferShared2", 0L, 8192L);
            BufferAllocator childAllocator3 = rootAllocator.newChildAllocator("transferShared3", 0L, 8192L);
            ArrowBuf arrowBuf1 = childAllocator1.buffer(1024L);
            ArrowBuf arrowBuf2 = arrowBuf1.getReferenceManager().retain(arrowBuf1, childAllocator2);
            rootAllocator.verify();
            Assert.assertNotNull((Object)arrowBuf2);
            Assert.assertNotEquals((Object)arrowBuf2, (Object)arrowBuf1);
            this.assertEquiv(arrowBuf1, arrowBuf2);
            ReferenceManager refManager1 = arrowBuf1.getReferenceManager();
            OwnershipTransferResult result1 = refManager1.transferOwnership(arrowBuf1, childAllocator3);
            boolean allocationFit = result1.getAllocationFit();
            ArrowBuf arrowBuf3 = result1.getTransferredBuffer();
            Assert.assertTrue((boolean)allocationFit);
            this.assertEquiv(arrowBuf1, arrowBuf3);
            rootAllocator.verify();
            arrowBuf1.getReferenceManager().release();
            childAllocator1.close();
            rootAllocator.verify();
            arrowBuf2.getReferenceManager().release();
            childAllocator2.close();
            rootAllocator.verify();
            BufferAllocator childAllocator4 = rootAllocator.newChildAllocator("transferShared4", 0L, 8192L);
            ReferenceManager refManager3 = arrowBuf3.getReferenceManager();
            OwnershipTransferResult result3 = refManager3.transferOwnership(arrowBuf3, childAllocator4);
            allocationFit = result3.getAllocationFit();
            ArrowBuf arrowBuf4 = result3.getTransferredBuffer();
            Assert.assertTrue((boolean)allocationFit);
            this.assertEquiv(arrowBuf3, arrowBuf4);
            rootAllocator.verify();
            arrowBuf3.getReferenceManager().release();
            childAllocator3.close();
            rootAllocator.verify();
            arrowBuf4.getReferenceManager().release();
            childAllocator4.close();
            rootAllocator.verify();
        }
    }

    @Test
    public void testAllocator_unclaimedReservation() throws Exception {
        try (RootAllocator rootAllocator = new RootAllocator(8192L);
             BufferAllocator childAllocator1 = rootAllocator.newChildAllocator("unclaimedReservation", 0L, 8192L);){
            try (AllocationReservation reservation = childAllocator1.newReservation();){
                Assert.assertTrue((boolean)reservation.add(64));
            }
            rootAllocator.verify();
        }
    }

    @Test
    public void testAllocator_claimedReservation() throws Exception {
        try (RootAllocator rootAllocator = new RootAllocator(8192L);
             BufferAllocator childAllocator1 = rootAllocator.newChildAllocator("claimedReservation", 0L, 8192L);){
            try (AllocationReservation reservation = childAllocator1.newReservation();){
                Assert.assertTrue((boolean)reservation.add(32));
                Assert.assertTrue((boolean)reservation.add(32));
                ArrowBuf arrowBuf = reservation.allocateBuffer();
                Assert.assertEquals((long)64L, (long)arrowBuf.capacity());
                rootAllocator.verify();
                arrowBuf.getReferenceManager().release();
                rootAllocator.verify();
            }
            rootAllocator.verify();
        }
    }

    @Test
    public void testInitReservationAndLimit() throws Exception {
        try (RootAllocator rootAllocator = new RootAllocator(8192L);
             BufferAllocator childAllocator = rootAllocator.newChildAllocator("child", 2048L, 4096L);){
            Assert.assertEquals((long)2048L, (long)childAllocator.getInitReservation());
            Assert.assertEquals((long)4096L, (long)childAllocator.getLimit());
        }
    }

    @Test
    public void multiple() throws Exception {
        String owner = "test";
        try (RootAllocator allocator = new RootAllocator(Long.MAX_VALUE);){
            int op = 100000;
            BufferAllocator frag1 = allocator.newChildAllocator("test", 1500000L, Long.MAX_VALUE);
            BufferAllocator frag2 = allocator.newChildAllocator("test", 500000L, Long.MAX_VALUE);
            allocator.verify();
            BufferAllocator allocator11 = frag1.newChildAllocator("test", 100000L, Long.MAX_VALUE);
            ArrowBuf b11 = allocator11.buffer(1000000L);
            allocator.verify();
            BufferAllocator allocator12 = frag1.newChildAllocator("test", 100000L, Long.MAX_VALUE);
            ArrowBuf b12 = allocator12.buffer(500000L);
            allocator.verify();
            BufferAllocator allocator21 = frag1.newChildAllocator("test", 100000L, Long.MAX_VALUE);
            allocator.verify();
            BufferAllocator allocator22 = frag2.newChildAllocator("test", 100000L, Long.MAX_VALUE);
            ArrowBuf b22 = allocator22.buffer(2000000L);
            allocator.verify();
            BufferAllocator frag3 = allocator.newChildAllocator("test", 1000000L, Long.MAX_VALUE);
            allocator.verify();
            BufferAllocator allocator31 = frag3.newChildAllocator("test", 100000L, Long.MAX_VALUE);
            ArrowBuf b31a = allocator31.buffer(200000L);
            allocator.verify();
            b22.getReferenceManager().release();
            allocator.verify();
            allocator22.close();
            b31a.getReferenceManager().release();
            allocator31.close();
            b12.getReferenceManager().release();
            allocator12.close();
            allocator21.close();
            b11.getReferenceManager().release();
            allocator11.close();
            frag1.close();
            frag2.close();
            frag3.close();
        }
    }

    @Test(expected=IllegalStateException.class)
    @Ignore
    public void testMemoryLeakWithReservation() throws Exception {
        AssertionUtil.class.getClassLoader().setClassAssertionStatus(AssertionUtil.class.getName(), false);
        try (RootAllocator rootAllocator = new RootAllocator(8192L);){
            ChildAllocator childAllocator1 = (ChildAllocator)rootAllocator.newChildAllocator("child1", 1024L, 8192L);
            rootAllocator.verify();
            ChildAllocator childAllocator2 = (ChildAllocator)childAllocator1.newChildAllocator("child2", 1024L, 8192L);
            rootAllocator.verify();
            ArrowBuf buff = childAllocator2.buffer(256L);
            Exception exception = (Exception)Assertions.assertThrows(IllegalStateException.class, () -> childAllocator2.close());
            String exMessage = exception.getMessage();
            Assert.assertTrue((boolean)exMessage.contains("Memory leaked: (256)"));
            exception = (Exception)Assertions.assertThrows(IllegalStateException.class, () -> childAllocator1.close());
            exMessage = exception.getMessage();
            Assert.assertTrue((boolean)exMessage.contains("Memory leaked: (256)"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMemoryUsage() {
        ListAppender memoryLogsAppender = new ListAppender();
        Logger logger = (Logger)LoggerFactory.getLogger((String)"arrow.allocator");
        try {
            logger.setLevel(Level.TRACE);
            logger.addAppender((Appender)memoryLogsAppender);
            memoryLogsAppender.start();
            try (ArrowBuf buf = new ArrowBuf(ReferenceManager.NO_OP, null, 1024L, new PooledByteBufAllocatorL().empty.memoryAddress());){
                buf.memoryAddress();
            }
            boolean result = false;
            long startTime = System.currentTimeMillis();
            while (System.currentTimeMillis() - startTime < 10000L && !(result = memoryLogsAppender.list.stream().anyMatch(log -> log.toString().contains("Memory Usage: \n") && log.toString().contains("Large buffers outstanding: ") && log.toString().contains("Normal buffers outstanding: ") && log.getLevel().equals(Level.TRACE)))) {
            }
            Assert.assertTrue((String)("Log messages are:\n" + memoryLogsAppender.list.stream().map(Object::toString).collect(Collectors.joining("\n"))), (boolean)result);
        }
        finally {
            memoryLogsAppender.stop();
            logger.detachAppender((Appender)memoryLogsAppender);
            logger.setLevel(null);
        }
    }

    @Test
    public void testOverlimit() {
        try (RootAllocator allocator = new RootAllocator(1024L);
             BufferAllocator child1 = allocator.newChildAllocator("ChildA", 0L, 1024L);
             BufferAllocator child2 = allocator.newChildAllocator("ChildB", 1024L, 1024L);){
            Assertions.assertThrows(OutOfMemoryException.class, () -> {
                ArrowBuf buf1 = child1.buffer(8L);
                buf1.close();
            });
            Assert.assertEquals((long)0L, (long)child1.getAllocatedMemory());
            Assert.assertEquals((long)0L, (long)child2.getAllocatedMemory());
            Assert.assertEquals((long)1024L, (long)allocator.getAllocatedMemory());
        }
    }

    @Test
    public void testOverlimitOverflow() {
        try (RootAllocator allocator = new RootAllocator(Long.MAX_VALUE);
             BufferAllocator child1 = allocator.newChildAllocator("ChildA", 0L, Long.MAX_VALUE);
             BufferAllocator child2 = allocator.newChildAllocator("ChildB", Long.MAX_VALUE, Long.MAX_VALUE);){
            Assertions.assertThrows(OutOfMemoryException.class, () -> {
                ArrowBuf buf1 = child1.buffer(1024L);
                buf1.close();
            });
            Assert.assertEquals((long)0L, (long)child1.getAllocatedMemory());
            Assert.assertEquals((long)0L, (long)child2.getAllocatedMemory());
            Assert.assertEquals((long)Long.MAX_VALUE, (long)allocator.getAllocatedMemory());
        }
    }

    public void assertEquiv(ArrowBuf origBuf, ArrowBuf newBuf) {
        Assert.assertEquals((long)origBuf.readerIndex(), (long)newBuf.readerIndex());
        Assert.assertEquals((long)origBuf.writerIndex(), (long)newBuf.writerIndex());
    }
}

