/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.memory;

import io.netty.buffer.PooledByteBufAllocatorL;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BaseAllocator;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.ReferenceManager;
import org.apache.arrow.memory.RootAllocator;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestEmptyArrowBuf {
    private static final int MAX_ALLOCATION = 8192;
    private static RootAllocator allocator;

    @BeforeClass
    public static void beforeClass() {
        allocator = new RootAllocator(8192L);
    }

    @AfterClass
    public static void afterClass() {
        if (allocator != null) {
            allocator.close();
        }
    }

    @Test
    public void testZeroBuf() {
        allocator.getEmpty().print(new StringBuilder(), 0, BaseAllocator.Verbosity.LOG_WITH_STACKTRACE);
    }

    @Test
    public void testEmptyArrowBuf() {
        ArrowBuf buf = new ArrowBuf(ReferenceManager.NO_OP, null, 1024L, new PooledByteBufAllocatorL().empty.memoryAddress());
        buf.getReferenceManager().retain();
        buf.getReferenceManager().retain(8);
        Assert.assertEquals((long)1024L, (long)buf.capacity());
        Assert.assertEquals((long)1L, (long)buf.getReferenceManager().getRefCount());
        Assert.assertEquals((long)0L, (long)buf.getActualMemoryConsumed());
        for (int i = 0; i < 10; ++i) {
            buf.setByte((long)i, i);
        }
        Assert.assertEquals((long)0L, (long)buf.getActualMemoryConsumed());
        Assert.assertEquals((long)0L, (long)buf.getReferenceManager().getSize());
        Assert.assertEquals((long)0L, (long)buf.getReferenceManager().getAccountedSize());
        Assert.assertEquals((Object)false, (Object)buf.getReferenceManager().release());
        Assert.assertEquals((Object)false, (Object)buf.getReferenceManager().release(2));
        Assert.assertEquals((long)0L, (long)buf.getReferenceManager().getAllocator().getLimit());
        Assert.assertEquals((Object)buf, (Object)buf.getReferenceManager().transferOwnership(buf, (BufferAllocator)allocator).getTransferredBuffer());
        Assert.assertEquals((long)0L, (long)buf.readerIndex());
        Assert.assertEquals((long)0L, (long)buf.writerIndex());
        Assert.assertEquals((long)1L, (long)buf.refCnt());
        ArrowBuf derive = buf.getReferenceManager().deriveBuffer(buf, 0L, 100L);
        Assert.assertEquals((Object)derive, (Object)buf);
        Assert.assertEquals((long)1L, (long)buf.refCnt());
        Assert.assertEquals((long)1L, (long)derive.refCnt());
        buf.close();
    }
}

