/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.memory;

import junit.framework.TestCase;
import org.apache.arrow.memory.LowCostIdentityHashMap;
import org.apache.arrow.memory.ValueWithKeyIncluded;
import org.junit.Assert;
import org.junit.Test;

public class TestLowCostIdentityHashMap {
    @Test
    public void testIdentityHashMap() throws Exception {
        LowCostIdentityHashMap hashMap = new LowCostIdentityHashMap();
        StringWithKey obj1 = new StringWithKey("s1key", "s1value");
        StringWithKey obj2 = new StringWithKey("s2key", "s2value");
        StringWithKey obj3 = new StringWithKey("s3key", "s3value");
        StringWithKey obj4 = new StringWithKey("s1key", "s4value");
        StringWithKey obj5 = new StringWithKey("s5key", "s5value");
        Assert.assertNull((Object)hashMap.put((ValueWithKeyIncluded)obj1));
        Assert.assertNull((Object)hashMap.put((ValueWithKeyIncluded)obj2));
        Assert.assertNull((Object)hashMap.put((ValueWithKeyIncluded)obj3));
        Assert.assertEquals((Object)obj1, (Object)hashMap.put((ValueWithKeyIncluded)obj4));
        Assert.assertNull((Object)hashMap.put((ValueWithKeyIncluded)obj5));
        Assert.assertEquals((long)4L, (long)hashMap.size());
        Assert.assertEquals((Object)obj4, (Object)hashMap.get((Object)"s1key"));
        Assert.assertNull((Object)hashMap.remove((Object)"abc"));
        Assert.assertEquals((Object)obj3, (Object)hashMap.remove((Object)"s3key"));
        Assert.assertEquals((long)3L, (long)hashMap.size());
        TestCase.assertTrue((!hashMap.isEmpty() ? 1 : 0) != 0);
        StringWithKey nextValue = (StringWithKey)hashMap.getNextValue();
        TestCase.assertNotNull((Object)nextValue);
        TestCase.assertTrue((hashMap.get((Object)"s1key") == nextValue || hashMap.get((Object)"s2key") == nextValue || hashMap.get((Object)"s5key") == nextValue ? 1 : 0) != 0);
        TestCase.assertTrue((boolean)hashMap.containsValue((ValueWithKeyIncluded)obj4));
        TestCase.assertTrue((boolean)hashMap.containsValue((ValueWithKeyIncluded)obj2));
        TestCase.assertTrue((boolean)hashMap.containsValue((ValueWithKeyIncluded)obj5));
        Assert.assertEquals((Object)obj4, (Object)hashMap.remove((Object)"s1key"));
        nextValue = (StringWithKey)hashMap.getNextValue();
        TestCase.assertNotNull((Object)nextValue);
        TestCase.assertTrue((hashMap.get((Object)"s2key") == nextValue || hashMap.get((Object)"s5key") == nextValue ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)hashMap.size());
        Assert.assertEquals((Object)obj2, (Object)hashMap.remove((Object)"s2key"));
        Assert.assertEquals((Object)obj5, (Object)hashMap.remove((Object)"s5key"));
        Assert.assertEquals((long)0L, (long)hashMap.size());
        TestCase.assertTrue((boolean)hashMap.isEmpty());
    }

    @Test
    public void testLargeMap() throws Exception {
        StringWithKey returnObj;
        StringWithKey retObj;
        StringWithKey obj;
        int i;
        LowCostIdentityHashMap hashMap = new LowCostIdentityHashMap();
        String[] keys = new String[200];
        for (i = 0; i < 200; ++i) {
            keys[i] = "s" + i + "key";
        }
        for (i = 0; i < 100; ++i) {
            if (i % 5 == 0 && i != 0) {
                obj = new StringWithKey(keys[i - 5], "s" + i + "value");
                retObj = (StringWithKey)hashMap.put((ValueWithKeyIncluded)obj);
                TestCase.assertNotNull((Object)retObj);
                StringWithKey obj1 = new StringWithKey(keys[i], "s" + 2 * i + "value");
                StringWithKey retObj1 = (StringWithKey)hashMap.put((ValueWithKeyIncluded)obj1);
                Assert.assertNull((Object)retObj1);
                continue;
            }
            obj = new StringWithKey(keys[i], "s" + i + "value");
            retObj = (StringWithKey)hashMap.put((ValueWithKeyIncluded)obj);
            Assert.assertNull((Object)retObj);
        }
        Assert.assertEquals((long)100L, (long)hashMap.size());
        for (i = 0; i < 100; ++i) {
            returnObj = (StringWithKey)hashMap.get((Object)keys[i]);
            TestCase.assertNotNull((Object)returnObj);
            if (i == 95) {
                Assert.assertEquals((Object)"s190value", (Object)returnObj.getValue());
                continue;
            }
            if (i % 5 == 0) {
                Assert.assertEquals((Object)("s" + (i + 5) + "value"), (Object)returnObj.getValue());
                continue;
            }
            Assert.assertEquals((Object)("s" + i + "value"), (Object)returnObj.getValue());
        }
        for (i = 0; i < 100; ++i) {
            if (i % 4 == 0) {
                returnObj = (StringWithKey)hashMap.remove((Object)keys[i]);
                TestCase.assertNotNull((Object)returnObj);
                TestCase.assertTrue((!hashMap.containsKey((Object)keys[i]) ? 1 : 0) != 0);
            }
            obj = new StringWithKey(keys[100 + i], "s" + (100 + i) + "value");
            retObj = (StringWithKey)hashMap.put((ValueWithKeyIncluded)obj);
            Assert.assertNull((Object)retObj);
            TestCase.assertTrue((boolean)hashMap.containsKey((Object)keys[100 + i]));
        }
        Assert.assertEquals((long)175L, (long)hashMap.size());
        for (i = 0; i < 100; ++i) {
            StringWithKey retObj2 = (StringWithKey)hashMap.getNextValue();
            TestCase.assertNotNull((Object)retObj2);
            hashMap.remove((Object)retObj2.getKey());
        }
        TestCase.assertTrue((!hashMap.isEmpty() ? 1 : 0) != 0);
        Assert.assertEquals((long)75L, (long)hashMap.size());
        hashMap.clear();
        TestCase.assertTrue((boolean)hashMap.isEmpty());
    }

    private class StringWithKey
    implements ValueWithKeyIncluded<String> {
        private String myValue;
        private String myKey;

        StringWithKey(String myKey, String myValue) {
            this.myKey = myKey;
            this.myValue = myValue;
        }

        public String getKey() {
            return this.myKey;
        }

        String getValue() {
            return this.myValue;
        }
    }
}

