/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.memory;

import org.apache.arrow.memory.AllocationManager;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BaseAllocator;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.BufferLedger;
import org.apache.arrow.memory.NettyAllocationManager;
import org.apache.arrow.memory.RootAllocator;
import org.junit.Assert;
import org.junit.Test;

public class TestNettyAllocationManager {
    static int CUSTOMIZED_ALLOCATION_CUTOFF_VALUE = 1024;

    private BaseAllocator createCustomizedAllocator() {
        return new RootAllocator((BaseAllocator.Config)BaseAllocator.configBuilder().allocationManagerFactory(new AllocationManager.Factory(){

            public AllocationManager create(BufferAllocator accountingAllocator, long size) {
                return new NettyAllocationManager(accountingAllocator, size, CUSTOMIZED_ALLOCATION_CUTOFF_VALUE);
            }

            public ArrowBuf empty() {
                return null;
            }
        }).build());
    }

    private void readWriteArrowBuf(ArrowBuf buffer) {
        long i;
        for (i = 0L; i < buffer.capacity() / 8L; ++i) {
            buffer.setLong(i * 8L, i);
        }
        for (i = 0L; i < buffer.capacity() / 8L; ++i) {
            long val = buffer.getLong(i * 8L);
            Assert.assertEquals((long)i, (long)val);
        }
    }

    @Test
    public void testSmallBufferAllocation() {
        long bufSize = (long)CUSTOMIZED_ALLOCATION_CUTOFF_VALUE - 512L;
        try (BaseAllocator allocator = this.createCustomizedAllocator();
             ArrowBuf buffer = allocator.buffer(bufSize);){
            Assert.assertTrue((boolean)(buffer.getReferenceManager() instanceof BufferLedger));
            BufferLedger bufferLedger = (BufferLedger)buffer.getReferenceManager();
            AllocationManager allocMgr = bufferLedger.getAllocationManager();
            Assert.assertTrue((boolean)(allocMgr instanceof NettyAllocationManager));
            NettyAllocationManager nettyMgr = (NettyAllocationManager)allocMgr;
            Assert.assertNotNull((Object)nettyMgr.getMemoryChunk());
            this.readWriteArrowBuf(buffer);
        }
    }

    @Test
    public void testLargeBufferAllocation() {
        long bufSize = (long)CUSTOMIZED_ALLOCATION_CUTOFF_VALUE + 1024L;
        try (BaseAllocator allocator = this.createCustomizedAllocator();
             ArrowBuf buffer = allocator.buffer(bufSize);){
            Assert.assertTrue((boolean)(buffer.getReferenceManager() instanceof BufferLedger));
            BufferLedger bufferLedger = (BufferLedger)buffer.getReferenceManager();
            AllocationManager allocMgr = bufferLedger.getAllocationManager();
            Assert.assertTrue((boolean)(allocMgr instanceof NettyAllocationManager));
            NettyAllocationManager nettyMgr = (NettyAllocationManager)allocMgr;
            Assert.assertNull((Object)nettyMgr.getMemoryChunk());
            this.readWriteArrowBuf(buffer);
        }
    }
}

