/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.memory.util;

import junit.framework.TestCase;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.memory.util.ArrowBufPointer;
import org.apache.arrow.memory.util.hash.ArrowBufHasher;
import org.apache.arrow.memory.util.hash.SimpleHasher;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class TestArrowBufPointer {
    private final int BUFFER_LENGTH = 1024;
    private BufferAllocator allocator;

    @Before
    public void prepare() {
        this.allocator = new RootAllocator(0x100000L);
    }

    @After
    public void shutdown() {
        this.allocator.close();
    }

    @Test
    public void testArrowBufPointersEqual() {
        try (ArrowBuf buf1 = this.allocator.buffer(1024L);
             ArrowBuf buf2 = this.allocator.buffer(1024L);){
            for (int i = 0; i < 256; ++i) {
                buf1.setInt((long)(i * 4), i * 1234);
                buf2.setInt((long)(i * 4), i * 1234);
            }
            ArrowBufPointer ptr1 = new ArrowBufPointer(null, 0L, 100L);
            ArrowBufPointer ptr2 = new ArrowBufPointer(null, 100L, 5032L);
            TestCase.assertTrue((boolean)ptr1.equals((Object)ptr2));
            for (int i = 0; i < 256; ++i) {
                ptr1.set(buf1, (long)(i * 4), 4L);
                ptr2.set(buf2, (long)(i * 4), 4L);
                TestCase.assertTrue((boolean)ptr1.equals((Object)ptr2));
            }
        }
    }

    @Test
    public void testArrowBufPointersHashCode() {
        int vectorLength = 100;
        try (ArrowBuf buf1 = this.allocator.buffer(400L);
             ArrowBuf buf2 = this.allocator.buffer(400L);){
            for (int i = 0; i < 100; ++i) {
                buf1.setInt((long)(i * 4), i);
                buf2.setInt((long)(i * 4), i);
            }
            CounterHasher hasher1 = new CounterHasher();
            CounterHasher hasher2 = new CounterHasher();
            ArrowBufPointer pointer1 = new ArrowBufPointer((ArrowBufHasher)hasher1);
            TestCase.assertEquals((int)0, (int)pointer1.hashCode());
            ArrowBufPointer pointer2 = new ArrowBufPointer((ArrowBufHasher)hasher2);
            TestCase.assertEquals((int)0, (int)pointer2.hashCode());
            for (int i = 0; i < 100; ++i) {
                pointer1.set(buf1, (long)(i * 4), 4L);
                pointer2.set(buf2, (long)(i * 4), 4L);
                TestCase.assertEquals((int)pointer1.hashCode(), (int)pointer2.hashCode());
                TestCase.assertEquals((int)hasher1.counter, (int)(i + 1));
                TestCase.assertEquals((int)hasher2.counter, (int)(i + 1));
            }
        }
    }

    @Test
    public void testNullPointersHashCode() {
        ArrowBufPointer pointer = new ArrowBufPointer();
        TestCase.assertEquals((int)0, (int)pointer.hashCode());
        pointer.set(null, 0L, 0L);
        TestCase.assertEquals((int)0, (int)pointer.hashCode());
    }

    @Test
    public void testReuseHashCode() {
        try (ArrowBuf buf = this.allocator.buffer(10L);){
            buf.setInt(0L, 10);
            buf.setInt(4L, 20);
            CounterHasher hasher = new CounterHasher();
            ArrowBufPointer pointer = new ArrowBufPointer((ArrowBufHasher)hasher);
            pointer.set(buf, 0L, 4L);
            int hashCode = pointer.hashCode();
            TestCase.assertEquals((int)1, (int)hasher.counter);
            TestCase.assertEquals((int)hashCode, (int)pointer.hashCode());
            TestCase.assertEquals((int)1, (int)hasher.counter);
            pointer.set(buf, 4L, 4L);
            TestCase.assertNotSame((Object)hashCode, (Object)pointer.hashCode());
            TestCase.assertEquals((int)2, (int)hasher.counter);
        }
    }

    @Test
    public void testHashersForEquality() {
        try (ArrowBuf buf = this.allocator.buffer(10L);){
            ArrowBufPointer pointer1 = new ArrowBufPointer(buf, 0L, 10L);
            ArrowBufPointer pointer2 = new ArrowBufPointer(buf, 0L, 10L, (ArrowBufHasher)new CounterHasher());
            Assertions.assertFalse((boolean)pointer1.equals((Object)pointer2));
        }
    }

    @Test
    public void testArrowBufPointersComparison() {
        int vectorLength = 100;
        try (ArrowBuf buf1 = this.allocator.buffer(100L);
             ArrowBuf buf2 = this.allocator.buffer(100L);){
            for (int i = 0; i < 100; ++i) {
                buf1.setByte((long)i, i);
                buf2.setByte((long)i, i);
            }
            ArrowBufPointer pointer1 = new ArrowBufPointer();
            ArrowBufPointer pointer2 = new ArrowBufPointer();
            pointer1.set(buf1, 0L, 10L);
            pointer2.set(buf2, 0L, 10L);
            TestCase.assertEquals((int)0, (int)pointer1.compareTo(pointer2));
            pointer1.set(null, 0L, 0L);
            pointer2.set(null, 0L, 0L);
            TestCase.assertEquals((int)0, (int)pointer1.compareTo(pointer2));
            pointer2.set(buf2, 0L, 5L);
            TestCase.assertTrue((pointer1.compareTo(pointer2) < 0 ? 1 : 0) != 0);
            pointer1.set(buf1, 0L, 10L);
            TestCase.assertTrue((pointer1.compareTo(pointer2) > 0 ? 1 : 0) != 0);
            pointer1.set(buf1, 1L, 5L);
            pointer2.set(buf2, 3L, 8L);
            TestCase.assertTrue((pointer1.compareTo(pointer2) < 0 ? 1 : 0) != 0);
        }
    }

    class CounterHasher
    implements ArrowBufHasher {
        protected int counter = 0;

        CounterHasher() {
        }

        public int hashCode(long address, long length) {
            ++this.counter;
            return SimpleHasher.INSTANCE.hashCode(address, length);
        }

        public int hashCode(ArrowBuf buf, long offset, long length) {
            ++this.counter;
            return SimpleHasher.INSTANCE.hashCode(buf, offset, length);
        }

        public int hashCode() {
            return super.hashCode();
        }

        public boolean equals(Object o) {
            return o != null && this.getClass() == o.getClass();
        }
    }
}

