/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.memory.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import org.junit.Assert;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class TestLargeMemoryUtil {
    private ClassLoader copyClassLoader() {
        ClassLoader curClassLoader = this.getClass().getClassLoader();
        if (curClassLoader instanceof URLClassLoader) {
            return new URLClassLoader(((URLClassLoader)curClassLoader).getURLs(), null);
        }
        return null;
    }

    private int checkedCastToInt(ClassLoader classLoader, long value) throws Exception {
        Class<?> clazz = classLoader.loadClass("org.apache.arrow.memory.util.LargeMemoryUtil");
        Method method = clazz.getMethod("checkedCastToInt", Long.TYPE);
        return (Integer)method.invoke(null, value);
    }

    private void checkExpectedOverflow(ClassLoader classLoader, long value) {
        InvocationTargetException ex = (InvocationTargetException)Assertions.assertThrows(InvocationTargetException.class, () -> this.checkedCastToInt(classLoader, value));
        Assert.assertTrue((boolean)(ex.getCause() instanceof ArithmeticException));
        Assert.assertEquals((Object)"integer overflow", (Object)ex.getCause().getMessage());
    }

    @Test
    public void testEnableLargeMemoryUtilCheck() throws Exception {
        String savedNewProperty = System.getProperty("arrow.enable_unsafe_memory_access");
        System.setProperty("arrow.enable_unsafe_memory_access", "false");
        try {
            ClassLoader classLoader = this.copyClassLoader();
            if (classLoader != null) {
                Assert.assertEquals((long)Integer.MAX_VALUE, (long)this.checkedCastToInt(classLoader, Integer.MAX_VALUE));
                this.checkExpectedOverflow(classLoader, 0x80000000L);
                this.checkExpectedOverflow(classLoader, -2147483649L);
            }
        }
        finally {
            if (savedNewProperty != null) {
                System.setProperty("arrow.enable_unsafe_memory_access", savedNewProperty);
            } else {
                System.clearProperty("arrow.enable_unsafe_memory_access");
            }
        }
    }

    @Test
    public void testDisabledLargeMemoryUtilCheck() throws Exception {
        String savedNewProperty = System.getProperty("arrow.enable_unsafe_memory_access");
        System.setProperty("arrow.enable_unsafe_memory_access", "true");
        try {
            ClassLoader classLoader = this.copyClassLoader();
            if (classLoader != null) {
                Assert.assertEquals((long)Integer.MAX_VALUE, (long)this.checkedCastToInt(classLoader, Integer.MAX_VALUE));
                Assert.assertEquals((long)Integer.MIN_VALUE, (long)this.checkedCastToInt(classLoader, 0x80000000L));
                Assert.assertEquals((long)Integer.MAX_VALUE, (long)this.checkedCastToInt(classLoader, -2147483649L));
            }
        }
        finally {
            if (savedNewProperty != null) {
                System.setProperty("arrow.enable_unsafe_memory_access", savedNewProperty);
            } else {
                System.clearProperty("arrow.enable_unsafe_memory_access");
            }
        }
    }
}

