/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.arrow.util.Collections2;
import org.junit.Assert;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class TestCollections2 {
    @Test
    public void testToImmutableListFromIterable() {
        ArrayList<String> source = new ArrayList<String>(Arrays.asList("foo", "bar", "baz"));
        List copy = Collections2.toImmutableList(source);
        Assertions.assertEquals(source, (Object)copy);
        try {
            copy.add("unexpected");
            Assert.fail((String)"add operation should not be supported");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            copy.set(0, "unexpected");
            Assert.fail((String)"set operation should not be supported");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            copy.remove(0);
            Assert.fail((String)"remove operation should not be supported");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        source.set(1, "newvalue");
        source.add("anothervalue");
        Assertions.assertEquals((Object)"bar", copy.get(1));
        Assertions.assertEquals((int)3, (int)copy.size());
    }

    @Test
    public void testStringFromEmptyIterator() {
        Assertions.assertEquals((Object)"[]", (Object)Collections2.toString(Collections.emptyIterator()));
    }

    @Test
    public void testStringFromIterator() {
        Iterator<String> iterator = Arrays.asList("foo", "bar", "baz").iterator();
        iterator.next();
        Assertions.assertEquals((Object)"[bar, baz]", (Object)Collections2.toString(iterator));
        Assertions.assertEquals((Object)false, (Object)iterator.hasNext());
    }
}

