/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector;

import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.OutOfMemoryException;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.VarCharVector;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestOutOfMemoryForValueVector {
    private static final String EMPTY_SCHEMA_PATH = "";
    private BufferAllocator allocator;

    @Before
    public void init() {
        this.allocator = new RootAllocator(200L);
    }

    @Test(expected=OutOfMemoryException.class)
    public void variableWidthVectorAllocateNew() {
        VarCharVector vector = new VarCharVector(EMPTY_SCHEMA_PATH, this.allocator);
        Throwable throwable = null;
        try {
            vector.allocateNew();
        }
        catch (Throwable throwable2) {
            try {
                throwable = throwable2;
                throw throwable2;
            }
            catch (Throwable throwable3) {
                TestOutOfMemoryForValueVector.$closeResource(throwable, (AutoCloseable)vector);
                throw throwable3;
            }
        }
        TestOutOfMemoryForValueVector.$closeResource(throwable, (AutoCloseable)vector);
    }

    @Test(expected=OutOfMemoryException.class)
    public void variableWidthVectorAllocateNewCustom() {
        try (VarCharVector vector = new VarCharVector(EMPTY_SCHEMA_PATH, this.allocator);){
            vector.allocateNew(2342L, 234);
        }
    }

    @Test(expected=OutOfMemoryException.class)
    public void fixedWidthVectorAllocateNew() {
        IntVector vector = new IntVector(EMPTY_SCHEMA_PATH, this.allocator);
        Throwable throwable = null;
        try {
            vector.allocateNew();
        }
        catch (Throwable throwable2) {
            try {
                throwable = throwable2;
                throw throwable2;
            }
            catch (Throwable throwable3) {
                TestOutOfMemoryForValueVector.$closeResource(throwable, (AutoCloseable)vector);
                throw throwable3;
            }
        }
        TestOutOfMemoryForValueVector.$closeResource(throwable, (AutoCloseable)vector);
    }

    @Test(expected=OutOfMemoryException.class)
    public void fixedWidthVectorAllocateNewCustom() {
        try (IntVector vector = new IntVector(EMPTY_SCHEMA_PATH, this.allocator);){
            vector.allocateNew(2342);
        }
    }

    @After
    public void terminate() {
        this.allocator.close();
    }
}

