/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector.complex.impl;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.Duration;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.DirtyRootAllocator;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.complex.AbstractStructVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.NonNullableStructVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.complex.UnionVector;
import org.apache.arrow.vector.complex.impl.ComplexWriterImpl;
import org.apache.arrow.vector.complex.impl.PromotableWriter;
import org.apache.arrow.vector.complex.writer.BaseWriter;
import org.apache.arrow.vector.holders.DurationHolder;
import org.apache.arrow.vector.holders.FixedSizeBinaryHolder;
import org.apache.arrow.vector.holders.NullableTimeStampMilliTZHolder;
import org.apache.arrow.vector.holders.TimeStampMilliTZHolder;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class TestPromotableWriter {
    private static final String EMPTY_SCHEMA_PATH = "";
    private BufferAllocator allocator;

    @Before
    public void init() {
        this.allocator = new DirtyRootAllocator(Long.MAX_VALUE, 100);
    }

    @After
    public void terminate() throws Exception {
        this.allocator.close();
    }

    @Test
    public void testPromoteToUnion() throws Exception {
        try (NonNullableStructVector container = NonNullableStructVector.empty((String)EMPTY_SCHEMA_PATH, (BufferAllocator)this.allocator);
             StructVector v = container.addOrGetStruct("test");
             PromotableWriter writer = new PromotableWriter((ValueVector)v, (AbstractStructVector)container);){
            container.allocateNew();
            writer.start();
            writer.setPosition(0);
            writer.bit("A").writeBit(0);
            writer.setPosition(1);
            writer.bit("A").writeBit(1);
            writer.decimal("dec", 10, 10);
            writer.setPosition(2);
            writer.integer("A").writeInt(10);
            writer.setPosition(4);
            writer.integer("A").writeInt(100);
            writer.setPosition(5);
            writer.timeStampMilliTZ("A").writeTimeStampMilliTZ(123123L);
            writer.setPosition(6);
            TimeStampMilliTZHolder tsmtzHolder = new TimeStampMilliTZHolder();
            tsmtzHolder.timezone = "UTC";
            tsmtzHolder.value = 12345L;
            writer.timeStampMilliTZ("A").write(tsmtzHolder);
            writer.setPosition(7);
            DurationHolder durationHolder = new DurationHolder();
            durationHolder.unit = TimeUnit.SECOND;
            durationHolder.value = 444413L;
            writer.duration("A").write(durationHolder);
            writer.setPosition(8);
            ArrowBuf buf = this.allocator.buffer(4L);
            buf.setInt(0L, 18978);
            FixedSizeBinaryHolder binHolder = new FixedSizeBinaryHolder();
            binHolder.byteWidth = 4;
            binHolder.buffer = buf;
            writer.fixedSizeBinary("A", 4).write(binHolder);
            writer.end();
            container.setValueCount(9);
            UnionVector uv = (UnionVector)v.getChild("A", UnionVector.class);
            Assert.assertFalse((String)"0 shouldn't be null", (boolean)uv.isNull(0));
            Assert.assertEquals((Object)false, (Object)uv.getObject(0));
            Assert.assertFalse((String)"1 shouldn't be null", (boolean)uv.isNull(1));
            Assert.assertEquals((Object)true, (Object)uv.getObject(1));
            Assert.assertFalse((String)"2 shouldn't be null", (boolean)uv.isNull(2));
            Assert.assertEquals((Object)10, (Object)uv.getObject(2));
            Assert.assertNull((String)"3 should be null", (Object)uv.getObject(3));
            Assert.assertFalse((String)"4 shouldn't be null", (boolean)uv.isNull(4));
            Assert.assertEquals((Object)100, (Object)uv.getObject(4));
            Assert.assertFalse((String)"5 shouldn't be null", (boolean)uv.isNull(5));
            Assert.assertEquals((Object)123123L, (Object)uv.getObject(5));
            Assert.assertFalse((String)"6 shouldn't be null", (boolean)uv.isNull(6));
            NullableTimeStampMilliTZHolder readBackHolder = new NullableTimeStampMilliTZHolder();
            uv.getTimeStampMilliTZVector().get(6, readBackHolder);
            Assert.assertEquals((long)12345L, (long)readBackHolder.value);
            Assert.assertEquals((Object)"UTC", (Object)readBackHolder.timezone);
            Assert.assertFalse((String)"7 shouldn't be null", (boolean)uv.isNull(7));
            Assert.assertEquals((long)444413L, (long)((Duration)uv.getObject(7)).getSeconds());
            Assert.assertFalse((String)"8 shouldn't be null", (boolean)uv.isNull(8));
            Assert.assertEquals((long)18978L, (long)ByteBuffer.wrap(uv.getFixedSizeBinaryVector().get(8)).order(ByteOrder.nativeOrder()).getInt());
            container.clear();
            container.allocateNew();
            ComplexWriterImpl newWriter = new ComplexWriterImpl(EMPTY_SCHEMA_PATH, container);
            BaseWriter.StructWriter newStructWriter = newWriter.rootAsStruct();
            newStructWriter.start();
            newStructWriter.setPosition(2);
            newStructWriter.integer("A").writeInt(10);
            Field childField1 = (Field)((Field)container.getField().getChildren().get(0)).getChildren().get(0);
            Field childField2 = (Field)((Field)container.getField().getChildren().get(0)).getChildren().get(1);
            Assert.assertEquals((String)("Child field should be union type: " + childField1.getName()), (Object)ArrowType.ArrowTypeID.Union, (Object)childField1.getType().getTypeID());
            Assert.assertEquals((String)("Child field should be decimal type: " + childField2.getName()), (Object)ArrowType.ArrowTypeID.Decimal, (Object)childField2.getType().getTypeID());
            buf.close();
        }
    }

    @Test
    public void testNoPromoteFloat4ToUnionWithNull() throws Exception {
        try (NonNullableStructVector container = NonNullableStructVector.empty((String)EMPTY_SCHEMA_PATH, (BufferAllocator)this.allocator);
             StructVector v = container.addOrGetStruct("test");
             PromotableWriter writer = new PromotableWriter((ValueVector)v, (AbstractStructVector)container);){
            container.allocateNew();
            writer.start();
            writer.list("list").startList();
            writer.list("list").endList();
            writer.end();
            FieldType childTypeOfListInContainer = ((Field)((Field)((Field)container.getField().getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getFieldType();
            ListVector lv = ListVector.empty((String)"name", (BufferAllocator)this.allocator);
            lv.addOrGetVector(childTypeOfListInContainer);
            Assert.assertEquals((Object)childTypeOfListInContainer.getType(), (Object)Types.MinorType.NULL.getType());
            Assert.assertEquals((Object)((FieldVector)lv.getChildrenFromFields().get(0)).getMinorType().getType(), (Object)Types.MinorType.NULL.getType());
            writer.start();
            writer.list("list").startList();
            writer.list("list").float4().writeFloat4(1.36f);
            writer.list("list").endList();
            writer.end();
            container.setValueCount(2);
            childTypeOfListInContainer = ((Field)((Field)((Field)container.getField().getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getFieldType();
            lv.addOrGetVector(childTypeOfListInContainer);
            Assert.assertEquals((Object)childTypeOfListInContainer.getType(), (Object)Types.MinorType.FLOAT4.getType());
            Assert.assertEquals((Object)((FieldVector)lv.getChildrenFromFields().get(0)).getMinorType().getType(), (Object)Types.MinorType.FLOAT4.getType());
            lv.close();
        }
    }

    @Test
    public void testNoPromoteTimeStampMilliTZToUnionWithNull() throws Exception {
        try (NonNullableStructVector container = NonNullableStructVector.empty((String)EMPTY_SCHEMA_PATH, (BufferAllocator)this.allocator);
             StructVector v = container.addOrGetStruct("test");
             PromotableWriter writer = new PromotableWriter((ValueVector)v, (AbstractStructVector)container);){
            container.allocateNew();
            writer.start();
            writer.list("list").startList();
            writer.list("list").endList();
            writer.end();
            FieldType childTypeOfListInContainer = ((Field)((Field)((Field)container.getField().getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getFieldType();
            ListVector lv = ListVector.empty((String)"name", (BufferAllocator)this.allocator);
            lv.addOrGetVector(childTypeOfListInContainer);
            Assert.assertEquals((Object)childTypeOfListInContainer.getType(), (Object)Types.MinorType.NULL.getType());
            Assert.assertEquals((Object)((FieldVector)lv.getChildrenFromFields().get(0)).getMinorType().getType(), (Object)Types.MinorType.NULL.getType());
            writer.start();
            writer.list("list").startList();
            TimeStampMilliTZHolder holder = new TimeStampMilliTZHolder();
            holder.value = 12341234L;
            holder.timezone = "FakeTimeZone";
            writer.list("list").timeStampMilliTZ().write(holder);
            holder.timezone = "SomeTimeZone";
            IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> writer.list("list").timeStampMilliTZ().write(holder));
            Assert.assertEquals((Object)"holder.timezone: SomeTimeZone not equal to vector timezone: FakeTimeZone", (Object)ex.getMessage());
            writer.list("list").endList();
            writer.end();
            container.setValueCount(2);
            childTypeOfListInContainer = ((Field)((Field)((Field)container.getField().getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getFieldType();
            lv.addOrGetVector(childTypeOfListInContainer);
            Assert.assertEquals((Object)childTypeOfListInContainer.getType(), (Object)new ArrowType.Timestamp(TimeUnit.MILLISECOND, "FakeTimeZone"));
            Assert.assertEquals((Object)((FieldVector)lv.getChildrenFromFields().get(0)).getField().getType(), (Object)new ArrowType.Timestamp(TimeUnit.MILLISECOND, "FakeTimeZone"));
            lv.close();
        }
    }

    @Test
    public void testNoPromoteDurationToUnionWithNull() throws Exception {
        try (NonNullableStructVector container = NonNullableStructVector.empty((String)EMPTY_SCHEMA_PATH, (BufferAllocator)this.allocator);
             StructVector v = container.addOrGetStruct("test");
             PromotableWriter writer = new PromotableWriter((ValueVector)v, (AbstractStructVector)container);){
            container.allocateNew();
            writer.start();
            writer.list("list").startList();
            writer.list("list").endList();
            writer.end();
            FieldType childTypeOfListInContainer = ((Field)((Field)((Field)container.getField().getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getFieldType();
            ListVector lv = ListVector.empty((String)"name", (BufferAllocator)this.allocator);
            lv.addOrGetVector(childTypeOfListInContainer);
            Assert.assertEquals((Object)childTypeOfListInContainer.getType(), (Object)Types.MinorType.NULL.getType());
            Assert.assertEquals((Object)((FieldVector)lv.getChildrenFromFields().get(0)).getMinorType().getType(), (Object)Types.MinorType.NULL.getType());
            writer.start();
            writer.list("list").startList();
            DurationHolder holder = new DurationHolder();
            holder.unit = TimeUnit.NANOSECOND;
            holder.value = 567657L;
            writer.list("list").duration().write(holder);
            holder.unit = TimeUnit.MICROSECOND;
            IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> writer.list("list").duration().write(holder));
            Assert.assertEquals((Object)"holder.unit: MICROSECOND not equal to vector unit: NANOSECOND", (Object)ex.getMessage());
            writer.list("list").endList();
            writer.end();
            container.setValueCount(2);
            childTypeOfListInContainer = ((Field)((Field)((Field)container.getField().getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getFieldType();
            lv.addOrGetVector(childTypeOfListInContainer);
            Assert.assertEquals((Object)childTypeOfListInContainer.getType(), (Object)new ArrowType.Duration(TimeUnit.NANOSECOND));
            Assert.assertEquals((Object)((FieldVector)lv.getChildrenFromFields().get(0)).getField().getType(), (Object)new ArrowType.Duration(TimeUnit.NANOSECOND));
            lv.close();
        }
    }

    @Test
    public void testNoPromoteFixedSizeBinaryToUnionWithNull() throws Exception {
        try (NonNullableStructVector container = NonNullableStructVector.empty((String)EMPTY_SCHEMA_PATH, (BufferAllocator)this.allocator);
             StructVector v = container.addOrGetStruct("test");
             PromotableWriter writer = new PromotableWriter((ValueVector)v, (AbstractStructVector)container);){
            container.allocateNew();
            writer.start();
            writer.list("list").startList();
            writer.list("list").endList();
            writer.end();
            FieldType childTypeOfListInContainer = ((Field)((Field)((Field)container.getField().getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getFieldType();
            ListVector lv = ListVector.empty((String)"name", (BufferAllocator)this.allocator);
            lv.addOrGetVector(childTypeOfListInContainer);
            Assert.assertEquals((Object)childTypeOfListInContainer.getType(), (Object)Types.MinorType.NULL.getType());
            Assert.assertEquals((Object)((FieldVector)lv.getChildrenFromFields().get(0)).getMinorType().getType(), (Object)Types.MinorType.NULL.getType());
            writer.start();
            writer.list("list").startList();
            ArrowBuf buf = this.allocator.buffer(4L);
            buf.setInt(0L, 22222);
            FixedSizeBinaryHolder holder = new FixedSizeBinaryHolder();
            holder.byteWidth = 4;
            holder.buffer = buf;
            writer.list("list").fixedSizeBinary().write(holder);
            holder.byteWidth = 7;
            IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> writer.list("list").fixedSizeBinary().write(holder));
            Assert.assertEquals((Object)"holder.byteWidth: 7 not equal to vector byteWidth: 4", (Object)ex.getMessage());
            writer.list("list").endList();
            writer.end();
            container.setValueCount(2);
            childTypeOfListInContainer = ((Field)((Field)((Field)container.getField().getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getFieldType();
            lv.addOrGetVector(childTypeOfListInContainer);
            Assert.assertEquals((Object)childTypeOfListInContainer.getType(), (Object)new ArrowType.FixedSizeBinary(4));
            Assert.assertEquals((Object)((FieldVector)lv.getChildrenFromFields().get(0)).getField().getType(), (Object)new ArrowType.FixedSizeBinary(4));
            lv.close();
            buf.close();
        }
    }
}

