/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector.util;

import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.LargeVarCharVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.compare.Range;
import org.apache.arrow.vector.compare.RangeEqualsVisitor;
import org.apache.arrow.vector.compare.TypeEqualsVisitor;
import org.apache.arrow.vector.compare.VectorVisitor;
import org.apache.arrow.vector.complex.DenseUnionVector;
import org.apache.arrow.vector.complex.FixedSizeListVector;
import org.apache.arrow.vector.complex.LargeListVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.complex.UnionVector;
import org.apache.arrow.vector.holders.NullableBigIntHolder;
import org.apache.arrow.vector.holders.NullableFloat4Holder;
import org.apache.arrow.vector.holders.NullableIntHolder;
import org.apache.arrow.vector.testing.ValueVectorDataPopulator;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.util.VectorAppender;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class TestVectorAppender {
    private BufferAllocator allocator;

    @Before
    public void prepare() {
        this.allocator = new RootAllocator(0x100000L);
    }

    @After
    public void shutdown() {
        this.allocator.close();
    }

    @Test
    public void testAppendFixedWidthVector() {
        int length1 = 10;
        int length2 = 5;
        try (IntVector target = new IntVector("", this.allocator);
             IntVector delta = new IntVector("", this.allocator);){
            target.allocateNew(10);
            delta.allocateNew(5);
            ValueVectorDataPopulator.setVector(target, 0, 1, 2, 3, 4, 5, 6, null, 8, 9);
            ValueVectorDataPopulator.setVector(delta, null, 11, 12, 13, 14);
            VectorAppender appender = new VectorAppender((ValueVector)target);
            delta.accept((VectorVisitor)appender, null);
            TestCase.assertEquals((int)15, (int)target.getValueCount());
            try (IntVector expected = new IntVector("expected", this.allocator);){
                expected.allocateNew();
                ValueVectorDataPopulator.setVector(expected, 0, 1, 2, 3, 4, 5, 6, null, 8, 9, null, 11, 12, 13, 14);
                TestVectorAppender.assertVectorsEqual((ValueVector)expected, (ValueVector)target);
            }
        }
    }

    @Test
    public void testAppendBitVector() {
        int length1 = 10;
        int length2 = 5;
        try (BitVector target = new BitVector("", this.allocator);
             BitVector delta = new BitVector("", this.allocator);){
            target.allocateNew(10);
            delta.allocateNew(5);
            ValueVectorDataPopulator.setVector(target, 0, 1, 0, 1, 0, 1, 0, null, 0, 1);
            ValueVectorDataPopulator.setVector(delta, null, 1, 1, 0, 0);
            VectorAppender appender = new VectorAppender((ValueVector)target);
            delta.accept((VectorVisitor)appender, null);
            TestCase.assertEquals((int)15, (int)target.getValueCount());
            try (BitVector expected = new BitVector("expected", this.allocator);){
                expected.allocateNew();
                ValueVectorDataPopulator.setVector(expected, 0, 1, 0, 1, 0, 1, 0, null, 0, 1, null, 1, 1, 0, 0);
                TestVectorAppender.assertVectorsEqual((ValueVector)expected, (ValueVector)target);
            }
        }
    }

    @Test
    public void testAppendEmptyFixedWidthVector() {
        try (IntVector target = new IntVector("", this.allocator);
             IntVector delta = new IntVector("", this.allocator);){
            ValueVectorDataPopulator.setVector(target, 0, 1, 2, 3, 4, 5, 6, null, 8, 9);
            VectorAppender appender = new VectorAppender((ValueVector)target);
            delta.accept((VectorVisitor)appender, null);
            TestCase.assertEquals((int)10, (int)target.getValueCount());
            try (IntVector expected = new IntVector("expected", this.allocator);){
                ValueVectorDataPopulator.setVector(expected, 0, 1, 2, 3, 4, 5, 6, null, 8, 9);
                TestVectorAppender.assertVectorsEqual((ValueVector)expected, (ValueVector)target);
            }
        }
    }

    @Test
    public void testAppendVariableWidthVector() {
        int length1 = 10;
        int length2 = 5;
        try (VarCharVector target = new VarCharVector("", this.allocator);
             VarCharVector delta = new VarCharVector("", this.allocator);){
            target.allocateNew(5L, 10);
            delta.allocateNew(5L, 5);
            ValueVectorDataPopulator.setVector(target, "a0", "a1", "a2", "a3", null, "a5", "a6", "a7", "a8", "a9");
            ValueVectorDataPopulator.setVector(delta, "a10", "a11", "a12", "a13", null);
            VectorAppender appender = new VectorAppender((ValueVector)target);
            delta.accept((VectorVisitor)appender, null);
            try (VarCharVector expected = new VarCharVector("expected", this.allocator);){
                expected.allocateNew();
                ValueVectorDataPopulator.setVector(expected, "a0", "a1", "a2", "a3", null, "a5", "a6", "a7", "a8", "a9", "a10", "a11", "a12", "a13", null);
                TestVectorAppender.assertVectorsEqual((ValueVector)expected, (ValueVector)target);
            }
        }
    }

    @Test
    public void testAppendEmptyVariableWidthVector() {
        try (VarCharVector target = new VarCharVector("", this.allocator);
             VarCharVector delta = new VarCharVector("", this.allocator);){
            ValueVectorDataPopulator.setVector(target, "a0", "a1", "a2", "a3", null, "a5", "a6", "a7", "a8", "a9");
            VectorAppender appender = new VectorAppender((ValueVector)target);
            delta.accept((VectorVisitor)appender, null);
            try (VarCharVector expected = new VarCharVector("expected", this.allocator);){
                ValueVectorDataPopulator.setVector(expected, "a0", "a1", "a2", "a3", null, "a5", "a6", "a7", "a8", "a9");
                TestVectorAppender.assertVectorsEqual((ValueVector)expected, (ValueVector)target);
            }
        }
    }

    @Test
    public void testAppendLargeVariableWidthVector() {
        int length1 = 5;
        int length2 = 10;
        try (LargeVarCharVector target = new LargeVarCharVector("", this.allocator);
             LargeVarCharVector delta = new LargeVarCharVector("", this.allocator);){
            target.allocateNew(5L, 5);
            delta.allocateNew(5L, 10);
            ValueVectorDataPopulator.setVector(target, "a0", null, "a2", "a3", null);
            ValueVectorDataPopulator.setVector(delta, "a5", "a6", "a7", null, null, "a10", "a11", "a12", "a13", null);
            VectorAppender appender = new VectorAppender((ValueVector)target);
            delta.accept((VectorVisitor)appender, null);
            try (LargeVarCharVector expected = new LargeVarCharVector("expected", this.allocator);){
                expected.allocateNew();
                ValueVectorDataPopulator.setVector(expected, "a0", null, "a2", "a3", null, "a5", "a6", "a7", null, null, "a10", "a11", "a12", "a13", null);
                TestVectorAppender.assertVectorsEqual((ValueVector)expected, (ValueVector)target);
            }
        }
    }

    @Test
    public void testAppendEmptyLargeVariableWidthVector() {
        try (LargeVarCharVector target = new LargeVarCharVector("", this.allocator);
             LargeVarCharVector delta = new LargeVarCharVector("", this.allocator);){
            ValueVectorDataPopulator.setVector(target, "a0", null, "a2", "a3", null);
            VectorAppender appender = new VectorAppender((ValueVector)target);
            delta.accept((VectorVisitor)appender, null);
            try (LargeVarCharVector expected = new LargeVarCharVector("expected", this.allocator);){
                ValueVectorDataPopulator.setVector(expected, "a0", null, "a2", "a3", null);
                TestVectorAppender.assertVectorsEqual((ValueVector)expected, (ValueVector)target);
            }
        }
    }

    @Test
    public void testAppendListVector() {
        int length1 = 5;
        int length2 = 2;
        try (ListVector target = ListVector.empty((String)"target", (BufferAllocator)this.allocator);
             ListVector delta = ListVector.empty((String)"delta", (BufferAllocator)this.allocator);){
            target.allocateNew();
            ValueVectorDataPopulator.setVector(target, Arrays.asList(0, 1), Arrays.asList(2, 3), null, Arrays.asList(6, 7), Arrays.asList(8, 9));
            TestCase.assertEquals((int)5, (int)target.getValueCount());
            delta.allocateNew();
            ValueVectorDataPopulator.setVector(delta, Arrays.asList(10, 11, 12, 13, 14), Arrays.asList(15, 16, 17, 18, 19));
            TestCase.assertEquals((int)2, (int)delta.getValueCount());
            VectorAppender appender = new VectorAppender((ValueVector)target);
            delta.accept((VectorVisitor)appender, null);
            TestCase.assertEquals((int)7, (int)target.getValueCount());
            List<Integer> expected = Arrays.asList(0, 1);
            TestCase.assertEquals(expected, (Object)target.getObject(0));
            expected = Arrays.asList(2, 3);
            TestCase.assertEquals(expected, (Object)target.getObject(1));
            TestCase.assertTrue((boolean)target.isNull(2));
            expected = Arrays.asList(6, 7);
            TestCase.assertEquals(expected, (Object)target.getObject(3));
            expected = Arrays.asList(8, 9);
            TestCase.assertEquals(expected, (Object)target.getObject(4));
            expected = Arrays.asList(10, 11, 12, 13, 14);
            TestCase.assertEquals(expected, (Object)target.getObject(5));
            expected = Arrays.asList(15, 16, 17, 18, 19);
            TestCase.assertEquals(expected, (Object)target.getObject(6));
        }
    }

    @Test
    public void testAppendEmptyListVector() {
        try (ListVector target = ListVector.empty((String)"target", (BufferAllocator)this.allocator);
             ListVector delta = ListVector.empty((String)"delta", (BufferAllocator)this.allocator);){
            ValueVectorDataPopulator.setVector(target, Arrays.asList(0, 1), Arrays.asList(2, 3), null, Arrays.asList(6, 7));
            TestCase.assertEquals((int)4, (int)target.getValueCount());
            delta.addOrGetVector(FieldType.nullable((ArrowType)Types.MinorType.INT.getType()));
            VectorAppender appender = new VectorAppender((ValueVector)target);
            delta.accept((VectorVisitor)appender, null);
            TestCase.assertEquals((int)4, (int)target.getValueCount());
            List<Integer> expected = Arrays.asList(0, 1);
            TestCase.assertEquals(expected, (Object)target.getObject(0));
            expected = Arrays.asList(2, 3);
            TestCase.assertEquals(expected, (Object)target.getObject(1));
            TestCase.assertTrue((boolean)target.isNull(2));
            expected = Arrays.asList(6, 7);
            TestCase.assertEquals(expected, (Object)target.getObject(3));
        }
    }

    @Test
    public void testAppendFixedSizeListVector() {
        try (FixedSizeListVector target = FixedSizeListVector.empty((String)"target", (int)5, (BufferAllocator)this.allocator);
             FixedSizeListVector delta = FixedSizeListVector.empty((String)"delta", (int)5, (BufferAllocator)this.allocator);){
            target.allocateNew();
            ValueVectorDataPopulator.setVector(target, Arrays.asList(0, 1, 2, 3, 4), null);
            TestCase.assertEquals((int)2, (int)target.getValueCount());
            delta.allocateNew();
            ValueVectorDataPopulator.setVector(delta, Arrays.asList(10, 11, 12, 13, 14), Arrays.asList(15, 16, 17, 18, 19));
            TestCase.assertEquals((int)2, (int)delta.getValueCount());
            VectorAppender appender = new VectorAppender((ValueVector)target);
            delta.accept((VectorVisitor)appender, null);
            TestCase.assertEquals((int)4, (int)target.getValueCount());
            TestCase.assertEquals(Arrays.asList(0, 1, 2, 3, 4), (Object)target.getObject(0));
            TestCase.assertTrue((boolean)target.isNull(1));
            TestCase.assertEquals(Arrays.asList(10, 11, 12, 13, 14), (Object)target.getObject(2));
            TestCase.assertEquals(Arrays.asList(15, 16, 17, 18, 19), (Object)target.getObject(3));
        }
    }

    @Test
    public void testAppendEmptyFixedSizeListVector() {
        try (FixedSizeListVector target = FixedSizeListVector.empty((String)"target", (int)5, (BufferAllocator)this.allocator);
             FixedSizeListVector delta = FixedSizeListVector.empty((String)"delta", (int)5, (BufferAllocator)this.allocator);){
            ValueVectorDataPopulator.setVector(target, Arrays.asList(0, 1, 2, 3, 4), null);
            TestCase.assertEquals((int)2, (int)target.getValueCount());
            delta.addOrGetVector(FieldType.nullable((ArrowType)Types.MinorType.INT.getType()));
            VectorAppender appender = new VectorAppender((ValueVector)target);
            delta.accept((VectorVisitor)appender, null);
            TestCase.assertEquals((int)2, (int)target.getValueCount());
            TestCase.assertEquals(Arrays.asList(0, 1, 2, 3, 4), (Object)target.getObject(0));
            TestCase.assertTrue((boolean)target.isNull(1));
        }
    }

    @Test
    public void testAppendEmptyLargeListVector() {
        try (LargeListVector target = LargeListVector.empty((String)"target", (BufferAllocator)this.allocator);
             LargeListVector delta = LargeListVector.empty((String)"delta", (BufferAllocator)this.allocator);){
            ValueVectorDataPopulator.setVector(target, Arrays.asList(0, 1, 2, 3, 4), null);
            TestCase.assertEquals((int)2, (int)target.getValueCount());
            delta.addOrGetVector(FieldType.nullable((ArrowType)Types.MinorType.INT.getType()));
            VectorAppender appender = new VectorAppender((ValueVector)target);
            delta.accept((VectorVisitor)appender, null);
            TestCase.assertEquals((int)2, (int)target.getValueCount());
            TestCase.assertEquals(Arrays.asList(0, 1, 2, 3, 4), (Object)target.getObject(0));
            TestCase.assertTrue((boolean)target.isNull(1));
        }
    }

    @Test
    public void testAppendStructVector() {
        int length1 = 10;
        int length2 = 5;
        try (StructVector target = StructVector.empty((String)"target", (BufferAllocator)this.allocator);
             StructVector delta = StructVector.empty((String)"delta", (BufferAllocator)this.allocator);){
            IntVector targetChild1 = (IntVector)target.addOrGet("f0", FieldType.nullable((ArrowType)new ArrowType.Int(32, true)), IntVector.class);
            VarCharVector targetChild2 = (VarCharVector)target.addOrGet("f1", FieldType.nullable((ArrowType)new ArrowType.Utf8()), VarCharVector.class);
            targetChild1.allocateNew();
            targetChild2.allocateNew();
            ValueVectorDataPopulator.setVector(targetChild1, 0, 1, 2, 3, 4, null, 6, 7, 8, 9);
            ValueVectorDataPopulator.setVector(targetChild2, "a0", "a1", "a2", "a3", "a4", "a5", "a6", null, "a8", "a9");
            target.setValueCount(10);
            IntVector deltaChild1 = (IntVector)delta.addOrGet("f0", FieldType.nullable((ArrowType)new ArrowType.Int(32, true)), IntVector.class);
            VarCharVector deltaChild2 = (VarCharVector)delta.addOrGet("f1", FieldType.nullable((ArrowType)new ArrowType.Utf8()), VarCharVector.class);
            deltaChild1.allocateNew();
            deltaChild2.allocateNew();
            ValueVectorDataPopulator.setVector(deltaChild1, 10, 11, 12, null, 14);
            ValueVectorDataPopulator.setVector(deltaChild2, "a10", "a11", "a12", "a13", "a14");
            delta.setValueCount(5);
            VectorAppender appender = new VectorAppender((ValueVector)target);
            delta.accept((VectorVisitor)appender, null);
            TestCase.assertEquals((int)15, (int)target.getValueCount());
            IntVector child1 = (IntVector)target.getVectorById(0);
            VarCharVector child2 = (VarCharVector)target.getVectorById(1);
            try (IntVector expected1 = new IntVector("expected1", this.allocator);
                 VarCharVector expected2 = new VarCharVector("expected2", this.allocator);){
                expected1.allocateNew();
                expected2.allocateNew();
                ValueVectorDataPopulator.setVector(expected1, 0, 1, 2, 3, 4, null, 6, 7, 8, 9, 10, 11, 12, null, 14);
                ValueVectorDataPopulator.setVector(expected2, "a0", "a1", "a2", "a3", "a4", "a5", "a6", null, "a8", "a9", "a10", "a11", "a12", "a13", "a14");
                TestVectorAppender.assertVectorsEqual((ValueVector)expected1, (ValueVector)target.getChild("f0"));
                TestVectorAppender.assertVectorsEqual((ValueVector)expected2, (ValueVector)target.getChild("f1"));
            }
        }
    }

    @Test
    public void testAppendEmptyStructVector() {
        try (StructVector target = StructVector.empty((String)"target", (BufferAllocator)this.allocator);
             StructVector delta = StructVector.empty((String)"delta", (BufferAllocator)this.allocator);){
            IntVector targetChild1 = (IntVector)target.addOrGet("f0", FieldType.nullable((ArrowType)new ArrowType.Int(32, true)), IntVector.class);
            VarCharVector targetChild2 = (VarCharVector)target.addOrGet("f1", FieldType.nullable((ArrowType)new ArrowType.Utf8()), VarCharVector.class);
            ValueVectorDataPopulator.setVector(targetChild1, 0, 1, 2, 3, 4, null, 6, 7, 8, 9);
            ValueVectorDataPopulator.setVector(targetChild2, "a0", "a1", "a2", "a3", "a4", "a5", "a6", null, "a8", "a9");
            target.setValueCount(10);
            delta.addOrGet("f0", FieldType.nullable((ArrowType)new ArrowType.Int(32, true)), IntVector.class);
            delta.addOrGet("f1", FieldType.nullable((ArrowType)new ArrowType.Utf8()), VarCharVector.class);
            VectorAppender appender = new VectorAppender((ValueVector)target);
            delta.accept((VectorVisitor)appender, null);
            TestCase.assertEquals((int)10, (int)target.getValueCount());
            try (IntVector expected1 = new IntVector("expected1", this.allocator);
                 VarCharVector expected2 = new VarCharVector("expected2", this.allocator);){
                ValueVectorDataPopulator.setVector(expected1, 0, 1, 2, 3, 4, null, 6, 7, 8, 9);
                ValueVectorDataPopulator.setVector(expected2, "a0", "a1", "a2", "a3", "a4", "a5", "a6", null, "a8", "a9");
                TestVectorAppender.assertVectorsEqual((ValueVector)expected1, (ValueVector)target.getChild("f0"));
                TestVectorAppender.assertVectorsEqual((ValueVector)expected2, (ValueVector)target.getChild("f1"));
            }
        }
    }

    @Test
    public void testAppendUnionVector() {
        int length1 = 10;
        int length2 = 5;
        try (UnionVector target = UnionVector.empty((String)"target", (BufferAllocator)this.allocator);
             UnionVector delta = UnionVector.empty((String)"delta", (BufferAllocator)this.allocator);){
            int i;
            target.setType(0, Types.MinorType.INT);
            target.setType(1, Types.MinorType.BIGINT);
            target.setType(2, Types.MinorType.INT);
            target.setType(3, Types.MinorType.BIGINT);
            target.setType(4, Types.MinorType.INT);
            target.setType(5, Types.MinorType.BIGINT);
            target.setType(6, Types.MinorType.INT);
            target.setType(7, Types.MinorType.BIGINT);
            target.setType(8, Types.MinorType.INT);
            target.setType(9, Types.MinorType.BIGINT);
            target.setType(10, Types.MinorType.INT);
            target.setType(11, Types.MinorType.BIGINT);
            target.setType(12, Types.MinorType.INT);
            target.setType(13, Types.MinorType.BIGINT);
            target.setType(14, Types.MinorType.INT);
            target.setType(15, Types.MinorType.BIGINT);
            target.setType(16, Types.MinorType.INT);
            target.setType(17, Types.MinorType.BIGINT);
            target.setType(18, Types.MinorType.INT);
            target.setType(19, Types.MinorType.BIGINT);
            IntVector targetIntVec = target.getIntVector();
            targetIntVec.allocateNew();
            ValueVectorDataPopulator.setVector(targetIntVec, 0, null, 1, null, 2, null, 3, null, 4, null, 5, null, 6, null, 7, null, 8, null, 9, null);
            TestCase.assertEquals((int)20, (int)targetIntVec.getValueCount());
            BigIntVector targetBigIntVec = target.getBigIntVector();
            targetBigIntVec.allocateNew();
            ValueVectorDataPopulator.setVector(targetBigIntVec, null, 0L, null, 1L, null, 2L, null, 3L, null, 4L, null, 5L, null, 6L, null, 7L, null, 8L, null, 9L);
            TestCase.assertEquals((int)20, (int)targetBigIntVec.getValueCount());
            target.setValueCount(20);
            delta.setType(0, Types.MinorType.FLOAT4);
            delta.setType(1, Types.MinorType.FLOAT4);
            delta.setType(2, Types.MinorType.FLOAT4);
            delta.setType(3, Types.MinorType.FLOAT4);
            delta.setType(4, Types.MinorType.FLOAT4);
            Float4Vector deltaFloatVector = delta.getFloat4Vector();
            deltaFloatVector.allocateNew();
            ValueVectorDataPopulator.setVector(deltaFloatVector, Float.valueOf(10.0f), Float.valueOf(11.0f), Float.valueOf(12.0f), Float.valueOf(13.0f), Float.valueOf(14.0f));
            TestCase.assertEquals((int)5, (int)deltaFloatVector.getValueCount());
            delta.setValueCount(5);
            VectorAppender appender = new VectorAppender((ValueVector)target);
            delta.accept((VectorVisitor)appender, null);
            TestCase.assertEquals((int)25, (int)target.getValueCount());
            for (i = 0; i < 10; ++i) {
                Object intObj = target.getObject(i * 2);
                TestCase.assertTrue((boolean)(intObj instanceof Integer));
                TestCase.assertEquals((int)i, (int)((Integer)intObj));
                Object longObj = target.getObject(i * 2 + 1);
                TestCase.assertTrue((boolean)(longObj instanceof Long));
                TestCase.assertEquals((long)i, (long)((Long)longObj));
            }
            for (i = 0; i < 5; ++i) {
                Object floatObj = target.getObject(20 + i);
                TestCase.assertTrue((boolean)(floatObj instanceof Float));
                TestCase.assertEquals((int)(i + 10), (int)((Float)floatObj).intValue());
            }
        }
    }

    @Test
    public void testAppendEmptyUnionVector() {
        int length1 = 10;
        try (UnionVector target = UnionVector.empty((String)"target", (BufferAllocator)this.allocator);
             UnionVector delta = UnionVector.empty((String)"delta", (BufferAllocator)this.allocator);){
            target.setType(0, Types.MinorType.INT);
            target.setType(1, Types.MinorType.BIGINT);
            target.setType(2, Types.MinorType.INT);
            target.setType(3, Types.MinorType.BIGINT);
            target.setType(4, Types.MinorType.INT);
            target.setType(5, Types.MinorType.BIGINT);
            target.setType(6, Types.MinorType.INT);
            target.setType(7, Types.MinorType.BIGINT);
            target.setType(8, Types.MinorType.INT);
            target.setType(9, Types.MinorType.BIGINT);
            target.setType(10, Types.MinorType.INT);
            target.setType(11, Types.MinorType.BIGINT);
            target.setType(12, Types.MinorType.INT);
            target.setType(13, Types.MinorType.BIGINT);
            target.setType(14, Types.MinorType.INT);
            target.setType(15, Types.MinorType.BIGINT);
            target.setType(16, Types.MinorType.INT);
            target.setType(17, Types.MinorType.BIGINT);
            target.setType(18, Types.MinorType.INT);
            target.setType(19, Types.MinorType.BIGINT);
            IntVector targetIntVec = target.getIntVector();
            ValueVectorDataPopulator.setVector(targetIntVec, 0, null, 1, null, 2, null, 3, null, 4, null, 5, null, 6, null, 7, null, 8, null, 9, null);
            TestCase.assertEquals((int)20, (int)targetIntVec.getValueCount());
            BigIntVector targetBigIntVec = target.getBigIntVector();
            ValueVectorDataPopulator.setVector(targetBigIntVec, null, 0L, null, 1L, null, 2L, null, 3L, null, 4L, null, 5L, null, 6L, null, 7L, null, 8L, null, 9L);
            TestCase.assertEquals((int)20, (int)targetBigIntVec.getValueCount());
            target.setValueCount(20);
            delta.setType(0, Types.MinorType.FLOAT4);
            delta.setType(1, Types.MinorType.FLOAT4);
            delta.setType(2, Types.MinorType.FLOAT4);
            delta.setType(3, Types.MinorType.FLOAT4);
            delta.setType(4, Types.MinorType.FLOAT4);
            VectorAppender appender = new VectorAppender((ValueVector)target);
            delta.accept((VectorVisitor)appender, null);
            TestCase.assertEquals((int)20, (int)target.getValueCount());
            for (int i = 0; i < 10; ++i) {
                Object intObj = target.getObject(i * 2);
                TestCase.assertTrue((boolean)(intObj instanceof Integer));
                TestCase.assertEquals((int)i, (int)((Integer)intObj));
                Object longObj = target.getObject(i * 2 + 1);
                TestCase.assertTrue((boolean)(longObj instanceof Long));
                TestCase.assertEquals((long)i, (long)((Long)longObj));
            }
        }
    }

    private DenseUnionVector getTargetVector() {
        NullableIntHolder intHolder = new NullableIntHolder();
        intHolder.isSet = 1;
        NullableBigIntHolder longHolder = new NullableBigIntHolder();
        longHolder.isSet = 1;
        NullableFloat4Holder floatHolder = new NullableFloat4Holder();
        floatHolder.isSet = 1;
        DenseUnionVector targetVector = new DenseUnionVector("target vector", this.allocator, null, null);
        targetVector.allocateNew();
        while (targetVector.getValueCapacity() < 4) {
            targetVector.reAlloc();
        }
        byte intTypeId = targetVector.registerNewTypeId(Field.nullable((String)"", (ArrowType)Types.MinorType.INT.getType()));
        targetVector.setTypeId(0, intTypeId);
        intHolder.value = 1;
        targetVector.setSafe(0, intHolder);
        targetVector.setTypeId(1, intTypeId);
        intHolder.value = 2;
        targetVector.setSafe(1, intHolder);
        byte longTypeId = targetVector.registerNewTypeId(Field.nullable((String)"", (ArrowType)Types.MinorType.BIGINT.getType()));
        targetVector.setTypeId(3, longTypeId);
        longHolder.value = 10L;
        targetVector.setSafe(3, longHolder);
        targetVector.setValueCount(4);
        this.assertVectorValuesEqual((ValueVector)targetVector, new Object[]{1, 2, null, 10L});
        return targetVector;
    }

    private DenseUnionVector getDeltaVector() {
        NullableIntHolder intHolder = new NullableIntHolder();
        intHolder.isSet = 1;
        NullableBigIntHolder longHolder = new NullableBigIntHolder();
        longHolder.isSet = 1;
        NullableFloat4Holder floatHolder = new NullableFloat4Holder();
        floatHolder.isSet = 1;
        DenseUnionVector deltaVector = new DenseUnionVector("target vector", this.allocator, null, null);
        while (deltaVector.getValueCapacity() < 4) {
            deltaVector.reAlloc();
        }
        byte intTypeId = deltaVector.registerNewTypeId(Field.nullable((String)"", (ArrowType)Types.MinorType.INT.getType()));
        deltaVector.setTypeId(0, intTypeId);
        intHolder.value = 7;
        deltaVector.setSafe(0, intHolder);
        byte longTypeId = deltaVector.registerNewTypeId(Field.nullable((String)"", (ArrowType)Types.MinorType.BIGINT.getType()));
        deltaVector.setTypeId(2, longTypeId);
        longHolder.value = 8L;
        deltaVector.setSafe(2, longHolder);
        byte floatTypeId = deltaVector.registerNewTypeId(Field.nullable((String)"", (ArrowType)Types.MinorType.FLOAT4.getType()));
        deltaVector.setTypeId(3, floatTypeId);
        floatHolder.value = 9.0f;
        deltaVector.setSafe(3, floatHolder);
        deltaVector.setValueCount(4);
        this.assertVectorValuesEqual((ValueVector)deltaVector, new Object[]{7, null, 8L, Float.valueOf(9.0f)});
        return deltaVector;
    }

    @Test
    public void testAppendDenseUnionVector() {
        VectorAppender appender2;
        Throwable throwable;
        DenseUnionVector deltaVector;
        try (DenseUnionVector targetVector = this.getTargetVector();){
            deltaVector = this.getDeltaVector();
            throwable = null;
            try {
                appender2 = new VectorAppender((ValueVector)targetVector);
                deltaVector.accept((VectorVisitor)appender2, null);
                this.assertVectorValuesEqual((ValueVector)targetVector, new Object[]{1, 2, null, 10L, 7, null, 8L, Float.valueOf(9.0f)});
            }
            catch (Throwable appender2) {
                throwable = appender2;
                throw appender2;
            }
            finally {
                if (deltaVector != null) {
                    TestVectorAppender.$closeResource(throwable, (AutoCloseable)deltaVector);
                }
            }
        }
        targetVector = this.getTargetVector();
        var2_2 = null;
        try {
            deltaVector = this.getDeltaVector();
            throwable = null;
            try {
                appender2 = new VectorAppender((ValueVector)deltaVector);
                targetVector.accept((VectorVisitor)appender2, null);
                this.assertVectorValuesEqual((ValueVector)deltaVector, new Object[]{7, null, 8L, Float.valueOf(9.0f), 1, 2, null, 10L});
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (deltaVector != null) {
                    TestVectorAppender.$closeResource(throwable, (AutoCloseable)deltaVector);
                }
            }
        }
        catch (Throwable throwable3) {
            var2_2 = throwable3;
            throw throwable3;
        }
        finally {
            if (targetVector != null) {
                TestVectorAppender.$closeResource(var2_2, (AutoCloseable)targetVector);
            }
        }
    }

    private DenseUnionVector getEmptyDeltaVector() {
        DenseUnionVector deltaVector = new DenseUnionVector("target vector", this.allocator, null, null);
        byte intTypeId = deltaVector.registerNewTypeId(Field.nullable((String)"", (ArrowType)Types.MinorType.INT.getType()));
        deltaVector.setTypeId(0, intTypeId);
        byte longTypeId = deltaVector.registerNewTypeId(Field.nullable((String)"", (ArrowType)Types.MinorType.BIGINT.getType()));
        deltaVector.setTypeId(2, longTypeId);
        byte floatTypeId = deltaVector.registerNewTypeId(Field.nullable((String)"", (ArrowType)Types.MinorType.FLOAT4.getType()));
        deltaVector.setTypeId(3, floatTypeId);
        return deltaVector;
    }

    @Test
    public void testAppendEmptyDenseUnionVector() {
        try (DenseUnionVector targetVector = this.getTargetVector();
             DenseUnionVector deltaVector = this.getEmptyDeltaVector();){
            VectorAppender appender = new VectorAppender((ValueVector)targetVector);
            deltaVector.accept((VectorVisitor)appender, null);
            this.assertVectorValuesEqual((ValueVector)targetVector, new Object[]{1, 2, null, 10L});
        }
    }

    @Test
    public void testAppendDenseUnionVectorMismatch() {
        NullableIntHolder intHolder = new NullableIntHolder();
        intHolder.isSet = 1;
        NullableBigIntHolder longHolder = new NullableBigIntHolder();
        longHolder.isSet = 1;
        NullableFloat4Holder floatHolder = new NullableFloat4Holder();
        floatHolder.isSet = 1;
        try (DenseUnionVector targetVector = new DenseUnionVector("target vector", this.allocator, null, null);
             DenseUnionVector deltaVector = new DenseUnionVector("target vector", this.allocator, null, null);){
            targetVector.allocateNew();
            deltaVector.allocateNew();
            while (targetVector.getValueCapacity() < 2) {
                targetVector.reAlloc();
            }
            byte intTypeId = targetVector.registerNewTypeId(Field.nullable((String)"", (ArrowType)Types.MinorType.INT.getType()));
            targetVector.setTypeId(0, intTypeId);
            intHolder.value = 1;
            targetVector.setSafe(0, intHolder);
            byte longTypeId = targetVector.registerNewTypeId(Field.nullable((String)"", (ArrowType)Types.MinorType.BIGINT.getType()));
            targetVector.setTypeId(1, longTypeId);
            longHolder.value = 2L;
            targetVector.setSafe(1, longHolder);
            targetVector.setValueCount(2);
            this.assertVectorValuesEqual((ValueVector)targetVector, new Object[]{1, 2L});
            while (deltaVector.getValueCapacity() < 2) {
                deltaVector.reAlloc();
            }
            intTypeId = deltaVector.registerNewTypeId(Field.nullable((String)"", (ArrowType)Types.MinorType.INT.getType()));
            deltaVector.setTypeId(0, intTypeId);
            intHolder.value = 3;
            deltaVector.setSafe(0, intHolder);
            byte floatTypeId = deltaVector.registerNewTypeId(Field.nullable((String)"", (ArrowType)Types.MinorType.FLOAT4.getType()));
            deltaVector.setTypeId(1, floatTypeId);
            floatHolder.value = 5.0f;
            deltaVector.setSafe(1, floatHolder);
            deltaVector.setValueCount(2);
            this.assertVectorValuesEqual((ValueVector)deltaVector, new Object[]{3, Float.valueOf(5.0f)});
            VectorAppender appender = new VectorAppender((ValueVector)targetVector);
            Assertions.assertThrows(IllegalArgumentException.class, () -> {
                ValueVector cfr_ignored_0 = (ValueVector)deltaVector.accept((VectorVisitor)appender, null);
            });
        }
    }

    @Test
    public void testAppendVectorNegative() {
        int vectorLength = 10;
        try (IntVector target = new IntVector("", this.allocator);
             VarCharVector delta = new VarCharVector("", this.allocator);){
            target.allocateNew(10);
            delta.allocateNew(10);
            VectorAppender appender = new VectorAppender((ValueVector)target);
            Assertions.assertThrows(IllegalArgumentException.class, () -> {
                ValueVector cfr_ignored_0 = (ValueVector)delta.accept((VectorVisitor)appender, null);
            });
        }
    }

    private void assertVectorValuesEqual(ValueVector vector, Object[] values) {
        TestCase.assertEquals((int)vector.getValueCount(), (int)values.length);
        for (int i = 0; i < values.length; ++i) {
            TestCase.assertEquals((Object)vector.getObject(i), (Object)values[i]);
        }
    }

    public static void assertVectorsEqual(ValueVector vector1, ValueVector vector2) {
        TestCase.assertEquals((int)vector1.getValueCount(), (int)vector2.getValueCount());
        TypeEqualsVisitor typeEqualsVisitor = new TypeEqualsVisitor(vector1, false, false);
        RangeEqualsVisitor equalsVisitor = new RangeEqualsVisitor(vector1, vector2, (v1, v2) -> typeEqualsVisitor.equals(vector2));
        TestCase.assertTrue((boolean)equalsVisitor.rangeEquals(new Range(0, 0, vector1.getValueCount())));
    }
}

