/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.AnnotationUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class AnnotationUtilsTest {
    @TestAnnotation(booleanValue=false, booleanValues={false}, byteValue=0, byteValues={0}, charValue=0, charValues={0}, doubleValue=0.0, doubleValues={0.0}, floatValue=0.0f, floatValues={0.0f}, intValue=0, intValues={0}, longValue=0L, longValues={0L}, nest=@NestAnnotation(booleanValue=false, booleanValues={false}, byteValue=0, byteValues={0}, charValue=0, charValues={0}, doubleValue=0.0, doubleValues={0.0}, floatValue=0.0f, floatValues={0.0f}, intValue=0, intValues={0}, longValue=0L, longValues={0L}, shortValue=0, shortValues={0}, stooge=Stooge.CURLY, stooges={Stooge.MOE, Stooge.LARRY, Stooge.SHEMP}, string="", strings={""}, type=Object.class, types={Object.class}), nests={@NestAnnotation(booleanValue=false, booleanValues={false}, byteValue=0, byteValues={0}, charValue=0, charValues={0}, doubleValue=0.0, doubleValues={0.0}, floatValue=0.0f, floatValues={0.0f}, intValue=0, intValues={0}, longValue=0L, longValues={0L}, shortValue=0, shortValues={0}, stooge=Stooge.CURLY, stooges={Stooge.MOE, Stooge.LARRY, Stooge.SHEMP}, string="", strings={""}, type=Object[].class, types={Object[].class})}, shortValue=0, shortValues={0}, stooge=Stooge.SHEMP, stooges={Stooge.MOE, Stooge.LARRY, Stooge.CURLY}, string="", strings={""}, type=Object.class, types={Object.class})
    public Object dummy1;
    @TestAnnotation(booleanValue=false, booleanValues={false}, byteValue=0, byteValues={0}, charValue=0, charValues={0}, doubleValue=0.0, doubleValues={0.0}, floatValue=0.0f, floatValues={0.0f}, intValue=0, intValues={0}, longValue=0L, longValues={0L}, nest=@NestAnnotation(booleanValue=false, booleanValues={false}, byteValue=0, byteValues={0}, charValue=0, charValues={0}, doubleValue=0.0, doubleValues={0.0}, floatValue=0.0f, floatValues={0.0f}, intValue=0, intValues={0}, longValue=0L, longValues={0L}, shortValue=0, shortValues={0}, stooge=Stooge.CURLY, stooges={Stooge.MOE, Stooge.LARRY, Stooge.SHEMP}, string="", strings={""}, type=Object.class, types={Object.class}), nests={@NestAnnotation(booleanValue=false, booleanValues={false}, byteValue=0, byteValues={0}, charValue=0, charValues={0}, doubleValue=0.0, doubleValues={0.0}, floatValue=0.0f, floatValues={0.0f}, intValue=0, intValues={0}, longValue=0L, longValues={0L}, shortValue=0, shortValues={0}, stooge=Stooge.CURLY, stooges={Stooge.MOE, Stooge.LARRY, Stooge.SHEMP}, string="", strings={""}, type=Object[].class, types={Object[].class})}, shortValue=0, shortValues={0}, stooge=Stooge.SHEMP, stooges={Stooge.MOE, Stooge.LARRY, Stooge.CURLY}, string="", strings={""}, type=Object.class, types={Object.class})
    public Object dummy2;
    @TestAnnotation(booleanValue=false, booleanValues={false}, byteValue=0, byteValues={0}, charValue=0, charValues={0}, doubleValue=0.0, doubleValues={0.0}, floatValue=0.0f, floatValues={0.0f}, intValue=0, intValues={0}, longValue=0L, longValues={0L}, nest=@NestAnnotation(booleanValue=false, booleanValues={false}, byteValue=0, byteValues={0}, charValue=0, charValues={0}, doubleValue=0.0, doubleValues={0.0}, floatValue=0.0f, floatValues={0.0f}, intValue=0, intValues={0}, longValue=0L, longValues={0L}, shortValue=0, shortValues={0}, stooge=Stooge.CURLY, stooges={Stooge.MOE, Stooge.LARRY, Stooge.SHEMP}, string="", strings={""}, type=Object.class, types={Object.class}), nests={@NestAnnotation(booleanValue=false, booleanValues={false}, byteValue=0, byteValues={0}, charValue=0, charValues={0}, doubleValue=0.0, doubleValues={0.0}, floatValue=0.0f, floatValues={0.0f}, intValue=0, intValues={0}, longValue=0L, longValues={0L}, shortValue=0, shortValues={0}, stooge=Stooge.CURLY, stooges={Stooge.MOE, Stooge.LARRY, Stooge.SHEMP}, string="", strings={""}, type=Object[].class, types={Object[].class}), @NestAnnotation(booleanValue=false, booleanValues={false}, byteValue=0, byteValues={0}, charValue=0, charValues={0}, doubleValue=0.0, doubleValues={0.0}, floatValue=0.0f, floatValues={0.0f}, intValue=0, intValues={0}, longValue=0L, longValues={0L}, shortValue=0, shortValues={0}, stooge=Stooge.CURLY, stooges={Stooge.MOE, Stooge.LARRY, Stooge.SHEMP}, string="", strings={""}, type=Object[].class, types={Object[].class})}, shortValue=0, shortValues={0}, stooge=Stooge.SHEMP, stooges={Stooge.MOE, Stooge.LARRY, Stooge.CURLY}, string="", strings={""}, type=Object.class, types={Object.class})
    public Object dummy3;
    @NestAnnotation(booleanValue=false, booleanValues={false}, byteValue=0, byteValues={0}, charValue=0, charValues={0}, doubleValue=0.0, doubleValues={0.0}, floatValue=0.0f, floatValues={0.0f}, intValue=0, intValues={0}, longValue=0L, longValues={0L}, shortValue=0, shortValues={0}, stooge=Stooge.CURLY, stooges={Stooge.MOE, Stooge.LARRY, Stooge.SHEMP}, string="", strings={""}, type=Object[].class, types={Object[].class})
    public Object dummy4;
    private Field field1;
    private Field field2;
    private Field field3;
    private Field field4;

    @BeforeEach
    public void setup() throws Exception {
        this.field1 = this.getClass().getDeclaredField("dummy1");
        this.field2 = this.getClass().getDeclaredField("dummy2");
        this.field3 = this.getClass().getDeclaredField("dummy3");
        this.field4 = this.getClass().getDeclaredField("dummy4");
    }

    @Test
    public void testEquivalence() {
        Assertions.assertTrue((boolean)AnnotationUtils.equals((Annotation)this.field1.getAnnotation(TestAnnotation.class), (Annotation)this.field2.getAnnotation(TestAnnotation.class)));
        Assertions.assertTrue((boolean)AnnotationUtils.equals((Annotation)this.field2.getAnnotation(TestAnnotation.class), (Annotation)this.field1.getAnnotation(TestAnnotation.class)));
    }

    @Test
    public void testSameInstance() {
        Assertions.assertTrue((boolean)AnnotationUtils.equals((Annotation)this.field1.getAnnotation(TestAnnotation.class), (Annotation)this.field1.getAnnotation(TestAnnotation.class)));
    }

    @Test
    public void testNonEquivalentAnnotationsOfSameType() {
        Assertions.assertFalse((boolean)AnnotationUtils.equals((Annotation)this.field1.getAnnotation(TestAnnotation.class), (Annotation)this.field3.getAnnotation(TestAnnotation.class)));
        Assertions.assertFalse((boolean)AnnotationUtils.equals((Annotation)this.field3.getAnnotation(TestAnnotation.class), (Annotation)this.field1.getAnnotation(TestAnnotation.class)));
    }

    @Test
    public void testAnnotationsOfDifferingTypes() {
        Assertions.assertFalse((boolean)AnnotationUtils.equals((Annotation)this.field1.getAnnotation(TestAnnotation.class), (Annotation)this.field4.getAnnotation(NestAnnotation.class)));
        Assertions.assertFalse((boolean)AnnotationUtils.equals((Annotation)this.field4.getAnnotation(NestAnnotation.class), (Annotation)this.field1.getAnnotation(TestAnnotation.class)));
    }

    @Test
    public void testOneArgNull() {
        Assertions.assertFalse((boolean)AnnotationUtils.equals((Annotation)this.field1.getAnnotation(TestAnnotation.class), null));
        Assertions.assertFalse((boolean)AnnotationUtils.equals(null, (Annotation)this.field1.getAnnotation(TestAnnotation.class)));
    }

    @Test
    public void testBothArgsNull() {
        Assertions.assertTrue((boolean)AnnotationUtils.equals(null, null));
    }

    @Test
    public void testIsValidAnnotationMemberType() {
        for (Class type : new Class[]{Byte.TYPE, Short.TYPE, Integer.TYPE, Character.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Boolean.TYPE, String.class, Class.class, NestAnnotation.class, TestAnnotation.class, Stooge.class, ElementType.class}) {
            Assertions.assertTrue((boolean)AnnotationUtils.isValidAnnotationMemberType((Class)type));
            Assertions.assertTrue((boolean)AnnotationUtils.isValidAnnotationMemberType(Array.newInstance(type, 0).getClass()));
        }
        for (Class type : new Class[]{Object.class, Map.class, Collection.class}) {
            Assertions.assertFalse((boolean)AnnotationUtils.isValidAnnotationMemberType((Class)type));
            Assertions.assertFalse((boolean)AnnotationUtils.isValidAnnotationMemberType(Array.newInstance(type, 0).getClass()));
        }
    }

    @Test
    public void testGeneratedAnnotationEquivalentToRealAnnotation() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(666L), () -> {
            Test real = this.getClass().getDeclaredMethod("testGeneratedAnnotationEquivalentToRealAnnotation", new Class[0]).getAnnotation(Test.class);
            InvocationHandler generatedTestInvocationHandler = (proxy, method, args) -> {
                if ("equals".equals(method.getName()) && method.getParameterTypes().length == 1) {
                    return proxy == args[0];
                }
                if ("hashCode".equals(method.getName()) && method.getParameterTypes().length == 0) {
                    return System.identityHashCode(proxy);
                }
                if ("toString".equals(method.getName()) && method.getParameterTypes().length == 0) {
                    return "Test proxy";
                }
                return method.invoke((Object)real, args);
            };
            Test generated = (Test)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{Test.class}, generatedTestInvocationHandler);
            Assertions.assertEquals((Object)real, (Object)generated);
            Assertions.assertNotEquals((Object)generated, (Object)real);
            Assertions.assertTrue((boolean)AnnotationUtils.equals((Annotation)generated, (Annotation)real));
            Assertions.assertTrue((boolean)AnnotationUtils.equals((Annotation)real, (Annotation)generated));
            Test generated2 = (Test)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{Test.class}, generatedTestInvocationHandler);
            Assertions.assertNotEquals((Object)generated, (Object)generated2);
            Assertions.assertNotEquals((Object)generated2, (Object)generated);
            Assertions.assertTrue((boolean)AnnotationUtils.equals((Annotation)generated, (Annotation)generated2));
            Assertions.assertTrue((boolean)AnnotationUtils.equals((Annotation)generated2, (Annotation)generated));
        });
    }

    @Test
    public void testHashCode() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(666L), () -> {
            Test test = this.getClass().getDeclaredMethod("testHashCode", new Class[0]).getAnnotation(Test.class);
            Assertions.assertEquals((int)test.hashCode(), (int)AnnotationUtils.hashCode((Annotation)test));
            TestAnnotation testAnnotation1 = this.field1.getAnnotation(TestAnnotation.class);
            Assertions.assertEquals((int)testAnnotation1.hashCode(), (int)AnnotationUtils.hashCode((Annotation)testAnnotation1));
            TestAnnotation testAnnotation3 = this.field3.getAnnotation(TestAnnotation.class);
            Assertions.assertEquals((int)testAnnotation3.hashCode(), (int)AnnotationUtils.hashCode((Annotation)testAnnotation3));
        });
    }

    @Test
    @TestMethodAnnotation(timeout=666000L)
    public void testToString() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(666L), () -> {
            TestMethodAnnotation testAnnotation = this.getClass().getDeclaredMethod("testToString", new Class[0]).getAnnotation(TestMethodAnnotation.class);
            String annotationString = AnnotationUtils.toString((Annotation)testAnnotation);
            Assertions.assertTrue((boolean)annotationString.startsWith("@org.apache.commons.lang3.AnnotationUtilsTest$TestMethodAnnotation("));
            Assertions.assertTrue((boolean)annotationString.endsWith(")"));
            Assertions.assertTrue((boolean)annotationString.contains("expected=class org.apache.commons.lang3.AnnotationUtilsTest$TestMethodAnnotation$None"));
            Assertions.assertTrue((boolean)annotationString.contains("timeout=666000"));
            Assertions.assertTrue((boolean)annotationString.contains(", "));
        });
    }

    public static enum Stooge {
        MOE,
        LARRY,
        CURLY,
        JOE,
        SHEMP;

    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface TestMethodAnnotation {
        public Class<? extends Throwable> expected() default None.class;

        public long timeout() default 0L;

        public static class None
        extends Throwable {
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface NestAnnotation {
        public String string();

        public String[] strings();

        public Class<?> type();

        public Class<?>[] types();

        public byte byteValue();

        public byte[] byteValues();

        public short shortValue();

        public short[] shortValues();

        public int intValue();

        public int[] intValues();

        public char charValue();

        public char[] charValues();

        public long longValue();

        public long[] longValues();

        public float floatValue();

        public float[] floatValues();

        public double doubleValue();

        public double[] doubleValues();

        public boolean booleanValue();

        public boolean[] booleanValues();

        public Stooge stooge();

        public Stooge[] stooges();
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface TestAnnotation {
        public String string();

        public String[] strings();

        public Class<?> type();

        public Class<?>[] types();

        public byte byteValue();

        public byte[] byteValues();

        public short shortValue();

        public short[] shortValues();

        public int intValue();

        public int[] intValues();

        public char charValue();

        public char[] charValues();

        public long longValue();

        public long[] longValues();

        public float floatValue();

        public float[] floatValues();

        public double doubleValue();

        public double[] doubleValues();

        public boolean booleanValue();

        public boolean[] booleanValues();

        public Stooge stooge();

        public Stooge[] stooges();

        public NestAnnotation nest();

        public NestAnnotation[] nests();
    }
}

