/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.Serializable;
import java.lang.reflect.Modifier;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.CharRange;
import org.apache.commons.lang3.CharSet;
import org.apache.commons.lang3.SerializationUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CharSetTest {
    @Test
    public void testClass() {
        Assertions.assertTrue((boolean)Modifier.isPublic(CharSet.class.getModifiers()));
        Assertions.assertFalse((boolean)Modifier.isFinal(CharSet.class.getModifiers()));
    }

    @Test
    public void testGetInstance() {
        Assertions.assertSame((Object)CharSet.EMPTY, (Object)CharSet.getInstance((String[])new String[]{null}));
        Assertions.assertSame((Object)CharSet.EMPTY, (Object)CharSet.getInstance((String[])new String[]{""}));
        Assertions.assertSame((Object)CharSet.ASCII_ALPHA, (Object)CharSet.getInstance((String[])new String[]{"a-zA-Z"}));
        Assertions.assertSame((Object)CharSet.ASCII_ALPHA, (Object)CharSet.getInstance((String[])new String[]{"A-Za-z"}));
        Assertions.assertSame((Object)CharSet.ASCII_ALPHA_LOWER, (Object)CharSet.getInstance((String[])new String[]{"a-z"}));
        Assertions.assertSame((Object)CharSet.ASCII_ALPHA_UPPER, (Object)CharSet.getInstance((String[])new String[]{"A-Z"}));
        Assertions.assertSame((Object)CharSet.ASCII_NUMERIC, (Object)CharSet.getInstance((String[])new String[]{"0-9"}));
    }

    @Test
    public void testGetInstance_Stringarray() {
        Assertions.assertNull((Object)CharSet.getInstance((String[])null));
        Assertions.assertEquals((Object)"[]", (Object)CharSet.getInstance((String[])new String[0]).toString());
        Assertions.assertEquals((Object)"[]", (Object)CharSet.getInstance((String[])new String[]{null}).toString());
        Assertions.assertEquals((Object)"[a-e]", (Object)CharSet.getInstance((String[])new String[]{"a-e"}).toString());
    }

    @Test
    public void testConstructor_String_simple() {
        CharSet set = CharSet.getInstance((String[])new String[]{null});
        CharRange[] array = set.getCharRanges();
        Assertions.assertEquals((Object)"[]", (Object)set.toString());
        Assertions.assertEquals((int)0, (int)array.length);
        set = CharSet.getInstance((String[])new String[]{""});
        array = set.getCharRanges();
        Assertions.assertEquals((Object)"[]", (Object)set.toString());
        Assertions.assertEquals((int)0, (int)array.length);
        set = CharSet.getInstance((String[])new String[]{"a"});
        array = set.getCharRanges();
        Assertions.assertEquals((Object)"[a]", (Object)set.toString());
        Assertions.assertEquals((int)1, (int)array.length);
        Assertions.assertEquals((Object)"a", (Object)array[0].toString());
        set = CharSet.getInstance((String[])new String[]{"^a"});
        array = set.getCharRanges();
        Assertions.assertEquals((Object)"[^a]", (Object)set.toString());
        Assertions.assertEquals((int)1, (int)array.length);
        Assertions.assertEquals((Object)"^a", (Object)array[0].toString());
        set = CharSet.getInstance((String[])new String[]{"a-e"});
        array = set.getCharRanges();
        Assertions.assertEquals((Object)"[a-e]", (Object)set.toString());
        Assertions.assertEquals((int)1, (int)array.length);
        Assertions.assertEquals((Object)"a-e", (Object)array[0].toString());
        set = CharSet.getInstance((String[])new String[]{"^a-e"});
        array = set.getCharRanges();
        Assertions.assertEquals((Object)"[^a-e]", (Object)set.toString());
        Assertions.assertEquals((int)1, (int)array.length);
        Assertions.assertEquals((Object)"^a-e", (Object)array[0].toString());
    }

    @Test
    public void testConstructor_String_combo() {
        CharSet set = CharSet.getInstance((String[])new String[]{"abc"});
        Object[] array = set.getCharRanges();
        Assertions.assertEquals((int)3, (int)array.length);
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'a')));
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'b')));
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'c')));
        set = CharSet.getInstance((String[])new String[]{"a-ce-f"});
        array = set.getCharRanges();
        Assertions.assertEquals((int)2, (int)array.length);
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isIn((char)'a', (char)'c')));
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isIn((char)'e', (char)'f')));
        set = CharSet.getInstance((String[])new String[]{"ae-f"});
        array = set.getCharRanges();
        Assertions.assertEquals((int)2, (int)array.length);
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'a')));
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isIn((char)'e', (char)'f')));
        set = CharSet.getInstance((String[])new String[]{"e-fa"});
        array = set.getCharRanges();
        Assertions.assertEquals((int)2, (int)array.length);
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'a')));
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isIn((char)'e', (char)'f')));
        set = CharSet.getInstance((String[])new String[]{"ae-fm-pz"});
        array = set.getCharRanges();
        Assertions.assertEquals((int)4, (int)array.length);
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'a')));
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isIn((char)'e', (char)'f')));
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isIn((char)'m', (char)'p')));
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'z')));
    }

    @Test
    public void testConstructor_String_comboNegated() {
        CharSet set = CharSet.getInstance((String[])new String[]{"^abc"});
        Object[] array = set.getCharRanges();
        Assertions.assertEquals((int)3, (int)array.length);
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isNot((char)'a')));
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'b')));
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'c')));
        set = CharSet.getInstance((String[])new String[]{"b^ac"});
        array = set.getCharRanges();
        Assertions.assertEquals((int)3, (int)array.length);
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'b')));
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isNot((char)'a')));
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'c')));
        set = CharSet.getInstance((String[])new String[]{"db^ac"});
        array = set.getCharRanges();
        Assertions.assertEquals((int)4, (int)array.length);
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'d')));
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'b')));
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isNot((char)'a')));
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'c')));
        set = CharSet.getInstance((String[])new String[]{"^b^a"});
        array = set.getCharRanges();
        Assertions.assertEquals((int)2, (int)array.length);
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isNot((char)'b')));
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isNot((char)'a')));
        set = CharSet.getInstance((String[])new String[]{"b^a-c^z"});
        array = set.getCharRanges();
        Assertions.assertEquals((int)3, (int)array.length);
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isNotIn((char)'a', (char)'c')));
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isNot((char)'z')));
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'b')));
    }

    @Test
    public void testConstructor_String_oddDash() {
        CharSet set = CharSet.getInstance((String[])new String[]{"-"});
        Object[] array = set.getCharRanges();
        Assertions.assertEquals((int)1, (int)array.length);
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'-')));
        set = CharSet.getInstance((String[])new String[]{"--"});
        array = set.getCharRanges();
        Assertions.assertEquals((int)1, (int)array.length);
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'-')));
        set = CharSet.getInstance((String[])new String[]{"---"});
        array = set.getCharRanges();
        Assertions.assertEquals((int)1, (int)array.length);
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'-')));
        set = CharSet.getInstance((String[])new String[]{"----"});
        array = set.getCharRanges();
        Assertions.assertEquals((int)1, (int)array.length);
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'-')));
        set = CharSet.getInstance((String[])new String[]{"-a"});
        array = set.getCharRanges();
        Assertions.assertEquals((int)2, (int)array.length);
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'-')));
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'a')));
        set = CharSet.getInstance((String[])new String[]{"a-"});
        array = set.getCharRanges();
        Assertions.assertEquals((int)2, (int)array.length);
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'a')));
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'-')));
        set = CharSet.getInstance((String[])new String[]{"a--"});
        array = set.getCharRanges();
        Assertions.assertEquals((int)1, (int)array.length);
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isIn((char)'a', (char)'-')));
        set = CharSet.getInstance((String[])new String[]{"--a"});
        array = set.getCharRanges();
        Assertions.assertEquals((int)1, (int)array.length);
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isIn((char)'-', (char)'a')));
    }

    @Test
    public void testConstructor_String_oddNegate() {
        CharSet set = CharSet.getInstance((String[])new String[]{"^"});
        Object[] array = set.getCharRanges();
        Assertions.assertEquals((int)1, (int)array.length);
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'^')));
        set = CharSet.getInstance((String[])new String[]{"^^"});
        array = set.getCharRanges();
        Assertions.assertEquals((int)1, (int)array.length);
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isNot((char)'^')));
        set = CharSet.getInstance((String[])new String[]{"^^^"});
        array = set.getCharRanges();
        Assertions.assertEquals((int)2, (int)array.length);
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isNot((char)'^')));
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'^')));
        set = CharSet.getInstance((String[])new String[]{"^^^^"});
        array = set.getCharRanges();
        Assertions.assertEquals((int)1, (int)array.length);
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isNot((char)'^')));
        set = CharSet.getInstance((String[])new String[]{"a^"});
        array = set.getCharRanges();
        Assertions.assertEquals((int)2, (int)array.length);
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'a')));
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'^')));
        set = CharSet.getInstance((String[])new String[]{"^a-"});
        array = set.getCharRanges();
        Assertions.assertEquals((int)2, (int)array.length);
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isNot((char)'a')));
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'-')));
        set = CharSet.getInstance((String[])new String[]{"^^-c"});
        array = set.getCharRanges();
        Assertions.assertEquals((int)1, (int)array.length);
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isNotIn((char)'^', (char)'c')));
        set = CharSet.getInstance((String[])new String[]{"^c-^"});
        array = set.getCharRanges();
        Assertions.assertEquals((int)1, (int)array.length);
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isNotIn((char)'c', (char)'^')));
        set = CharSet.getInstance((String[])new String[]{"^c-^d"});
        array = set.getCharRanges();
        Assertions.assertEquals((int)2, (int)array.length);
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isNotIn((char)'c', (char)'^')));
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'d')));
        set = CharSet.getInstance((String[])new String[]{"^^-"});
        array = set.getCharRanges();
        Assertions.assertEquals((int)2, (int)array.length);
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isNot((char)'^')));
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'-')));
    }

    @Test
    public void testConstructor_String_oddCombinations() {
        CharSet set = CharSet.getInstance((String[])new String[]{"a-^c"});
        Object[] array = set.getCharRanges();
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isIn((char)'a', (char)'^')));
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'c')));
        Assertions.assertFalse((boolean)set.contains('b'));
        Assertions.assertTrue((boolean)set.contains('^'));
        Assertions.assertTrue((boolean)set.contains('_'));
        Assertions.assertTrue((boolean)set.contains('c'));
        set = CharSet.getInstance((String[])new String[]{"^a-^c"});
        array = set.getCharRanges();
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isNotIn((char)'a', (char)'^')));
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'c')));
        Assertions.assertTrue((boolean)set.contains('b'));
        Assertions.assertFalse((boolean)set.contains('^'));
        Assertions.assertFalse((boolean)set.contains('_'));
        set = CharSet.getInstance((String[])new String[]{"a- ^-- "});
        array = set.getCharRanges();
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isIn((char)'a', (char)' ')));
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isNotIn((char)'-', (char)' ')));
        Assertions.assertTrue((boolean)set.contains('#'));
        Assertions.assertTrue((boolean)set.contains('^'));
        Assertions.assertTrue((boolean)set.contains('a'));
        Assertions.assertTrue((boolean)set.contains('*'));
        Assertions.assertTrue((boolean)set.contains('A'));
        set = CharSet.getInstance((String[])new String[]{"^-b"});
        array = set.getCharRanges();
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isIn((char)'^', (char)'b')));
        Assertions.assertTrue((boolean)set.contains('b'));
        Assertions.assertTrue((boolean)set.contains('_'));
        Assertions.assertFalse((boolean)set.contains('A'));
        Assertions.assertTrue((boolean)set.contains('^'));
        set = CharSet.getInstance((String[])new String[]{"b-^"});
        array = set.getCharRanges();
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isIn((char)'^', (char)'b')));
        Assertions.assertTrue((boolean)set.contains('b'));
        Assertions.assertTrue((boolean)set.contains('^'));
        Assertions.assertTrue((boolean)set.contains('a'));
        Assertions.assertFalse((boolean)set.contains('c'));
    }

    @Test
    public void testEquals_Object() {
        CharSet abc = CharSet.getInstance((String[])new String[]{"abc"});
        CharSet abc2 = CharSet.getInstance((String[])new String[]{"abc"});
        CharSet atoc = CharSet.getInstance((String[])new String[]{"a-c"});
        CharSet atoc2 = CharSet.getInstance((String[])new String[]{"a-c"});
        CharSet notatoc = CharSet.getInstance((String[])new String[]{"^a-c"});
        CharSet notatoc2 = CharSet.getInstance((String[])new String[]{"^a-c"});
        Assertions.assertNotEquals(null, (Object)abc);
        Assertions.assertEquals((Object)abc, (Object)abc);
        Assertions.assertEquals((Object)abc, (Object)abc2);
        Assertions.assertNotEquals((Object)abc, (Object)atoc);
        Assertions.assertNotEquals((Object)abc, (Object)notatoc);
        Assertions.assertNotEquals((Object)atoc, (Object)abc);
        Assertions.assertEquals((Object)atoc, (Object)atoc);
        Assertions.assertEquals((Object)atoc, (Object)atoc2);
        Assertions.assertNotEquals((Object)atoc, (Object)notatoc);
        Assertions.assertNotEquals((Object)notatoc, (Object)abc);
        Assertions.assertNotEquals((Object)notatoc, (Object)atoc);
        Assertions.assertEquals((Object)notatoc, (Object)notatoc);
        Assertions.assertEquals((Object)notatoc, (Object)notatoc2);
    }

    @Test
    public void testHashCode() {
        CharSet abc = CharSet.getInstance((String[])new String[]{"abc"});
        CharSet abc2 = CharSet.getInstance((String[])new String[]{"abc"});
        CharSet atoc = CharSet.getInstance((String[])new String[]{"a-c"});
        CharSet atoc2 = CharSet.getInstance((String[])new String[]{"a-c"});
        CharSet notatoc = CharSet.getInstance((String[])new String[]{"^a-c"});
        CharSet notatoc2 = CharSet.getInstance((String[])new String[]{"^a-c"});
        Assertions.assertEquals((int)abc.hashCode(), (int)abc.hashCode());
        Assertions.assertEquals((int)abc.hashCode(), (int)abc2.hashCode());
        Assertions.assertEquals((int)atoc.hashCode(), (int)atoc.hashCode());
        Assertions.assertEquals((int)atoc.hashCode(), (int)atoc2.hashCode());
        Assertions.assertEquals((int)notatoc.hashCode(), (int)notatoc.hashCode());
        Assertions.assertEquals((int)notatoc.hashCode(), (int)notatoc2.hashCode());
    }

    @Test
    public void testContains_Char() {
        CharSet btod = CharSet.getInstance((String[])new String[]{"b-d"});
        CharSet dtob = CharSet.getInstance((String[])new String[]{"d-b"});
        CharSet bcd = CharSet.getInstance((String[])new String[]{"bcd"});
        CharSet bd = CharSet.getInstance((String[])new String[]{"bd"});
        CharSet notbtod = CharSet.getInstance((String[])new String[]{"^b-d"});
        Assertions.assertFalse((boolean)btod.contains('a'));
        Assertions.assertTrue((boolean)btod.contains('b'));
        Assertions.assertTrue((boolean)btod.contains('c'));
        Assertions.assertTrue((boolean)btod.contains('d'));
        Assertions.assertFalse((boolean)btod.contains('e'));
        Assertions.assertFalse((boolean)bcd.contains('a'));
        Assertions.assertTrue((boolean)bcd.contains('b'));
        Assertions.assertTrue((boolean)bcd.contains('c'));
        Assertions.assertTrue((boolean)bcd.contains('d'));
        Assertions.assertFalse((boolean)bcd.contains('e'));
        Assertions.assertFalse((boolean)bd.contains('a'));
        Assertions.assertTrue((boolean)bd.contains('b'));
        Assertions.assertFalse((boolean)bd.contains('c'));
        Assertions.assertTrue((boolean)bd.contains('d'));
        Assertions.assertFalse((boolean)bd.contains('e'));
        Assertions.assertTrue((boolean)notbtod.contains('a'));
        Assertions.assertFalse((boolean)notbtod.contains('b'));
        Assertions.assertFalse((boolean)notbtod.contains('c'));
        Assertions.assertFalse((boolean)notbtod.contains('d'));
        Assertions.assertTrue((boolean)notbtod.contains('e'));
        Assertions.assertFalse((boolean)dtob.contains('a'));
        Assertions.assertTrue((boolean)dtob.contains('b'));
        Assertions.assertTrue((boolean)dtob.contains('c'));
        Assertions.assertTrue((boolean)dtob.contains('d'));
        Assertions.assertFalse((boolean)dtob.contains('e'));
        CharRange[] array = dtob.getCharRanges();
        Assertions.assertEquals((Object)"[b-d]", (Object)dtob.toString());
        Assertions.assertEquals((int)1, (int)array.length);
    }

    @Test
    public void testSerialization() {
        CharSet set = CharSet.getInstance((String[])new String[]{"a"});
        Assertions.assertEquals((Object)set, (Object)SerializationUtils.clone((Serializable)set));
        set = CharSet.getInstance((String[])new String[]{"a-e"});
        Assertions.assertEquals((Object)set, (Object)SerializationUtils.clone((Serializable)set));
        set = CharSet.getInstance((String[])new String[]{"be-f^a-z"});
        Assertions.assertEquals((Object)set, (Object)SerializationUtils.clone((Serializable)set));
    }

    @Test
    public void testStatics() {
        Object[] array = CharSet.EMPTY.getCharRanges();
        Assertions.assertEquals((int)0, (int)array.length);
        array = CharSet.ASCII_ALPHA.getCharRanges();
        Assertions.assertEquals((int)2, (int)array.length);
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isIn((char)'a', (char)'z')));
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isIn((char)'A', (char)'Z')));
        array = CharSet.ASCII_ALPHA_LOWER.getCharRanges();
        Assertions.assertEquals((int)1, (int)array.length);
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isIn((char)'a', (char)'z')));
        array = CharSet.ASCII_ALPHA_UPPER.getCharRanges();
        Assertions.assertEquals((int)1, (int)array.length);
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isIn((char)'A', (char)'Z')));
        array = CharSet.ASCII_NUMERIC.getCharRanges();
        Assertions.assertEquals((int)1, (int)array.length);
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isIn((char)'0', (char)'9')));
    }

    @Test
    public void testJavadocExamples() {
        Assertions.assertFalse((boolean)CharSet.getInstance((String[])new String[]{"^a-c"}).contains('a'));
        Assertions.assertTrue((boolean)CharSet.getInstance((String[])new String[]{"^a-c"}).contains('d'));
        Assertions.assertTrue((boolean)CharSet.getInstance((String[])new String[]{"^^a-c"}).contains('a'));
        Assertions.assertFalse((boolean)CharSet.getInstance((String[])new String[]{"^^a-c"}).contains('^'));
        Assertions.assertTrue((boolean)CharSet.getInstance((String[])new String[]{"^a-cd-f"}).contains('d'));
        Assertions.assertTrue((boolean)CharSet.getInstance((String[])new String[]{"a-c^"}).contains('^'));
        Assertions.assertTrue((boolean)CharSet.getInstance((String[])new String[]{"^", "a-c"}).contains('^'));
    }
}

