/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class LocaleUtilsTest {
    private static final Locale LOCALE_EN = new Locale("en", "");
    private static final Locale LOCALE_EN_US = new Locale("en", "US");
    private static final Locale LOCALE_EN_US_ZZZZ = new Locale("en", "US", "ZZZZ");
    private static final Locale LOCALE_FR = new Locale("fr", "");
    private static final Locale LOCALE_FR_CA = new Locale("fr", "CA");
    private static final Locale LOCALE_QQ = new Locale("qq", "");
    private static final Locale LOCALE_QQ_ZZ = new Locale("qq", "ZZ");

    @BeforeEach
    public void setUp() {
        LocaleUtils.isAvailableLocale((Locale)Locale.getDefault());
    }

    @Test
    public void testConstructor() {
        Assertions.assertNotNull((Object)new LocaleUtils());
        Constructor<?>[] cons = LocaleUtils.class.getDeclaredConstructors();
        Assertions.assertEquals((int)1, (int)cons.length);
        Assertions.assertTrue((boolean)Modifier.isPublic(cons[0].getModifiers()));
        Assertions.assertTrue((boolean)Modifier.isPublic(LocaleUtils.class.getModifiers()));
        Assertions.assertFalse((boolean)Modifier.isFinal(LocaleUtils.class.getModifiers()));
    }

    private static void assertValidToLocale(String language) {
        Locale locale = LocaleUtils.toLocale((String)language);
        Assertions.assertNotNull((Object)locale, (String)"valid locale");
        Assertions.assertEquals((Object)language, (Object)locale.getLanguage());
        Assertions.assertTrue((locale.getCountry() == null || locale.getCountry().isEmpty() ? 1 : 0) != 0);
        Assertions.assertTrue((locale.getVariant() == null || locale.getVariant().isEmpty() ? 1 : 0) != 0);
    }

    private static void assertValidToLocale(String localeString, String language, String country) {
        Locale locale = LocaleUtils.toLocale((String)localeString);
        Assertions.assertNotNull((Object)locale, (String)"valid locale");
        Assertions.assertEquals((Object)language, (Object)locale.getLanguage());
        Assertions.assertEquals((Object)country, (Object)locale.getCountry());
        Assertions.assertTrue((locale.getVariant() == null || locale.getVariant().isEmpty() ? 1 : 0) != 0);
    }

    private static void assertValidToLocale(String localeString, String language, String country, String variant) {
        Locale locale = LocaleUtils.toLocale((String)localeString);
        Assertions.assertNotNull((Object)locale, (String)"valid locale");
        Assertions.assertEquals((Object)language, (Object)locale.getLanguage());
        Assertions.assertEquals((Object)country, (Object)locale.getCountry());
        Assertions.assertEquals((Object)variant, (Object)locale.getVariant());
    }

    @Test
    public void testToLocale_Locale_defaults() {
        Assertions.assertNull((Object)LocaleUtils.toLocale((String)null));
        Assertions.assertEquals((Object)Locale.getDefault(), (Object)LocaleUtils.toLocale((Locale)null));
        Assertions.assertEquals((Object)Locale.getDefault(), (Object)LocaleUtils.toLocale((Locale)Locale.getDefault()));
    }

    @ParameterizedTest
    @MethodSource(value={"java.util.Locale#getAvailableLocales"})
    public void testToLocales(Locale actualLocale) {
        Assertions.assertEquals((Object)actualLocale, (Object)LocaleUtils.toLocale((Locale)actualLocale));
    }

    @Test
    public void testToLocale_1Part() {
        Assertions.assertNull((Object)LocaleUtils.toLocale((String)null));
        LocaleUtilsTest.assertValidToLocale("us");
        LocaleUtilsTest.assertValidToLocale("fr");
        LocaleUtilsTest.assertValidToLocale("de");
        LocaleUtilsTest.assertValidToLocale("zh");
        LocaleUtilsTest.assertValidToLocale("qq");
        LocaleUtilsTest.assertValidToLocale("");
        Assertions.assertThrows(IllegalArgumentException.class, () -> LocaleUtils.toLocale((String)"Us"), (String)"Should fail if not lowercase");
        Assertions.assertThrows(IllegalArgumentException.class, () -> LocaleUtils.toLocale((String)"uS"), (String)"Should fail if not lowercase");
        Assertions.assertThrows(IllegalArgumentException.class, () -> LocaleUtils.toLocale((String)"u#"), (String)"Should fail if not lowercase");
        Assertions.assertThrows(IllegalArgumentException.class, () -> LocaleUtils.toLocale((String)"u"), (String)"Must be 2 chars if less than 5");
        Assertions.assertThrows(IllegalArgumentException.class, () -> LocaleUtils.toLocale((String)"uu_U"), (String)"Must be 2 chars if less than 5");
    }

    @Test
    public void testToLocale_2Part() {
        LocaleUtilsTest.assertValidToLocale("us_EN", "us", "EN");
        LocaleUtilsTest.assertValidToLocale("us_ZH", "us", "ZH");
        Assertions.assertThrows(IllegalArgumentException.class, () -> LocaleUtils.toLocale((String)"us-EN"), (String)"Should fail as not underscore");
        Assertions.assertThrows(IllegalArgumentException.class, () -> LocaleUtils.toLocale((String)"us_En"), (String)"Should fail second part not uppercase");
        Assertions.assertThrows(IllegalArgumentException.class, () -> LocaleUtils.toLocale((String)"us_en"), (String)"Should fail second part not uppercase");
        Assertions.assertThrows(IllegalArgumentException.class, () -> LocaleUtils.toLocale((String)"us_eN"), (String)"Should fail second part not uppercase");
        Assertions.assertThrows(IllegalArgumentException.class, () -> LocaleUtils.toLocale((String)"uS_EN"), (String)"Should fail first part not lowercase");
        Assertions.assertThrows(IllegalArgumentException.class, () -> LocaleUtils.toLocale((String)"us_E3"), (String)"Should fail second part not uppercase");
    }

    @Test
    public void testToLocale_3Part() {
        LocaleUtilsTest.assertValidToLocale("us_EN_A", "us", "EN", "A");
        if (SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_4)) {
            LocaleUtilsTest.assertValidToLocale("us_EN_a", "us", "EN", "a");
            LocaleUtilsTest.assertValidToLocale("us_EN_SFsafdFDsdfF", "us", "EN", "SFsafdFDsdfF");
        } else {
            LocaleUtilsTest.assertValidToLocale("us_EN_a", "us", "EN", "A");
            LocaleUtilsTest.assertValidToLocale("us_EN_SFsafdFDsdfF", "us", "EN", "SFSAFDFDSDFF");
        }
        Assertions.assertThrows(IllegalArgumentException.class, () -> LocaleUtils.toLocale((String)"us_EN-a"), (String)"Should fail as not underscore");
        Assertions.assertThrows(IllegalArgumentException.class, () -> LocaleUtils.toLocale((String)"uu_UU_"), (String)"Must be 3, 5 or 7+ in length");
    }

    private static void assertLocaleLookupList(Locale locale, Locale defaultLocale, Locale[] expected) {
        List localeList = defaultLocale == null ? LocaleUtils.localeLookupList((Locale)locale) : LocaleUtils.localeLookupList((Locale)locale, (Locale)defaultLocale);
        Assertions.assertEquals((int)expected.length, (int)localeList.size());
        Assertions.assertEquals(Arrays.asList(expected), (Object)localeList);
        LocaleUtilsTest.assertUnmodifiableCollection(localeList);
    }

    @Test
    public void testLocaleLookupList_Locale() {
        LocaleUtilsTest.assertLocaleLookupList(null, null, new Locale[0]);
        LocaleUtilsTest.assertLocaleLookupList(LOCALE_QQ, null, new Locale[]{LOCALE_QQ});
        LocaleUtilsTest.assertLocaleLookupList(LOCALE_EN, null, new Locale[]{LOCALE_EN});
        LocaleUtilsTest.assertLocaleLookupList(LOCALE_EN, null, new Locale[]{LOCALE_EN});
        LocaleUtilsTest.assertLocaleLookupList(LOCALE_EN_US, null, new Locale[]{LOCALE_EN_US, LOCALE_EN});
        LocaleUtilsTest.assertLocaleLookupList(LOCALE_EN_US_ZZZZ, null, new Locale[]{LOCALE_EN_US_ZZZZ, LOCALE_EN_US, LOCALE_EN});
    }

    @Test
    public void testLocaleLookupList_LocaleLocale() {
        LocaleUtilsTest.assertLocaleLookupList(LOCALE_QQ, LOCALE_QQ, new Locale[]{LOCALE_QQ});
        LocaleUtilsTest.assertLocaleLookupList(LOCALE_EN, LOCALE_EN, new Locale[]{LOCALE_EN});
        LocaleUtilsTest.assertLocaleLookupList(LOCALE_EN_US, LOCALE_EN_US, new Locale[]{LOCALE_EN_US, LOCALE_EN});
        LocaleUtilsTest.assertLocaleLookupList(LOCALE_EN_US, LOCALE_QQ, new Locale[]{LOCALE_EN_US, LOCALE_EN, LOCALE_QQ});
        LocaleUtilsTest.assertLocaleLookupList(LOCALE_EN_US, LOCALE_QQ_ZZ, new Locale[]{LOCALE_EN_US, LOCALE_EN, LOCALE_QQ_ZZ});
        LocaleUtilsTest.assertLocaleLookupList(LOCALE_EN_US_ZZZZ, null, new Locale[]{LOCALE_EN_US_ZZZZ, LOCALE_EN_US, LOCALE_EN});
        LocaleUtilsTest.assertLocaleLookupList(LOCALE_EN_US_ZZZZ, LOCALE_EN_US_ZZZZ, new Locale[]{LOCALE_EN_US_ZZZZ, LOCALE_EN_US, LOCALE_EN});
        LocaleUtilsTest.assertLocaleLookupList(LOCALE_EN_US_ZZZZ, LOCALE_QQ, new Locale[]{LOCALE_EN_US_ZZZZ, LOCALE_EN_US, LOCALE_EN, LOCALE_QQ});
        LocaleUtilsTest.assertLocaleLookupList(LOCALE_EN_US_ZZZZ, LOCALE_QQ_ZZ, new Locale[]{LOCALE_EN_US_ZZZZ, LOCALE_EN_US, LOCALE_EN, LOCALE_QQ_ZZ});
        LocaleUtilsTest.assertLocaleLookupList(LOCALE_FR_CA, LOCALE_EN, new Locale[]{LOCALE_FR_CA, LOCALE_FR, LOCALE_EN});
    }

    @Test
    public void testAvailableLocaleList() {
        List list = LocaleUtils.availableLocaleList();
        List list2 = LocaleUtils.availableLocaleList();
        Assertions.assertNotNull((Object)list);
        Assertions.assertSame((Object)list, (Object)list2);
        LocaleUtilsTest.assertUnmodifiableCollection(list);
        Locale[] jdkLocaleArray = Locale.getAvailableLocales();
        List<Locale> jdkLocaleList = Arrays.asList(jdkLocaleArray);
        Assertions.assertEquals(jdkLocaleList, (Object)list);
    }

    @Test
    public void testAvailableLocaleSet() {
        Set set = LocaleUtils.availableLocaleSet();
        Set set2 = LocaleUtils.availableLocaleSet();
        Assertions.assertNotNull((Object)set);
        Assertions.assertSame((Object)set, (Object)set2);
        LocaleUtilsTest.assertUnmodifiableCollection(set);
        Locale[] jdkLocaleArray = Locale.getAvailableLocales();
        List<Locale> jdkLocaleList = Arrays.asList(jdkLocaleArray);
        HashSet<Locale> jdkLocaleSet = new HashSet<Locale>(jdkLocaleList);
        Assertions.assertEquals(jdkLocaleSet, (Object)set);
    }

    @Test
    public void testIsAvailableLocale() {
        Set set = LocaleUtils.availableLocaleSet();
        Assertions.assertEquals((Object)set.contains(LOCALE_EN), (Object)LocaleUtils.isAvailableLocale((Locale)LOCALE_EN));
        Assertions.assertEquals((Object)set.contains(LOCALE_EN_US), (Object)LocaleUtils.isAvailableLocale((Locale)LOCALE_EN_US));
        Assertions.assertEquals((Object)set.contains(LOCALE_EN_US_ZZZZ), (Object)LocaleUtils.isAvailableLocale((Locale)LOCALE_EN_US_ZZZZ));
        Assertions.assertEquals((Object)set.contains(LOCALE_FR), (Object)LocaleUtils.isAvailableLocale((Locale)LOCALE_FR));
        Assertions.assertEquals((Object)set.contains(LOCALE_FR_CA), (Object)LocaleUtils.isAvailableLocale((Locale)LOCALE_FR_CA));
        Assertions.assertEquals((Object)set.contains(LOCALE_QQ), (Object)LocaleUtils.isAvailableLocale((Locale)LOCALE_QQ));
        Assertions.assertEquals((Object)set.contains(LOCALE_QQ_ZZ), (Object)LocaleUtils.isAvailableLocale((Locale)LOCALE_QQ_ZZ));
    }

    @Test
    public void testThreeCharsLocale() {
        for (String str : Arrays.asList("udm", "tet")) {
            Locale locale = LocaleUtils.toLocale((String)str);
            Assertions.assertNotNull((Object)locale);
            Assertions.assertEquals((Object)str, (Object)locale.getLanguage());
            Assertions.assertTrue((boolean)StringUtils.isBlank((CharSequence)locale.getCountry()));
            Assertions.assertEquals((Object)new Locale(str), (Object)locale);
        }
    }

    private static void assertLanguageByCountry(String country, String[] languages) {
        List list = LocaleUtils.languagesByCountry((String)country);
        List list2 = LocaleUtils.languagesByCountry((String)country);
        Assertions.assertNotNull((Object)list);
        Assertions.assertSame((Object)list, (Object)list2);
        for (String language : languages) {
            Iterator iterator = list.iterator();
            boolean found = false;
            while (iterator.hasNext()) {
                Locale locale = (Locale)iterator.next();
                Assertions.assertTrue((locale.getVariant() == null || locale.getVariant().isEmpty() ? 1 : 0) != 0);
                Assertions.assertEquals((Object)country, (Object)locale.getCountry());
                if (!language.equals(locale.getLanguage())) continue;
                found = true;
                break;
            }
            Assertions.assertTrue((boolean)found, (String)("Could not find language: " + language + " for country: " + country));
        }
        LocaleUtilsTest.assertUnmodifiableCollection(list);
    }

    @Test
    public void testLanguagesByCountry() {
        LocaleUtilsTest.assertLanguageByCountry(null, new String[0]);
        LocaleUtilsTest.assertLanguageByCountry("GB", new String[]{"en"});
        LocaleUtilsTest.assertLanguageByCountry("ZZ", new String[0]);
        LocaleUtilsTest.assertLanguageByCountry("CH", new String[]{"fr", "de", "it"});
    }

    private static void assertCountriesByLanguage(String language, String[] countries) {
        List list = LocaleUtils.countriesByLanguage((String)language);
        List list2 = LocaleUtils.countriesByLanguage((String)language);
        Assertions.assertNotNull((Object)list);
        Assertions.assertSame((Object)list, (Object)list2);
        for (String country : countries) {
            Iterator iterator = list.iterator();
            boolean found = false;
            while (iterator.hasNext()) {
                Locale locale = (Locale)iterator.next();
                Assertions.assertTrue((locale.getVariant() == null || locale.getVariant().isEmpty() ? 1 : 0) != 0);
                Assertions.assertEquals((Object)language, (Object)locale.getLanguage());
                if (!country.equals(locale.getCountry())) continue;
                found = true;
                break;
            }
            Assertions.assertTrue((boolean)found, (String)("Could not find language: " + country + " for country: " + language));
        }
        LocaleUtilsTest.assertUnmodifiableCollection(list);
    }

    @Test
    public void testCountriesByLanguage() {
        LocaleUtilsTest.assertCountriesByLanguage(null, new String[0]);
        LocaleUtilsTest.assertCountriesByLanguage("de", new String[]{"DE", "CH", "AT", "LU"});
        LocaleUtilsTest.assertCountriesByLanguage("zz", new String[0]);
        LocaleUtilsTest.assertCountriesByLanguage("it", new String[]{"IT", "CH"});
    }

    private static void assertUnmodifiableCollection(Collection<?> coll) {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> coll.add(null));
    }

    @Test
    public void testLang328() {
        LocaleUtilsTest.assertValidToLocale("fr__P", "fr", "", "P");
        LocaleUtilsTest.assertValidToLocale("fr__POSIX", "fr", "", "POSIX");
    }

    @Test
    public void testLanguageAndUNM49Numeric3AreaCodeLang1312() {
        LocaleUtilsTest.assertValidToLocale("en_001", "en", "001");
        LocaleUtilsTest.assertValidToLocale("en_150", "en", "150");
        LocaleUtilsTest.assertValidToLocale("ar_001", "ar", "001");
        LocaleUtilsTest.assertValidToLocale("en_001_GB", "en", "001", "GB");
        LocaleUtilsTest.assertValidToLocale("en_150_US", "en", "150", "US");
    }

    @Test
    public void testLang865() {
        LocaleUtilsTest.assertValidToLocale("_GB", "", "GB", "");
        LocaleUtilsTest.assertValidToLocale("_GB_P", "", "GB", "P");
        LocaleUtilsTest.assertValidToLocale("_GB_POSIX", "", "GB", "POSIX");
        Assertions.assertThrows(IllegalArgumentException.class, () -> LocaleUtils.toLocale((String)"_G"), (String)"Must be at least 3 chars if starts with underscore");
        Assertions.assertThrows(IllegalArgumentException.class, () -> LocaleUtils.toLocale((String)"_Gb"), (String)"Must be uppercase if starts with underscore");
        Assertions.assertThrows(IllegalArgumentException.class, () -> LocaleUtils.toLocale((String)"_gB"), (String)"Must be uppercase if starts with underscore");
        Assertions.assertThrows(IllegalArgumentException.class, () -> LocaleUtils.toLocale((String)"_1B"), (String)"Must be letter if starts with underscore");
        Assertions.assertThrows(IllegalArgumentException.class, () -> LocaleUtils.toLocale((String)"_G1"), (String)"Must be letter if starts with underscore");
        Assertions.assertThrows(IllegalArgumentException.class, () -> LocaleUtils.toLocale((String)"_GB_"), (String)"Must be at least 5 chars if starts with underscore");
        Assertions.assertThrows(IllegalArgumentException.class, () -> LocaleUtils.toLocale((String)"_GBAP"), (String)"Must have underscore after the country if starts with underscore and is at least 5 chars");
    }

    @ParameterizedTest
    @MethodSource(value={"java.util.Locale#getAvailableLocales"})
    public void testParseAllLocales(Locale actualLocale) {
        Locale locale = new Locale(actualLocale.getLanguage(), actualLocale.getCountry(), actualLocale.getVariant());
        if (actualLocale.equals(locale)) {
            String str = actualLocale.toString();
            int suff = str.indexOf("_#");
            if (suff == -1) {
                suff = str.indexOf("#");
            }
            String localeStr = str;
            if (suff >= 0) {
                Assertions.assertThrows(IllegalArgumentException.class, () -> LocaleUtils.toLocale((String)str));
                localeStr = str.substring(0, suff);
            }
            Locale loc = LocaleUtils.toLocale((String)localeStr);
            Assertions.assertEquals((Object)actualLocale, (Object)loc);
        }
    }
}

