/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import org.apache.commons.lang3.RandomUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RandomUtilsTest {
    private static final double DELTA = 1.0E-5;

    @Test
    public void testConstructor() {
        Assertions.assertNotNull((Object)new RandomUtils());
        Constructor<?>[] cons = RandomUtils.class.getDeclaredConstructors();
        Assertions.assertEquals((int)1, (int)cons.length);
        Assertions.assertTrue((boolean)Modifier.isPublic(cons[0].getModifiers()));
        Assertions.assertTrue((boolean)Modifier.isPublic(RandomUtils.class.getModifiers()));
        Assertions.assertFalse((boolean)Modifier.isFinal(RandomUtils.class.getModifiers()));
    }

    @Test
    public void testNextBytesNegative() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> RandomUtils.nextBytes((int)-1));
    }

    @Test
    public void testNextIntNegative() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> RandomUtils.nextInt((int)-1, (int)1));
    }

    @Test
    public void testNextLongNegative() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> RandomUtils.nextLong((long)-1L, (long)1L));
    }

    @Test
    public void testNextDoubleNegative() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> RandomUtils.nextDouble((double)-1.0, (double)1.0));
    }

    @Test
    public void testNextFloatNegative() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> RandomUtils.nextFloat((float)-1.0f, (float)1.0f));
    }

    @Test
    public void testNextIntLowerGreaterUpper() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> RandomUtils.nextInt((int)2, (int)1));
    }

    @Test
    public void testNextLongLowerGreaterUpper() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> RandomUtils.nextLong((long)2L, (long)1L));
    }

    @Test
    public void testNextDoubleLowerGreaterUpper() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> RandomUtils.nextDouble((double)2.0, (double)1.0));
    }

    @Test
    public void testNextFloatLowerGreaterUpper() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> RandomUtils.nextFloat((float)2.0f, (float)1.0f));
    }

    @Test
    public void testBoolean() {
        boolean result = RandomUtils.nextBoolean();
        Assertions.assertTrue((result || !result ? 1 : 0) != 0);
    }

    @Test
    public void testZeroLengthNextBytes() {
        Assertions.assertArrayEquals((byte[])new byte[0], (byte[])RandomUtils.nextBytes((int)0));
    }

    @Test
    public void testNextBytes() {
        byte[] result = RandomUtils.nextBytes((int)20);
        Assertions.assertEquals((int)20, (int)result.length);
    }

    @Test
    public void testNextIntMinimalRange() {
        Assertions.assertEquals((int)42, (int)RandomUtils.nextInt((int)42, (int)42));
    }

    @Test
    public void testNextInt() {
        int result = RandomUtils.nextInt((int)33, (int)42);
        Assertions.assertTrue((result >= 33 && result < 42 ? 1 : 0) != 0);
    }

    @Test
    public void testNextIntRandomResult() {
        int randomResult = RandomUtils.nextInt();
        Assertions.assertTrue((randomResult > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((randomResult < Integer.MAX_VALUE ? 1 : 0) != 0);
    }

    @Test
    public void testNextDoubleMinimalRange() {
        Assertions.assertEquals((double)42.1, (double)RandomUtils.nextDouble((double)42.1, (double)42.1), (double)1.0E-5);
    }

    @Test
    public void testNextFloatMinimalRange() {
        Assertions.assertEquals((double)42.1f, (double)RandomUtils.nextFloat((float)42.1f, (float)42.1f), (double)1.0E-5);
    }

    @Test
    public void testNextDouble() {
        double result = RandomUtils.nextDouble((double)33.0, (double)42.0);
        Assertions.assertTrue((result >= 33.0 && result <= 42.0 ? 1 : 0) != 0);
    }

    @Test
    public void testNextDoubleRandomResult() {
        double randomResult = RandomUtils.nextDouble();
        Assertions.assertTrue((randomResult > 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((randomResult < Double.MAX_VALUE ? 1 : 0) != 0);
    }

    @Test
    public void testNextFloat() {
        double result = RandomUtils.nextFloat((float)33.0f, (float)42.0f);
        Assertions.assertTrue((result >= 33.0 && result <= 42.0 ? 1 : 0) != 0);
    }

    @Test
    public void testNextFloatRandomResult() {
        float randomResult = RandomUtils.nextFloat();
        Assertions.assertTrue((randomResult > 0.0f ? 1 : 0) != 0);
        Assertions.assertTrue((randomResult < Float.MAX_VALUE ? 1 : 0) != 0);
    }

    @Test
    public void testNextLongMinimalRange() {
        Assertions.assertEquals((long)42L, (long)RandomUtils.nextLong((long)42L, (long)42L));
    }

    @Test
    public void testNextLong() {
        long result = RandomUtils.nextLong((long)33L, (long)42L);
        Assertions.assertTrue((result >= 33L && result < 42L ? 1 : 0) != 0);
    }

    @Test
    public void testNextLongRandomResult() {
        long randomResult = RandomUtils.nextLong();
        Assertions.assertTrue((randomResult > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((randomResult < Long.MAX_VALUE ? 1 : 0) != 0);
    }

    @Test
    public void testExtremeRangeInt() {
        int result = RandomUtils.nextInt((int)0, (int)Integer.MAX_VALUE);
        Assertions.assertTrue((result >= 0 && result < Integer.MAX_VALUE ? 1 : 0) != 0);
    }

    @Test
    public void testExtremeRangeLong() {
        long result = RandomUtils.nextLong((long)0L, (long)Long.MAX_VALUE);
        Assertions.assertTrue((result >= 0L && result < Long.MAX_VALUE ? 1 : 0) != 0);
    }

    @Test
    public void testExtremeRangeFloat() {
        float result = RandomUtils.nextFloat((float)0.0f, (float)Float.MAX_VALUE);
        Assertions.assertTrue((result >= 0.0f && result <= Float.MAX_VALUE ? 1 : 0) != 0);
    }

    @Test
    public void testExtremeRangeDouble() {
        double result = RandomUtils.nextDouble((double)0.0, (double)Double.MAX_VALUE);
        Assertions.assertTrue((result >= 0.0 && result <= Double.MAX_VALUE ? 1 : 0) != 0);
    }

    @Test
    public void testLargeValueRangeLong() {
        long startInclusive = 12900000000001L;
        long endExclusive = 12900000000016L;
        int n = 15000;
        for (int i = 0; i < 15000; ++i) {
            Assertions.assertNotEquals((long)12900000000016L, (long)RandomUtils.nextLong((long)12900000000001L, (long)12900000000016L));
        }
    }
}

