/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junitpioneer.jupiter.DefaultLocale;

public class StringUtilsContainsTest {
    private static final String CharU20000 = "\ud840\udc00";
    private static final String CharU20001 = "\ud840\udc01";
    private static final String CharUSuppCharHigh = "\udc00";
    private static final String CharUSuppCharLow = "\ud840";

    @Test
    public void testContains_Char() {
        Assertions.assertFalse((boolean)StringUtils.contains(null, (int)32));
        Assertions.assertFalse((boolean)StringUtils.contains((CharSequence)"", (int)32));
        Assertions.assertFalse((boolean)StringUtils.contains((CharSequence)"", null));
        Assertions.assertFalse((boolean)StringUtils.contains(null, null));
        Assertions.assertTrue((boolean)StringUtils.contains((CharSequence)"abc", (int)97));
        Assertions.assertTrue((boolean)StringUtils.contains((CharSequence)"abc", (int)98));
        Assertions.assertTrue((boolean)StringUtils.contains((CharSequence)"abc", (int)99));
        Assertions.assertFalse((boolean)StringUtils.contains((CharSequence)"abc", (int)122));
    }

    @Test
    public void testContains_String() {
        Assertions.assertFalse((boolean)StringUtils.contains(null, null));
        Assertions.assertFalse((boolean)StringUtils.contains(null, (CharSequence)""));
        Assertions.assertFalse((boolean)StringUtils.contains(null, (CharSequence)"a"));
        Assertions.assertFalse((boolean)StringUtils.contains((CharSequence)"", null));
        Assertions.assertTrue((boolean)StringUtils.contains((CharSequence)"", (CharSequence)""));
        Assertions.assertFalse((boolean)StringUtils.contains((CharSequence)"", (CharSequence)"a"));
        Assertions.assertTrue((boolean)StringUtils.contains((CharSequence)"abc", (CharSequence)"a"));
        Assertions.assertTrue((boolean)StringUtils.contains((CharSequence)"abc", (CharSequence)"b"));
        Assertions.assertTrue((boolean)StringUtils.contains((CharSequence)"abc", (CharSequence)"c"));
        Assertions.assertTrue((boolean)StringUtils.contains((CharSequence)"abc", (CharSequence)"abc"));
        Assertions.assertFalse((boolean)StringUtils.contains((CharSequence)"abc", (CharSequence)"z"));
    }

    @Test
    public void testContains_StringWithBadSupplementaryChars() {
        Assertions.assertFalse((boolean)StringUtils.contains((CharSequence)CharUSuppCharHigh, (CharSequence)CharU20001));
        Assertions.assertFalse((boolean)StringUtils.contains((CharSequence)CharUSuppCharLow, (CharSequence)CharU20001));
        Assertions.assertFalse((boolean)StringUtils.contains((CharSequence)CharU20001, (CharSequence)CharUSuppCharHigh));
        Assertions.assertEquals((int)0, (int)CharU20001.indexOf(CharUSuppCharLow));
        Assertions.assertTrue((boolean)StringUtils.contains((CharSequence)CharU20001, (CharSequence)CharUSuppCharLow));
        Assertions.assertTrue((boolean)StringUtils.contains((CharSequence)"\ud840\udc01\ud840a", (CharSequence)"a"));
        Assertions.assertTrue((boolean)StringUtils.contains((CharSequence)"\ud840\udc01\udc00a", (CharSequence)"a"));
    }

    @Test
    public void testContains_StringWithSupplementaryChars() {
        Assertions.assertTrue((boolean)StringUtils.contains((CharSequence)"\ud840\udc00\ud840\udc01", (CharSequence)CharU20000));
        Assertions.assertTrue((boolean)StringUtils.contains((CharSequence)"\ud840\udc00\ud840\udc01", (CharSequence)CharU20001));
        Assertions.assertTrue((boolean)StringUtils.contains((CharSequence)CharU20000, (CharSequence)CharU20000));
        Assertions.assertFalse((boolean)StringUtils.contains((CharSequence)CharU20000, (CharSequence)CharU20001));
    }

    @Test
    public void testContainsAny_StringCharArray() {
        Assertions.assertFalse((boolean)StringUtils.containsAny(null, (char[])null));
        Assertions.assertFalse((boolean)StringUtils.containsAny(null, (char[])new char[0]));
        Assertions.assertFalse((boolean)StringUtils.containsAny(null, (char[])new char[]{'a', 'b'}));
        Assertions.assertFalse((boolean)StringUtils.containsAny((CharSequence)"", (char[])null));
        Assertions.assertFalse((boolean)StringUtils.containsAny((CharSequence)"", (char[])new char[0]));
        Assertions.assertFalse((boolean)StringUtils.containsAny((CharSequence)"", (char[])new char[]{'a', 'b'}));
        Assertions.assertFalse((boolean)StringUtils.containsAny((CharSequence)"zzabyycdxx", (char[])null));
        Assertions.assertFalse((boolean)StringUtils.containsAny((CharSequence)"zzabyycdxx", (char[])new char[0]));
        Assertions.assertTrue((boolean)StringUtils.containsAny((CharSequence)"zzabyycdxx", (char[])new char[]{'z', 'a'}));
        Assertions.assertTrue((boolean)StringUtils.containsAny((CharSequence)"zzabyycdxx", (char[])new char[]{'b', 'y'}));
        Assertions.assertTrue((boolean)StringUtils.containsAny((CharSequence)"zzabyycdxx", (char[])new char[]{'z', 'y'}));
        Assertions.assertFalse((boolean)StringUtils.containsAny((CharSequence)"ab", (char[])new char[]{'z'}));
    }

    @Test
    public void testContainsAny_StringCharArrayWithBadSupplementaryChars() {
        Assertions.assertFalse((boolean)StringUtils.containsAny((CharSequence)CharUSuppCharHigh, (char[])CharU20001.toCharArray()));
        Assertions.assertFalse((boolean)StringUtils.containsAny((CharSequence)"abc\udc00xyz", (char[])CharU20001.toCharArray()));
        Assertions.assertEquals((int)-1, (int)CharUSuppCharLow.indexOf(CharU20001));
        Assertions.assertFalse((boolean)StringUtils.containsAny((CharSequence)CharUSuppCharLow, (char[])CharU20001.toCharArray()));
        Assertions.assertFalse((boolean)StringUtils.containsAny((CharSequence)CharU20001, (char[])CharUSuppCharHigh.toCharArray()));
        Assertions.assertEquals((int)0, (int)CharU20001.indexOf(CharUSuppCharLow));
        Assertions.assertTrue((boolean)StringUtils.containsAny((CharSequence)CharU20001, (char[])CharUSuppCharLow.toCharArray()));
    }

    @Test
    public void testContainsAny_StringCharArrayWithSupplementaryChars() {
        Assertions.assertTrue((boolean)StringUtils.containsAny((CharSequence)"\ud840\udc00\ud840\udc01", (char[])CharU20000.toCharArray()));
        Assertions.assertTrue((boolean)StringUtils.containsAny((CharSequence)"a\ud840\udc00\ud840\udc01", (char[])"a".toCharArray()));
        Assertions.assertTrue((boolean)StringUtils.containsAny((CharSequence)"\ud840\udc00a\ud840\udc01", (char[])"a".toCharArray()));
        Assertions.assertTrue((boolean)StringUtils.containsAny((CharSequence)"\ud840\udc00\ud840\udc01a", (char[])"a".toCharArray()));
        Assertions.assertTrue((boolean)StringUtils.containsAny((CharSequence)"\ud840\udc00\ud840\udc01", (char[])CharU20001.toCharArray()));
        Assertions.assertTrue((boolean)StringUtils.containsAny((CharSequence)CharU20000, (char[])CharU20000.toCharArray()));
        Assertions.assertEquals((int)-1, (int)CharU20000.indexOf(CharU20001));
        Assertions.assertEquals((int)0, (int)CharU20000.indexOf(CharU20001.charAt(0)));
        Assertions.assertEquals((int)-1, (int)CharU20000.indexOf(CharU20001.charAt(1)));
        Assertions.assertFalse((boolean)StringUtils.containsAny((CharSequence)CharU20000, (char[])CharU20001.toCharArray()));
        Assertions.assertFalse((boolean)StringUtils.containsAny((CharSequence)CharU20001, (char[])CharU20000.toCharArray()));
    }

    @Test
    public void testContainsAny_StringString() {
        Assertions.assertFalse((boolean)StringUtils.containsAny(null, (CharSequence)null));
        Assertions.assertFalse((boolean)StringUtils.containsAny(null, (CharSequence)""));
        Assertions.assertFalse((boolean)StringUtils.containsAny(null, (CharSequence)"ab"));
        Assertions.assertFalse((boolean)StringUtils.containsAny((CharSequence)"", (CharSequence)null));
        Assertions.assertFalse((boolean)StringUtils.containsAny((CharSequence)"", (CharSequence)""));
        Assertions.assertFalse((boolean)StringUtils.containsAny((CharSequence)"", (CharSequence)"ab"));
        Assertions.assertFalse((boolean)StringUtils.containsAny((CharSequence)"zzabyycdxx", (CharSequence)null));
        Assertions.assertFalse((boolean)StringUtils.containsAny((CharSequence)"zzabyycdxx", (CharSequence)""));
        Assertions.assertTrue((boolean)StringUtils.containsAny((CharSequence)"zzabyycdxx", (CharSequence)"za"));
        Assertions.assertTrue((boolean)StringUtils.containsAny((CharSequence)"zzabyycdxx", (CharSequence)"by"));
        Assertions.assertTrue((boolean)StringUtils.containsAny((CharSequence)"zzabyycdxx", (CharSequence)"zy"));
        Assertions.assertFalse((boolean)StringUtils.containsAny((CharSequence)"ab", (CharSequence)"z"));
    }

    @Test
    public void testContainsAny_StringStringArray() {
        Assertions.assertFalse((boolean)StringUtils.containsAny(null, (CharSequence[])null));
        Assertions.assertFalse((boolean)StringUtils.containsAny(null, (CharSequence[])new String[0]));
        Assertions.assertFalse((boolean)StringUtils.containsAny(null, (CharSequence[])new String[]{"hello"}));
        Assertions.assertFalse((boolean)StringUtils.containsAny((CharSequence)"", (CharSequence[])null));
        Assertions.assertFalse((boolean)StringUtils.containsAny((CharSequence)"", (CharSequence[])new String[0]));
        Assertions.assertFalse((boolean)StringUtils.containsAny((CharSequence)"", (CharSequence[])new String[]{"hello"}));
        Assertions.assertFalse((boolean)StringUtils.containsAny((CharSequence)"hello, goodbye", (CharSequence[])null));
        Assertions.assertFalse((boolean)StringUtils.containsAny((CharSequence)"hello, goodbye", (CharSequence[])new String[0]));
        Assertions.assertTrue((boolean)StringUtils.containsAny((CharSequence)"hello, goodbye", (CharSequence[])new String[]{"hello", "goodbye"}));
        Assertions.assertTrue((boolean)StringUtils.containsAny((CharSequence)"hello, goodbye", (CharSequence[])new String[]{"hello", "Goodbye"}));
        Assertions.assertFalse((boolean)StringUtils.containsAny((CharSequence)"hello, goodbye", (CharSequence[])new String[]{"Hello", "Goodbye"}));
        Assertions.assertFalse((boolean)StringUtils.containsAny((CharSequence)"hello, goodbye", (CharSequence[])new String[]{"Hello", null}));
        Assertions.assertFalse((boolean)StringUtils.containsAny((CharSequence)"hello, null", (CharSequence[])new String[]{"Hello", null}));
        Assertions.assertTrue((boolean)StringUtils.containsAny((CharSequence)"abcd", (CharSequence[])new CharSequence[]{"ab", null}));
        Assertions.assertTrue((boolean)StringUtils.containsAny((CharSequence)"abcd", (CharSequence[])new CharSequence[]{"ab", "cd"}));
        Assertions.assertTrue((boolean)StringUtils.containsAny((CharSequence)"abc", (CharSequence[])new CharSequence[]{"d", "abc"}));
    }

    @Test
    public void testContainsAnyIgnoreCase_StringStringArray() {
        Assertions.assertFalse((boolean)StringUtils.containsAnyIgnoreCase(null, (CharSequence[])null));
        Assertions.assertFalse((boolean)StringUtils.containsAnyIgnoreCase(null, (CharSequence[])new String[0]));
        Assertions.assertFalse((boolean)StringUtils.containsAnyIgnoreCase(null, (CharSequence[])new String[]{"hello"}));
        Assertions.assertFalse((boolean)StringUtils.containsAnyIgnoreCase((CharSequence)"", (CharSequence[])null));
        Assertions.assertFalse((boolean)StringUtils.containsAnyIgnoreCase((CharSequence)"", (CharSequence[])new String[0]));
        Assertions.assertFalse((boolean)StringUtils.containsAnyIgnoreCase((CharSequence)"", (CharSequence[])new String[]{"hello"}));
        Assertions.assertFalse((boolean)StringUtils.containsAnyIgnoreCase((CharSequence)"hello, goodbye", (CharSequence[])null));
        Assertions.assertFalse((boolean)StringUtils.containsAnyIgnoreCase((CharSequence)"hello, goodbye", (CharSequence[])new String[0]));
        Assertions.assertTrue((boolean)StringUtils.containsAnyIgnoreCase((CharSequence)"hello, goodbye", (CharSequence[])new String[]{"hello", "goodbye"}));
        Assertions.assertTrue((boolean)StringUtils.containsAnyIgnoreCase((CharSequence)"hello, goodbye", (CharSequence[])new String[]{"hello", "Goodbye"}));
        Assertions.assertTrue((boolean)StringUtils.containsAnyIgnoreCase((CharSequence)"hello, goodbye", (CharSequence[])new String[]{"Hello", "Goodbye"}));
        Assertions.assertTrue((boolean)StringUtils.containsAnyIgnoreCase((CharSequence)"hello, goodbye", (CharSequence[])new String[]{"Hello", null}));
        Assertions.assertTrue((boolean)StringUtils.containsAnyIgnoreCase((CharSequence)"hello, null", (CharSequence[])new String[]{"Hello", null}));
        Assertions.assertTrue((boolean)StringUtils.containsAnyIgnoreCase((CharSequence)"abcd", (CharSequence[])new CharSequence[]{"ab", null}));
        Assertions.assertTrue((boolean)StringUtils.containsAnyIgnoreCase((CharSequence)"abcd", (CharSequence[])new CharSequence[]{"ab", "cd"}));
        Assertions.assertTrue((boolean)StringUtils.containsAnyIgnoreCase((CharSequence)"abc", (CharSequence[])new CharSequence[]{"d", "abc"}));
    }

    @Test
    public void testContainsAny_StringWithBadSupplementaryChars() {
        Assertions.assertFalse((boolean)StringUtils.containsAny((CharSequence)CharUSuppCharHigh, (CharSequence)CharU20001));
        Assertions.assertEquals((int)-1, (int)CharUSuppCharLow.indexOf(CharU20001));
        Assertions.assertFalse((boolean)StringUtils.containsAny((CharSequence)CharUSuppCharLow, (CharSequence)CharU20001));
        Assertions.assertFalse((boolean)StringUtils.containsAny((CharSequence)CharU20001, (CharSequence)CharUSuppCharHigh));
        Assertions.assertEquals((int)0, (int)CharU20001.indexOf(CharUSuppCharLow));
        Assertions.assertTrue((boolean)StringUtils.containsAny((CharSequence)CharU20001, (CharSequence)CharUSuppCharLow));
    }

    @Test
    public void testContainsAny_StringWithSupplementaryChars() {
        Assertions.assertTrue((boolean)StringUtils.containsAny((CharSequence)"\ud840\udc00\ud840\udc01", (CharSequence)CharU20000));
        Assertions.assertTrue((boolean)StringUtils.containsAny((CharSequence)"\ud840\udc00\ud840\udc01", (CharSequence)CharU20001));
        Assertions.assertTrue((boolean)StringUtils.containsAny((CharSequence)CharU20000, (CharSequence)CharU20000));
        Assertions.assertEquals((int)-1, (int)CharU20000.indexOf(CharU20001));
        Assertions.assertEquals((int)0, (int)CharU20000.indexOf(CharU20001.charAt(0)));
        Assertions.assertEquals((int)-1, (int)CharU20000.indexOf(CharU20001.charAt(1)));
        Assertions.assertFalse((boolean)StringUtils.containsAny((CharSequence)CharU20000, (CharSequence)CharU20001));
        Assertions.assertFalse((boolean)StringUtils.containsAny((CharSequence)CharU20001, (CharSequence)CharU20000));
    }

    @DefaultLocale(language="de", country="DE")
    @Test
    public void testContainsIgnoreCase_LocaleIndependence() {
        Locale[] locales = new Locale[]{Locale.ENGLISH, new Locale("tr"), Locale.getDefault()};
        String[][] tdata = new String[][]{{"i", "I"}, {"I", "i"}, {"\u03c2", "\u03c3"}, {"\u03a3", "\u03c2"}, {"\u03a3", "\u03c3"}};
        String[][] fdata = new String[][]{{"\u00df", "SS"}};
        for (Locale testLocale : locales) {
            int j;
            Locale.setDefault(testLocale);
            for (j = 0; j < tdata.length; ++j) {
                Assertions.assertTrue((boolean)StringUtils.containsIgnoreCase((CharSequence)tdata[j][0], (CharSequence)tdata[j][1]), (String)(Locale.getDefault() + ": " + j + " " + tdata[j][0] + " " + tdata[j][1]));
            }
            for (j = 0; j < fdata.length; ++j) {
                Assertions.assertFalse((boolean)StringUtils.containsIgnoreCase((CharSequence)fdata[j][0], (CharSequence)fdata[j][1]), (String)(Locale.getDefault() + ": " + j + " " + fdata[j][0] + " " + fdata[j][1]));
            }
        }
    }

    @Test
    public void testContainsIgnoreCase_StringString() {
        Assertions.assertFalse((boolean)StringUtils.containsIgnoreCase(null, null));
        Assertions.assertFalse((boolean)StringUtils.containsIgnoreCase(null, (CharSequence)""));
        Assertions.assertFalse((boolean)StringUtils.containsIgnoreCase(null, (CharSequence)"a"));
        Assertions.assertFalse((boolean)StringUtils.containsIgnoreCase(null, (CharSequence)"abc"));
        Assertions.assertFalse((boolean)StringUtils.containsIgnoreCase((CharSequence)"", null));
        Assertions.assertFalse((boolean)StringUtils.containsIgnoreCase((CharSequence)"a", null));
        Assertions.assertFalse((boolean)StringUtils.containsIgnoreCase((CharSequence)"abc", null));
        Assertions.assertTrue((boolean)StringUtils.containsIgnoreCase((CharSequence)"", (CharSequence)""));
        Assertions.assertTrue((boolean)StringUtils.containsIgnoreCase((CharSequence)"a", (CharSequence)""));
        Assertions.assertTrue((boolean)StringUtils.containsIgnoreCase((CharSequence)"abc", (CharSequence)""));
        Assertions.assertFalse((boolean)StringUtils.containsIgnoreCase((CharSequence)"", (CharSequence)"a"));
        Assertions.assertTrue((boolean)StringUtils.containsIgnoreCase((CharSequence)"a", (CharSequence)"a"));
        Assertions.assertTrue((boolean)StringUtils.containsIgnoreCase((CharSequence)"abc", (CharSequence)"a"));
        Assertions.assertFalse((boolean)StringUtils.containsIgnoreCase((CharSequence)"", (CharSequence)"A"));
        Assertions.assertTrue((boolean)StringUtils.containsIgnoreCase((CharSequence)"a", (CharSequence)"A"));
        Assertions.assertTrue((boolean)StringUtils.containsIgnoreCase((CharSequence)"abc", (CharSequence)"A"));
        Assertions.assertFalse((boolean)StringUtils.containsIgnoreCase((CharSequence)"", (CharSequence)"abc"));
        Assertions.assertFalse((boolean)StringUtils.containsIgnoreCase((CharSequence)"a", (CharSequence)"abc"));
        Assertions.assertTrue((boolean)StringUtils.containsIgnoreCase((CharSequence)"xabcz", (CharSequence)"abc"));
        Assertions.assertFalse((boolean)StringUtils.containsIgnoreCase((CharSequence)"", (CharSequence)"ABC"));
        Assertions.assertFalse((boolean)StringUtils.containsIgnoreCase((CharSequence)"a", (CharSequence)"ABC"));
        Assertions.assertTrue((boolean)StringUtils.containsIgnoreCase((CharSequence)"xabcz", (CharSequence)"ABC"));
    }

    @Test
    public void testContainsNone_CharArray() {
        String str1 = "a";
        String str2 = "b";
        String str3 = "ab.";
        char[] chars1 = new char[]{'b'};
        char[] chars2 = new char[]{'.'};
        char[] chars3 = new char[]{'c', 'd'};
        char[] emptyChars = new char[]{};
        Assertions.assertTrue((boolean)StringUtils.containsNone(null, (char[])null));
        Assertions.assertTrue((boolean)StringUtils.containsNone((CharSequence)"", (char[])null));
        Assertions.assertTrue((boolean)StringUtils.containsNone(null, (char[])emptyChars));
        Assertions.assertTrue((boolean)StringUtils.containsNone((CharSequence)"a", (char[])emptyChars));
        Assertions.assertTrue((boolean)StringUtils.containsNone((CharSequence)"", (char[])emptyChars));
        Assertions.assertTrue((boolean)StringUtils.containsNone((CharSequence)"", (char[])chars1));
        Assertions.assertTrue((boolean)StringUtils.containsNone((CharSequence)"a", (char[])chars1));
        Assertions.assertTrue((boolean)StringUtils.containsNone((CharSequence)"a", (char[])chars2));
        Assertions.assertTrue((boolean)StringUtils.containsNone((CharSequence)"a", (char[])chars3));
        Assertions.assertFalse((boolean)StringUtils.containsNone((CharSequence)"b", (char[])chars1));
        Assertions.assertTrue((boolean)StringUtils.containsNone((CharSequence)"b", (char[])chars2));
        Assertions.assertTrue((boolean)StringUtils.containsNone((CharSequence)"b", (char[])chars3));
        Assertions.assertFalse((boolean)StringUtils.containsNone((CharSequence)"ab.", (char[])chars1));
        Assertions.assertFalse((boolean)StringUtils.containsNone((CharSequence)"ab.", (char[])chars2));
        Assertions.assertTrue((boolean)StringUtils.containsNone((CharSequence)"ab.", (char[])chars3));
    }

    @Test
    public void testContainsNone_CharArrayWithBadSupplementaryChars() {
        Assertions.assertTrue((boolean)StringUtils.containsNone((CharSequence)CharUSuppCharHigh, (char[])CharU20001.toCharArray()));
        Assertions.assertEquals((int)-1, (int)CharUSuppCharLow.indexOf(CharU20001));
        Assertions.assertTrue((boolean)StringUtils.containsNone((CharSequence)CharUSuppCharLow, (char[])CharU20001.toCharArray()));
        Assertions.assertEquals((int)-1, (int)CharU20001.indexOf(CharUSuppCharHigh));
        Assertions.assertTrue((boolean)StringUtils.containsNone((CharSequence)CharU20001, (char[])CharUSuppCharHigh.toCharArray()));
        Assertions.assertEquals((int)0, (int)CharU20001.indexOf(CharUSuppCharLow));
        Assertions.assertFalse((boolean)StringUtils.containsNone((CharSequence)CharU20001, (char[])CharUSuppCharLow.toCharArray()));
    }

    @Test
    public void testContainsNone_CharArrayWithSupplementaryChars() {
        Assertions.assertFalse((boolean)StringUtils.containsNone((CharSequence)"\ud840\udc00\ud840\udc01", (char[])CharU20000.toCharArray()));
        Assertions.assertFalse((boolean)StringUtils.containsNone((CharSequence)"\ud840\udc00\ud840\udc01", (char[])CharU20001.toCharArray()));
        Assertions.assertFalse((boolean)StringUtils.containsNone((CharSequence)CharU20000, (char[])CharU20000.toCharArray()));
        Assertions.assertEquals((int)-1, (int)CharU20000.indexOf(CharU20001));
        Assertions.assertEquals((int)0, (int)CharU20000.indexOf(CharU20001.charAt(0)));
        Assertions.assertEquals((int)-1, (int)CharU20000.indexOf(CharU20001.charAt(1)));
        Assertions.assertTrue((boolean)StringUtils.containsNone((CharSequence)CharU20000, (char[])CharU20001.toCharArray()));
        Assertions.assertTrue((boolean)StringUtils.containsNone((CharSequence)CharU20001, (char[])CharU20000.toCharArray()));
    }

    @Test
    public void testContainsNone_String() {
        String str1 = "a";
        String str2 = "b";
        String str3 = "ab.";
        String chars1 = "b";
        String chars2 = ".";
        String chars3 = "cd";
        Assertions.assertTrue((boolean)StringUtils.containsNone(null, (String)null));
        Assertions.assertTrue((boolean)StringUtils.containsNone((CharSequence)"", (String)null));
        Assertions.assertTrue((boolean)StringUtils.containsNone(null, (String)""));
        Assertions.assertTrue((boolean)StringUtils.containsNone((CharSequence)"a", (String)""));
        Assertions.assertTrue((boolean)StringUtils.containsNone((CharSequence)"", (String)""));
        Assertions.assertTrue((boolean)StringUtils.containsNone((CharSequence)"", (String)"b"));
        Assertions.assertTrue((boolean)StringUtils.containsNone((CharSequence)"a", (String)"b"));
        Assertions.assertTrue((boolean)StringUtils.containsNone((CharSequence)"a", (String)"."));
        Assertions.assertTrue((boolean)StringUtils.containsNone((CharSequence)"a", (String)"cd"));
        Assertions.assertFalse((boolean)StringUtils.containsNone((CharSequence)"b", (String)"b"));
        Assertions.assertTrue((boolean)StringUtils.containsNone((CharSequence)"b", (String)"."));
        Assertions.assertTrue((boolean)StringUtils.containsNone((CharSequence)"b", (String)"cd"));
        Assertions.assertFalse((boolean)StringUtils.containsNone((CharSequence)"ab.", (String)"b"));
        Assertions.assertFalse((boolean)StringUtils.containsNone((CharSequence)"ab.", (String)"."));
        Assertions.assertTrue((boolean)StringUtils.containsNone((CharSequence)"ab.", (String)"cd"));
    }

    @Test
    public void testContainsNone_StringWithBadSupplementaryChars() {
        Assertions.assertTrue((boolean)StringUtils.containsNone((CharSequence)CharUSuppCharHigh, (String)CharU20001));
        Assertions.assertEquals((int)-1, (int)CharUSuppCharLow.indexOf(CharU20001));
        Assertions.assertTrue((boolean)StringUtils.containsNone((CharSequence)CharUSuppCharLow, (String)CharU20001));
        Assertions.assertEquals((int)-1, (int)CharU20001.indexOf(CharUSuppCharHigh));
        Assertions.assertTrue((boolean)StringUtils.containsNone((CharSequence)CharU20001, (String)CharUSuppCharHigh));
        Assertions.assertEquals((int)0, (int)CharU20001.indexOf(CharUSuppCharLow));
        Assertions.assertFalse((boolean)StringUtils.containsNone((CharSequence)CharU20001, (String)CharUSuppCharLow));
    }

    @Test
    public void testContainsNone_StringWithSupplementaryChars() {
        Assertions.assertFalse((boolean)StringUtils.containsNone((CharSequence)"\ud840\udc00\ud840\udc01", (String)CharU20000));
        Assertions.assertFalse((boolean)StringUtils.containsNone((CharSequence)"\ud840\udc00\ud840\udc01", (String)CharU20001));
        Assertions.assertFalse((boolean)StringUtils.containsNone((CharSequence)CharU20000, (String)CharU20000));
        Assertions.assertEquals((int)-1, (int)CharU20000.indexOf(CharU20001));
        Assertions.assertEquals((int)0, (int)CharU20000.indexOf(CharU20001.charAt(0)));
        Assertions.assertEquals((int)-1, (int)CharU20000.indexOf(CharU20001.charAt(1)));
        Assertions.assertTrue((boolean)StringUtils.containsNone((CharSequence)CharU20000, (String)CharU20001));
        Assertions.assertTrue((boolean)StringUtils.containsNone((CharSequence)CharU20001, (String)CharU20000));
    }

    @Test
    public void testContainsOnly_CharArray() {
        String str1 = "a";
        String str2 = "b";
        String str3 = "ab";
        char[] chars1 = new char[]{'b'};
        char[] chars2 = new char[]{'a'};
        char[] chars3 = new char[]{'a', 'b'};
        char[] emptyChars = new char[]{};
        Assertions.assertFalse((boolean)StringUtils.containsOnly(null, (char[])null));
        Assertions.assertFalse((boolean)StringUtils.containsOnly((CharSequence)"", (char[])null));
        Assertions.assertFalse((boolean)StringUtils.containsOnly(null, (char[])emptyChars));
        Assertions.assertFalse((boolean)StringUtils.containsOnly((CharSequence)"a", (char[])emptyChars));
        Assertions.assertTrue((boolean)StringUtils.containsOnly((CharSequence)"", (char[])emptyChars));
        Assertions.assertTrue((boolean)StringUtils.containsOnly((CharSequence)"", (char[])chars1));
        Assertions.assertFalse((boolean)StringUtils.containsOnly((CharSequence)"a", (char[])chars1));
        Assertions.assertTrue((boolean)StringUtils.containsOnly((CharSequence)"a", (char[])chars2));
        Assertions.assertTrue((boolean)StringUtils.containsOnly((CharSequence)"a", (char[])chars3));
        Assertions.assertTrue((boolean)StringUtils.containsOnly((CharSequence)"b", (char[])chars1));
        Assertions.assertFalse((boolean)StringUtils.containsOnly((CharSequence)"b", (char[])chars2));
        Assertions.assertTrue((boolean)StringUtils.containsOnly((CharSequence)"b", (char[])chars3));
        Assertions.assertFalse((boolean)StringUtils.containsOnly((CharSequence)"ab", (char[])chars1));
        Assertions.assertFalse((boolean)StringUtils.containsOnly((CharSequence)"ab", (char[])chars2));
        Assertions.assertTrue((boolean)StringUtils.containsOnly((CharSequence)"ab", (char[])chars3));
    }

    @Test
    public void testContainsOnly_String() {
        String str1 = "a";
        String str2 = "b";
        String str3 = "ab";
        String chars1 = "b";
        String chars2 = "a";
        String chars3 = "ab";
        Assertions.assertFalse((boolean)StringUtils.containsOnly(null, (String)null));
        Assertions.assertFalse((boolean)StringUtils.containsOnly((CharSequence)"", (String)null));
        Assertions.assertFalse((boolean)StringUtils.containsOnly(null, (String)""));
        Assertions.assertFalse((boolean)StringUtils.containsOnly((CharSequence)"a", (String)""));
        Assertions.assertTrue((boolean)StringUtils.containsOnly((CharSequence)"", (String)""));
        Assertions.assertTrue((boolean)StringUtils.containsOnly((CharSequence)"", (String)"b"));
        Assertions.assertFalse((boolean)StringUtils.containsOnly((CharSequence)"a", (String)"b"));
        Assertions.assertTrue((boolean)StringUtils.containsOnly((CharSequence)"a", (String)"a"));
        Assertions.assertTrue((boolean)StringUtils.containsOnly((CharSequence)"a", (String)"ab"));
        Assertions.assertTrue((boolean)StringUtils.containsOnly((CharSequence)"b", (String)"b"));
        Assertions.assertFalse((boolean)StringUtils.containsOnly((CharSequence)"b", (String)"a"));
        Assertions.assertTrue((boolean)StringUtils.containsOnly((CharSequence)"b", (String)"ab"));
        Assertions.assertFalse((boolean)StringUtils.containsOnly((CharSequence)"ab", (String)"b"));
        Assertions.assertFalse((boolean)StringUtils.containsOnly((CharSequence)"ab", (String)"a"));
        Assertions.assertTrue((boolean)StringUtils.containsOnly((CharSequence)"ab", (String)"ab"));
    }

    @Test
    public void testContainsWhitespace() {
        Assertions.assertFalse((boolean)StringUtils.containsWhitespace((CharSequence)""));
        Assertions.assertTrue((boolean)StringUtils.containsWhitespace((CharSequence)" "));
        Assertions.assertFalse((boolean)StringUtils.containsWhitespace((CharSequence)"a"));
        Assertions.assertTrue((boolean)StringUtils.containsWhitespace((CharSequence)"a "));
        Assertions.assertTrue((boolean)StringUtils.containsWhitespace((CharSequence)" a"));
        Assertions.assertTrue((boolean)StringUtils.containsWhitespace((CharSequence)"a\t"));
        Assertions.assertTrue((boolean)StringUtils.containsWhitespace((CharSequence)"\n"));
    }
}

