/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.StringUtilsTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StringUtilsEmptyBlankTest {
    @Test
    public void testIsEmpty() {
        Assertions.assertTrue((boolean)StringUtils.isEmpty(null));
        Assertions.assertTrue((boolean)StringUtils.isEmpty((CharSequence)""));
        Assertions.assertFalse((boolean)StringUtils.isEmpty((CharSequence)" "));
        Assertions.assertFalse((boolean)StringUtils.isEmpty((CharSequence)"foo"));
        Assertions.assertFalse((boolean)StringUtils.isEmpty((CharSequence)"  foo  "));
    }

    @Test
    public void testIsNotEmpty() {
        Assertions.assertFalse((boolean)StringUtils.isNotEmpty(null));
        Assertions.assertFalse((boolean)StringUtils.isNotEmpty((CharSequence)""));
        Assertions.assertTrue((boolean)StringUtils.isNotEmpty((CharSequence)" "));
        Assertions.assertTrue((boolean)StringUtils.isNotEmpty((CharSequence)"foo"));
        Assertions.assertTrue((boolean)StringUtils.isNotEmpty((CharSequence)"  foo  "));
    }

    @Test
    public void testIsAnyEmpty() {
        Assertions.assertTrue((boolean)StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{null}));
        Assertions.assertFalse((boolean)StringUtils.isAnyEmpty((CharSequence[])null));
        Assertions.assertTrue((boolean)StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{null, "foo"}));
        Assertions.assertTrue((boolean)StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{"", "bar"}));
        Assertions.assertTrue((boolean)StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{"bob", ""}));
        Assertions.assertTrue((boolean)StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{"  bob  ", null}));
        Assertions.assertFalse((boolean)StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{" ", "bar"}));
        Assertions.assertFalse((boolean)StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{"foo", "bar"}));
    }

    @Test
    public void testIsNoneEmpty() {
        Assertions.assertFalse((boolean)StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{null}));
        Assertions.assertTrue((boolean)StringUtils.isNoneEmpty((CharSequence[])null));
        Assertions.assertFalse((boolean)StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{null, "foo"}));
        Assertions.assertFalse((boolean)StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{"", "bar"}));
        Assertions.assertFalse((boolean)StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{"bob", ""}));
        Assertions.assertFalse((boolean)StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{"  bob  ", null}));
        Assertions.assertTrue((boolean)StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{" ", "bar"}));
        Assertions.assertTrue((boolean)StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{"foo", "bar"}));
    }

    @Test
    public void testIsAllEmpty() {
        Assertions.assertTrue((boolean)StringUtils.isAllEmpty((CharSequence[])new CharSequence[0]));
        Assertions.assertTrue((boolean)StringUtils.isAllEmpty((CharSequence[])new CharSequence[0]));
        Assertions.assertTrue((boolean)StringUtils.isAllEmpty((CharSequence[])new CharSequence[]{null}));
        Assertions.assertTrue((boolean)StringUtils.isAllEmpty((CharSequence[])null));
        Assertions.assertFalse((boolean)StringUtils.isAllEmpty((CharSequence[])new CharSequence[]{null, "foo"}));
        Assertions.assertFalse((boolean)StringUtils.isAllEmpty((CharSequence[])new CharSequence[]{"", "bar"}));
        Assertions.assertFalse((boolean)StringUtils.isAllEmpty((CharSequence[])new CharSequence[]{"bob", ""}));
        Assertions.assertFalse((boolean)StringUtils.isAllEmpty((CharSequence[])new CharSequence[]{"  bob  ", null}));
        Assertions.assertFalse((boolean)StringUtils.isAllEmpty((CharSequence[])new CharSequence[]{" ", "bar"}));
        Assertions.assertFalse((boolean)StringUtils.isAllEmpty((CharSequence[])new CharSequence[]{"foo", "bar"}));
        Assertions.assertTrue((boolean)StringUtils.isAllEmpty((CharSequence[])new CharSequence[]{"", null}));
    }

    @Test
    public void testIsBlank() {
        Assertions.assertTrue((boolean)StringUtils.isBlank(null));
        Assertions.assertTrue((boolean)StringUtils.isBlank((CharSequence)""));
        Assertions.assertTrue((boolean)StringUtils.isBlank((CharSequence)StringUtilsTest.WHITESPACE));
        Assertions.assertFalse((boolean)StringUtils.isBlank((CharSequence)"foo"));
        Assertions.assertFalse((boolean)StringUtils.isBlank((CharSequence)"  foo  "));
    }

    @Test
    public void testIsNotBlank() {
        Assertions.assertFalse((boolean)StringUtils.isNotBlank(null));
        Assertions.assertFalse((boolean)StringUtils.isNotBlank((CharSequence)""));
        Assertions.assertFalse((boolean)StringUtils.isNotBlank((CharSequence)StringUtilsTest.WHITESPACE));
        Assertions.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)"foo"));
        Assertions.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)"  foo  "));
    }

    @Test
    public void testIsAnyBlank() {
        Assertions.assertTrue((boolean)StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{null}));
        Assertions.assertFalse((boolean)StringUtils.isAnyBlank((CharSequence[])null));
        Assertions.assertTrue((boolean)StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{null, "foo"}));
        Assertions.assertTrue((boolean)StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{null, null}));
        Assertions.assertTrue((boolean)StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{"", "bar"}));
        Assertions.assertTrue((boolean)StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{"bob", ""}));
        Assertions.assertTrue((boolean)StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{"  bob  ", null}));
        Assertions.assertTrue((boolean)StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{" ", "bar"}));
        Assertions.assertFalse((boolean)StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{"foo", "bar"}));
    }

    @Test
    public void testIsNoneBlank() {
        Assertions.assertFalse((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{null}));
        Assertions.assertTrue((boolean)StringUtils.isNoneBlank((CharSequence[])null));
        Assertions.assertFalse((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{null, "foo"}));
        Assertions.assertFalse((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{null, null}));
        Assertions.assertFalse((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{"", "bar"}));
        Assertions.assertFalse((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{"bob", ""}));
        Assertions.assertFalse((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{"  bob  ", null}));
        Assertions.assertFalse((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{" ", "bar"}));
        Assertions.assertTrue((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{"foo", "bar"}));
    }

    @Test
    public void testIsAllBlank() {
        Assertions.assertTrue((boolean)StringUtils.isAllBlank((CharSequence[])new CharSequence[]{null}));
        Assertions.assertTrue((boolean)StringUtils.isAllBlank((CharSequence[])null));
        Assertions.assertTrue((boolean)StringUtils.isAllBlank((CharSequence[])new CharSequence[]{null, null}));
        Assertions.assertTrue((boolean)StringUtils.isAllBlank((CharSequence[])new CharSequence[]{null, " "}));
        Assertions.assertFalse((boolean)StringUtils.isAllBlank((CharSequence[])new CharSequence[]{null, "foo"}));
        Assertions.assertFalse((boolean)StringUtils.isAllBlank((CharSequence[])new CharSequence[]{"", "bar"}));
        Assertions.assertFalse((boolean)StringUtils.isAllBlank((CharSequence[])new CharSequence[]{"bob", ""}));
        Assertions.assertFalse((boolean)StringUtils.isAllBlank((CharSequence[])new CharSequence[]{"  bob  ", null}));
        Assertions.assertFalse((boolean)StringUtils.isAllBlank((CharSequence[])new CharSequence[]{" ", "bar"}));
        Assertions.assertFalse((boolean)StringUtils.isAllBlank((CharSequence[])new CharSequence[]{"foo", "bar"}));
    }

    @Test
    public void testFirstNonBlank() {
        Assertions.assertNull((Object)StringUtils.firstNonBlank((CharSequence[])new CharSequence[0]));
        Assertions.assertNull((Object)StringUtils.firstNonBlank((CharSequence[])null));
        Assertions.assertNull((Object)StringUtils.firstNonBlank((CharSequence[])new CharSequence[]{null, null, null}));
        Assertions.assertNull((Object)StringUtils.firstNonBlank((CharSequence[])new String[]{null, "", " "}));
        Assertions.assertNull((Object)StringUtils.firstNonBlank((CharSequence[])new String[]{null, null, " "}));
        Assertions.assertEquals((Object)"zz", (Object)StringUtils.firstNonBlank((CharSequence[])new String[]{null, "zz"}));
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.firstNonBlank((CharSequence[])new String[]{"abc"}));
        Assertions.assertEquals((Object)"xyz", (Object)StringUtils.firstNonBlank((CharSequence[])new String[]{null, "xyz"}));
        Assertions.assertEquals((Object)"xyz", (Object)StringUtils.firstNonBlank((CharSequence[])new String[]{null, "xyz", "abc"}));
    }

    @Test
    public void testFirstNonEmpty() {
        Assertions.assertNull((Object)StringUtils.firstNonEmpty((CharSequence[])new CharSequence[0]));
        Assertions.assertNull((Object)StringUtils.firstNonEmpty((CharSequence[])null));
        Assertions.assertNull((Object)StringUtils.firstNonEmpty((CharSequence[])new CharSequence[]{null, null, null}));
        Assertions.assertEquals((Object)" ", (Object)StringUtils.firstNonEmpty((CharSequence[])new String[]{null, "", " "}));
        Assertions.assertNull((Object)StringUtils.firstNonEmpty((CharSequence[])new String[]{null, null, ""}));
        Assertions.assertEquals((Object)"zz", (Object)StringUtils.firstNonEmpty((CharSequence[])new String[]{null, "zz"}));
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.firstNonEmpty((CharSequence[])new String[]{"abc"}));
        Assertions.assertEquals((Object)"xyz", (Object)StringUtils.firstNonEmpty((CharSequence[])new String[]{null, "xyz"}));
        Assertions.assertEquals((Object)"xyz", (Object)StringUtils.firstNonEmpty((CharSequence[])new String[]{null, "xyz", "abc"}));
    }
}

