/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.StringUtilsTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StringUtilsTrimStripTest {
    private static final String FOO = "foo";

    @Test
    public void testTrim() {
        Assertions.assertEquals((Object)FOO, (Object)StringUtils.trim((String)"foo  "));
        Assertions.assertEquals((Object)FOO, (Object)StringUtils.trim((String)" foo  "));
        Assertions.assertEquals((Object)FOO, (Object)StringUtils.trim((String)" foo"));
        Assertions.assertEquals((Object)FOO, (Object)StringUtils.trim((String)FOO));
        Assertions.assertEquals((Object)"", (Object)StringUtils.trim((String)" \t\r\n\b "));
        Assertions.assertEquals((Object)"", (Object)StringUtils.trim((String)StringUtilsTest.TRIMMABLE));
        Assertions.assertEquals((Object)StringUtilsTest.NON_TRIMMABLE, (Object)StringUtils.trim((String)StringUtilsTest.NON_TRIMMABLE));
        Assertions.assertEquals((Object)"", (Object)StringUtils.trim((String)""));
        Assertions.assertNull((Object)StringUtils.trim(null));
    }

    @Test
    public void testTrimToNull() {
        Assertions.assertEquals((Object)FOO, (Object)StringUtils.trimToNull((String)"foo  "));
        Assertions.assertEquals((Object)FOO, (Object)StringUtils.trimToNull((String)" foo  "));
        Assertions.assertEquals((Object)FOO, (Object)StringUtils.trimToNull((String)" foo"));
        Assertions.assertEquals((Object)FOO, (Object)StringUtils.trimToNull((String)FOO));
        Assertions.assertNull((Object)StringUtils.trimToNull((String)" \t\r\n\b "));
        Assertions.assertNull((Object)StringUtils.trimToNull((String)StringUtilsTest.TRIMMABLE));
        Assertions.assertEquals((Object)StringUtilsTest.NON_TRIMMABLE, (Object)StringUtils.trimToNull((String)StringUtilsTest.NON_TRIMMABLE));
        Assertions.assertNull((Object)StringUtils.trimToNull((String)""));
        Assertions.assertNull((Object)StringUtils.trimToNull(null));
    }

    @Test
    public void testTrimToEmpty() {
        Assertions.assertEquals((Object)FOO, (Object)StringUtils.trimToEmpty((String)"foo  "));
        Assertions.assertEquals((Object)FOO, (Object)StringUtils.trimToEmpty((String)" foo  "));
        Assertions.assertEquals((Object)FOO, (Object)StringUtils.trimToEmpty((String)" foo"));
        Assertions.assertEquals((Object)FOO, (Object)StringUtils.trimToEmpty((String)FOO));
        Assertions.assertEquals((Object)"", (Object)StringUtils.trimToEmpty((String)" \t\r\n\b "));
        Assertions.assertEquals((Object)"", (Object)StringUtils.trimToEmpty((String)StringUtilsTest.TRIMMABLE));
        Assertions.assertEquals((Object)StringUtilsTest.NON_TRIMMABLE, (Object)StringUtils.trimToEmpty((String)StringUtilsTest.NON_TRIMMABLE));
        Assertions.assertEquals((Object)"", (Object)StringUtils.trimToEmpty((String)""));
        Assertions.assertEquals((Object)"", (Object)StringUtils.trimToEmpty(null));
    }

    @Test
    public void testStrip_String() {
        Assertions.assertNull((Object)StringUtils.strip(null));
        Assertions.assertEquals((Object)"", (Object)StringUtils.strip((String)""));
        Assertions.assertEquals((Object)"", (Object)StringUtils.strip((String)"        "));
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.strip((String)"  abc  "));
        Assertions.assertEquals((Object)StringUtilsTest.NON_WHITESPACE, (Object)StringUtils.strip((String)(StringUtilsTest.WHITESPACE + StringUtilsTest.NON_WHITESPACE + StringUtilsTest.WHITESPACE)));
    }

    @Test
    public void testStripToNull_String() {
        Assertions.assertNull((Object)StringUtils.stripToNull(null));
        Assertions.assertNull((Object)StringUtils.stripToNull((String)""));
        Assertions.assertNull((Object)StringUtils.stripToNull((String)"        "));
        Assertions.assertNull((Object)StringUtils.stripToNull((String)StringUtilsTest.WHITESPACE));
        Assertions.assertEquals((Object)"ab c", (Object)StringUtils.stripToNull((String)"  ab c  "));
        Assertions.assertEquals((Object)StringUtilsTest.NON_WHITESPACE, (Object)StringUtils.stripToNull((String)(StringUtilsTest.WHITESPACE + StringUtilsTest.NON_WHITESPACE + StringUtilsTest.WHITESPACE)));
    }

    @Test
    public void testStripToEmpty_String() {
        Assertions.assertEquals((Object)"", (Object)StringUtils.stripToEmpty(null));
        Assertions.assertEquals((Object)"", (Object)StringUtils.stripToEmpty((String)""));
        Assertions.assertEquals((Object)"", (Object)StringUtils.stripToEmpty((String)"        "));
        Assertions.assertEquals((Object)"", (Object)StringUtils.stripToEmpty((String)StringUtilsTest.WHITESPACE));
        Assertions.assertEquals((Object)"ab c", (Object)StringUtils.stripToEmpty((String)"  ab c  "));
        Assertions.assertEquals((Object)StringUtilsTest.NON_WHITESPACE, (Object)StringUtils.stripToEmpty((String)(StringUtilsTest.WHITESPACE + StringUtilsTest.NON_WHITESPACE + StringUtilsTest.WHITESPACE)));
    }

    @Test
    public void testStrip_StringString() {
        Assertions.assertNull((Object)StringUtils.strip(null, null));
        Assertions.assertEquals((Object)"", (Object)StringUtils.strip((String)"", null));
        Assertions.assertEquals((Object)"", (Object)StringUtils.strip((String)"        ", null));
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.strip((String)"  abc  ", null));
        Assertions.assertEquals((Object)StringUtilsTest.NON_WHITESPACE, (Object)StringUtils.strip((String)(StringUtilsTest.WHITESPACE + StringUtilsTest.NON_WHITESPACE + StringUtilsTest.WHITESPACE), null));
        Assertions.assertNull((Object)StringUtils.strip(null, (String)""));
        Assertions.assertEquals((Object)"", (Object)StringUtils.strip((String)"", (String)""));
        Assertions.assertEquals((Object)"        ", (Object)StringUtils.strip((String)"        ", (String)""));
        Assertions.assertEquals((Object)"  abc  ", (Object)StringUtils.strip((String)"  abc  ", (String)""));
        Assertions.assertEquals((Object)StringUtilsTest.WHITESPACE, (Object)StringUtils.strip((String)StringUtilsTest.WHITESPACE, (String)""));
        Assertions.assertNull((Object)StringUtils.strip(null, (String)" "));
        Assertions.assertEquals((Object)"", (Object)StringUtils.strip((String)"", (String)" "));
        Assertions.assertEquals((Object)"", (Object)StringUtils.strip((String)"        ", (String)" "));
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.strip((String)"  abc  ", (String)" "));
        Assertions.assertNull((Object)StringUtils.strip(null, (String)"ab"));
        Assertions.assertEquals((Object)"", (Object)StringUtils.strip((String)"", (String)"ab"));
        Assertions.assertEquals((Object)"        ", (Object)StringUtils.strip((String)"        ", (String)"ab"));
        Assertions.assertEquals((Object)"  abc  ", (Object)StringUtils.strip((String)"  abc  ", (String)"ab"));
        Assertions.assertEquals((Object)"c", (Object)StringUtils.strip((String)"abcabab", (String)"ab"));
        Assertions.assertEquals((Object)StringUtilsTest.WHITESPACE, (Object)StringUtils.strip((String)StringUtilsTest.WHITESPACE, (String)""));
    }

    @Test
    public void testStripStart_StringString() {
        Assertions.assertNull((Object)StringUtils.stripStart(null, null));
        Assertions.assertEquals((Object)"", (Object)StringUtils.stripStart((String)"", null));
        Assertions.assertEquals((Object)"", (Object)StringUtils.stripStart((String)"        ", null));
        Assertions.assertEquals((Object)"abc  ", (Object)StringUtils.stripStart((String)"  abc  ", null));
        Assertions.assertEquals((Object)(StringUtilsTest.NON_WHITESPACE + StringUtilsTest.WHITESPACE), (Object)StringUtils.stripStart((String)(StringUtilsTest.WHITESPACE + StringUtilsTest.NON_WHITESPACE + StringUtilsTest.WHITESPACE), null));
        Assertions.assertNull((Object)StringUtils.stripStart(null, (String)""));
        Assertions.assertEquals((Object)"", (Object)StringUtils.stripStart((String)"", (String)""));
        Assertions.assertEquals((Object)"        ", (Object)StringUtils.stripStart((String)"        ", (String)""));
        Assertions.assertEquals((Object)"  abc  ", (Object)StringUtils.stripStart((String)"  abc  ", (String)""));
        Assertions.assertEquals((Object)StringUtilsTest.WHITESPACE, (Object)StringUtils.stripStart((String)StringUtilsTest.WHITESPACE, (String)""));
        Assertions.assertNull((Object)StringUtils.stripStart(null, (String)" "));
        Assertions.assertEquals((Object)"", (Object)StringUtils.stripStart((String)"", (String)" "));
        Assertions.assertEquals((Object)"", (Object)StringUtils.stripStart((String)"        ", (String)" "));
        Assertions.assertEquals((Object)"abc  ", (Object)StringUtils.stripStart((String)"  abc  ", (String)" "));
        Assertions.assertNull((Object)StringUtils.stripStart(null, (String)"ab"));
        Assertions.assertEquals((Object)"", (Object)StringUtils.stripStart((String)"", (String)"ab"));
        Assertions.assertEquals((Object)"        ", (Object)StringUtils.stripStart((String)"        ", (String)"ab"));
        Assertions.assertEquals((Object)"  abc  ", (Object)StringUtils.stripStart((String)"  abc  ", (String)"ab"));
        Assertions.assertEquals((Object)"cabab", (Object)StringUtils.stripStart((String)"abcabab", (String)"ab"));
        Assertions.assertEquals((Object)StringUtilsTest.WHITESPACE, (Object)StringUtils.stripStart((String)StringUtilsTest.WHITESPACE, (String)""));
    }

    @Test
    public void testStripEnd_StringString() {
        Assertions.assertNull((Object)StringUtils.stripEnd(null, null));
        Assertions.assertEquals((Object)"", (Object)StringUtils.stripEnd((String)"", null));
        Assertions.assertEquals((Object)"", (Object)StringUtils.stripEnd((String)"        ", null));
        Assertions.assertEquals((Object)"  abc", (Object)StringUtils.stripEnd((String)"  abc  ", null));
        Assertions.assertEquals((Object)(StringUtilsTest.WHITESPACE + StringUtilsTest.NON_WHITESPACE), (Object)StringUtils.stripEnd((String)(StringUtilsTest.WHITESPACE + StringUtilsTest.NON_WHITESPACE + StringUtilsTest.WHITESPACE), null));
        Assertions.assertNull((Object)StringUtils.stripEnd(null, (String)""));
        Assertions.assertEquals((Object)"", (Object)StringUtils.stripEnd((String)"", (String)""));
        Assertions.assertEquals((Object)"        ", (Object)StringUtils.stripEnd((String)"        ", (String)""));
        Assertions.assertEquals((Object)"  abc  ", (Object)StringUtils.stripEnd((String)"  abc  ", (String)""));
        Assertions.assertEquals((Object)StringUtilsTest.WHITESPACE, (Object)StringUtils.stripEnd((String)StringUtilsTest.WHITESPACE, (String)""));
        Assertions.assertNull((Object)StringUtils.stripEnd(null, (String)" "));
        Assertions.assertEquals((Object)"", (Object)StringUtils.stripEnd((String)"", (String)" "));
        Assertions.assertEquals((Object)"", (Object)StringUtils.stripEnd((String)"        ", (String)" "));
        Assertions.assertEquals((Object)"  abc", (Object)StringUtils.stripEnd((String)"  abc  ", (String)" "));
        Assertions.assertNull((Object)StringUtils.stripEnd(null, (String)"ab"));
        Assertions.assertEquals((Object)"", (Object)StringUtils.stripEnd((String)"", (String)"ab"));
        Assertions.assertEquals((Object)"        ", (Object)StringUtils.stripEnd((String)"        ", (String)"ab"));
        Assertions.assertEquals((Object)"  abc  ", (Object)StringUtils.stripEnd((String)"  abc  ", (String)"ab"));
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.stripEnd((String)"abcabab", (String)"ab"));
        Assertions.assertEquals((Object)StringUtilsTest.WHITESPACE, (Object)StringUtils.stripEnd((String)StringUtilsTest.WHITESPACE, (String)""));
    }

    @Test
    public void testStripAll() {
        Object[] empty = new String[]{};
        String[] fooSpace = new String[]{"  foo  ", "  foo", "foo  "};
        String[] fooDots = new String[]{"..foo..", "..foo", "foo.."};
        Object[] foo = new String[]{FOO, FOO, FOO};
        Assertions.assertNull((Object)StringUtils.stripAll((String[])null));
        Assertions.assertArrayEquals((Object[])empty, (Object[])StringUtils.stripAll((String[])new String[0]));
        Assertions.assertArrayEquals((Object[])new String[]{null}, (Object[])StringUtils.stripAll((String[])new String[]{null}));
        Assertions.assertArrayEquals((Object[])empty, (Object[])StringUtils.stripAll((String[])empty));
        Assertions.assertArrayEquals((Object[])foo, (Object[])StringUtils.stripAll((String[])fooSpace));
        Assertions.assertNull((Object)StringUtils.stripAll(null, null));
        Assertions.assertArrayEquals((Object[])foo, (Object[])StringUtils.stripAll((String[])fooSpace, null));
        Assertions.assertArrayEquals((Object[])foo, (Object[])StringUtils.stripAll((String[])fooDots, (String)"."));
    }

    @Test
    public void testStripAccents() {
        String cue = "\u00c7\u00fa\u00ea";
        Assertions.assertEquals((Object)"Cue", (Object)StringUtils.stripAccents((String)"\u00c7\u00fa\u00ea"), (String)"Failed to strip accents from \u00c7\u00fa\u00ea");
        String lots = "\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d1\u00d2\u00d3\u00d4\u00d5\u00d6\u00d9\u00da\u00db\u00dc\u00dd";
        Assertions.assertEquals((Object)"AAAAAACEEEEIIIINOOOOOUUUUY", (Object)StringUtils.stripAccents((String)"\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d1\u00d2\u00d3\u00d4\u00d5\u00d6\u00d9\u00da\u00db\u00dc\u00dd"), (String)"Failed to strip accents from \u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d1\u00d2\u00d3\u00d4\u00d5\u00d6\u00d9\u00da\u00db\u00dc\u00dd");
        Assertions.assertNull((Object)StringUtils.stripAccents(null), (String)"Failed null safety");
        Assertions.assertEquals((Object)"", (Object)StringUtils.stripAccents((String)""), (String)"Failed empty String");
        Assertions.assertEquals((Object)"control", (Object)StringUtils.stripAccents((String)"control"), (String)"Failed to handle non-accented text");
        Assertions.assertEquals((Object)"eclair", (Object)StringUtils.stripAccents((String)"\u00e9clair"), (String)"Failed to handle easy example");
        Assertions.assertEquals((Object)"ALOSZZCN aloszzcn", (Object)StringUtils.stripAccents((String)"\u0104\u0141\u00d3\u015a\u017b\u0179\u0106\u0143 \u0105\u0142\u00f3\u015b\u017c\u017a\u0107\u0144"));
    }
}

