/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class ReflectionToStringBuilderConcurrencyTest {
    private static final int DATA_SIZE = 100000;
    private static final int REPEAT = 100;

    @Test
    @Disabled
    public void testLinkedList() throws InterruptedException, ExecutionException {
        this.testConcurrency(new CollectionHolder<List<Integer>>(new LinkedList()));
    }

    @Test
    @Disabled
    public void testArrayList() throws InterruptedException, ExecutionException {
        this.testConcurrency(new CollectionHolder<List<Integer>>(new ArrayList()));
    }

    @Test
    @Disabled
    public void testCopyOnWriteArrayList() throws InterruptedException, ExecutionException {
        this.testConcurrency(new CollectionHolder<List<Integer>>(new CopyOnWriteArrayList()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testConcurrency(CollectionHolder<List<Integer>> holder) throws InterruptedException, ExecutionException {
        List list = (List)holder.collection;
        for (int i = 0; i < 100000; ++i) {
            list.add(i);
        }
        ExecutorService threadPool = Executors.newFixedThreadPool(2);
        try {
            Callable<Integer> consumer = () -> {
                for (int i = 0; i < 100; ++i) {
                    String s = ReflectionToStringBuilder.toString((Object)holder);
                    Assertions.assertNotNull((Object)s);
                }
                return 100;
            };
            Callable<Integer> producer = () -> {
                for (int i = 0; i < 100000; ++i) {
                    list.remove(list.get(0));
                }
                return 100;
            };
            ArrayList<Callable<Integer>> tasks = new ArrayList<Callable<Integer>>();
            tasks.add(consumer);
            tasks.add(producer);
            List futures = threadPool.invokeAll(tasks);
            for (Future future : futures) {
                Assertions.assertEquals((int)100, (int)((Integer)future.get()));
            }
        }
        finally {
            threadPool.shutdown();
            threadPool.awaitTermination(1L, TimeUnit.SECONDS);
        }
    }

    static class CollectionHolder<T extends Collection<?>> {
        T collection;

        CollectionHolder(T collection) {
            this.collection = collection;
        }
    }
}

