/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.math;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.apache.commons.lang3.math.NumberUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class NumberUtilsTest {
    private boolean checkCreateNumber(String val) {
        try {
            Number obj = NumberUtils.createNumber((String)val);
            return obj != null;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Test
    public void compareByte() {
        Assertions.assertTrue((NumberUtils.compare((byte)-3, (byte)0) < 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)NumberUtils.compare((byte)113, (byte)113));
        Assertions.assertTrue((NumberUtils.compare((byte)123, (byte)32) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void compareInt() {
        Assertions.assertTrue((NumberUtils.compare((int)-3, (int)0) < 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)NumberUtils.compare((int)113, (int)113));
        Assertions.assertTrue((NumberUtils.compare((int)213, (int)32) > 0 ? 1 : 0) != 0);
    }

    private void compareIsCreatableWithCreateNumber(String val, boolean expected) {
        boolean isValid = NumberUtils.isCreatable((String)val);
        boolean canCreate = this.checkCreateNumber(val);
        Assertions.assertTrue((isValid == expected && canCreate == expected ? 1 : 0) != 0, (String)("Expecting " + expected + " for isCreatable/createNumber using \"" + val + "\" but got " + isValid + " and " + canCreate));
    }

    private void compareIsNumberWithCreateNumber(String val, boolean expected) {
        boolean isValid = NumberUtils.isCreatable((String)val);
        boolean canCreate = this.checkCreateNumber(val);
        Assertions.assertTrue((isValid == expected && canCreate == expected ? 1 : 0) != 0, (String)("Expecting " + expected + " for isCreatable/createNumber using \"" + val + "\" but got " + isValid + " and " + canCreate));
    }

    @Test
    public void compareLong() {
        Assertions.assertTrue((NumberUtils.compare((long)-3L, (long)0L) < 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)NumberUtils.compare((long)113L, (long)113L));
        Assertions.assertTrue((NumberUtils.compare((long)213L, (long)32L) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void compareShort() {
        Assertions.assertTrue((NumberUtils.compare((short)-3, (short)0) < 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)NumberUtils.compare((short)113, (short)113));
        Assertions.assertTrue((NumberUtils.compare((short)213, (short)32) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testBigIntegerToDoubleBigInteger() {
        Assertions.assertEquals((double)0.0, (double)NumberUtils.toDouble((BigDecimal)null), (String)"toDouble(BigInteger) 1 failed");
        Assertions.assertEquals((double)8.5, (double)NumberUtils.toDouble((BigDecimal)BigDecimal.valueOf(8.5)), (String)"toDouble(BigInteger) 2 failed");
    }

    @Test
    public void testBigIntegerToDoubleBigIntegerD() {
        Assertions.assertEquals((double)1.1, (double)NumberUtils.toDouble((BigDecimal)null, (double)1.1), (String)"toDouble(BigInteger) 1 failed");
        Assertions.assertEquals((double)8.5, (double)NumberUtils.toDouble((BigDecimal)BigDecimal.valueOf(8.5), (double)1.1), (String)"toDouble(BigInteger) 2 failed");
    }

    @Test
    public void testCompareDouble() {
        Assertions.assertEquals((int)0, (int)Double.compare(Double.NaN, Double.NaN));
        Assertions.assertEquals((int)Double.compare(Double.NaN, Double.POSITIVE_INFINITY), (int)1);
        Assertions.assertEquals((int)Double.compare(Double.NaN, Double.MAX_VALUE), (int)1);
        Assertions.assertEquals((int)Double.compare(Double.NaN, 1.2), (int)1);
        Assertions.assertEquals((int)Double.compare(Double.NaN, 0.0), (int)1);
        Assertions.assertEquals((int)Double.compare(Double.NaN, -0.0), (int)1);
        Assertions.assertEquals((int)Double.compare(Double.NaN, -1.2), (int)1);
        Assertions.assertEquals((int)Double.compare(Double.NaN, -1.7976931348623157E308), (int)1);
        Assertions.assertEquals((int)Double.compare(Double.NaN, Double.NEGATIVE_INFINITY), (int)1);
        Assertions.assertEquals((int)Double.compare(Double.POSITIVE_INFINITY, Double.NaN), (int)-1);
        Assertions.assertEquals((int)0, (int)Double.compare(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY));
        Assertions.assertEquals((int)Double.compare(Double.POSITIVE_INFINITY, Double.MAX_VALUE), (int)1);
        Assertions.assertEquals((int)Double.compare(Double.POSITIVE_INFINITY, 1.2), (int)1);
        Assertions.assertEquals((int)Double.compare(Double.POSITIVE_INFINITY, 0.0), (int)1);
        Assertions.assertEquals((int)Double.compare(Double.POSITIVE_INFINITY, -0.0), (int)1);
        Assertions.assertEquals((int)Double.compare(Double.POSITIVE_INFINITY, -1.2), (int)1);
        Assertions.assertEquals((int)Double.compare(Double.POSITIVE_INFINITY, -1.7976931348623157E308), (int)1);
        Assertions.assertEquals((int)Double.compare(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY), (int)1);
        Assertions.assertEquals((int)Double.compare(Double.MAX_VALUE, Double.NaN), (int)-1);
        Assertions.assertEquals((int)Double.compare(Double.MAX_VALUE, Double.POSITIVE_INFINITY), (int)-1);
        Assertions.assertEquals((int)0, (int)Double.compare(Double.MAX_VALUE, Double.MAX_VALUE));
        Assertions.assertEquals((int)Double.compare(Double.MAX_VALUE, 1.2), (int)1);
        Assertions.assertEquals((int)Double.compare(Double.MAX_VALUE, 0.0), (int)1);
        Assertions.assertEquals((int)Double.compare(Double.MAX_VALUE, -0.0), (int)1);
        Assertions.assertEquals((int)Double.compare(Double.MAX_VALUE, -1.2), (int)1);
        Assertions.assertEquals((int)Double.compare(Double.MAX_VALUE, -1.7976931348623157E308), (int)1);
        Assertions.assertEquals((int)Double.compare(Double.MAX_VALUE, Double.NEGATIVE_INFINITY), (int)1);
        Assertions.assertEquals((int)Double.compare(1.2, Double.NaN), (int)-1);
        Assertions.assertEquals((int)Double.compare(1.2, Double.POSITIVE_INFINITY), (int)-1);
        Assertions.assertEquals((int)Double.compare(1.2, Double.MAX_VALUE), (int)-1);
        Assertions.assertEquals((int)0, (int)Double.compare(1.2, 1.2));
        Assertions.assertEquals((int)Double.compare(1.2, 0.0), (int)1);
        Assertions.assertEquals((int)Double.compare(1.2, -0.0), (int)1);
        Assertions.assertEquals((int)Double.compare(1.2, -1.2), (int)1);
        Assertions.assertEquals((int)Double.compare(1.2, -1.7976931348623157E308), (int)1);
        Assertions.assertEquals((int)Double.compare(1.2, Double.NEGATIVE_INFINITY), (int)1);
        Assertions.assertEquals((int)Double.compare(0.0, Double.NaN), (int)-1);
        Assertions.assertEquals((int)Double.compare(0.0, Double.POSITIVE_INFINITY), (int)-1);
        Assertions.assertEquals((int)Double.compare(0.0, Double.MAX_VALUE), (int)-1);
        Assertions.assertEquals((int)Double.compare(0.0, 1.2), (int)-1);
        Assertions.assertEquals((int)0, (int)Double.compare(0.0, 0.0));
        Assertions.assertEquals((int)Double.compare(0.0, -0.0), (int)1);
        Assertions.assertEquals((int)Double.compare(0.0, -1.2), (int)1);
        Assertions.assertEquals((int)Double.compare(0.0, -1.7976931348623157E308), (int)1);
        Assertions.assertEquals((int)Double.compare(0.0, Double.NEGATIVE_INFINITY), (int)1);
        Assertions.assertEquals((int)Double.compare(-0.0, Double.NaN), (int)-1);
        Assertions.assertEquals((int)Double.compare(-0.0, Double.POSITIVE_INFINITY), (int)-1);
        Assertions.assertEquals((int)Double.compare(-0.0, Double.MAX_VALUE), (int)-1);
        Assertions.assertEquals((int)Double.compare(-0.0, 1.2), (int)-1);
        Assertions.assertEquals((int)Double.compare(-0.0, 0.0), (int)-1);
        Assertions.assertEquals((int)0, (int)Double.compare(-0.0, -0.0));
        Assertions.assertEquals((int)Double.compare(-0.0, -1.2), (int)1);
        Assertions.assertEquals((int)Double.compare(-0.0, -1.7976931348623157E308), (int)1);
        Assertions.assertEquals((int)Double.compare(-0.0, Double.NEGATIVE_INFINITY), (int)1);
        Assertions.assertEquals((int)Double.compare(-1.2, Double.NaN), (int)-1);
        Assertions.assertEquals((int)Double.compare(-1.2, Double.POSITIVE_INFINITY), (int)-1);
        Assertions.assertEquals((int)Double.compare(-1.2, Double.MAX_VALUE), (int)-1);
        Assertions.assertEquals((int)Double.compare(-1.2, 1.2), (int)-1);
        Assertions.assertEquals((int)Double.compare(-1.2, 0.0), (int)-1);
        Assertions.assertEquals((int)Double.compare(-1.2, -0.0), (int)-1);
        Assertions.assertEquals((int)0, (int)Double.compare(-1.2, -1.2));
        Assertions.assertEquals((int)Double.compare(-1.2, -1.7976931348623157E308), (int)1);
        Assertions.assertEquals((int)Double.compare(-1.2, Double.NEGATIVE_INFINITY), (int)1);
        Assertions.assertEquals((int)Double.compare(-1.7976931348623157E308, Double.NaN), (int)-1);
        Assertions.assertEquals((int)Double.compare(-1.7976931348623157E308, Double.POSITIVE_INFINITY), (int)-1);
        Assertions.assertEquals((int)Double.compare(-1.7976931348623157E308, Double.MAX_VALUE), (int)-1);
        Assertions.assertEquals((int)Double.compare(-1.7976931348623157E308, 1.2), (int)-1);
        Assertions.assertEquals((int)Double.compare(-1.7976931348623157E308, 0.0), (int)-1);
        Assertions.assertEquals((int)Double.compare(-1.7976931348623157E308, -0.0), (int)-1);
        Assertions.assertEquals((int)Double.compare(-1.7976931348623157E308, -1.2), (int)-1);
        Assertions.assertEquals((int)0, (int)Double.compare(-1.7976931348623157E308, -1.7976931348623157E308));
        Assertions.assertEquals((int)Double.compare(-1.7976931348623157E308, Double.NEGATIVE_INFINITY), (int)1);
        Assertions.assertEquals((int)Double.compare(Double.NEGATIVE_INFINITY, Double.NaN), (int)-1);
        Assertions.assertEquals((int)Double.compare(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY), (int)-1);
        Assertions.assertEquals((int)Double.compare(Double.NEGATIVE_INFINITY, Double.MAX_VALUE), (int)-1);
        Assertions.assertEquals((int)Double.compare(Double.NEGATIVE_INFINITY, 1.2), (int)-1);
        Assertions.assertEquals((int)Double.compare(Double.NEGATIVE_INFINITY, 0.0), (int)-1);
        Assertions.assertEquals((int)Double.compare(Double.NEGATIVE_INFINITY, -0.0), (int)-1);
        Assertions.assertEquals((int)Double.compare(Double.NEGATIVE_INFINITY, -1.2), (int)-1);
        Assertions.assertEquals((int)Double.compare(Double.NEGATIVE_INFINITY, -1.7976931348623157E308), (int)-1);
        Assertions.assertEquals((int)0, (int)Double.compare(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY));
    }

    @Test
    public void testCompareFloat() {
        Assertions.assertEquals((int)0, (int)Float.compare(Float.NaN, Float.NaN));
        Assertions.assertEquals((int)Float.compare(Float.NaN, Float.POSITIVE_INFINITY), (int)1);
        Assertions.assertEquals((int)Float.compare(Float.NaN, Float.MAX_VALUE), (int)1);
        Assertions.assertEquals((int)Float.compare(Float.NaN, 1.2f), (int)1);
        Assertions.assertEquals((int)Float.compare(Float.NaN, 0.0f), (int)1);
        Assertions.assertEquals((int)Float.compare(Float.NaN, -0.0f), (int)1);
        Assertions.assertEquals((int)Float.compare(Float.NaN, -1.2f), (int)1);
        Assertions.assertEquals((int)Float.compare(Float.NaN, -3.4028235E38f), (int)1);
        Assertions.assertEquals((int)Float.compare(Float.NaN, Float.NEGATIVE_INFINITY), (int)1);
        Assertions.assertEquals((int)Float.compare(Float.POSITIVE_INFINITY, Float.NaN), (int)-1);
        Assertions.assertEquals((int)0, (int)Float.compare(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY));
        Assertions.assertEquals((int)Float.compare(Float.POSITIVE_INFINITY, Float.MAX_VALUE), (int)1);
        Assertions.assertEquals((int)Float.compare(Float.POSITIVE_INFINITY, 1.2f), (int)1);
        Assertions.assertEquals((int)Float.compare(Float.POSITIVE_INFINITY, 0.0f), (int)1);
        Assertions.assertEquals((int)Float.compare(Float.POSITIVE_INFINITY, -0.0f), (int)1);
        Assertions.assertEquals((int)Float.compare(Float.POSITIVE_INFINITY, -1.2f), (int)1);
        Assertions.assertEquals((int)Float.compare(Float.POSITIVE_INFINITY, -3.4028235E38f), (int)1);
        Assertions.assertEquals((int)Float.compare(Float.POSITIVE_INFINITY, Float.NEGATIVE_INFINITY), (int)1);
        Assertions.assertEquals((int)Float.compare(Float.MAX_VALUE, Float.NaN), (int)-1);
        Assertions.assertEquals((int)Float.compare(Float.MAX_VALUE, Float.POSITIVE_INFINITY), (int)-1);
        Assertions.assertEquals((int)0, (int)Float.compare(Float.MAX_VALUE, Float.MAX_VALUE));
        Assertions.assertEquals((int)Float.compare(Float.MAX_VALUE, 1.2f), (int)1);
        Assertions.assertEquals((int)Float.compare(Float.MAX_VALUE, 0.0f), (int)1);
        Assertions.assertEquals((int)Float.compare(Float.MAX_VALUE, -0.0f), (int)1);
        Assertions.assertEquals((int)Float.compare(Float.MAX_VALUE, -1.2f), (int)1);
        Assertions.assertEquals((int)Float.compare(Float.MAX_VALUE, -3.4028235E38f), (int)1);
        Assertions.assertEquals((int)Float.compare(Float.MAX_VALUE, Float.NEGATIVE_INFINITY), (int)1);
        Assertions.assertEquals((int)Float.compare(1.2f, Float.NaN), (int)-1);
        Assertions.assertEquals((int)Float.compare(1.2f, Float.POSITIVE_INFINITY), (int)-1);
        Assertions.assertEquals((int)Float.compare(1.2f, Float.MAX_VALUE), (int)-1);
        Assertions.assertEquals((int)0, (int)Float.compare(1.2f, 1.2f));
        Assertions.assertEquals((int)Float.compare(1.2f, 0.0f), (int)1);
        Assertions.assertEquals((int)Float.compare(1.2f, -0.0f), (int)1);
        Assertions.assertEquals((int)Float.compare(1.2f, -1.2f), (int)1);
        Assertions.assertEquals((int)Float.compare(1.2f, -3.4028235E38f), (int)1);
        Assertions.assertEquals((int)Float.compare(1.2f, Float.NEGATIVE_INFINITY), (int)1);
        Assertions.assertEquals((int)Float.compare(0.0f, Float.NaN), (int)-1);
        Assertions.assertEquals((int)Float.compare(0.0f, Float.POSITIVE_INFINITY), (int)-1);
        Assertions.assertEquals((int)Float.compare(0.0f, Float.MAX_VALUE), (int)-1);
        Assertions.assertEquals((int)Float.compare(0.0f, 1.2f), (int)-1);
        Assertions.assertEquals((int)0, (int)Float.compare(0.0f, 0.0f));
        Assertions.assertEquals((int)Float.compare(0.0f, -0.0f), (int)1);
        Assertions.assertEquals((int)Float.compare(0.0f, -1.2f), (int)1);
        Assertions.assertEquals((int)Float.compare(0.0f, -3.4028235E38f), (int)1);
        Assertions.assertEquals((int)Float.compare(0.0f, Float.NEGATIVE_INFINITY), (int)1);
        Assertions.assertEquals((int)Float.compare(-0.0f, Float.NaN), (int)-1);
        Assertions.assertEquals((int)Float.compare(-0.0f, Float.POSITIVE_INFINITY), (int)-1);
        Assertions.assertEquals((int)Float.compare(-0.0f, Float.MAX_VALUE), (int)-1);
        Assertions.assertEquals((int)Float.compare(-0.0f, 1.2f), (int)-1);
        Assertions.assertEquals((int)Float.compare(-0.0f, 0.0f), (int)-1);
        Assertions.assertEquals((int)0, (int)Float.compare(-0.0f, -0.0f));
        Assertions.assertEquals((int)Float.compare(-0.0f, -1.2f), (int)1);
        Assertions.assertEquals((int)Float.compare(-0.0f, -3.4028235E38f), (int)1);
        Assertions.assertEquals((int)Float.compare(-0.0f, Float.NEGATIVE_INFINITY), (int)1);
        Assertions.assertEquals((int)Float.compare(-1.2f, Float.NaN), (int)-1);
        Assertions.assertEquals((int)Float.compare(-1.2f, Float.POSITIVE_INFINITY), (int)-1);
        Assertions.assertEquals((int)Float.compare(-1.2f, Float.MAX_VALUE), (int)-1);
        Assertions.assertEquals((int)Float.compare(-1.2f, 1.2f), (int)-1);
        Assertions.assertEquals((int)Float.compare(-1.2f, 0.0f), (int)-1);
        Assertions.assertEquals((int)Float.compare(-1.2f, -0.0f), (int)-1);
        Assertions.assertEquals((int)0, (int)Float.compare(-1.2f, -1.2f));
        Assertions.assertEquals((int)Float.compare(-1.2f, -3.4028235E38f), (int)1);
        Assertions.assertEquals((int)Float.compare(-1.2f, Float.NEGATIVE_INFINITY), (int)1);
        Assertions.assertEquals((int)Float.compare(-3.4028235E38f, Float.NaN), (int)-1);
        Assertions.assertEquals((int)Float.compare(-3.4028235E38f, Float.POSITIVE_INFINITY), (int)-1);
        Assertions.assertEquals((int)Float.compare(-3.4028235E38f, Float.MAX_VALUE), (int)-1);
        Assertions.assertEquals((int)Float.compare(-3.4028235E38f, 1.2f), (int)-1);
        Assertions.assertEquals((int)Float.compare(-3.4028235E38f, 0.0f), (int)-1);
        Assertions.assertEquals((int)Float.compare(-3.4028235E38f, -0.0f), (int)-1);
        Assertions.assertEquals((int)Float.compare(-3.4028235E38f, -1.2f), (int)-1);
        Assertions.assertEquals((int)0, (int)Float.compare(-3.4028235E38f, -3.4028235E38f));
        Assertions.assertEquals((int)Float.compare(-3.4028235E38f, Float.NEGATIVE_INFINITY), (int)1);
        Assertions.assertEquals((int)Float.compare(Float.NEGATIVE_INFINITY, Float.NaN), (int)-1);
        Assertions.assertEquals((int)Float.compare(Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY), (int)-1);
        Assertions.assertEquals((int)Float.compare(Float.NEGATIVE_INFINITY, Float.MAX_VALUE), (int)-1);
        Assertions.assertEquals((int)Float.compare(Float.NEGATIVE_INFINITY, 1.2f), (int)-1);
        Assertions.assertEquals((int)Float.compare(Float.NEGATIVE_INFINITY, 0.0f), (int)-1);
        Assertions.assertEquals((int)Float.compare(Float.NEGATIVE_INFINITY, -0.0f), (int)-1);
        Assertions.assertEquals((int)Float.compare(Float.NEGATIVE_INFINITY, -1.2f), (int)-1);
        Assertions.assertEquals((int)Float.compare(Float.NEGATIVE_INFINITY, -3.4028235E38f), (int)-1);
        Assertions.assertEquals((int)0, (int)Float.compare(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY));
    }

    @Test
    public void testConstants() {
        Assertions.assertTrue((boolean)(NumberUtils.LONG_ZERO instanceof Long));
        Assertions.assertTrue((boolean)(NumberUtils.LONG_ONE instanceof Long));
        Assertions.assertTrue((boolean)(NumberUtils.LONG_MINUS_ONE instanceof Long));
        Assertions.assertTrue((boolean)(NumberUtils.INTEGER_ZERO instanceof Integer));
        Assertions.assertTrue((boolean)(NumberUtils.INTEGER_ONE instanceof Integer));
        Assertions.assertTrue((boolean)(NumberUtils.INTEGER_MINUS_ONE instanceof Integer));
        Assertions.assertTrue((boolean)(NumberUtils.SHORT_ZERO instanceof Short));
        Assertions.assertTrue((boolean)(NumberUtils.SHORT_ONE instanceof Short));
        Assertions.assertTrue((boolean)(NumberUtils.SHORT_MINUS_ONE instanceof Short));
        Assertions.assertTrue((boolean)(NumberUtils.BYTE_ZERO instanceof Byte));
        Assertions.assertTrue((boolean)(NumberUtils.BYTE_ONE instanceof Byte));
        Assertions.assertTrue((boolean)(NumberUtils.BYTE_MINUS_ONE instanceof Byte));
        Assertions.assertTrue((boolean)(NumberUtils.DOUBLE_ZERO instanceof Double));
        Assertions.assertTrue((boolean)(NumberUtils.DOUBLE_ONE instanceof Double));
        Assertions.assertTrue((boolean)(NumberUtils.DOUBLE_MINUS_ONE instanceof Double));
        Assertions.assertTrue((boolean)(NumberUtils.FLOAT_ZERO instanceof Float));
        Assertions.assertTrue((boolean)(NumberUtils.FLOAT_ONE instanceof Float));
        Assertions.assertTrue((boolean)(NumberUtils.FLOAT_MINUS_ONE instanceof Float));
        Assertions.assertEquals((long)0L, (long)NumberUtils.LONG_ZERO);
        Assertions.assertEquals((long)1L, (long)NumberUtils.LONG_ONE);
        Assertions.assertEquals((long)NumberUtils.LONG_MINUS_ONE, (long)-1L);
        Assertions.assertEquals((int)0, (int)NumberUtils.INTEGER_ZERO);
        Assertions.assertEquals((int)1, (int)NumberUtils.INTEGER_ONE);
        Assertions.assertEquals((int)NumberUtils.INTEGER_MINUS_ONE, (int)-1);
        Assertions.assertEquals((int)0, (int)NumberUtils.SHORT_ZERO.shortValue());
        Assertions.assertEquals((int)1, (int)NumberUtils.SHORT_ONE.shortValue());
        Assertions.assertEquals((int)NumberUtils.SHORT_MINUS_ONE.shortValue(), (int)-1);
        Assertions.assertEquals((int)0, (int)NumberUtils.BYTE_ZERO.byteValue());
        Assertions.assertEquals((int)1, (int)NumberUtils.BYTE_ONE.byteValue());
        Assertions.assertEquals((int)NumberUtils.BYTE_MINUS_ONE.byteValue(), (int)-1);
        Assertions.assertEquals((double)0.0, (double)NumberUtils.DOUBLE_ZERO);
        Assertions.assertEquals((double)1.0, (double)NumberUtils.DOUBLE_ONE);
        Assertions.assertEquals((double)NumberUtils.DOUBLE_MINUS_ONE, (double)-1.0);
        Assertions.assertEquals((float)0.0f, (float)NumberUtils.FLOAT_ZERO.floatValue());
        Assertions.assertEquals((float)1.0f, (float)NumberUtils.FLOAT_ONE.floatValue());
        Assertions.assertEquals((float)NumberUtils.FLOAT_MINUS_ONE.floatValue(), (float)-1.0f);
    }

    @Test
    public void testConstructor() {
        Assertions.assertNotNull((Object)new NumberUtils());
        Constructor<?>[] cons = NumberUtils.class.getDeclaredConstructors();
        Assertions.assertEquals((int)1, (int)cons.length);
        Assertions.assertTrue((boolean)Modifier.isPublic(cons[0].getModifiers()));
        Assertions.assertTrue((boolean)Modifier.isPublic(NumberUtils.class.getModifiers()));
        Assertions.assertFalse((boolean)Modifier.isFinal(NumberUtils.class.getModifiers()));
    }

    @Test
    public void testCreateBigDecimal() {
        Assertions.assertEquals((Object)new BigDecimal("1234.5"), (Object)NumberUtils.createBigDecimal((String)"1234.5"), (String)"createBigDecimal(String) failed");
        Assertions.assertNull((Object)NumberUtils.createBigDecimal(null), (String)"createBigDecimal(null) failed");
        this.testCreateBigDecimalFailure("");
        this.testCreateBigDecimalFailure(" ");
        this.testCreateBigDecimalFailure("\b\t\n\f\r");
        this.testCreateBigDecimalFailure("\u00a0\ufeff\u000b\f\u001c\u001d\u001e\u001f");
        this.testCreateBigDecimalFailure("-");
        this.testCreateBigDecimalFailure("--");
        this.testCreateBigDecimalFailure("--0");
        this.testCreateBigDecimalFailure("+");
        this.testCreateBigDecimalFailure("++");
        this.testCreateBigDecimalFailure("++0");
    }

    protected void testCreateBigDecimalFailure(String str) {
        Assertions.assertThrows(NumberFormatException.class, () -> NumberUtils.createBigDecimal((String)str), (String)("createBigDecimal(\"" + str + "\") should have failed."));
    }

    @Test
    public void testCreateBigInteger() {
        Assertions.assertEquals((Object)new BigInteger("12345"), (Object)NumberUtils.createBigInteger((String)"12345"), (String)"createBigInteger(String) failed");
        Assertions.assertNull((Object)NumberUtils.createBigInteger(null), (String)"createBigInteger(null) failed");
        this.testCreateBigIntegerFailure("");
        this.testCreateBigIntegerFailure(" ");
        this.testCreateBigIntegerFailure("\b\t\n\f\r");
        this.testCreateBigIntegerFailure("\u00a0\ufeff\u000b\f\u001c\u001d\u001e\u001f");
        Assertions.assertEquals((Object)new BigInteger("255"), (Object)NumberUtils.createBigInteger((String)"0xff"), (String)"createBigInteger(String) failed");
        Assertions.assertEquals((Object)new BigInteger("255"), (Object)NumberUtils.createBigInteger((String)"0Xff"), (String)"createBigInteger(String) failed");
        Assertions.assertEquals((Object)new BigInteger("255"), (Object)NumberUtils.createBigInteger((String)"#ff"), (String)"createBigInteger(String) failed");
        Assertions.assertEquals((Object)new BigInteger("-255"), (Object)NumberUtils.createBigInteger((String)"-0xff"), (String)"createBigInteger(String) failed");
        Assertions.assertEquals((Object)new BigInteger("255"), (Object)NumberUtils.createBigInteger((String)"0377"), (String)"createBigInteger(String) failed");
        Assertions.assertEquals((Object)new BigInteger("-255"), (Object)NumberUtils.createBigInteger((String)"-0377"), (String)"createBigInteger(String) failed");
        Assertions.assertEquals((Object)new BigInteger("-255"), (Object)NumberUtils.createBigInteger((String)"-0377"), (String)"createBigInteger(String) failed");
        Assertions.assertEquals((Object)new BigInteger("-0"), (Object)NumberUtils.createBigInteger((String)"-0"), (String)"createBigInteger(String) failed");
        Assertions.assertEquals((Object)new BigInteger("0"), (Object)NumberUtils.createBigInteger((String)"0"), (String)"createBigInteger(String) failed");
        this.testCreateBigIntegerFailure("#");
        this.testCreateBigIntegerFailure("-#");
        this.testCreateBigIntegerFailure("0x");
        this.testCreateBigIntegerFailure("-0x");
    }

    protected void testCreateBigIntegerFailure(String str) {
        Assertions.assertThrows(NumberFormatException.class, () -> NumberUtils.createBigInteger((String)str), (String)("createBigInteger(\"" + str + "\") should have failed."));
    }

    @Test
    public void testCreateDouble() {
        Assertions.assertEquals((Double)Double.valueOf("1234.5"), (Double)NumberUtils.createDouble((String)"1234.5"), (String)"createDouble(String) failed");
        Assertions.assertNull((Object)NumberUtils.createDouble(null), (String)"createDouble(null) failed");
        this.testCreateDoubleFailure("");
        this.testCreateDoubleFailure(" ");
        this.testCreateDoubleFailure("\b\t\n\f\r");
        this.testCreateDoubleFailure("\u00a0\ufeff\u000b\f\u001c\u001d\u001e\u001f");
    }

    protected void testCreateDoubleFailure(String str) {
        Assertions.assertThrows(NumberFormatException.class, () -> NumberUtils.createDouble((String)str), (String)("createDouble(\"" + str + "\") should have failed."));
    }

    @Test
    public void testCreateFloat() {
        Assertions.assertEquals((Float)Float.valueOf("1234.5"), (Float)NumberUtils.createFloat((String)"1234.5"), (String)"createFloat(String) failed");
        Assertions.assertNull((Object)NumberUtils.createFloat(null), (String)"createFloat(null) failed");
        this.testCreateFloatFailure("");
        this.testCreateFloatFailure(" ");
        this.testCreateFloatFailure("\b\t\n\f\r");
        this.testCreateFloatFailure("\u00a0\ufeff\u000b\f\u001c\u001d\u001e\u001f");
    }

    protected void testCreateFloatFailure(String str) {
        Assertions.assertThrows(NumberFormatException.class, () -> NumberUtils.createFloat((String)str), (String)("createFloat(\"" + str + "\") should have failed."));
    }

    @Test
    public void testCreateInteger() {
        Assertions.assertEquals((Integer)Integer.valueOf("12345"), (Integer)NumberUtils.createInteger((String)"12345"), (String)"createInteger(String) failed");
        Assertions.assertNull((Object)NumberUtils.createInteger(null), (String)"createInteger(null) failed");
        this.testCreateIntegerFailure("");
        this.testCreateIntegerFailure(" ");
        this.testCreateIntegerFailure("\b\t\n\f\r");
        this.testCreateIntegerFailure("\u00a0\ufeff\u000b\f\u001c\u001d\u001e\u001f");
    }

    protected void testCreateIntegerFailure(String str) {
        Assertions.assertThrows(NumberFormatException.class, () -> NumberUtils.createInteger((String)str), (String)("createInteger(\"" + str + "\") should have failed."));
    }

    @Test
    public void testCreateLong() {
        Assertions.assertEquals((Long)Long.valueOf("12345"), (Long)NumberUtils.createLong((String)"12345"), (String)"createLong(String) failed");
        Assertions.assertNull((Object)NumberUtils.createLong(null), (String)"createLong(null) failed");
        this.testCreateLongFailure("");
        this.testCreateLongFailure(" ");
        this.testCreateLongFailure("\b\t\n\f\r");
        this.testCreateLongFailure("\u00a0\ufeff\u000b\f\u001c\u001d\u001e\u001f");
    }

    protected void testCreateLongFailure(String str) {
        Assertions.assertThrows(NumberFormatException.class, () -> NumberUtils.createLong((String)str), (String)("createLong(\"" + str + "\") should have failed."));
    }

    @Test
    public void testCreateNumber() {
        Assertions.assertEquals((Object)Float.valueOf("1234.5"), (Object)NumberUtils.createNumber((String)"1234.5"), (String)"createNumber(String) 1 failed");
        Assertions.assertEquals((Object)Integer.valueOf("12345"), (Object)NumberUtils.createNumber((String)"12345"), (String)"createNumber(String) 2 failed");
        Assertions.assertEquals((Object)Double.valueOf("1234.5"), (Object)NumberUtils.createNumber((String)"1234.5D"), (String)"createNumber(String) 3 failed");
        Assertions.assertEquals((Object)Double.valueOf("1234.5"), (Object)NumberUtils.createNumber((String)"1234.5d"), (String)"createNumber(String) 3 failed");
        Assertions.assertEquals((Object)Float.valueOf("1234.5"), (Object)NumberUtils.createNumber((String)"1234.5F"), (String)"createNumber(String) 4 failed");
        Assertions.assertEquals((Object)Float.valueOf("1234.5"), (Object)NumberUtils.createNumber((String)"1234.5f"), (String)"createNumber(String) 4 failed");
        Assertions.assertEquals((Object)0x80000000L, (Object)NumberUtils.createNumber((String)"2147483648"), (String)"createNumber(String) 5 failed");
        Assertions.assertEquals((Object)12345L, (Object)NumberUtils.createNumber((String)"12345L"), (String)"createNumber(String) 6 failed");
        Assertions.assertEquals((Object)12345L, (Object)NumberUtils.createNumber((String)"12345l"), (String)"createNumber(String) 6 failed");
        Assertions.assertEquals((Object)Float.valueOf("-1234.5"), (Object)NumberUtils.createNumber((String)"-1234.5"), (String)"createNumber(String) 7 failed");
        Assertions.assertEquals((Object)Integer.valueOf("-12345"), (Object)NumberUtils.createNumber((String)"-12345"), (String)"createNumber(String) 8 failed");
        Assertions.assertEquals((int)64222, (int)NumberUtils.createNumber((String)"0xFADE").intValue(), (String)"createNumber(String) 9a failed");
        Assertions.assertEquals((int)64222, (int)NumberUtils.createNumber((String)"0Xfade").intValue(), (String)"createNumber(String) 9b failed");
        Assertions.assertEquals((int)-64222, (int)NumberUtils.createNumber((String)"-0xFADE").intValue(), (String)"createNumber(String) 10a failed");
        Assertions.assertEquals((int)-64222, (int)NumberUtils.createNumber((String)"-0Xfade").intValue(), (String)"createNumber(String) 10b failed");
        Assertions.assertEquals((Object)Double.valueOf("1.1E200"), (Object)NumberUtils.createNumber((String)"1.1E200"), (String)"createNumber(String) 11 failed");
        Assertions.assertEquals((Object)Float.valueOf("1.1E20"), (Object)NumberUtils.createNumber((String)"1.1E20"), (String)"createNumber(String) 12 failed");
        Assertions.assertEquals((Object)Double.valueOf("-1.1E200"), (Object)NumberUtils.createNumber((String)"-1.1E200"), (String)"createNumber(String) 13 failed");
        Assertions.assertEquals((Object)Double.valueOf("1.1E-200"), (Object)NumberUtils.createNumber((String)"1.1E-200"), (String)"createNumber(String) 14 failed");
        Assertions.assertNull((Object)NumberUtils.createNumber(null), (String)"createNumber(null) failed");
        Assertions.assertEquals((Object)new BigInteger("12345678901234567890"), (Object)NumberUtils.createNumber((String)"12345678901234567890L"), (String)"createNumber(String) failed");
        Assertions.assertEquals((Object)new BigDecimal("1.1E-700"), (Object)NumberUtils.createNumber((String)"1.1E-700F"), (String)"createNumber(String) 15 failed");
        Assertions.assertEquals((Object)Long.valueOf("102147483647"), (Object)NumberUtils.createNumber((String)"102147483647L"), (String)"createNumber(String) 16 failed");
        Assertions.assertEquals((Object)Long.valueOf("102147483647"), (Object)NumberUtils.createNumber((String)"102147483647"), (String)"createNumber(String) 17 failed");
        Assertions.assertEquals((Object)new BigInteger("109223372036854775807"), (Object)NumberUtils.createNumber((String)"109223372036854775807"), (String)"createNumber(String) 18 failed");
        Assertions.assertEquals((Object)Float.valueOf("2."), (Object)NumberUtils.createNumber((String)"2."), (String)"createNumber(String) LANG-521 failed");
        Assertions.assertFalse((boolean)this.checkCreateNumber("1eE"), (String)"createNumber(String) succeeded");
        Assertions.assertEquals((Object)Double.MAX_VALUE, (Object)NumberUtils.createNumber((String)"1.7976931348623157E308"), (String)"createNumber(String) LANG-693 failed");
        Number bigNum = NumberUtils.createNumber((String)"-1.1E-700F");
        Assertions.assertNotNull((Object)bigNum);
        Assertions.assertEquals(BigDecimal.class, bigNum.getClass());
        Assertions.assertEquals((Object)Double.valueOf("-160952.54"), (Object)NumberUtils.createNumber((String)"-160952.54"), (String)"createNumber(String) LANG-1018 failed");
        Assertions.assertEquals((Object)Double.valueOf("6264583.33"), (Object)NumberUtils.createNumber((String)"6264583.33"), (String)"createNumber(String) LANG-1187 failed");
        Assertions.assertEquals((Object)Double.valueOf("193343.82"), (Object)NumberUtils.createNumber((String)"193343.82"), (String)"createNumber(String) LANG-1215 failed");
        Assertions.assertEquals((Object)Double.valueOf("001234.5678"), (Object)NumberUtils.createNumber((String)"001234.5678"), (String)"createNumber(String) LANG-1060a failed");
        Assertions.assertEquals((Object)Double.valueOf("+001234.5678"), (Object)NumberUtils.createNumber((String)"+001234.5678"), (String)"createNumber(String) LANG-1060b failed");
        Assertions.assertEquals((Object)Double.valueOf("-001234.5678"), (Object)NumberUtils.createNumber((String)"-001234.5678"), (String)"createNumber(String) LANG-1060c failed");
        Assertions.assertEquals((Object)Double.valueOf("0000.00000"), (Object)NumberUtils.createNumber((String)"0000.00000d"), (String)"createNumber(String) LANG-1060d failed");
        Assertions.assertEquals((Object)Float.valueOf("001234.56"), (Object)NumberUtils.createNumber((String)"001234.56"), (String)"createNumber(String) LANG-1060e failed");
        Assertions.assertEquals((Object)Float.valueOf("+001234.56"), (Object)NumberUtils.createNumber((String)"+001234.56"), (String)"createNumber(String) LANG-1060f failed");
        Assertions.assertEquals((Object)Float.valueOf("-001234.56"), (Object)NumberUtils.createNumber((String)"-001234.56"), (String)"createNumber(String) LANG-1060g failed");
        Assertions.assertEquals((Object)Float.valueOf("0000.10"), (Object)NumberUtils.createNumber((String)"0000.10"), (String)"createNumber(String) LANG-1060h failed");
        Assertions.assertEquals((Object)Float.valueOf("001.1E20"), (Object)NumberUtils.createNumber((String)"001.1E20"), (String)"createNumber(String) LANG-1060i failed");
        Assertions.assertEquals((Object)Float.valueOf("+001.1E20"), (Object)NumberUtils.createNumber((String)"+001.1E20"), (String)"createNumber(String) LANG-1060j failed");
        Assertions.assertEquals((Object)Float.valueOf("-001.1E20"), (Object)NumberUtils.createNumber((String)"-001.1E20"), (String)"createNumber(String) LANG-1060k failed");
        Assertions.assertEquals((Object)Double.valueOf("001.1E200"), (Object)NumberUtils.createNumber((String)"001.1E200"), (String)"createNumber(String) LANG-1060l failed");
        Assertions.assertEquals((Object)Double.valueOf("+001.1E200"), (Object)NumberUtils.createNumber((String)"+001.1E200"), (String)"createNumber(String) LANG-1060m failed");
        Assertions.assertEquals((Object)Double.valueOf("-001.1E200"), (Object)NumberUtils.createNumber((String)"-001.1E200"), (String)"createNumber(String) LANG-1060n failed");
    }

    @Test
    public void testCreateNumberFailure_1() {
        Assertions.assertThrows(NumberFormatException.class, () -> NumberUtils.createNumber((String)"--1.1E-700F"));
    }

    @Test
    public void testCreateNumberFailure_2() {
        Assertions.assertThrows(NumberFormatException.class, () -> NumberUtils.createNumber((String)"-1.1E+0-7e00"));
    }

    @Test
    public void testCreateNumberFailure_3() {
        Assertions.assertThrows(NumberFormatException.class, () -> NumberUtils.createNumber((String)"-11E+0-7e00"));
    }

    @Test
    public void testCreateNumberFailure_4() {
        Assertions.assertThrows(NumberFormatException.class, () -> NumberUtils.createNumber((String)"1eE+00001"));
    }

    @Test
    public void testCreateNumberFailure_5() {
        Assertions.assertThrows(NumberFormatException.class, () -> NumberUtils.createNumber((String)"1234.5ff"));
    }

    @Test
    public void testCreateNumberFailure_6() {
        Assertions.assertThrows(NumberFormatException.class, () -> NumberUtils.createNumber((String)"1234.5FF"));
    }

    @Test
    public void testCreateNumberFailure_7() {
        Assertions.assertThrows(NumberFormatException.class, () -> NumberUtils.createNumber((String)"1234.5dd"));
    }

    @Test
    public void testCreateNumberFailure_8() {
        Assertions.assertThrows(NumberFormatException.class, () -> NumberUtils.createNumber((String)"1234.5DD"));
    }

    @Test
    public void testCreateNumberMagnitude() {
        Assertions.assertEquals((Object)Float.valueOf(Float.MAX_VALUE), (Object)NumberUtils.createNumber((String)"3.4028235e+38"));
        Assertions.assertEquals((Object)3.4028236E38, (Object)NumberUtils.createNumber((String)"3.4028236e+38"));
        Assertions.assertEquals((Object)Double.MAX_VALUE, (Object)NumberUtils.createNumber((String)"1.7976931348623157e+308"));
        Assertions.assertEquals((Object)new BigDecimal("1.7976931348623159e+308"), (Object)NumberUtils.createNumber((String)"1.7976931348623159e+308"));
        Assertions.assertEquals((Object)305419896, (Object)NumberUtils.createNumber((String)"0x12345678"));
        Assertions.assertEquals((Object)4886718345L, (Object)NumberUtils.createNumber((String)"0x123456789"));
        Assertions.assertEquals((Object)Long.MAX_VALUE, (Object)NumberUtils.createNumber((String)"0x7fffffffffffffff"));
        Assertions.assertEquals((Object)new BigInteger("7fffffffffffffff0", 16), (Object)NumberUtils.createNumber((String)"0x7fffffffffffffff0"));
        Assertions.assertEquals((Object)Long.MAX_VALUE, (Object)NumberUtils.createNumber((String)"#7fffffffffffffff"));
        Assertions.assertEquals((Object)new BigInteger("7fffffffffffffff0", 16), (Object)NumberUtils.createNumber((String)"#7fffffffffffffff0"));
        Assertions.assertEquals((Object)Integer.MAX_VALUE, (Object)NumberUtils.createNumber((String)"017777777777"));
        Assertions.assertEquals((Object)0xFFFFFFFFL, (Object)NumberUtils.createNumber((String)"037777777777"));
        Assertions.assertEquals((Object)Long.MAX_VALUE, (Object)NumberUtils.createNumber((String)"0777777777777777777777"));
        Assertions.assertEquals((Object)new BigInteger("1777777777777777777777", 8), (Object)NumberUtils.createNumber((String)"01777777777777777777777"));
    }

    @Test
    public void testIsCreatable() {
        this.compareIsCreatableWithCreateNumber("12345", true);
        this.compareIsCreatableWithCreateNumber("1234.5", true);
        this.compareIsCreatableWithCreateNumber(".12345", true);
        this.compareIsCreatableWithCreateNumber("1234E5", true);
        this.compareIsCreatableWithCreateNumber("1234E+5", true);
        this.compareIsCreatableWithCreateNumber("1234E-5", true);
        this.compareIsCreatableWithCreateNumber("123.4E5", true);
        this.compareIsCreatableWithCreateNumber("-1234", true);
        this.compareIsCreatableWithCreateNumber("-1234.5", true);
        this.compareIsCreatableWithCreateNumber("-.12345", true);
        this.compareIsCreatableWithCreateNumber("-1234E5", true);
        this.compareIsCreatableWithCreateNumber("0", true);
        this.compareIsCreatableWithCreateNumber("0.1", true);
        this.compareIsCreatableWithCreateNumber("-0", true);
        this.compareIsCreatableWithCreateNumber("01234", true);
        this.compareIsCreatableWithCreateNumber("-01234", true);
        this.compareIsCreatableWithCreateNumber("-0xABC123", true);
        this.compareIsCreatableWithCreateNumber("-0x0", true);
        this.compareIsCreatableWithCreateNumber("123.4E21D", true);
        this.compareIsCreatableWithCreateNumber("-221.23F", true);
        this.compareIsCreatableWithCreateNumber("22338L", true);
        this.compareIsCreatableWithCreateNumber(null, false);
        this.compareIsCreatableWithCreateNumber("", false);
        this.compareIsCreatableWithCreateNumber(" ", false);
        this.compareIsCreatableWithCreateNumber("\r\n\t", false);
        this.compareIsCreatableWithCreateNumber("--2.3", false);
        this.compareIsCreatableWithCreateNumber(".12.3", false);
        this.compareIsCreatableWithCreateNumber("-123E", false);
        this.compareIsCreatableWithCreateNumber("-123E+-212", false);
        this.compareIsCreatableWithCreateNumber("-123E2.12", false);
        this.compareIsCreatableWithCreateNumber("0xGF", false);
        this.compareIsCreatableWithCreateNumber("0xFAE-1", false);
        this.compareIsCreatableWithCreateNumber(".", false);
        this.compareIsCreatableWithCreateNumber("-0ABC123", false);
        this.compareIsCreatableWithCreateNumber("123.4E-D", false);
        this.compareIsCreatableWithCreateNumber("123.4ED", false);
        this.compareIsCreatableWithCreateNumber("1234E5l", false);
        this.compareIsCreatableWithCreateNumber("11a", false);
        this.compareIsCreatableWithCreateNumber("1a", false);
        this.compareIsCreatableWithCreateNumber("a", false);
        this.compareIsCreatableWithCreateNumber("11g", false);
        this.compareIsCreatableWithCreateNumber("11z", false);
        this.compareIsCreatableWithCreateNumber("11def", false);
        this.compareIsCreatableWithCreateNumber("11d11", false);
        this.compareIsCreatableWithCreateNumber("11 11", false);
        this.compareIsCreatableWithCreateNumber(" 1111", false);
        this.compareIsCreatableWithCreateNumber("1111 ", false);
        this.compareIsCreatableWithCreateNumber("2.", true);
        this.compareIsCreatableWithCreateNumber("1.1L", false);
    }

    @Test
    public void testIsDigits() {
        Assertions.assertFalse((boolean)NumberUtils.isDigits(null), (String)"isDigits(null) failed");
        Assertions.assertFalse((boolean)NumberUtils.isDigits((String)""), (String)"isDigits('') failed");
        Assertions.assertTrue((boolean)NumberUtils.isDigits((String)"12345"), (String)"isDigits(String) failed");
        Assertions.assertFalse((boolean)NumberUtils.isDigits((String)"1234.5"), (String)"isDigits(String) neg 1 failed");
        Assertions.assertFalse((boolean)NumberUtils.isDigits((String)"1ab"), (String)"isDigits(String) neg 3 failed");
        Assertions.assertFalse((boolean)NumberUtils.isDigits((String)"abc"), (String)"isDigits(String) neg 4 failed");
    }

    @Test
    public void testIsNumber() {
        this.compareIsNumberWithCreateNumber("12345", true);
        this.compareIsNumberWithCreateNumber("1234.5", true);
        this.compareIsNumberWithCreateNumber(".12345", true);
        this.compareIsNumberWithCreateNumber("1234E5", true);
        this.compareIsNumberWithCreateNumber("1234E+5", true);
        this.compareIsNumberWithCreateNumber("1234E-5", true);
        this.compareIsNumberWithCreateNumber("123.4E5", true);
        this.compareIsNumberWithCreateNumber("-1234", true);
        this.compareIsNumberWithCreateNumber("-1234.5", true);
        this.compareIsNumberWithCreateNumber("-.12345", true);
        this.compareIsNumberWithCreateNumber("-0001.12345", true);
        this.compareIsNumberWithCreateNumber("-000.12345", true);
        this.compareIsNumberWithCreateNumber("+00.12345", true);
        this.compareIsNumberWithCreateNumber("+0002.12345", true);
        this.compareIsNumberWithCreateNumber("-1234E5", true);
        this.compareIsNumberWithCreateNumber("0", true);
        this.compareIsNumberWithCreateNumber("-0", true);
        this.compareIsNumberWithCreateNumber("01234", true);
        this.compareIsNumberWithCreateNumber("-01234", true);
        this.compareIsNumberWithCreateNumber("-0xABC123", true);
        this.compareIsNumberWithCreateNumber("-0x0", true);
        this.compareIsNumberWithCreateNumber("123.4E21D", true);
        this.compareIsNumberWithCreateNumber("-221.23F", true);
        this.compareIsNumberWithCreateNumber("22338L", true);
        this.compareIsNumberWithCreateNumber(null, false);
        this.compareIsNumberWithCreateNumber("", false);
        this.compareIsNumberWithCreateNumber(" ", false);
        this.compareIsNumberWithCreateNumber("\r\n\t", false);
        this.compareIsNumberWithCreateNumber("--2.3", false);
        this.compareIsNumberWithCreateNumber(".12.3", false);
        this.compareIsNumberWithCreateNumber("-123E", false);
        this.compareIsNumberWithCreateNumber("-123E+-212", false);
        this.compareIsNumberWithCreateNumber("-123E2.12", false);
        this.compareIsNumberWithCreateNumber("0xGF", false);
        this.compareIsNumberWithCreateNumber("0xFAE-1", false);
        this.compareIsNumberWithCreateNumber(".", false);
        this.compareIsNumberWithCreateNumber("-0ABC123", false);
        this.compareIsNumberWithCreateNumber("123.4E-D", false);
        this.compareIsNumberWithCreateNumber("123.4ED", false);
        this.compareIsNumberWithCreateNumber("+000E.12345", false);
        this.compareIsNumberWithCreateNumber("-000E.12345", false);
        this.compareIsNumberWithCreateNumber("1234E5l", false);
        this.compareIsNumberWithCreateNumber("11a", false);
        this.compareIsNumberWithCreateNumber("1a", false);
        this.compareIsNumberWithCreateNumber("a", false);
        this.compareIsNumberWithCreateNumber("11g", false);
        this.compareIsNumberWithCreateNumber("11z", false);
        this.compareIsNumberWithCreateNumber("11def", false);
        this.compareIsNumberWithCreateNumber("11d11", false);
        this.compareIsNumberWithCreateNumber("11 11", false);
        this.compareIsNumberWithCreateNumber(" 1111", false);
        this.compareIsNumberWithCreateNumber("1111 ", false);
        this.compareIsNumberWithCreateNumber("2.", true);
        this.compareIsNumberWithCreateNumber("1.1L", false);
    }

    @Test
    public void testIsNumberLANG1252() {
        this.compareIsNumberWithCreateNumber("+2", true);
        this.compareIsNumberWithCreateNumber("+2.0", true);
    }

    @Test
    public void testIsNumberLANG1385() {
        this.compareIsNumberWithCreateNumber("L", false);
    }

    @Test
    public void testIsNumberLANG971() {
        this.compareIsNumberWithCreateNumber("0085", false);
        this.compareIsNumberWithCreateNumber("085", false);
        this.compareIsNumberWithCreateNumber("08", false);
        this.compareIsNumberWithCreateNumber("07", true);
        this.compareIsNumberWithCreateNumber("00", true);
    }

    @Test
    public void testIsNumberLANG972() {
        this.compareIsNumberWithCreateNumber("0xABCD", true);
        this.compareIsNumberWithCreateNumber("0XABCD", true);
    }

    @Test
    public void testIsNumberLANG992() {
        this.compareIsNumberWithCreateNumber("0.0", true);
        this.compareIsNumberWithCreateNumber("0.4790", true);
    }

    @Test
    public void testIsParsable() {
        Assertions.assertFalse((boolean)NumberUtils.isParsable(null));
        Assertions.assertFalse((boolean)NumberUtils.isParsable((String)""));
        Assertions.assertFalse((boolean)NumberUtils.isParsable((String)"0xC1AB"));
        Assertions.assertFalse((boolean)NumberUtils.isParsable((String)"65CBA2"));
        Assertions.assertFalse((boolean)NumberUtils.isParsable((String)"pendro"));
        Assertions.assertFalse((boolean)NumberUtils.isParsable((String)"64, 2"));
        Assertions.assertFalse((boolean)NumberUtils.isParsable((String)"64.2.2"));
        Assertions.assertFalse((boolean)NumberUtils.isParsable((String)"64."));
        Assertions.assertFalse((boolean)NumberUtils.isParsable((String)"64L"));
        Assertions.assertFalse((boolean)NumberUtils.isParsable((String)"-"));
        Assertions.assertFalse((boolean)NumberUtils.isParsable((String)"--2"));
        Assertions.assertTrue((boolean)NumberUtils.isParsable((String)"64.2"));
        Assertions.assertTrue((boolean)NumberUtils.isParsable((String)"64"));
        Assertions.assertTrue((boolean)NumberUtils.isParsable((String)"018"));
        Assertions.assertTrue((boolean)NumberUtils.isParsable((String)".18"));
        Assertions.assertTrue((boolean)NumberUtils.isParsable((String)"-65"));
        Assertions.assertTrue((boolean)NumberUtils.isParsable((String)"-018"));
        Assertions.assertTrue((boolean)NumberUtils.isParsable((String)"-018.2"));
        Assertions.assertTrue((boolean)NumberUtils.isParsable((String)"-.236"));
    }

    @Test
    public void testLang1087() {
        Assertions.assertEquals(Float.class, NumberUtils.createNumber((String)"0.0").getClass());
        Assertions.assertEquals((Object)Float.valueOf("0.0"), (Object)NumberUtils.createNumber((String)"0.0"));
        Assertions.assertEquals(Float.class, NumberUtils.createNumber((String)"+0.0").getClass());
        Assertions.assertEquals((Object)Float.valueOf("+0.0"), (Object)NumberUtils.createNumber((String)"+0.0"));
        Assertions.assertEquals(Float.class, NumberUtils.createNumber((String)"-0.0").getClass());
        Assertions.assertEquals((Object)Float.valueOf("-0.0"), (Object)NumberUtils.createNumber((String)"-0.0"));
    }

    @Test
    public void testLANG1252() {
        this.compareIsCreatableWithCreateNumber("+2", true);
        this.compareIsCreatableWithCreateNumber("+2.0", true);
    }

    @Test
    public void testLang300() {
        NumberUtils.createNumber((String)"-1l");
        NumberUtils.createNumber((String)"01l");
        NumberUtils.createNumber((String)"1l");
    }

    @Test
    public void testLang381() {
        Assertions.assertTrue((boolean)Double.isNaN(NumberUtils.min((double)1.2, (double)2.5, (double)Double.NaN)));
        Assertions.assertTrue((boolean)Double.isNaN(NumberUtils.max((double)1.2, (double)2.5, (double)Double.NaN)));
        Assertions.assertTrue((boolean)Float.isNaN(NumberUtils.min((float)1.2f, (float)2.5f, (float)Float.NaN)));
        Assertions.assertTrue((boolean)Float.isNaN(NumberUtils.max((float)1.2f, (float)2.5f, (float)Float.NaN)));
        double[] a = new double[]{1.2, Double.NaN, 3.7, 27.0, 42.0, Double.NaN};
        Assertions.assertTrue((boolean)Double.isNaN(NumberUtils.max((double[])a)));
        Assertions.assertTrue((boolean)Double.isNaN(NumberUtils.min((double[])a)));
        double[] b = new double[]{Double.NaN, 1.2, Double.NaN, 3.7, 27.0, 42.0, Double.NaN};
        Assertions.assertTrue((boolean)Double.isNaN(NumberUtils.max((double[])b)));
        Assertions.assertTrue((boolean)Double.isNaN(NumberUtils.min((double[])b)));
        float[] aF = new float[]{1.2f, Float.NaN, 3.7f, 27.0f, 42.0f, Float.NaN};
        Assertions.assertTrue((boolean)Float.isNaN(NumberUtils.max((float[])aF)));
        float[] bF = new float[]{Float.NaN, 1.2f, Float.NaN, 3.7f, 27.0f, 42.0f, Float.NaN};
        Assertions.assertTrue((boolean)Float.isNaN(NumberUtils.max((float[])bF)));
    }

    @Test
    public void TestLang747() {
        Assertions.assertEquals((Object)32768, (Object)NumberUtils.createNumber((String)"0x8000"));
        Assertions.assertEquals((Object)524288, (Object)NumberUtils.createNumber((String)"0x80000"));
        Assertions.assertEquals((Object)0x800000, (Object)NumberUtils.createNumber((String)"0x800000"));
        Assertions.assertEquals((Object)0x8000000, (Object)NumberUtils.createNumber((String)"0x8000000"));
        Assertions.assertEquals((Object)Integer.MAX_VALUE, (Object)NumberUtils.createNumber((String)"0x7FFFFFFF"));
        Assertions.assertEquals((Object)0x80000000L, (Object)NumberUtils.createNumber((String)"0x80000000"));
        Assertions.assertEquals((Object)0xFFFFFFFFL, (Object)NumberUtils.createNumber((String)"0xFFFFFFFF"));
        Assertions.assertEquals((Object)0x8000000, (Object)NumberUtils.createNumber((String)"0x08000000"));
        Assertions.assertEquals((Object)Integer.MAX_VALUE, (Object)NumberUtils.createNumber((String)"0x007FFFFFFF"));
        Assertions.assertEquals((Object)0x80000000L, (Object)NumberUtils.createNumber((String)"0x080000000"));
        Assertions.assertEquals((Object)0xFFFFFFFFL, (Object)NumberUtils.createNumber((String)"0x00FFFFFFFF"));
        Assertions.assertEquals((Object)0x800000000L, (Object)NumberUtils.createNumber((String)"0x800000000"));
        Assertions.assertEquals((Object)0x8000000000L, (Object)NumberUtils.createNumber((String)"0x8000000000"));
        Assertions.assertEquals((Object)0x80000000000L, (Object)NumberUtils.createNumber((String)"0x80000000000"));
        Assertions.assertEquals((Object)0x800000000000L, (Object)NumberUtils.createNumber((String)"0x800000000000"));
        Assertions.assertEquals((Object)0x8000000000000L, (Object)NumberUtils.createNumber((String)"0x8000000000000"));
        Assertions.assertEquals((Object)0x80000000000000L, (Object)NumberUtils.createNumber((String)"0x80000000000000"));
        Assertions.assertEquals((Object)0x800000000000000L, (Object)NumberUtils.createNumber((String)"0x800000000000000"));
        Assertions.assertEquals((Object)Long.MAX_VALUE, (Object)NumberUtils.createNumber((String)"0x7FFFFFFFFFFFFFFF"));
        Assertions.assertEquals((Object)new BigInteger("8000000000000000", 16), (Object)NumberUtils.createNumber((String)"0x8000000000000000"));
        Assertions.assertEquals((Object)new BigInteger("FFFFFFFFFFFFFFFF", 16), (Object)NumberUtils.createNumber((String)"0xFFFFFFFFFFFFFFFF"));
        Assertions.assertEquals((Object)0x80000000000000L, (Object)NumberUtils.createNumber((String)"0x00080000000000000"));
        Assertions.assertEquals((Object)0x800000000000000L, (Object)NumberUtils.createNumber((String)"0x0800000000000000"));
        Assertions.assertEquals((Object)Long.MAX_VALUE, (Object)NumberUtils.createNumber((String)"0x07FFFFFFFFFFFFFFF"));
        Assertions.assertEquals((Object)new BigInteger("8000000000000000", 16), (Object)NumberUtils.createNumber((String)"0x00008000000000000000"));
        Assertions.assertEquals((Object)new BigInteger("FFFFFFFFFFFFFFFF", 16), (Object)NumberUtils.createNumber((String)"0x0FFFFFFFFFFFFFFFF"));
    }

    @Test
    public void testLANG971() {
        this.compareIsCreatableWithCreateNumber("0085", false);
        this.compareIsCreatableWithCreateNumber("085", false);
        this.compareIsCreatableWithCreateNumber("08", false);
        this.compareIsCreatableWithCreateNumber("07", true);
        this.compareIsCreatableWithCreateNumber("00", true);
    }

    @Test
    public void testLANG972() {
        this.compareIsCreatableWithCreateNumber("0xABCD", true);
        this.compareIsCreatableWithCreateNumber("0XABCD", true);
    }

    @Test
    public void testLANG992() {
        this.compareIsCreatableWithCreateNumber("0.0", true);
        this.compareIsCreatableWithCreateNumber("0.4790", true);
    }

    @Test
    public void testMaxByte() {
        Assertions.assertEquals((byte)5, (byte)NumberUtils.max((byte[])new byte[]{5}), (String)"max(byte[]) failed for array length 1");
        Assertions.assertEquals((byte)9, (byte)NumberUtils.max((byte[])new byte[]{6, 9}), (String)"max(byte[]) failed for array length 2");
        Assertions.assertEquals((byte)10, (byte)NumberUtils.max((byte[])new byte[]{-10, -5, 0, 5, 10}), (String)"max(byte[]) failed for array length 5");
        Assertions.assertEquals((byte)10, (byte)NumberUtils.max((byte[])new byte[]{-10, -5, 0, 5, 10}));
        Assertions.assertEquals((byte)10, (byte)NumberUtils.max((byte[])new byte[]{-5, 0, 10, 5, -10}));
    }

    @Test
    public void testMaxByte_emptyArray() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> NumberUtils.max((byte[])new byte[0]));
    }

    @Test
    public void testMaxByte_nullArray() {
        Assertions.assertThrows(NullPointerException.class, () -> NumberUtils.max((byte[])null));
    }

    @Test
    public void testMaxDouble() {
        double[] d = null;
        Assertions.assertThrows(NullPointerException.class, () -> NumberUtils.max((double[])d), (String)"No exception was thrown for null input.");
        Assertions.assertThrows(IllegalArgumentException.class, () -> NumberUtils.max((byte[])new byte[0]), (String)"No exception was thrown for empty input.");
        Assertions.assertEquals((float)5.1f, (float)NumberUtils.max((float[])new float[]{5.1f}), (String)"max(double[]) failed for array length 1");
        Assertions.assertEquals((float)9.2f, (float)NumberUtils.max((float[])new float[]{6.3f, 9.2f}), (String)"max(double[]) failed for array length 2");
        Assertions.assertEquals((float)10.4f, (float)NumberUtils.max((float[])new float[]{-10.5f, -5.6f, 0.0f, 5.7f, 10.4f}), (String)"max(double[]) failed for float length 5");
        Assertions.assertEquals((double)10.0, (double)NumberUtils.max((int[])new int[]{-10, -5, 0, 5, 10}), (double)1.0E-4);
        Assertions.assertEquals((double)10.0, (double)NumberUtils.max((int[])new int[]{-5, 0, 10, 5, -10}), (double)1.0E-4);
    }

    @Test
    public void testMaxDouble_emptyArray() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> NumberUtils.max((byte[])new byte[0]));
    }

    @Test
    public void testMaxDouble_nullArray() {
        Assertions.assertThrows(NullPointerException.class, () -> NumberUtils.max((double[])null));
    }

    @Test
    public void testMaxFloat() {
        Assertions.assertEquals((float)5.1f, (float)NumberUtils.max((float[])new float[]{5.1f}), (String)"max(float[]) failed for array length 1");
        Assertions.assertEquals((float)9.2f, (float)NumberUtils.max((float[])new float[]{6.3f, 9.2f}), (String)"max(float[]) failed for array length 2");
        Assertions.assertEquals((float)10.4f, (float)NumberUtils.max((float[])new float[]{-10.5f, -5.6f, 0.0f, 5.7f, 10.4f}), (String)"max(float[]) failed for float length 5");
        Assertions.assertEquals((float)10.0f, (float)NumberUtils.max((int[])new int[]{-10, -5, 0, 5, 10}), (float)1.0E-4f);
        Assertions.assertEquals((float)10.0f, (float)NumberUtils.max((int[])new int[]{-5, 0, 10, 5, -10}), (float)1.0E-4f);
    }

    @Test
    public void testMaxFloat_emptyArray() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> NumberUtils.max((byte[])new byte[0]));
    }

    @Test
    public void testMaxFloat_nullArray() {
        Assertions.assertThrows(NullPointerException.class, () -> NumberUtils.max((float[])null));
    }

    @Test
    public void testMaximumByte() {
        int low = 123;
        int mid = 124;
        int high = 125;
        Assertions.assertEquals((byte)125, (byte)NumberUtils.max((byte)123, (byte)124, (byte)125), (String)"maximum(byte, byte, byte) 1 failed");
        Assertions.assertEquals((byte)125, (byte)NumberUtils.max((byte)124, (byte)123, (byte)125), (String)"maximum(byte, byte, byte) 2 failed");
        Assertions.assertEquals((byte)125, (byte)NumberUtils.max((byte)124, (byte)125, (byte)123), (String)"maximum(byte, byte, byte) 3 failed");
        Assertions.assertEquals((byte)125, (byte)NumberUtils.max((byte)125, (byte)124, (byte)125), (String)"maximum(byte, byte, byte) 4 failed");
    }

    @Test
    public void testMaximumDouble() {
        double low = 12.3;
        double mid = 13.3;
        double high = 14.3;
        Assertions.assertEquals((double)14.3, (double)NumberUtils.max((double)12.3, (double)13.3, (double)14.3), (double)1.0E-4);
        Assertions.assertEquals((double)14.3, (double)NumberUtils.max((double)13.3, (double)12.3, (double)14.3), (double)1.0E-4);
        Assertions.assertEquals((double)14.3, (double)NumberUtils.max((double)13.3, (double)14.3, (double)12.3), (double)1.0E-4);
        Assertions.assertEquals((double)13.3, (double)NumberUtils.max((double)12.3, (double)13.3, (double)12.3), (double)1.0E-4);
        Assertions.assertEquals((double)14.3, (double)NumberUtils.max((double)14.3, (double)13.3, (double)14.3), (double)1.0E-4);
    }

    @Test
    public void testMaximumFloat() {
        float low = 12.3f;
        float mid = 13.3f;
        float high = 14.3f;
        Assertions.assertEquals((float)14.3f, (float)NumberUtils.max((float)12.3f, (float)13.3f, (float)14.3f), (float)1.0E-4f);
        Assertions.assertEquals((float)14.3f, (float)NumberUtils.max((float)13.3f, (float)12.3f, (float)14.3f), (float)1.0E-4f);
        Assertions.assertEquals((float)14.3f, (float)NumberUtils.max((float)13.3f, (float)14.3f, (float)12.3f), (float)1.0E-4f);
        Assertions.assertEquals((float)13.3f, (float)NumberUtils.max((float)12.3f, (float)13.3f, (float)12.3f), (float)1.0E-4f);
        Assertions.assertEquals((float)14.3f, (float)NumberUtils.max((float)14.3f, (float)13.3f, (float)14.3f), (float)1.0E-4f);
    }

    @Test
    public void testMaximumInt() {
        Assertions.assertEquals((int)12345, (int)NumberUtils.max((int)12345, (int)12344, (int)12343), (String)"maximum(int, int, int) 1 failed");
        Assertions.assertEquals((int)12345, (int)NumberUtils.max((int)12344, (int)12345, (int)12343), (String)"maximum(int, int, int) 2 failed");
        Assertions.assertEquals((int)12345, (int)NumberUtils.max((int)12344, (int)12343, (int)12345), (String)"maximum(int, int, int) 3 failed");
        Assertions.assertEquals((int)12345, (int)NumberUtils.max((int)12344, (int)12345, (int)12345), (String)"maximum(int, int, int) 4 failed");
        Assertions.assertEquals((int)12345, (int)NumberUtils.max((int)12345, (int)12345, (int)12345), (String)"maximum(int, int, int) 5 failed");
    }

    @Test
    public void testMaximumLong() {
        Assertions.assertEquals((long)12345L, (long)NumberUtils.max((long)12345L, (long)12344L, (long)12343L), (String)"maximum(long, long, long) 1 failed");
        Assertions.assertEquals((long)12345L, (long)NumberUtils.max((long)12344L, (long)12345L, (long)12343L), (String)"maximum(long, long, long) 2 failed");
        Assertions.assertEquals((long)12345L, (long)NumberUtils.max((long)12344L, (long)12343L, (long)12345L), (String)"maximum(long, long, long) 3 failed");
        Assertions.assertEquals((long)12345L, (long)NumberUtils.max((long)12344L, (long)12345L, (long)12345L), (String)"maximum(long, long, long) 4 failed");
        Assertions.assertEquals((long)12345L, (long)NumberUtils.max((long)12345L, (long)12345L, (long)12345L), (String)"maximum(long, long, long) 5 failed");
    }

    @Test
    public void testMaximumShort() {
        int low = 1234;
        int mid = 1235;
        int high = 1236;
        Assertions.assertEquals((short)1236, (short)NumberUtils.max((short)1234, (short)1235, (short)1236), (String)"maximum(short, short, short) 1 failed");
        Assertions.assertEquals((short)1236, (short)NumberUtils.max((short)1235, (short)1234, (short)1236), (String)"maximum(short, short, short) 2 failed");
        Assertions.assertEquals((short)1236, (short)NumberUtils.max((short)1235, (short)1236, (short)1234), (String)"maximum(short, short, short) 3 failed");
        Assertions.assertEquals((short)1236, (short)NumberUtils.max((short)1236, (short)1235, (short)1236), (String)"maximum(short, short, short) 4 failed");
    }

    @Test
    public void testMaxInt() {
        Assertions.assertEquals((int)5, (int)NumberUtils.max((int[])new int[]{5}), (String)"max(int[]) failed for array length 1");
        Assertions.assertEquals((int)9, (int)NumberUtils.max((int[])new int[]{6, 9}), (String)"max(int[]) failed for array length 2");
        Assertions.assertEquals((int)10, (int)NumberUtils.max((int[])new int[]{-10, -5, 0, 5, 10}), (String)"max(int[]) failed for array length 5");
        Assertions.assertEquals((int)10, (int)NumberUtils.max((int[])new int[]{-10, -5, 0, 5, 10}));
        Assertions.assertEquals((int)10, (int)NumberUtils.max((int[])new int[]{-5, 0, 10, 5, -10}));
    }

    @Test
    public void testMaxInt_emptyArray() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> NumberUtils.max((byte[])new byte[0]));
    }

    @Test
    public void testMaxInt_nullArray() {
        Assertions.assertThrows(NullPointerException.class, () -> NumberUtils.max((int[])null));
    }

    @Test
    public void testMaxLong() {
        Assertions.assertEquals((long)5L, (long)NumberUtils.max((long[])new long[]{5L}), (String)"max(long[]) failed for array length 1");
        Assertions.assertEquals((long)9L, (long)NumberUtils.max((long[])new long[]{6L, 9L}), (String)"max(long[]) failed for array length 2");
        Assertions.assertEquals((long)10L, (long)NumberUtils.max((long[])new long[]{-10L, -5L, 0L, 5L, 10L}), (String)"max(long[]) failed for array length 5");
        Assertions.assertEquals((long)10L, (long)NumberUtils.max((long[])new long[]{-10L, -5L, 0L, 5L, 10L}));
        Assertions.assertEquals((long)10L, (long)NumberUtils.max((long[])new long[]{-5L, 0L, 10L, 5L, -10L}));
    }

    @Test
    public void testMaxLong_emptyArray() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> NumberUtils.max((byte[])new byte[0]));
    }

    @Test
    public void testMaxLong_nullArray() {
        Assertions.assertThrows(NullPointerException.class, () -> NumberUtils.max((long[])null));
    }

    @Test
    public void testMaxShort() {
        Assertions.assertEquals((short)5, (short)NumberUtils.max((short[])new short[]{5}), (String)"max(short[]) failed for array length 1");
        Assertions.assertEquals((short)9, (short)NumberUtils.max((short[])new short[]{6, 9}), (String)"max(short[]) failed for array length 2");
        Assertions.assertEquals((short)10, (short)NumberUtils.max((short[])new short[]{-10, -5, 0, 5, 10}), (String)"max(short[]) failed for array length 5");
        Assertions.assertEquals((short)10, (short)NumberUtils.max((short[])new short[]{-10, -5, 0, 5, 10}));
        Assertions.assertEquals((short)10, (short)NumberUtils.max((short[])new short[]{-5, 0, 10, 5, -10}));
    }

    @Test
    public void testMaxShort_emptyArray() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> NumberUtils.max((byte[])new byte[0]));
    }

    @Test
    public void testMaxShort_nullArray() {
        Assertions.assertThrows(NullPointerException.class, () -> NumberUtils.max((short[])null));
    }

    @Test
    public void testMinByte() {
        Assertions.assertEquals((byte)5, (byte)NumberUtils.min((byte[])new byte[]{5}), (String)"min(byte[]) failed for array length 1");
        Assertions.assertEquals((byte)6, (byte)NumberUtils.min((byte[])new byte[]{6, 9}), (String)"min(byte[]) failed for array length 2");
        Assertions.assertEquals((byte)-10, (byte)NumberUtils.min((byte[])new byte[]{-10, -5, 0, 5, 10}));
        Assertions.assertEquals((byte)-10, (byte)NumberUtils.min((byte[])new byte[]{-5, 0, -10, 5, 10}));
    }

    @Test
    public void testMinByte_emptyArray() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> NumberUtils.min((byte[])new byte[0]));
    }

    @Test
    public void testMinByte_nullArray() {
        Assertions.assertThrows(NullPointerException.class, () -> NumberUtils.min((byte[])null));
    }

    @Test
    public void testMinDouble() {
        Assertions.assertEquals((double)5.12, (double)NumberUtils.min((double[])new double[]{5.12}), (String)"min(double[]) failed for array length 1");
        Assertions.assertEquals((double)6.23, (double)NumberUtils.min((double[])new double[]{6.23, 9.34}), (String)"min(double[]) failed for array length 2");
        Assertions.assertEquals((double)-10.45, (double)NumberUtils.min((double[])new double[]{-10.45, -5.56, 0.0, 5.67, 10.78}), (String)"min(double[]) failed for array length 5");
        Assertions.assertEquals((double)-10.0, (double)NumberUtils.min((int[])new int[]{-10, -5, 0, 5, 10}), (double)1.0E-4);
        Assertions.assertEquals((double)-10.0, (double)NumberUtils.min((int[])new int[]{-5, 0, -10, 5, 10}), (double)1.0E-4);
    }

    @Test
    public void testMinDouble_emptyArray() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> NumberUtils.min((byte[])new byte[0]));
    }

    @Test
    public void testMinDouble_nullArray() {
        Assertions.assertThrows(NullPointerException.class, () -> NumberUtils.min((double[])null));
    }

    @Test
    public void testMinFloat() {
        Assertions.assertEquals((float)5.9f, (float)NumberUtils.min((float[])new float[]{5.9f}), (String)"min(float[]) failed for array length 1");
        Assertions.assertEquals((float)6.8f, (float)NumberUtils.min((float[])new float[]{6.8f, 9.7f}), (String)"min(float[]) failed for array length 2");
        Assertions.assertEquals((float)-10.6f, (float)NumberUtils.min((float[])new float[]{-10.6f, -5.5f, 0.0f, 5.4f, 10.3f}), (String)"min(float[]) failed for array length 5");
        Assertions.assertEquals((float)-10.0f, (float)NumberUtils.min((int[])new int[]{-10, -5, 0, 5, 10}), (float)1.0E-4f);
        Assertions.assertEquals((float)-10.0f, (float)NumberUtils.min((int[])new int[]{-5, 0, -10, 5, 10}), (float)1.0E-4f);
    }

    @Test
    public void testMinFloat_emptyArray() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> NumberUtils.min((byte[])new byte[0]));
    }

    @Test
    public void testMinFloat_nullArray() {
        Assertions.assertThrows(NullPointerException.class, () -> NumberUtils.min((float[])null));
    }

    @Test
    public void testMinimumByte() {
        int low = 123;
        int mid = 124;
        int high = 125;
        Assertions.assertEquals((byte)123, (byte)NumberUtils.min((byte)123, (byte)124, (byte)125), (String)"minimum(byte, byte, byte) 1 failed");
        Assertions.assertEquals((byte)123, (byte)NumberUtils.min((byte)124, (byte)123, (byte)125), (String)"minimum(byte, byte, byte) 2 failed");
        Assertions.assertEquals((byte)123, (byte)NumberUtils.min((byte)124, (byte)125, (byte)123), (String)"minimum(byte, byte, byte) 3 failed");
        Assertions.assertEquals((byte)123, (byte)NumberUtils.min((byte)123, (byte)124, (byte)123), (String)"minimum(byte, byte, byte) 4 failed");
    }

    @Test
    public void testMinimumDouble() {
        double low = 12.3;
        double mid = 13.3;
        double high = 14.3;
        Assertions.assertEquals((double)12.3, (double)NumberUtils.min((double)12.3, (double)13.3, (double)14.3), (double)1.0E-4);
        Assertions.assertEquals((double)12.3, (double)NumberUtils.min((double)13.3, (double)12.3, (double)14.3), (double)1.0E-4);
        Assertions.assertEquals((double)12.3, (double)NumberUtils.min((double)13.3, (double)14.3, (double)12.3), (double)1.0E-4);
        Assertions.assertEquals((double)12.3, (double)NumberUtils.min((double)12.3, (double)13.3, (double)12.3), (double)1.0E-4);
        Assertions.assertEquals((double)13.3, (double)NumberUtils.min((double)14.3, (double)13.3, (double)14.3), (double)1.0E-4);
    }

    @Test
    public void testMinimumFloat() {
        float low = 12.3f;
        float mid = 13.3f;
        float high = 14.3f;
        Assertions.assertEquals((float)12.3f, (float)NumberUtils.min((float)12.3f, (float)13.3f, (float)14.3f), (float)1.0E-4f);
        Assertions.assertEquals((float)12.3f, (float)NumberUtils.min((float)13.3f, (float)12.3f, (float)14.3f), (float)1.0E-4f);
        Assertions.assertEquals((float)12.3f, (float)NumberUtils.min((float)13.3f, (float)14.3f, (float)12.3f), (float)1.0E-4f);
        Assertions.assertEquals((float)12.3f, (float)NumberUtils.min((float)12.3f, (float)13.3f, (float)12.3f), (float)1.0E-4f);
        Assertions.assertEquals((float)13.3f, (float)NumberUtils.min((float)14.3f, (float)13.3f, (float)14.3f), (float)1.0E-4f);
    }

    @Test
    public void testMinimumInt() {
        Assertions.assertEquals((int)12345, (int)NumberUtils.min((int)12345, (int)12346, (int)12347), (String)"minimum(int, int, int) 1 failed");
        Assertions.assertEquals((int)12345, (int)NumberUtils.min((int)12346, (int)12345, (int)12347), (String)"minimum(int, int, int) 2 failed");
        Assertions.assertEquals((int)12345, (int)NumberUtils.min((int)12346, (int)12347, (int)12345), (String)"minimum(int, int, int) 3 failed");
        Assertions.assertEquals((int)12345, (int)NumberUtils.min((int)12346, (int)12345, (int)12345), (String)"minimum(int, int, int) 4 failed");
        Assertions.assertEquals((int)12345, (int)NumberUtils.min((int)12345, (int)12345, (int)12345), (String)"minimum(int, int, int) 5 failed");
    }

    @Test
    public void testMinimumLong() {
        Assertions.assertEquals((long)12345L, (long)NumberUtils.min((long)12345L, (long)12346L, (long)12347L), (String)"minimum(long, long, long) 1 failed");
        Assertions.assertEquals((long)12345L, (long)NumberUtils.min((long)12346L, (long)12345L, (long)12347L), (String)"minimum(long, long, long) 2 failed");
        Assertions.assertEquals((long)12345L, (long)NumberUtils.min((long)12346L, (long)12347L, (long)12345L), (String)"minimum(long, long, long) 3 failed");
        Assertions.assertEquals((long)12345L, (long)NumberUtils.min((long)12346L, (long)12345L, (long)12345L), (String)"minimum(long, long, long) 4 failed");
        Assertions.assertEquals((long)12345L, (long)NumberUtils.min((long)12345L, (long)12345L, (long)12345L), (String)"minimum(long, long, long) 5 failed");
    }

    @Test
    public void testMinimumShort() {
        int low = 1234;
        int mid = 1235;
        int high = 1236;
        Assertions.assertEquals((short)1234, (short)NumberUtils.min((short)1234, (short)1235, (short)1236), (String)"minimum(short, short, short) 1 failed");
        Assertions.assertEquals((short)1234, (short)NumberUtils.min((short)1235, (short)1234, (short)1236), (String)"minimum(short, short, short) 2 failed");
        Assertions.assertEquals((short)1234, (short)NumberUtils.min((short)1235, (short)1236, (short)1234), (String)"minimum(short, short, short) 3 failed");
        Assertions.assertEquals((short)1234, (short)NumberUtils.min((short)1234, (short)1235, (short)1234), (String)"minimum(short, short, short) 4 failed");
    }

    @Test
    public void testMinInt() {
        Assertions.assertEquals((int)5, (int)NumberUtils.min((int[])new int[]{5}), (String)"min(int[]) failed for array length 1");
        Assertions.assertEquals((int)6, (int)NumberUtils.min((int[])new int[]{6, 9}), (String)"min(int[]) failed for array length 2");
        Assertions.assertEquals((int)-10, (int)NumberUtils.min((int[])new int[]{-10, -5, 0, 5, 10}));
        Assertions.assertEquals((int)-10, (int)NumberUtils.min((int[])new int[]{-5, 0, -10, 5, 10}));
    }

    @Test
    public void testMinInt_emptyArray() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> NumberUtils.min((byte[])new byte[0]));
    }

    @Test
    public void testMinInt_nullArray() {
        Assertions.assertThrows(NullPointerException.class, () -> NumberUtils.min((int[])null));
    }

    @Test
    public void testMinLong() {
        Assertions.assertEquals((long)5L, (long)NumberUtils.min((long[])new long[]{5L}), (String)"min(long[]) failed for array length 1");
        Assertions.assertEquals((long)6L, (long)NumberUtils.min((long[])new long[]{6L, 9L}), (String)"min(long[]) failed for array length 2");
        Assertions.assertEquals((long)-10L, (long)NumberUtils.min((long[])new long[]{-10L, -5L, 0L, 5L, 10L}));
        Assertions.assertEquals((long)-10L, (long)NumberUtils.min((long[])new long[]{-5L, 0L, -10L, 5L, 10L}));
    }

    @Test
    public void testMinLong_emptyArray() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> NumberUtils.min((byte[])new byte[0]));
    }

    @Test
    public void testMinLong_nullArray() {
        Assertions.assertThrows(NullPointerException.class, () -> NumberUtils.min((long[])null));
    }

    @Test
    public void testMinShort() {
        Assertions.assertEquals((short)5, (short)NumberUtils.min((short[])new short[]{5}), (String)"min(short[]) failed for array length 1");
        Assertions.assertEquals((short)6, (short)NumberUtils.min((short[])new short[]{6, 9}), (String)"min(short[]) failed for array length 2");
        Assertions.assertEquals((short)-10, (short)NumberUtils.min((short[])new short[]{-10, -5, 0, 5, 10}));
        Assertions.assertEquals((short)-10, (short)NumberUtils.min((short[])new short[]{-5, 0, -10, 5, 10}));
    }

    @Test
    public void testMinShort_emptyArray() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> NumberUtils.min((byte[])new byte[0]));
    }

    @Test
    public void testMinShort_nullArray() {
        Assertions.assertThrows(NullPointerException.class, () -> NumberUtils.min((short[])null));
    }

    @Test
    public void testStringCreateNumberEnsureNoPrecisionLoss() {
        String shouldBeFloat = "1.23";
        String shouldBeDouble = "3.40282354e+38";
        String shouldBeBigDecimal = "1.797693134862315759e+308";
        Assertions.assertTrue((boolean)(NumberUtils.createNumber((String)"1.23") instanceof Float));
        Assertions.assertTrue((boolean)(NumberUtils.createNumber((String)"3.40282354e+38") instanceof Double));
        Assertions.assertTrue((boolean)(NumberUtils.createNumber((String)"1.797693134862315759e+308") instanceof BigDecimal));
        Assertions.assertTrue((boolean)(NumberUtils.createNumber((String)"001.12") instanceof Float));
        Assertions.assertTrue((boolean)(NumberUtils.createNumber((String)"-001.12") instanceof Float));
        Assertions.assertTrue((boolean)(NumberUtils.createNumber((String)"+001.12") instanceof Float));
        Assertions.assertTrue((boolean)(NumberUtils.createNumber((String)"003.40282354e+38") instanceof Double));
        Assertions.assertTrue((boolean)(NumberUtils.createNumber((String)"-003.40282354e+38") instanceof Double));
        Assertions.assertTrue((boolean)(NumberUtils.createNumber((String)"+003.40282354e+38") instanceof Double));
        Assertions.assertTrue((boolean)(NumberUtils.createNumber((String)"0001.797693134862315759e+308") instanceof BigDecimal));
        Assertions.assertTrue((boolean)(NumberUtils.createNumber((String)"-001.797693134862315759e+308") instanceof BigDecimal));
        Assertions.assertTrue((boolean)(NumberUtils.createNumber((String)"+001.797693134862315759e+308") instanceof BigDecimal));
        Assertions.assertTrue((boolean)(NumberUtils.createNumber((String)Double.toString(Double.MIN_NORMAL)) instanceof Double));
        Assertions.assertTrue((boolean)(NumberUtils.createNumber((String)(Double.toString(Double.MIN_NORMAL) + "D")) instanceof Double));
        Assertions.assertTrue((boolean)(NumberUtils.createNumber((String)(Double.toString(Double.MIN_NORMAL) + "F")) instanceof Double));
        Assertions.assertTrue((boolean)(NumberUtils.createNumber((String)Double.toString(Double.MIN_VALUE)) instanceof Double));
        Assertions.assertTrue((boolean)(NumberUtils.createNumber((String)(Double.toString(Double.MIN_VALUE) + "D")) instanceof Double));
        Assertions.assertTrue((boolean)(NumberUtils.createNumber((String)(Double.toString(Double.MIN_VALUE) + "F")) instanceof Double));
        Assertions.assertTrue((boolean)(NumberUtils.createNumber((String)Double.toString(Double.MAX_VALUE)) instanceof Double));
        Assertions.assertTrue((boolean)(NumberUtils.createNumber((String)(Double.toString(Double.MAX_VALUE) + "D")) instanceof Double));
        Assertions.assertTrue((boolean)(NumberUtils.createNumber((String)(Double.toString(Double.MAX_VALUE) + "F")) instanceof Double));
        Assertions.assertTrue((boolean)(NumberUtils.createNumber((String)"4.9e-324D") instanceof Double));
        Assertions.assertTrue((boolean)(NumberUtils.createNumber((String)"4.9e-324F") instanceof Double));
    }

    @Test
    public void testStringToDoubleString() {
        Assertions.assertEquals((double)NumberUtils.toDouble((String)"-1.2345"), (double)-1.2345, (String)"toDouble(String) 1 failed");
        Assertions.assertEquals((double)1.2345, (double)NumberUtils.toDouble((String)"1.2345"), (String)"toDouble(String) 2 failed");
        Assertions.assertEquals((double)0.0, (double)NumberUtils.toDouble((String)"abc"), (String)"toDouble(String) 3 failed");
        Assertions.assertEquals((double)NumberUtils.toDouble((String)"-001.2345"), (double)-1.2345, (String)"toDouble(String) 4 failed");
        Assertions.assertEquals((double)1.2345, (double)NumberUtils.toDouble((String)"+001.2345"), (String)"toDouble(String) 5 failed");
        Assertions.assertEquals((double)1.2345, (double)NumberUtils.toDouble((String)"001.2345"), (String)"toDouble(String) 6 failed");
        Assertions.assertEquals((double)0.0, (double)NumberUtils.toDouble((String)"000.00000"), (String)"toDouble(String) 7 failed");
        Assertions.assertEquals((double)NumberUtils.toDouble((String)"1.7976931348623157E308"), (double)Double.MAX_VALUE, (String)"toDouble(Double.MAX_VALUE) failed");
        Assertions.assertEquals((double)NumberUtils.toDouble((String)"4.9E-324"), (double)Double.MIN_VALUE, (String)"toDouble(Double.MIN_VALUE) failed");
        Assertions.assertEquals((double)0.0, (double)NumberUtils.toDouble((String)""), (String)"toDouble(empty) failed");
        Assertions.assertEquals((double)0.0, (double)NumberUtils.toDouble((String)null), (String)"toDouble(null) failed");
    }

    @Test
    public void testStringToDoubleStringD() {
        Assertions.assertEquals((double)1.2345, (double)NumberUtils.toDouble((String)"1.2345", (double)5.1), (String)"toDouble(String, int) 1 failed");
        Assertions.assertEquals((double)5.0, (double)NumberUtils.toDouble((String)"a", (double)5.0), (String)"toDouble(String, int) 2 failed");
        Assertions.assertEquals((double)1.2345, (double)NumberUtils.toDouble((String)"001.2345", (double)5.1), (String)"toDouble(String, int) 3 failed");
        Assertions.assertEquals((double)NumberUtils.toDouble((String)"-001.2345", (double)5.1), (double)-1.2345, (String)"toDouble(String, int) 4 failed");
        Assertions.assertEquals((double)1.2345, (double)NumberUtils.toDouble((String)"+001.2345", (double)5.1), (String)"toDouble(String, int) 5 failed");
        Assertions.assertEquals((double)0.0, (double)NumberUtils.toDouble((String)"000.00", (double)5.1), (String)"toDouble(String, int) 7 failed");
    }

    @Test
    public void testToByteString() {
        Assertions.assertEquals((int)123, (int)NumberUtils.toByte((String)"123"), (String)"toByte(String) 1 failed");
        Assertions.assertEquals((int)0, (int)NumberUtils.toByte((String)"abc"), (String)"toByte(String) 2 failed");
        Assertions.assertEquals((int)0, (int)NumberUtils.toByte((String)""), (String)"toByte(empty) failed");
        Assertions.assertEquals((int)0, (int)NumberUtils.toByte(null), (String)"toByte(null) failed");
    }

    @Test
    public void testToByteStringI() {
        Assertions.assertEquals((int)123, (int)NumberUtils.toByte((String)"123", (byte)5), (String)"toByte(String, byte) 1 failed");
        Assertions.assertEquals((int)5, (int)NumberUtils.toByte((String)"12.3", (byte)5), (String)"toByte(String, byte) 2 failed");
    }

    @Test
    public void testToFloatString() {
        Assertions.assertEquals((float)NumberUtils.toFloat((String)"-1.2345"), (float)-1.2345f, (String)"toFloat(String) 1 failed");
        Assertions.assertEquals((float)1.2345f, (float)NumberUtils.toFloat((String)"1.2345"), (String)"toFloat(String) 2 failed");
        Assertions.assertEquals((float)0.0f, (float)NumberUtils.toFloat((String)"abc"), (String)"toFloat(String) 3 failed");
        Assertions.assertEquals((float)NumberUtils.toFloat((String)"-001.2345"), (float)-1.2345f, (String)"toFloat(String) 4 failed");
        Assertions.assertEquals((float)1.2345f, (float)NumberUtils.toFloat((String)"+001.2345"), (String)"toFloat(String) 5 failed");
        Assertions.assertEquals((float)1.2345f, (float)NumberUtils.toFloat((String)"001.2345"), (String)"toFloat(String) 6 failed");
        Assertions.assertEquals((float)0.0f, (float)NumberUtils.toFloat((String)"000.00"), (String)"toFloat(String) 7 failed");
        Assertions.assertEquals((float)NumberUtils.toFloat((String)"3.4028235E38"), (float)Float.MAX_VALUE, (String)"toFloat(Float.MAX_VALUE) failed");
        Assertions.assertEquals((float)NumberUtils.toFloat((String)"1.4E-45"), (float)Float.MIN_VALUE, (String)"toFloat(Float.MIN_VALUE) failed");
        Assertions.assertEquals((float)0.0f, (float)NumberUtils.toFloat((String)""), (String)"toFloat(empty) failed");
        Assertions.assertEquals((float)0.0f, (float)NumberUtils.toFloat(null), (String)"toFloat(null) failed");
    }

    @Test
    public void testToFloatStringF() {
        Assertions.assertEquals((float)1.2345f, (float)NumberUtils.toFloat((String)"1.2345", (float)5.1f), (String)"toFloat(String, int) 1 failed");
        Assertions.assertEquals((float)5.0f, (float)NumberUtils.toFloat((String)"a", (float)5.0f), (String)"toFloat(String, int) 2 failed");
        Assertions.assertEquals((float)5.0f, (float)NumberUtils.toFloat((String)"-001Z.2345", (float)5.0f), (String)"toFloat(String, int) 3 failed");
        Assertions.assertEquals((float)5.0f, (float)NumberUtils.toFloat((String)"+001AB.2345", (float)5.0f), (String)"toFloat(String, int) 4 failed");
        Assertions.assertEquals((float)5.0f, (float)NumberUtils.toFloat((String)"001Z.2345", (float)5.0f), (String)"toFloat(String, int) 5 failed");
    }

    @Test
    public void testToIntString() {
        Assertions.assertEquals((int)12345, (int)NumberUtils.toInt((String)"12345"), (String)"toInt(String) 1 failed");
        Assertions.assertEquals((int)0, (int)NumberUtils.toInt((String)"abc"), (String)"toInt(String) 2 failed");
        Assertions.assertEquals((int)0, (int)NumberUtils.toInt((String)""), (String)"toInt(empty) failed");
        Assertions.assertEquals((int)0, (int)NumberUtils.toInt(null), (String)"toInt(null) failed");
    }

    @Test
    public void testToIntStringI() {
        Assertions.assertEquals((int)12345, (int)NumberUtils.toInt((String)"12345", (int)5), (String)"toInt(String, int) 1 failed");
        Assertions.assertEquals((int)5, (int)NumberUtils.toInt((String)"1234.5", (int)5), (String)"toInt(String, int) 2 failed");
    }

    @Test
    public void testToLongString() {
        Assertions.assertEquals((long)12345L, (long)NumberUtils.toLong((String)"12345"), (String)"toLong(String) 1 failed");
        Assertions.assertEquals((long)0L, (long)NumberUtils.toLong((String)"abc"), (String)"toLong(String) 2 failed");
        Assertions.assertEquals((long)0L, (long)NumberUtils.toLong((String)"1L"), (String)"toLong(String) 3 failed");
        Assertions.assertEquals((long)0L, (long)NumberUtils.toLong((String)"1l"), (String)"toLong(String) 4 failed");
        Assertions.assertEquals((long)NumberUtils.toLong((String)"9223372036854775807"), (long)Long.MAX_VALUE, (String)"toLong(Long.MAX_VALUE) failed");
        Assertions.assertEquals((long)NumberUtils.toLong((String)"-9223372036854775808"), (long)Long.MIN_VALUE, (String)"toLong(Long.MIN_VALUE) failed");
        Assertions.assertEquals((long)0L, (long)NumberUtils.toLong((String)""), (String)"toLong(empty) failed");
        Assertions.assertEquals((long)0L, (long)NumberUtils.toLong(null), (String)"toLong(null) failed");
    }

    @Test
    public void testToLongStringL() {
        Assertions.assertEquals((long)12345L, (long)NumberUtils.toLong((String)"12345", (long)5L), (String)"toLong(String, long) 1 failed");
        Assertions.assertEquals((long)5L, (long)NumberUtils.toLong((String)"1234.5", (long)5L), (String)"toLong(String, long) 2 failed");
    }

    @Test
    public void testToScaledBigDecimalBigDecimal() {
        Assertions.assertEquals((Object)NumberUtils.toScaledBigDecimal((BigDecimal)BigDecimal.valueOf(123.456)), (Object)BigDecimal.valueOf(123.46), (String)"toScaledBigDecimal(BigDecimal) 1 failed");
        Assertions.assertEquals((Object)NumberUtils.toScaledBigDecimal((BigDecimal)BigDecimal.valueOf(23.515)), (Object)BigDecimal.valueOf(23.52), (String)"toScaledBigDecimal(BigDecimal) 2 failed");
        Assertions.assertEquals((Object)NumberUtils.toScaledBigDecimal((BigDecimal)BigDecimal.valueOf(23.525)), (Object)BigDecimal.valueOf(23.52), (String)"toScaledBigDecimal(BigDecimal) 3 failed");
        Assertions.assertEquals((Object)"2352.00", (Object)NumberUtils.toScaledBigDecimal((BigDecimal)BigDecimal.valueOf(23.525)).multiply(BigDecimal.valueOf(100L)).toString(), (String)"toScaledBigDecimal(BigDecimal) 4 failed");
        Assertions.assertEquals((Object)NumberUtils.toScaledBigDecimal((BigDecimal)null), (Object)BigDecimal.ZERO, (String)"toScaledBigDecimal(BigDecimal) 5 failed");
    }

    @Test
    public void testToScaledBigDecimalBigDecimalIRM() {
        Assertions.assertEquals((Object)NumberUtils.toScaledBigDecimal((BigDecimal)BigDecimal.valueOf(123.456), (int)1, (RoundingMode)RoundingMode.CEILING), (Object)BigDecimal.valueOf(123.5), (String)"toScaledBigDecimal(BigDecimal, int, RoudingMode) 1 failed");
        Assertions.assertEquals((Object)NumberUtils.toScaledBigDecimal((BigDecimal)BigDecimal.valueOf(23.5159), (int)3, (RoundingMode)RoundingMode.FLOOR), (Object)BigDecimal.valueOf(23.515), (String)"toScaledBigDecimal(BigDecimal, int, RoudingMode) 2 failed");
        Assertions.assertEquals((Object)NumberUtils.toScaledBigDecimal((BigDecimal)BigDecimal.valueOf(23.525), (int)2, (RoundingMode)RoundingMode.HALF_UP), (Object)BigDecimal.valueOf(23.53), (String)"toScaledBigDecimal(BigDecimal, int, RoudingMode) 3 failed");
        Assertions.assertEquals((Object)"23521.0000", (Object)NumberUtils.toScaledBigDecimal((BigDecimal)BigDecimal.valueOf(23.521), (int)4, (RoundingMode)RoundingMode.HALF_EVEN).multiply(BigDecimal.valueOf(1000L)).toString(), (String)"toScaledBigDecimal(BigDecimal, int, RoudingMode) 4 failed");
        Assertions.assertEquals((Object)NumberUtils.toScaledBigDecimal((BigDecimal)null, (int)2, (RoundingMode)RoundingMode.HALF_UP), (Object)BigDecimal.ZERO, (String)"toScaledBigDecimal(BigDecimal, int, RoudingMode) 5 failed");
    }

    @Test
    public void testToScaledBigDecimalDouble() {
        Assertions.assertEquals((Object)NumberUtils.toScaledBigDecimal((Double)123.456), (Object)BigDecimal.valueOf(123.46), (String)"toScaledBigDecimal(Double) 1 failed");
        Assertions.assertEquals((Object)NumberUtils.toScaledBigDecimal((Double)23.515), (Object)BigDecimal.valueOf(23.52), (String)"toScaledBigDecimal(Double) 2 failed");
        Assertions.assertEquals((Object)NumberUtils.toScaledBigDecimal((Double)23.525), (Object)BigDecimal.valueOf(23.52), (String)"toScaledBigDecimal(Double) 3 failed");
        Assertions.assertEquals((Object)"2352.00", (Object)NumberUtils.toScaledBigDecimal((Double)23.525).multiply(BigDecimal.valueOf(100L)).toString(), (String)"toScaledBigDecimal(Double) 4 failed");
        Assertions.assertEquals((Object)NumberUtils.toScaledBigDecimal((Double)null), (Object)BigDecimal.ZERO, (String)"toScaledBigDecimal(Double) 5 failed");
    }

    @Test
    public void testToScaledBigDecimalDoubleIRM() {
        Assertions.assertEquals((Object)NumberUtils.toScaledBigDecimal((Double)123.456, (int)1, (RoundingMode)RoundingMode.CEILING), (Object)BigDecimal.valueOf(123.5), (String)"toScaledBigDecimal(Double, int, RoudingMode) 1 failed");
        Assertions.assertEquals((Object)NumberUtils.toScaledBigDecimal((Double)23.5159, (int)3, (RoundingMode)RoundingMode.FLOOR), (Object)BigDecimal.valueOf(23.515), (String)"toScaledBigDecimal(Double, int, RoudingMode) 2 failed");
        Assertions.assertEquals((Object)NumberUtils.toScaledBigDecimal((Double)23.525, (int)2, (RoundingMode)RoundingMode.HALF_UP), (Object)BigDecimal.valueOf(23.53), (String)"toScaledBigDecimal(Double, int, RoudingMode) 3 failed");
        Assertions.assertEquals((Object)"23521.0000", (Object)NumberUtils.toScaledBigDecimal((Double)23.521, (int)4, (RoundingMode)RoundingMode.HALF_EVEN).multiply(BigDecimal.valueOf(1000L)).toString(), (String)"toScaledBigDecimal(Double, int, RoudingMode) 4 failed");
        Assertions.assertEquals((Object)NumberUtils.toScaledBigDecimal((Double)null, (int)2, (RoundingMode)RoundingMode.HALF_UP), (Object)BigDecimal.ZERO, (String)"toScaledBigDecimal(Double, int, RoudingMode) 5 failed");
    }

    @Test
    public void testToScaledBigDecimalFloat() {
        Assertions.assertEquals((Object)NumberUtils.toScaledBigDecimal((Float)Float.valueOf(123.456f)), (Object)BigDecimal.valueOf(123.46), (String)"toScaledBigDecimal(Float) 1 failed");
        Assertions.assertEquals((Object)NumberUtils.toScaledBigDecimal((Float)Float.valueOf(23.515f)), (Object)BigDecimal.valueOf(23.51), (String)"toScaledBigDecimal(Float) 2 failed");
        Assertions.assertEquals((Object)NumberUtils.toScaledBigDecimal((Float)Float.valueOf(23.525f)), (Object)BigDecimal.valueOf(23.52), (String)"toScaledBigDecimal(Float) 3 failed");
        Assertions.assertEquals((Object)"2352.00", (Object)NumberUtils.toScaledBigDecimal((Float)Float.valueOf(23.525f)).multiply(BigDecimal.valueOf(100L)).toString(), (String)"toScaledBigDecimal(Float) 4 failed");
        Assertions.assertEquals((Object)NumberUtils.toScaledBigDecimal((Float)null), (Object)BigDecimal.ZERO, (String)"toScaledBigDecimal(Float) 5 failed");
    }

    @Test
    public void testToScaledBigDecimalFloatIRM() {
        Assertions.assertEquals((Object)NumberUtils.toScaledBigDecimal((Float)Float.valueOf(123.456f), (int)1, (RoundingMode)RoundingMode.CEILING), (Object)BigDecimal.valueOf(123.5), (String)"toScaledBigDecimal(Float, int, RoudingMode) 1 failed");
        Assertions.assertEquals((Object)NumberUtils.toScaledBigDecimal((Float)Float.valueOf(23.5159f), (int)3, (RoundingMode)RoundingMode.FLOOR), (Object)BigDecimal.valueOf(23.515), (String)"toScaledBigDecimal(Float, int, RoudingMode) 2 failed");
        Assertions.assertEquals((Object)NumberUtils.toScaledBigDecimal((Float)Float.valueOf(23.525f), (int)2, (RoundingMode)RoundingMode.HALF_UP), (Object)BigDecimal.valueOf(23.52), (String)"toScaledBigDecimal(Float, int, RoudingMode) 3 failed");
        Assertions.assertEquals((Object)"23521.0000", (Object)NumberUtils.toScaledBigDecimal((Float)Float.valueOf(23.521f), (int)4, (RoundingMode)RoundingMode.HALF_EVEN).multiply(BigDecimal.valueOf(1000L)).toString(), (String)"toScaledBigDecimal(Float, int, RoudingMode) 4 failed");
        Assertions.assertEquals((Object)NumberUtils.toScaledBigDecimal((Float)null, (int)2, (RoundingMode)RoundingMode.HALF_UP), (Object)BigDecimal.ZERO, (String)"toScaledBigDecimal(Float, int, RoudingMode) 5 failed");
    }

    @Test
    public void testToScaledBigDecimalString() {
        Assertions.assertEquals((Object)NumberUtils.toScaledBigDecimal((String)"123.456"), (Object)BigDecimal.valueOf(123.46), (String)"toScaledBigDecimal(String) 1 failed");
        Assertions.assertEquals((Object)NumberUtils.toScaledBigDecimal((String)"23.515"), (Object)BigDecimal.valueOf(23.52), (String)"toScaledBigDecimal(String) 2 failed");
        Assertions.assertEquals((Object)NumberUtils.toScaledBigDecimal((String)"23.525"), (Object)BigDecimal.valueOf(23.52), (String)"toScaledBigDecimal(String) 3 failed");
        Assertions.assertEquals((Object)"2352.00", (Object)NumberUtils.toScaledBigDecimal((String)"23.525").multiply(BigDecimal.valueOf(100L)).toString(), (String)"toScaledBigDecimal(String) 4 failed");
        Assertions.assertEquals((Object)NumberUtils.toScaledBigDecimal((String)null), (Object)BigDecimal.ZERO, (String)"toScaledBigDecimal(String) 5 failed");
    }

    @Test
    public void testToScaledBigDecimalStringIRM() {
        Assertions.assertEquals((Object)NumberUtils.toScaledBigDecimal((String)"123.456", (int)1, (RoundingMode)RoundingMode.CEILING), (Object)BigDecimal.valueOf(123.5), (String)"toScaledBigDecimal(String, int, RoudingMode) 1 failed");
        Assertions.assertEquals((Object)NumberUtils.toScaledBigDecimal((String)"23.5159", (int)3, (RoundingMode)RoundingMode.FLOOR), (Object)BigDecimal.valueOf(23.515), (String)"toScaledBigDecimal(String, int, RoudingMode) 2 failed");
        Assertions.assertEquals((Object)NumberUtils.toScaledBigDecimal((String)"23.525", (int)2, (RoundingMode)RoundingMode.HALF_UP), (Object)BigDecimal.valueOf(23.53), (String)"toScaledBigDecimal(String, int, RoudingMode) 3 failed");
        Assertions.assertEquals((Object)"23521.0000", (Object)NumberUtils.toScaledBigDecimal((String)"23.521", (int)4, (RoundingMode)RoundingMode.HALF_EVEN).multiply(BigDecimal.valueOf(1000L)).toString(), (String)"toScaledBigDecimal(String, int, RoudingMode) 4 failed");
        Assertions.assertEquals((Object)NumberUtils.toScaledBigDecimal((String)null, (int)2, (RoundingMode)RoundingMode.HALF_UP), (Object)BigDecimal.ZERO, (String)"toScaledBigDecimal(String, int, RoudingMode) 5 failed");
    }

    @Test
    public void testToShortString() {
        Assertions.assertEquals((int)12345, (int)NumberUtils.toShort((String)"12345"), (String)"toShort(String) 1 failed");
        Assertions.assertEquals((int)0, (int)NumberUtils.toShort((String)"abc"), (String)"toShort(String) 2 failed");
        Assertions.assertEquals((int)0, (int)NumberUtils.toShort((String)""), (String)"toShort(empty) failed");
        Assertions.assertEquals((int)0, (int)NumberUtils.toShort(null), (String)"toShort(null) failed");
    }

    @Test
    public void testToShortStringI() {
        Assertions.assertEquals((int)12345, (int)NumberUtils.toShort((String)"12345", (short)5), (String)"toShort(String, short) 1 failed");
        Assertions.assertEquals((int)5, (int)NumberUtils.toShort((String)"1234.5", (short)5), (String)"toShort(String, short) 2 failed");
    }
}

