/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang3.function.TriFunction;
import org.apache.commons.lang3.time.DateParser;
import org.apache.commons.lang3.time.FastDateParser;
import org.apache.commons.lang3.time.FastDateParserTest;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class Java15BugFastDateParserTest {
    private static final String DATE_PARSER_PARAMETERS = "org.apache.commons.lang3.time.FastDateParserTest#dateParserParameters()";

    @Test
    public void java15BuggyLocaleTest() throws ParseException {
        String buggyLocaleName = "ff_LR_#Adlm";
        Locale buggyLocale = null;
        for (Locale locale : Locale.getAvailableLocales()) {
            if (!"ff_LR_#Adlm".equals(locale.toString())) continue;
            buggyLocale = locale;
            break;
        }
        if (buggyLocale == null) {
            return;
        }
        this.testSingleLocale(buggyLocale);
    }

    @Test
    public void java15BuggyLocaleTestAll() throws ParseException {
        for (Locale locale : Locale.getAvailableLocales()) {
            this.testSingleLocale(locale);
        }
    }

    private void testLocales(TriFunction<String, TimeZone, Locale, DateParser> dbProvider, String format, boolean eraBC) throws Exception {
        Calendar cal = Calendar.getInstance(FastDateParserTest.GMT);
        cal.clear();
        cal.set(2003, 1, 10);
        if (eraBC) {
            cal.set(0, 0);
        }
        for (Locale locale : Locale.getAvailableLocales()) {
            if (eraBC && locale.equals(FastDateParser.JAPANESE_IMPERIAL)) continue;
            SimpleDateFormat sdf = new SimpleDateFormat(format, locale);
            DateParser fdf = (DateParser)dbProvider.apply((Object)format, (Object)TimeZone.getDefault(), (Object)locale);
            FastDateParserTest.checkParse(locale, cal, sdf, fdf);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.lang3.time.FastDateParserTest#dateParserParameters()"})
    public void testLocales_Long_AD(TriFunction<String, TimeZone, Locale, DateParser> dpProvider) throws Exception {
        this.testLocales(dpProvider, "GGGG/yyyy/MMMM/dddd/hhhh/mmmm/ss/aaaa/EEEE", false);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.lang3.time.FastDateParserTest#dateParserParameters()"})
    public void testLocales_Long_BC(TriFunction<String, TimeZone, Locale, DateParser> dpProvider) throws Exception {
        this.testLocales(dpProvider, "GGGG/yyyy/MMMM/dddd/hhhh/mmmm/ss/aaaa/EEEE", true);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.lang3.time.FastDateParserTest#dateParserParameters()"})
    public void testLocales_LongNoEra_AD(TriFunction<String, TimeZone, Locale, DateParser> dpProvider) throws Exception {
        this.testLocales(dpProvider, "yyyy/MMMM/dddd/hhhh/mmmm/ss/aaaa/EEEE", false);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.lang3.time.FastDateParserTest#dateParserParameters()"})
    public void testLocales_LongNoEra_BC(TriFunction<String, TimeZone, Locale, DateParser> dpProvider) throws Exception {
        this.testLocales(dpProvider, "yyyy/MMMM/dddd/hhhh/mmmm/ss/aaaa/EEEE", true);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.lang3.time.FastDateParserTest#dateParserParameters()"})
    public void testLocales_Short_AD(TriFunction<String, TimeZone, Locale, DateParser> dpProvider) throws Exception {
        this.testLocales(dpProvider, "G/y/M/d/h/a/m/s/E", false);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.lang3.time.FastDateParserTest#dateParserParameters()"})
    public void testLocales_Short_BC(TriFunction<String, TimeZone, Locale, DateParser> dpProvider) throws Exception {
        this.testLocales(dpProvider, "G/y/M/d/h/a/m/s/E", true);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.lang3.time.FastDateParserTest#dateParserParameters()"})
    public void testLocales_ShortNoEra_AD(TriFunction<String, TimeZone, Locale, DateParser> dpProvider) throws Exception {
        this.testLocales(dpProvider, "y/M/d/h/a/m/s/E", false);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.lang3.time.FastDateParserTest#dateParserParameters()"})
    public void testLocales_ShortNoEra_BC(TriFunction<String, TimeZone, Locale, DateParser> dpProvider) throws Exception {
        this.testLocales(dpProvider, "y/M/d/h/a/m/s/E", true);
    }

    private void testSingleLocale(Locale locale) throws ParseException {
        Calendar cal = Calendar.getInstance(FastDateParserTest.GMT);
        cal.clear();
        cal.set(2003, 1, 10);
        SimpleDateFormat sdf = new SimpleDateFormat("GGGG/yyyy/MMMM/dddd/hhhh/mmmm/ss/aaaa/EEEE", locale);
        String formattedDate = sdf.format(cal.getTime());
        sdf.parse(formattedDate);
        sdf.parse(formattedDate.toUpperCase(locale));
        sdf.parse(formattedDate.toLowerCase(locale));
    }
}

