/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.entity;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestEntityBuilder {
    @Test(expected=IllegalStateException.class)
    public void testBuildEmptyEntity() throws Exception {
        HttpEntity entity = EntityBuilder.create().build();
        Assert.assertNotNull((Object)entity);
        entity.getContent();
    }

    @Test
    public void testBuildTextEntity() throws Exception {
        HttpEntity entity = EntityBuilder.create().setText("stuff").build();
        Assert.assertNotNull((Object)entity);
        Assert.assertNotNull((Object)entity.getContent());
        Assert.assertNotNull((Object)entity.getContentType());
        Assert.assertEquals((Object)"text/plain; charset=ISO-8859-1", (Object)entity.getContentType().getValue());
    }

    @Test
    public void testBuildBinaryEntity() throws Exception {
        HttpEntity entity = EntityBuilder.create().setBinary(new byte[]{0, 1, 2}).build();
        Assert.assertNotNull((Object)entity);
        Assert.assertNotNull((Object)entity.getContent());
        Assert.assertNotNull((Object)entity.getContentType());
        Assert.assertEquals((Object)"application/octet-stream", (Object)entity.getContentType().getValue());
    }

    @Test
    public void testBuildStreamEntity() throws Exception {
        InputStream in = (InputStream)Mockito.mock(InputStream.class);
        HttpEntity entity = EntityBuilder.create().setStream(in).build();
        Assert.assertNotNull((Object)entity);
        Assert.assertNotNull((Object)entity.getContent());
        Assert.assertNotNull((Object)entity.getContentType());
        Assert.assertEquals((long)-1L, (long)entity.getContentLength());
        Assert.assertEquals((Object)"application/octet-stream", (Object)entity.getContentType().getValue());
    }

    @Test
    public void testBuildSerializableEntity() throws Exception {
        HttpEntity entity = EntityBuilder.create().setSerializable((Serializable)Boolean.TRUE).build();
        Assert.assertNotNull((Object)entity);
        Assert.assertNotNull((Object)entity.getContent());
        Assert.assertNotNull((Object)entity.getContentType());
        Assert.assertEquals((Object)"application/octet-stream", (Object)entity.getContentType().getValue());
    }

    @Test
    public void testBuildFileEntity() throws Exception {
        File file = new File("stuff");
        HttpEntity entity = EntityBuilder.create().setFile(file).build();
        Assert.assertNotNull((Object)entity);
        Assert.assertNotNull((Object)entity.getContentType());
        Assert.assertEquals((Object)"application/octet-stream", (Object)entity.getContentType().getValue());
    }

    @Test
    public void testExplicitContentProperties() throws Exception {
        HttpEntity entity = EntityBuilder.create().setContentType(ContentType.APPLICATION_JSON).setContentEncoding("identity").setBinary(new byte[]{0, 1, 2}).setText("{\"stuff\"}").build();
        Assert.assertNotNull((Object)entity);
        Assert.assertNotNull((Object)entity.getContentType());
        Assert.assertEquals((Object)"application/json; charset=UTF-8", (Object)entity.getContentType().getValue());
        Assert.assertNotNull((Object)entity.getContentEncoding());
        Assert.assertEquals((Object)"identity", (Object)entity.getContentEncoding().getValue());
        Assert.assertEquals((Object)"{\"stuff\"}", (Object)EntityUtils.toString((HttpEntity)entity));
    }

    @Test
    public void testBuildChunked() throws Exception {
        HttpEntity entity = EntityBuilder.create().setText("stuff").chunked().build();
        Assert.assertNotNull((Object)entity);
        Assert.assertTrue((boolean)entity.isChunked());
    }

    @Test
    public void testBuildGZipped() throws Exception {
        HttpEntity entity = EntityBuilder.create().setText("stuff").gzipCompress().build();
        Assert.assertNotNull((Object)entity);
        Assert.assertNotNull((Object)entity.getContentType());
        Assert.assertEquals((Object)"text/plain; charset=ISO-8859-1", (Object)entity.getContentType().getValue());
        Assert.assertNotNull((Object)entity.getContentEncoding());
        Assert.assertEquals((Object)"gzip", (Object)entity.getContentEncoding().getValue());
    }
}

