/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.utils;

import java.net.URLEncoder;
import java.nio.charset.Charset;
import org.apache.http.Consts;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.junit.Assert;
import org.junit.Test;

public class TestRequestBuilder {
    @Test
    public void testBuildGETwithUTF8() throws Exception {
        this.assertBuild(Consts.UTF_8);
    }

    @Test
    public void testBuildGETwithISO88591() throws Exception {
        this.assertBuild(Consts.ISO_8859_1);
    }

    private void assertBuild(Charset charset) throws Exception {
        RequestBuilder requestBuilder = RequestBuilder.create((String)"GET").setCharset(charset);
        requestBuilder.setUri("https://somehost.com/stuff");
        requestBuilder.addParameters(this.createParameters());
        String encodedData1 = URLEncoder.encode("\"1\u00aa position\"", charset.displayName());
        String encodedData2 = URLEncoder.encode("Jos\u00e9 Abra\u00e3o", charset.displayName());
        String uriExpected = String.format("https://somehost.com/stuff?parameter1=value1&parameter2=%s&parameter3=%s", encodedData1, encodedData2);
        HttpUriRequest request = requestBuilder.build();
        Assert.assertEquals((Object)uriExpected, (Object)request.getURI().toString());
    }

    private NameValuePair[] createParameters() {
        NameValuePair[] parameters = new NameValuePair[]{new BasicNameValuePair("parameter1", "value1"), new BasicNameValuePair("parameter2", "\"1\u00aa position\""), new BasicNameValuePair("parameter3", "Jos\u00e9 Abra\u00e3o")};
        return parameters;
    }
}

