/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.entity;

import org.apache.http.Header;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.message.BasicHeader;
import org.junit.Assert;
import org.junit.Test;

public class TestAbstractHttpEntity {
    @Test
    public void testContentType() throws Exception {
        BasicHttpEntity httpentity = new BasicHttpEntity();
        httpentity.setContentType((Header)new BasicHeader("Content-Type", "blah"));
        Assert.assertEquals((Object)"Content-Type", (Object)httpentity.getContentType().getName());
        Assert.assertEquals((Object)"blah", (Object)httpentity.getContentType().getValue());
        httpentity.setContentType("blah");
        Assert.assertEquals((Object)"Content-Type", (Object)httpentity.getContentType().getName());
        Assert.assertEquals((Object)"blah", (Object)httpentity.getContentType().getValue());
        httpentity.setContentType((Header)null);
        Assert.assertNull((Object)httpentity.getContentType());
        httpentity.setContentType((String)null);
        Assert.assertNull((Object)httpentity.getContentType());
    }

    @Test
    public void testContentEncoding() throws Exception {
        BasicHttpEntity httpentity = new BasicHttpEntity();
        httpentity.setContentEncoding((Header)new BasicHeader("Content-Encoding", "gzip"));
        Assert.assertEquals((Object)"Content-Encoding", (Object)httpentity.getContentEncoding().getName());
        Assert.assertEquals((Object)"gzip", (Object)httpentity.getContentEncoding().getValue());
        httpentity.setContentEncoding("gzip");
        Assert.assertEquals((Object)"Content-Encoding", (Object)httpentity.getContentEncoding().getName());
        Assert.assertEquals((Object)"gzip", (Object)httpentity.getContentEncoding().getValue());
        httpentity.setContentEncoding((Header)null);
        Assert.assertNull((Object)httpentity.getContentEncoding());
        httpentity.setContentEncoding((String)null);
        Assert.assertNull((Object)httpentity.getContentEncoding());
    }

    @Test
    public void testChunkingFlag() throws Exception {
        BasicHttpEntity httpentity = new BasicHttpEntity();
        Assert.assertFalse((boolean)httpentity.isChunked());
        httpentity.setChunked(true);
        Assert.assertTrue((boolean)httpentity.isChunked());
    }
}

