/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.entity;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.Consts;
import org.apache.http.entity.BasicHttpEntity;
import org.junit.Assert;
import org.junit.Test;

public class TestBasicHttpEntity {
    @Test
    public void testBasics() throws Exception {
        byte[] bytes = "Message content".getBytes(Consts.ASCII);
        ByteArrayInputStream content = new ByteArrayInputStream(bytes);
        BasicHttpEntity httpentity = new BasicHttpEntity();
        httpentity.setContent((InputStream)content);
        httpentity.setContentLength((long)bytes.length);
        Assert.assertEquals((long)bytes.length, (long)httpentity.getContentLength());
        Assert.assertFalse((boolean)httpentity.isRepeatable());
        Assert.assertTrue((boolean)httpentity.isStreaming());
    }

    @Test
    public void testContent() throws Exception {
        byte[] bytes = "Message content".getBytes(Consts.ASCII);
        ByteArrayInputStream content = new ByteArrayInputStream(bytes);
        BasicHttpEntity httpentity = new BasicHttpEntity();
        try {
            httpentity.getContent();
            Assert.fail((String)"IllegalStateException should have been thrown");
        }
        catch (IllegalStateException ex) {
            // empty catch block
        }
        httpentity.setContent((InputStream)content);
        Assert.assertEquals((Object)content, (Object)httpentity.getContent());
        httpentity.setContent(null);
        try {
            httpentity.getContent();
            Assert.fail((String)"IllegalStateException should have been thrown");
        }
        catch (IllegalStateException ex) {
            // empty catch block
        }
    }

    @Test
    public void testWriteTo() throws Exception {
        byte[] bytes = "Message content".getBytes(Consts.ASCII);
        ByteArrayInputStream content = new ByteArrayInputStream(bytes);
        BasicHttpEntity httpentity = new BasicHttpEntity();
        httpentity.setContent((InputStream)content);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        httpentity.writeTo((OutputStream)out);
        byte[] bytes2 = out.toByteArray();
        Assert.assertNotNull((Object)bytes2);
        Assert.assertEquals((long)bytes.length, (long)bytes2.length);
        for (int i = 0; i < bytes.length; ++i) {
            Assert.assertEquals((long)bytes[i], (long)bytes2[i]);
        }
        httpentity.setContent(null);
        out = new ByteArrayOutputStream();
        try {
            httpentity.writeTo((OutputStream)out);
            Assert.fail((String)"IllegalStateException should have been thrown");
        }
        catch (IllegalStateException ex) {
            // empty catch block
        }
        try {
            httpentity.writeTo(null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
    }
}

