/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.entity;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.apache.http.Consts;
import org.apache.http.entity.ByteArrayEntity;
import org.junit.Assert;
import org.junit.Test;

public class TestByteArrayEntity {
    @Test
    public void testBasics() throws Exception {
        byte[] bytes = "Message content".getBytes(Consts.ASCII);
        ByteArrayEntity httpentity = new ByteArrayEntity(bytes);
        Assert.assertEquals((long)bytes.length, (long)httpentity.getContentLength());
        Assert.assertNotNull((Object)httpentity.getContent());
        Assert.assertTrue((boolean)httpentity.isRepeatable());
        Assert.assertFalse((boolean)httpentity.isStreaming());
    }

    @Test
    public void testBasicOffLen() throws Exception {
        byte[] bytes = "Message content".getBytes(Consts.ASCII);
        ByteArrayEntity httpentity = new ByteArrayEntity(bytes, 8, 7);
        Assert.assertEquals((long)7L, (long)httpentity.getContentLength());
        Assert.assertNotNull((Object)httpentity.getContent());
        Assert.assertTrue((boolean)httpentity.isRepeatable());
        Assert.assertFalse((boolean)httpentity.isStreaming());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIllegalConstructorNullByteArray() throws Exception {
        new ByteArrayEntity(null);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testIllegalConstructorBadLen() throws Exception {
        byte[] bytes = "Message content".getBytes(Consts.ASCII);
        new ByteArrayEntity(bytes, 0, bytes.length + 1);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testIllegalConstructorBadOff1() throws Exception {
        byte[] bytes = "Message content".getBytes(Consts.ASCII);
        new ByteArrayEntity(bytes, -1, bytes.length);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testIllegalConstructorBadOff2() throws Exception {
        byte[] bytes = "Message content".getBytes(Consts.ASCII);
        new ByteArrayEntity(bytes, bytes.length + 1, bytes.length);
    }

    @Test
    public void testWriteTo() throws Exception {
        int i;
        byte[] bytes = "Message content".getBytes(Consts.ASCII);
        ByteArrayEntity httpentity = new ByteArrayEntity(bytes);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        httpentity.writeTo((OutputStream)out);
        byte[] bytes2 = out.toByteArray();
        Assert.assertNotNull((Object)bytes2);
        Assert.assertEquals((long)bytes.length, (long)bytes2.length);
        for (i = 0; i < bytes.length; ++i) {
            Assert.assertEquals((long)bytes[i], (long)bytes2[i]);
        }
        out = new ByteArrayOutputStream();
        httpentity.writeTo((OutputStream)out);
        bytes2 = out.toByteArray();
        Assert.assertNotNull((Object)bytes2);
        Assert.assertEquals((long)bytes.length, (long)bytes2.length);
        for (i = 0; i < bytes.length; ++i) {
            Assert.assertEquals((long)bytes[i], (long)bytes2[i]);
        }
        try {
            httpentity.writeTo(null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
    }

    @Test
    public void testWriteToOffLen() throws Exception {
        int i;
        byte[] bytes = "Message content".getBytes(Consts.ASCII);
        int off = 8;
        int len = 7;
        ByteArrayEntity httpentity = new ByteArrayEntity(bytes, 8, 7);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        httpentity.writeTo((OutputStream)out);
        byte[] bytes2 = out.toByteArray();
        Assert.assertNotNull((Object)bytes2);
        Assert.assertEquals((long)7L, (long)bytes2.length);
        for (i = 0; i < 7; ++i) {
            Assert.assertEquals((long)bytes[i + 8], (long)bytes2[i]);
        }
        out = new ByteArrayOutputStream();
        httpentity.writeTo((OutputStream)out);
        bytes2 = out.toByteArray();
        Assert.assertNotNull((Object)bytes2);
        Assert.assertEquals((long)7L, (long)bytes2.length);
        for (i = 0; i < 7; ++i) {
            Assert.assertEquals((long)bytes[i + 8], (long)bytes2[i]);
        }
        try {
            httpentity.writeTo(null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
    }
}

