/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.entity;

import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.ParseException;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.junit.Assert;
import org.junit.Test;

public class TestContentType {
    @Test
    public void testBasis() throws Exception {
        ContentType contentType = ContentType.create((String)"text/plain", (String)"US-ASCII");
        Assert.assertEquals((Object)"text/plain", (Object)contentType.getMimeType());
        Assert.assertEquals((Object)Consts.ASCII, (Object)contentType.getCharset());
        Assert.assertEquals((Object)"text/plain; charset=US-ASCII", (Object)contentType.toString());
    }

    @Test
    public void testWithCharset() throws Exception {
        ContentType contentType = ContentType.create((String)"text/plain", (String)"US-ASCII");
        Assert.assertEquals((Object)"text/plain", (Object)contentType.getMimeType());
        Assert.assertEquals((Object)Consts.ASCII, (Object)contentType.getCharset());
        Assert.assertEquals((Object)"text/plain; charset=US-ASCII", (Object)contentType.toString());
        contentType = contentType.withCharset(Charset.forName("UTF-8"));
        Assert.assertEquals((Object)"text/plain", (Object)contentType.getMimeType());
        Assert.assertEquals((Object)"UTF-8", (Object)contentType.getCharset().name());
        Assert.assertEquals((Object)"text/plain; charset=UTF-8", (Object)contentType.toString());
    }

    @Test
    public void testWithCharsetString() throws Exception {
        ContentType contentType = ContentType.create((String)"text/plain", (String)"US-ASCII");
        Assert.assertEquals((Object)"text/plain", (Object)contentType.getMimeType());
        Assert.assertEquals((Object)Consts.ASCII, (Object)contentType.getCharset());
        Assert.assertEquals((Object)"text/plain; charset=US-ASCII", (Object)contentType.toString());
        contentType = contentType.withCharset("UTF-8");
        Assert.assertEquals((Object)"text/plain", (Object)contentType.getMimeType());
        Assert.assertEquals((Object)Consts.UTF_8, (Object)contentType.getCharset());
        Assert.assertEquals((Object)"text/plain; charset=UTF-8", (Object)contentType.toString());
    }

    @Test
    public void testLowCaseText() throws Exception {
        ContentType contentType = ContentType.create((String)"Text/Plain", (String)"ascii");
        Assert.assertEquals((Object)"text/plain", (Object)contentType.getMimeType());
        Assert.assertEquals((Object)Consts.ASCII, (Object)contentType.getCharset());
    }

    @Test
    public void testCreateInvalidInput() throws Exception {
        try {
            ContentType.create(null, (String)null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            ContentType.create((String)"  ", (String)null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            ContentType.create((String)"stuff;", (String)null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            ContentType.create((String)"text/plain", (String)",");
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testParse() throws Exception {
        ContentType contentType = ContentType.parse((String)"text/plain; charset=\"ascii\"");
        Assert.assertEquals((Object)"text/plain", (Object)contentType.getMimeType());
        Assert.assertEquals((Object)Consts.ASCII, (Object)contentType.getCharset());
        Assert.assertEquals((Object)"text/plain; charset=ascii", (Object)contentType.toString());
    }

    @Test
    public void testParseMultiparam() throws Exception {
        ContentType contentType = ContentType.parse((String)"text/plain; charset=\"ascii\"; p0 ; p1 = \"blah-blah\"  ; p2 = \" yada yada \" ");
        Assert.assertEquals((Object)"text/plain", (Object)contentType.getMimeType());
        Assert.assertEquals((Object)Consts.ASCII, (Object)contentType.getCharset());
        Assert.assertEquals((Object)"text/plain; charset=ascii; p0; p1=blah-blah; p2=\" yada yada \"", (Object)contentType.toString());
        Assert.assertEquals(null, (Object)contentType.getParameter("p0"));
        Assert.assertEquals((Object)"blah-blah", (Object)contentType.getParameter("p1"));
        Assert.assertEquals((Object)" yada yada ", (Object)contentType.getParameter("p2"));
        Assert.assertEquals(null, (Object)contentType.getParameter("p3"));
    }

    @Test
    public void testParseEmptyCharset() throws Exception {
        ContentType contentType = ContentType.parse((String)"text/plain; charset=\" \"");
        Assert.assertEquals((Object)"text/plain", (Object)contentType.getMimeType());
        Assert.assertEquals(null, (Object)contentType.getCharset());
    }

    @Test
    public void testParseInvalidInput() throws Exception {
        try {
            ContentType.parse(null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            ContentType.parse((String)";");
            Assert.fail((String)"ParseException should have been thrown");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    @Test
    public void testExtractNullInput() throws Exception {
        Assert.assertNull((Object)ContentType.get(null));
    }

    @Test
    public void testExtractNullContentType() throws Exception {
        BasicHttpEntity httpentity = new BasicHttpEntity();
        httpentity.setContentType((Header)null);
        Assert.assertNull((Object)ContentType.get((HttpEntity)httpentity));
    }

    @Test
    public void testExtract() throws Exception {
        BasicHttpEntity httpentity = new BasicHttpEntity();
        httpentity.setContentType((Header)new BasicHeader("Content-Type", "text/plain; charset = UTF-8"));
        ContentType contentType = ContentType.get((HttpEntity)httpentity);
        Assert.assertNotNull((Object)contentType);
        Assert.assertEquals((Object)"text/plain", (Object)contentType.getMimeType());
        Assert.assertEquals((Object)Consts.UTF_8, (Object)contentType.getCharset());
    }

    @Test
    public void testExtractNoCharset() throws Exception {
        BasicHttpEntity httpentity = new BasicHttpEntity();
        httpentity.setContentType((Header)new BasicHeader("Content-Type", "text/plain; param=yadayada"));
        ContentType contentType = ContentType.get((HttpEntity)httpentity);
        Assert.assertNotNull((Object)contentType);
        Assert.assertEquals((Object)"text/plain", (Object)contentType.getMimeType());
        Assert.assertNull((Object)contentType.getCharset());
    }

    @Test(expected=UnsupportedCharsetException.class)
    public void testExtractInvalidCharset() throws Exception {
        BasicHttpEntity httpentity = new BasicHttpEntity();
        httpentity.setContentType((Header)new BasicHeader("Content-Type", "text/plain; charset = stuff"));
        ContentType.get((HttpEntity)httpentity);
    }

    @Test
    public void testExtracLenienttNullInput() throws Exception {
        Assert.assertNull((Object)ContentType.getLenient(null));
    }

    @Test
    public void testExtractLenientNullContentType() throws Exception {
        BasicHttpEntity httpentity = new BasicHttpEntity();
        httpentity.setContentType((Header)null);
        Assert.assertNull((Object)ContentType.getLenient((HttpEntity)httpentity));
    }

    @Test
    public void testLenientExtractInvalidCharset() throws Exception {
        BasicHttpEntity httpentity = new BasicHttpEntity();
        httpentity.setContentType((Header)new BasicHeader("Content-Type", "text/plain; charset = stuff"));
        ContentType contentType = ContentType.getLenient((HttpEntity)httpentity);
        Assert.assertNotNull((Object)contentType);
        Assert.assertEquals((Object)"text/plain", (Object)contentType.getMimeType());
        Assert.assertEquals(null, (Object)contentType.getCharset());
    }

    @Test
    public void testWithParams() throws Exception {
        ContentType contentType = ContentType.create((String)"text/plain", (NameValuePair[])new NameValuePair[]{new BasicNameValuePair("charset", "UTF-8"), new BasicNameValuePair("p", "this"), new BasicNameValuePair("p", "that")});
        Assert.assertEquals((Object)"text/plain", (Object)contentType.getMimeType());
        Assert.assertEquals((Object)Consts.UTF_8, (Object)contentType.getCharset());
        Assert.assertEquals((Object)"text/plain; charset=UTF-8; p=this; p=that", (Object)contentType.toString());
        contentType = contentType.withParameters(new NameValuePair[]{new BasicNameValuePair("charset", "ascii"), new BasicNameValuePair("p", "this and that")});
        Assert.assertEquals((Object)"text/plain", (Object)contentType.getMimeType());
        Assert.assertEquals((Object)Consts.ASCII, (Object)contentType.getCharset());
        Assert.assertEquals((Object)"text/plain; charset=ascii; p=\"this and that\"", (Object)contentType.toString());
        contentType = ContentType.create((String)"text/blah").withParameters(new NameValuePair[]{new BasicNameValuePair("p", "blah")});
        Assert.assertEquals((Object)"text/blah", (Object)contentType.getMimeType());
        Assert.assertEquals(null, (Object)contentType.getCharset());
        Assert.assertEquals((Object)"text/blah; p=blah", (Object)contentType.toString());
        contentType = ContentType.create((String)"text/blah", (Charset)Consts.ISO_8859_1).withParameters(new NameValuePair[]{new BasicNameValuePair("p", "blah")});
        Assert.assertEquals((Object)"text/blah", (Object)contentType.getMimeType());
        Assert.assertEquals((Object)Consts.ISO_8859_1, (Object)contentType.getCharset());
        Assert.assertEquals((Object)"text/blah; charset=ISO-8859-1; p=blah", (Object)contentType.toString());
    }
}

