/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.entity;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentProducer;
import org.apache.http.entity.EntityTemplate;
import org.apache.http.util.EntityUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestEntityTemplate {
    @Test
    public void testBasics() throws Exception {
        EntityTemplate httpentity = new EntityTemplate(new ContentProducer(){

            public void writeTo(OutputStream outStream) throws IOException {
                outStream.write(97);
            }
        });
        Assert.assertEquals((long)-1L, (long)httpentity.getContentLength());
        Assert.assertTrue((boolean)httpentity.isRepeatable());
        Assert.assertFalse((boolean)httpentity.isStreaming());
    }

    @Test
    public void testIllegalConstructor() throws Exception {
        try {
            new EntityTemplate(null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testWriteTo() throws Exception {
        EntityTemplate httpentity = new EntityTemplate(new ContentProducer(){

            public void writeTo(OutputStream outStream) throws IOException {
                outStream.write(97);
            }
        });
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        httpentity.writeTo((OutputStream)out);
        byte[] bytes2 = out.toByteArray();
        Assert.assertNotNull((Object)bytes2);
        Assert.assertEquals((long)1L, (long)bytes2.length);
        try {
            httpentity.writeTo(null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
    }

    @Test
    public void testgetContent() throws Exception {
        EntityTemplate httpentity = new EntityTemplate(new ContentProducer(){

            public void writeTo(OutputStream outStream) throws IOException {
                outStream.write(97);
            }
        });
        InputStream inStream = httpentity.getContent();
        Assert.assertNotNull((Object)inStream);
        String s = EntityUtils.toString((HttpEntity)httpentity);
        Assert.assertEquals((Object)"a", (Object)s);
    }
}

