/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.entity;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestFileEntity {
    @ClassRule
    public static final TemporaryFolder tempFolder = new TemporaryFolder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileLengthMaxIntPlusOne() throws IOException {
        File file = tempFolder.newFile("test.bin");
        RandomAccessFile raFile = new RandomAccessFile(file, "rw");
        try {
            long expectedLength = 0x80000000L;
            raFile.setLength(0x80000000L);
            FileEntity fileEntity = new FileEntity(file);
            Assert.assertEquals((long)0x80000000L, (long)fileEntity.getContentLength());
        }
        finally {
            raFile.close();
        }
    }

    @Test
    public void testBasics() throws Exception {
        File tmpfile = File.createTempFile("testfile", ".txt");
        tmpfile.deleteOnExit();
        FileEntity httpentity = new FileEntity(tmpfile, ContentType.TEXT_PLAIN);
        Assert.assertEquals((long)tmpfile.length(), (long)httpentity.getContentLength());
        InputStream content = httpentity.getContent();
        Assert.assertNotNull((Object)content);
        content.close();
        Assert.assertTrue((boolean)httpentity.isRepeatable());
        Assert.assertFalse((boolean)httpentity.isStreaming());
        if (!tmpfile.delete()) {
            Assert.fail((String)("Failed to delete: " + tmpfile));
        }
    }

    @Test
    public void testIllegalConstructor() throws Exception {
        try {
            new FileEntity(null, ContentType.TEXT_PLAIN);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testWriteTo() throws Exception {
        File tmpfile = File.createTempFile("testfile", ".txt");
        tmpfile.deleteOnExit();
        FileOutputStream outStream = new FileOutputStream(tmpfile);
        outStream.write(0);
        outStream.write(1);
        outStream.write(2);
        outStream.write(3);
        outStream.close();
        FileEntity httpentity = new FileEntity(tmpfile, ContentType.TEXT_PLAIN);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        httpentity.writeTo((OutputStream)out);
        byte[] bytes = out.toByteArray();
        Assert.assertNotNull((Object)bytes);
        Assert.assertEquals((long)tmpfile.length(), (long)bytes.length);
        for (int i = 0; i < 4; ++i) {
            Assert.assertEquals((long)i, (long)bytes[i]);
        }
        if (!tmpfile.delete()) {
            Assert.fail((String)("Failed to delete: " + tmpfile));
        }
        try {
            httpentity.writeTo(null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
    }
}

