/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.entity;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.Consts;
import org.apache.http.entity.InputStreamEntity;
import org.junit.Assert;
import org.junit.Test;

public class TestInputStreamEntity {
    @Test
    public void testBasics() throws Exception {
        byte[] bytes = "Message content".getBytes(Consts.ISO_8859_1);
        ByteArrayInputStream inStream = new ByteArrayInputStream(bytes);
        InputStreamEntity httpentity = new InputStreamEntity((InputStream)inStream, (long)bytes.length);
        Assert.assertEquals((long)bytes.length, (long)httpentity.getContentLength());
        Assert.assertEquals((Object)inStream, (Object)httpentity.getContent());
        Assert.assertNotNull((Object)httpentity.getContent());
        Assert.assertFalse((boolean)httpentity.isRepeatable());
        Assert.assertTrue((boolean)httpentity.isStreaming());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIllegalConstructor() throws Exception {
        new InputStreamEntity(null, 0L);
    }

    @Test
    public void testUnknownLengthConstructor() throws Exception {
        ByteArrayInputStream inStream = new ByteArrayInputStream(new byte[0]);
        InputStreamEntity httpentity = new InputStreamEntity((InputStream)inStream);
        Assert.assertEquals((long)-1L, (long)httpentity.getContentLength());
    }

    @Test
    public void testWriteTo() throws Exception {
        String message = "Message content";
        byte[] bytes = "Message content".getBytes(Consts.ISO_8859_1);
        ByteArrayInputStream inStream = new ByteArrayInputStream(bytes);
        InputStreamEntity httpentity = new InputStreamEntity((InputStream)inStream, (long)bytes.length);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        httpentity.writeTo((OutputStream)out);
        byte[] writtenBytes = out.toByteArray();
        Assert.assertNotNull((Object)writtenBytes);
        Assert.assertEquals((long)bytes.length, (long)writtenBytes.length);
        String s = new String(writtenBytes, Consts.ISO_8859_1.name());
        Assert.assertEquals((Object)"Message content", (Object)s);
    }

    @Test
    public void testWriteToPartialContent() throws Exception {
        String message = "Message content";
        byte[] bytes = "Message content".getBytes(Consts.ISO_8859_1);
        ByteArrayInputStream inStream = new ByteArrayInputStream(bytes);
        int contentLength = 7;
        InputStreamEntity httpentity = new InputStreamEntity((InputStream)inStream, 7L);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        httpentity.writeTo((OutputStream)out);
        byte[] writtenBytes = out.toByteArray();
        Assert.assertNotNull((Object)writtenBytes);
        Assert.assertEquals((long)7L, (long)writtenBytes.length);
        String s = new String(writtenBytes, Consts.ISO_8859_1.name());
        Assert.assertEquals((Object)"Message content".substring(0, 7), (Object)s);
    }

    @Test
    public void testWriteToUnknownLength() throws Exception {
        String message = "Message content";
        byte[] bytes = "Message content".getBytes(Consts.ISO_8859_1);
        ByteArrayInputStream inStream = new ByteArrayInputStream(bytes);
        InputStreamEntity httpentity = new InputStreamEntity((InputStream)inStream);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        httpentity.writeTo((OutputStream)out);
        byte[] writtenBytes = out.toByteArray();
        Assert.assertNotNull((Object)writtenBytes);
        Assert.assertEquals((long)bytes.length, (long)writtenBytes.length);
        String s = new String(writtenBytes, Consts.ISO_8859_1.name());
        Assert.assertEquals((Object)"Message content", (Object)s);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testWriteToNull() throws Exception {
        ByteArrayInputStream inStream = new ByteArrayInputStream(new byte[0]);
        InputStreamEntity httpentity = new InputStreamEntity((InputStream)inStream, 0L);
        httpentity.writeTo(null);
    }
}

