/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.entity;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.http.entity.SerializableEntity;
import org.junit.Assert;
import org.junit.Test;

public class TestSerializableEntity {
    @Test
    public void testBasicsBuff() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        SerializableObject serializableObj = new SerializableObject();
        out.writeObject(serializableObj);
        SerializableEntity httpentity = new SerializableEntity((Serializable)serializableObj, true);
        Assert.assertEquals((long)baos.toByteArray().length, (long)httpentity.getContentLength());
        Assert.assertNotNull((Object)httpentity.getContent());
        Assert.assertTrue((boolean)httpentity.isRepeatable());
        Assert.assertFalse((boolean)httpentity.isStreaming());
    }

    @Test
    public void testBasicsDirect() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        SerializableObject serializableObj = new SerializableObject();
        out.writeObject(serializableObj);
        SerializableEntity httpentity = new SerializableEntity((Serializable)serializableObj, false);
        Assert.assertEquals((long)-1L, (long)httpentity.getContentLength());
        Assert.assertNotNull((Object)httpentity.getContent());
        Assert.assertTrue((boolean)httpentity.isRepeatable());
        Assert.assertFalse((boolean)httpentity.isStreaming());
    }

    @Test
    public void testIllegalConstructor() throws Exception {
        try {
            new SerializableEntity(null, false);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testWriteToBuff() throws Exception {
        SerializableObject serializableObj = new SerializableObject();
        SerializableEntity httpentity = new SerializableEntity((Serializable)serializableObj, true);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        httpentity.writeTo((OutputStream)out);
        byte[] bytes = out.toByteArray();
        Assert.assertNotNull((Object)bytes);
        ObjectInputStream oin = new ObjectInputStream(new ByteArrayInputStream(bytes));
        SerializableObject serIn = (SerializableObject)oin.readObject();
        Assert.assertEquals((long)4L, (long)serIn.intValue);
        Assert.assertEquals((Object)"Hello", (Object)serIn.stringValue);
        try {
            httpentity.writeTo(null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
    }

    @Test
    public void testWriteToDirect() throws Exception {
        SerializableObject serializableObj = new SerializableObject();
        SerializableEntity httpentity = new SerializableEntity((Serializable)serializableObj, false);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        httpentity.writeTo((OutputStream)out);
        byte[] bytes = out.toByteArray();
        Assert.assertNotNull((Object)bytes);
        ObjectInputStream oin = new ObjectInputStream(new ByteArrayInputStream(bytes));
        SerializableObject serIn = (SerializableObject)oin.readObject();
        Assert.assertEquals((long)4L, (long)serIn.intValue);
        Assert.assertEquals((Object)"Hello", (Object)serIn.stringValue);
        try {
            httpentity.writeTo(null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
    }

    public static class SerializableObject
    implements Serializable {
        private static final long serialVersionUID = 1833335861188359573L;
        public int intValue = 4;
        public String stringValue = "Hello";
    }
}

