/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.entity;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestStringEntity {
    static final int[] SWISS_GERMAN_HELLO = new int[]{71, 114, 252, 101, 122, 105, 95, 122, 228, 109, 228};

    @Test
    public void testBasics() throws Exception {
        String s = "Message content";
        StringEntity httpentity = new StringEntity("Message content", ContentType.TEXT_PLAIN);
        byte[] bytes = "Message content".getBytes(Consts.ISO_8859_1);
        Assert.assertEquals((long)bytes.length, (long)httpentity.getContentLength());
        Assert.assertNotNull((Object)httpentity.getContent());
        Assert.assertTrue((boolean)httpentity.isRepeatable());
        Assert.assertFalse((boolean)httpentity.isStreaming());
    }

    @Test
    public void testIllegalConstructor() throws Exception {
        try {
            new StringEntity(null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testDefaultContent() throws Exception {
        String s = "Message content";
        StringEntity httpentity = new StringEntity("Message content", ContentType.create((String)"text/csv", (String)"ANSI_X3.4-1968"));
        Assert.assertEquals((Object)"text/csv; charset=US-ASCII", (Object)httpentity.getContentType().getValue());
        httpentity = new StringEntity("Message content", Consts.ASCII.name());
        Assert.assertEquals((Object)"text/plain; charset=US-ASCII", (Object)httpentity.getContentType().getValue());
        httpentity = new StringEntity("Message content", Consts.ASCII);
        Assert.assertEquals((Object)"text/plain; charset=US-ASCII", (Object)httpentity.getContentType().getValue());
        httpentity = new StringEntity("Message content");
        Assert.assertEquals((Object)"text/plain; charset=ISO-8859-1", (Object)httpentity.getContentType().getValue());
    }

    private static String constructString(int[] unicodeChars) {
        StringBuilder buffer = new StringBuilder();
        if (unicodeChars != null) {
            for (int unicodeChar : unicodeChars) {
                buffer.append((char)unicodeChar);
            }
        }
        return buffer.toString();
    }

    @Test
    public void testNullCharset() throws Exception {
        String s = TestStringEntity.constructString(SWISS_GERMAN_HELLO);
        StringEntity httpentity = new StringEntity(s, ContentType.create((String)"text/plain", (Charset)null));
        Assert.assertNotNull((Object)httpentity.getContentType());
        Assert.assertEquals((Object)"text/plain", (Object)httpentity.getContentType().getValue());
        Assert.assertEquals((Object)s, (Object)EntityUtils.toString((HttpEntity)httpentity));
        httpentity = new StringEntity(s, (Charset)null);
        Assert.assertNotNull((Object)httpentity.getContentType());
        Assert.assertEquals((Object)"text/plain", (Object)httpentity.getContentType().getValue());
        Assert.assertEquals((Object)s, (Object)EntityUtils.toString((HttpEntity)httpentity));
        httpentity = new StringEntity(s, (String)null);
        Assert.assertNotNull((Object)httpentity.getContentType());
        Assert.assertEquals((Object)"text/plain", (Object)httpentity.getContentType().getValue());
        Assert.assertEquals((Object)s, (Object)EntityUtils.toString((HttpEntity)httpentity));
    }

    @Test
    public void testWriteTo() throws Exception {
        int i;
        String s = "Message content";
        byte[] bytes = "Message content".getBytes(Consts.ISO_8859_1);
        StringEntity httpentity = new StringEntity("Message content");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        httpentity.writeTo((OutputStream)out);
        byte[] bytes2 = out.toByteArray();
        Assert.assertNotNull((Object)bytes2);
        Assert.assertEquals((long)bytes.length, (long)bytes2.length);
        for (i = 0; i < bytes.length; ++i) {
            Assert.assertEquals((long)bytes[i], (long)bytes2[i]);
        }
        out = new ByteArrayOutputStream();
        httpentity.writeTo((OutputStream)out);
        bytes2 = out.toByteArray();
        Assert.assertNotNull((Object)bytes2);
        Assert.assertEquals((long)bytes.length, (long)bytes2.length);
        for (i = 0; i < bytes.length; ++i) {
            Assert.assertEquals((long)bytes[i], (long)bytes2[i]);
        }
        try {
            httpentity.writeTo(null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
    }
}

