/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.net.Socket;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.config.MessageConstraints;
import org.apache.http.entity.ContentLengthStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.DefaultBHttpServerConnection;
import org.apache.http.impl.entity.LaxContentLengthStrategy;
import org.apache.http.impl.entity.StrictContentLengthStrategy;
import org.apache.http.impl.io.DefaultHttpRequestParserFactory;
import org.apache.http.impl.io.DefaultHttpResponseWriterFactory;
import org.apache.http.io.HttpMessageParserFactory;
import org.apache.http.io.HttpMessageWriterFactory;
import org.apache.http.message.BasicHttpResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class TestDefaultBHttpServerConnection {
    @Mock
    private Socket socket;
    private DefaultBHttpServerConnection conn;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.conn = new DefaultBHttpServerConnection(1024, 1024, null, null, MessageConstraints.DEFAULT, (ContentLengthStrategy)LaxContentLengthStrategy.INSTANCE, (ContentLengthStrategy)StrictContentLengthStrategy.INSTANCE, (HttpMessageParserFactory)DefaultHttpRequestParserFactory.INSTANCE, (HttpMessageWriterFactory)DefaultHttpResponseWriterFactory.INSTANCE);
    }

    @Test
    public void testBasics() throws Exception {
        Assert.assertFalse((boolean)this.conn.isOpen());
        Assert.assertEquals((Object)"[Not bound]", (Object)this.conn.toString());
    }

    @Test
    public void testReadRequestHead() throws Exception {
        String s = "GET / HTTP/1.1\r\nUser-Agent: test\r\n\r\n";
        ByteArrayInputStream inStream = new ByteArrayInputStream("GET / HTTP/1.1\r\nUser-Agent: test\r\n\r\n".getBytes(Consts.ASCII));
        Mockito.when((Object)this.socket.getInputStream()).thenReturn((Object)inStream);
        this.conn.bind(this.socket);
        Assert.assertEquals((long)0L, (long)this.conn.getMetrics().getRequestCount());
        HttpRequest request = this.conn.receiveRequestHeader();
        Assert.assertNotNull((Object)request);
        Assert.assertEquals((Object)HttpVersion.HTTP_1_1, (Object)request.getProtocolVersion());
        Assert.assertEquals((Object)"/", (Object)request.getRequestLine().getUri());
        Assert.assertEquals((Object)"GET", (Object)request.getRequestLine().getMethod());
        Assert.assertTrue((boolean)request.containsHeader("User-Agent"));
        Assert.assertEquals((long)1L, (long)this.conn.getMetrics().getRequestCount());
    }

    @Test
    public void testReadRequestEntity() throws Exception {
        String s = "POST / HTTP/1.1\r\nUser-Agent: test\r\nContent-Length: 3\r\n\r\n123";
        ByteArrayInputStream inStream = new ByteArrayInputStream("POST / HTTP/1.1\r\nUser-Agent: test\r\nContent-Length: 3\r\n\r\n123".getBytes(Consts.ASCII));
        Mockito.when((Object)this.socket.getInputStream()).thenReturn((Object)inStream);
        this.conn.bind(this.socket);
        Assert.assertEquals((long)0L, (long)this.conn.getMetrics().getRequestCount());
        HttpEntityEnclosingRequest request = (HttpEntityEnclosingRequest)this.conn.receiveRequestHeader();
        Assert.assertNotNull((Object)request);
        Assert.assertEquals((Object)HttpVersion.HTTP_1_1, (Object)request.getProtocolVersion());
        Assert.assertEquals((Object)"/", (Object)request.getRequestLine().getUri());
        Assert.assertEquals((Object)"POST", (Object)request.getRequestLine().getMethod());
        Assert.assertTrue((boolean)request.containsHeader("User-Agent"));
        Assert.assertNull((Object)request.getEntity());
        Assert.assertEquals((long)1L, (long)this.conn.getMetrics().getRequestCount());
        this.conn.receiveRequestEntity(request);
        HttpEntity entity = request.getEntity();
        Assert.assertNotNull((Object)entity);
        Assert.assertEquals((long)3L, (long)entity.getContentLength());
        Assert.assertEquals((long)1L, (long)this.conn.getMetrics().getRequestCount());
    }

    @Test
    public void testWriteResponseHead() throws Exception {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        Mockito.when((Object)this.socket.getOutputStream()).thenReturn((Object)outStream);
        this.conn.bind(this.socket);
        Assert.assertEquals((long)0L, (long)this.conn.getMetrics().getResponseCount());
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        response.addHeader("User-Agent", "test");
        this.conn.sendResponseHeader((HttpResponse)response);
        this.conn.flush();
        Assert.assertEquals((long)1L, (long)this.conn.getMetrics().getResponseCount());
        String s = new String(outStream.toByteArray(), "ASCII");
        Assert.assertEquals((Object)"HTTP/1.1 200 OK\r\nUser-Agent: test\r\n\r\n", (Object)s);
    }

    @Test
    public void testWriteResponse100Head() throws Exception {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        Mockito.when((Object)this.socket.getOutputStream()).thenReturn((Object)outStream);
        this.conn.bind(this.socket);
        Assert.assertEquals((long)0L, (long)this.conn.getMetrics().getResponseCount());
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 100, "Go on");
        this.conn.sendResponseHeader((HttpResponse)response);
        this.conn.flush();
        Assert.assertEquals((long)0L, (long)this.conn.getMetrics().getResponseCount());
        String s = new String(outStream.toByteArray(), "ASCII");
        Assert.assertEquals((Object)"HTTP/1.1 100 Go on\r\n\r\n", (Object)s);
    }

    @Test
    public void testWriteResponseEntity() throws Exception {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        Mockito.when((Object)this.socket.getOutputStream()).thenReturn((Object)outStream);
        this.conn.bind(this.socket);
        Assert.assertEquals((long)0L, (long)this.conn.getMetrics().getResponseCount());
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        response.addHeader("User-Agent", "test");
        response.addHeader("Content-Length", "3");
        response.setEntity((HttpEntity)new StringEntity("123", ContentType.TEXT_PLAIN));
        this.conn.sendResponseHeader((HttpResponse)response);
        this.conn.sendResponseEntity((HttpResponse)response);
        this.conn.flush();
        Assert.assertEquals((long)1L, (long)this.conn.getMetrics().getResponseCount());
        String s = new String(outStream.toByteArray(), "ASCII");
        Assert.assertEquals((Object)"HTTP/1.1 200 OK\r\nUser-Agent: test\r\nContent-Length: 3\r\n\r\n123", (Object)s);
    }
}

