/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.entity;

import org.apache.http.HttpMessage;
import org.apache.http.ProtocolException;
import org.apache.http.entity.ContentLengthStrategy;
import org.apache.http.impl.entity.DisallowIdentityContentLengthStrategy;
import org.apache.http.impl.entity.DummyHttpMessage;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestDisallowIdentityContentLengthStrategy {
    @Test
    public void testZeroLength() throws Exception {
        ContentLengthStrategy strat1 = (ContentLengthStrategy)Mockito.mock(ContentLengthStrategy.class);
        DummyHttpMessage message = new DummyHttpMessage();
        Mockito.when((Object)strat1.determineLength((HttpMessage)message)).thenReturn((Object)0L);
        DisallowIdentityContentLengthStrategy strat2 = new DisallowIdentityContentLengthStrategy(strat1);
        Assert.assertEquals((long)0L, (long)strat2.determineLength((HttpMessage)message));
    }

    @Test(expected=ProtocolException.class)
    public void testIdentity() throws Exception {
        ContentLengthStrategy strat1 = (ContentLengthStrategy)Mockito.mock(ContentLengthStrategy.class);
        DummyHttpMessage message = new DummyHttpMessage();
        Mockito.when((Object)strat1.determineLength((HttpMessage)message)).thenReturn((Object)-1L);
        DisallowIdentityContentLengthStrategy strat2 = new DisallowIdentityContentLengthStrategy(strat1);
        strat2.determineLength((HttpMessage)message);
    }
}

