/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.entity;

import org.apache.http.HttpMessage;
import org.apache.http.impl.entity.DummyHttpMessage;
import org.apache.http.impl.entity.LaxContentLengthStrategy;
import org.junit.Assert;
import org.junit.Test;

public class TestLaxContentLengthStrategy {
    @Test
    public void testEntityWithTransferEncoding() throws Exception {
        LaxContentLengthStrategy lenStrategy = new LaxContentLengthStrategy();
        DummyHttpMessage message = new DummyHttpMessage();
        message.addHeader("Content-Type", "unknown");
        message.addHeader("Transfer-Encoding", "identity, chunked");
        message.addHeader("Content-Length", "plain wrong");
        Assert.assertEquals((long)-2L, (long)lenStrategy.determineLength((HttpMessage)message));
    }

    @Test
    public void testEntityWithIdentityTransferEncoding() throws Exception {
        LaxContentLengthStrategy lenStrategy = new LaxContentLengthStrategy();
        DummyHttpMessage message = new DummyHttpMessage();
        message.addHeader("Content-Type", "unknown");
        message.addHeader("Transfer-Encoding", "identity");
        message.addHeader("Content-Length", "plain wrong");
        Assert.assertEquals((long)-1L, (long)lenStrategy.determineLength((HttpMessage)message));
    }

    @Test
    public void testEntityWithUnsupportedTransferEncoding() throws Exception {
        LaxContentLengthStrategy lenStrategy = new LaxContentLengthStrategy();
        DummyHttpMessage message = new DummyHttpMessage();
        message.addHeader("Content-Type", "unknown");
        message.addHeader("Transfer-Encoding", "whatever; param=value, chunked");
        message.addHeader("Content-Length", "plain wrong");
        Assert.assertEquals((long)-2L, (long)lenStrategy.determineLength((HttpMessage)message));
    }

    @Test
    public void testChunkedTransferEncodingMustBeLast() throws Exception {
        LaxContentLengthStrategy lenStrategy = new LaxContentLengthStrategy();
        DummyHttpMessage message = new DummyHttpMessage();
        message.addHeader("Content-Type", "unknown");
        message.addHeader("Transfer-Encoding", "chunked, identity");
        message.addHeader("Content-Length", "plain wrong");
        Assert.assertEquals((long)-1L, (long)lenStrategy.determineLength((HttpMessage)message));
    }

    @Test
    public void testEntityWithContentLength() throws Exception {
        LaxContentLengthStrategy lenStrategy = new LaxContentLengthStrategy();
        DummyHttpMessage message = new DummyHttpMessage();
        message.addHeader("Content-Type", "unknown");
        message.addHeader("Content-Length", "0");
        Assert.assertEquals((long)0L, (long)lenStrategy.determineLength((HttpMessage)message));
    }

    @Test
    public void testEntityWithMultipleContentLength() throws Exception {
        LaxContentLengthStrategy lenStrategy = new LaxContentLengthStrategy();
        DummyHttpMessage message = new DummyHttpMessage();
        message.addHeader("Content-Type", "unknown");
        message.addHeader("Content-Length", "0");
        message.addHeader("Content-Length", "0");
        message.addHeader("Content-Length", "1");
        Assert.assertEquals((long)1L, (long)lenStrategy.determineLength((HttpMessage)message));
    }

    @Test
    public void testEntityWithMultipleContentLengthSomeWrong() throws Exception {
        LaxContentLengthStrategy lenStrategy = new LaxContentLengthStrategy();
        DummyHttpMessage message = new DummyHttpMessage();
        message.addHeader("Content-Type", "unknown");
        message.addHeader("Content-Length", "1");
        message.addHeader("Content-Length", "yyy");
        message.addHeader("Content-Length", "xxx");
        Assert.assertEquals((long)1L, (long)lenStrategy.determineLength((HttpMessage)message));
    }

    @Test
    public void testEntityWithMultipleContentLengthAllWrong() throws Exception {
        LaxContentLengthStrategy lenStrategy = new LaxContentLengthStrategy();
        DummyHttpMessage message = new DummyHttpMessage();
        message.addHeader("Content-Type", "unknown");
        message.addHeader("Content-Length", "yyy");
        message.addHeader("Content-Length", "xxx");
        Assert.assertEquals((long)-1L, (long)lenStrategy.determineLength((HttpMessage)message));
    }

    @Test
    public void testEntityWithInvalidContentLength() throws Exception {
        LaxContentLengthStrategy lenStrategy = new LaxContentLengthStrategy();
        DummyHttpMessage message = new DummyHttpMessage();
        message.addHeader("Content-Type", "unknown");
        message.addHeader("Content-Length", "xxx");
        Assert.assertEquals((long)-1L, (long)lenStrategy.determineLength((HttpMessage)message));
    }

    @Test
    public void testEntityNeitherContentLengthNorTransferEncoding() throws Exception {
        LaxContentLengthStrategy lenStrategy = new LaxContentLengthStrategy();
        DummyHttpMessage message = new DummyHttpMessage();
        Assert.assertEquals((long)-1L, (long)lenStrategy.determineLength((HttpMessage)message));
    }
}

