/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.http.ConnectionClosedException;
import org.apache.http.Consts;
import org.apache.http.impl.SessionInputBufferMock;
import org.apache.http.impl.io.ContentLengthInputStream;
import org.apache.http.io.SessionInputBuffer;
import org.junit.Assert;
import org.junit.Test;

public class TestContentLengthInputStream {
    @Test
    public void testConstructors() throws Exception {
        ContentLengthInputStream in = new ContentLengthInputStream((SessionInputBuffer)new SessionInputBufferMock(new byte[0]), 0L);
        in.close();
        try {
            new ContentLengthInputStream(null, 10L);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            new ContentLengthInputStream((SessionInputBuffer)new SessionInputBufferMock(new byte[0]), -10L);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testBasics() throws IOException {
        String correct = "1234567890123456";
        ContentLengthInputStream in = new ContentLengthInputStream((SessionInputBuffer)new SessionInputBufferMock("1234567890123456", Consts.ISO_8859_1), 10L);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[50];
        int len = in.read(buffer, 0, 2);
        out.write(buffer, 0, len);
        len = in.read(buffer);
        out.write(buffer, 0, len);
        String result = new String(out.toByteArray(), Consts.ISO_8859_1);
        Assert.assertEquals((Object)result, (Object)"1234567890");
        in.close();
    }

    @Test
    public void testSkip() throws IOException {
        ContentLengthInputStream in = new ContentLengthInputStream((SessionInputBuffer)new SessionInputBufferMock(new byte[20]), 10L);
        Assert.assertEquals((long)10L, (long)in.skip(10L));
        Assert.assertTrue((in.read() == -1 ? 1 : 0) != 0);
        in = new ContentLengthInputStream((SessionInputBuffer)new SessionInputBufferMock(new byte[20]), 10L);
        in.read();
        Assert.assertEquals((long)9L, (long)in.skip(10L));
        Assert.assertTrue((in.read() == -1 ? 1 : 0) != 0);
        in.close();
        in = new ContentLengthInputStream((SessionInputBuffer)new SessionInputBufferMock(new byte[20]), 2L);
        in.read();
        in.read();
        Assert.assertTrue((in.skip(10L) <= 0L ? 1 : 0) != 0);
        Assert.assertTrue((in.skip(-1L) == 0L ? 1 : 0) != 0);
        Assert.assertTrue((in.read() == -1 ? 1 : 0) != 0);
        in.close();
        in = new ContentLengthInputStream((SessionInputBuffer)new SessionInputBufferMock(new byte[20]), 10L);
        Assert.assertEquals((long)5L, (long)in.skip(5L));
        Assert.assertEquals((long)5L, (long)in.read(new byte[20]));
        in.close();
    }

    @Test
    public void testAvailable() throws IOException {
        ContentLengthInputStream in = new ContentLengthInputStream((SessionInputBuffer)new SessionInputBufferMock(new byte[]{1, 2, 3}), 3L);
        Assert.assertEquals((long)0L, (long)in.available());
        in.read();
        Assert.assertEquals((long)2L, (long)in.available());
        in.close();
    }

    @Test
    public void testClose() throws IOException {
        String correct = "1234567890123456-";
        SessionInputBufferMock inBuffer = new SessionInputBufferMock("1234567890123456-", Consts.ISO_8859_1);
        ContentLengthInputStream in = new ContentLengthInputStream((SessionInputBuffer)inBuffer, 16L);
        in.close();
        in.close();
        try {
            in.read();
            Assert.fail((String)"IOException should have been thrown");
        }
        catch (IOException ex) {
            // empty catch block
        }
        byte[] tmp = new byte[10];
        try {
            in.read(tmp);
            Assert.fail((String)"IOException should have been thrown");
        }
        catch (IOException ex) {
            // empty catch block
        }
        try {
            in.read(tmp, 0, tmp.length);
            Assert.fail((String)"IOException should have been thrown");
        }
        catch (IOException ex) {
            // empty catch block
        }
        Assert.assertEquals((long)45L, (long)inBuffer.read());
    }

    @Test
    public void testTruncatedContent() throws IOException {
        String correct = "1234567890123456";
        SessionInputBufferMock inBuffer = new SessionInputBufferMock("1234567890123456", Consts.ISO_8859_1);
        ContentLengthInputStream in = new ContentLengthInputStream((SessionInputBuffer)inBuffer, 32L);
        byte[] tmp = new byte[32];
        int byteRead = in.read(tmp);
        Assert.assertEquals((long)16L, (long)byteRead);
        try {
            in.read(tmp);
            Assert.fail((String)"ConnectionClosedException should have been closed");
        }
        catch (ConnectionClosedException ex) {
            // empty catch block
        }
        try {
            in.read();
            Assert.fail((String)"ConnectionClosedException should have been closed");
        }
        catch (ConnectionClosedException ex) {
            // empty catch block
        }
        try {
            in.close();
            Assert.fail((String)"ConnectionClosedException should have been closed");
        }
        catch (ConnectionClosedException ex) {
            // empty catch block
        }
    }
}

