/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.http.impl.SessionOutputBufferMock;
import org.apache.http.impl.io.ContentLengthOutputStream;
import org.apache.http.io.SessionOutputBuffer;
import org.junit.Assert;
import org.junit.Test;

public class TestContentLengthOutputStream {
    @Test
    public void testConstructors() throws Exception {
        ContentLengthOutputStream in = new ContentLengthOutputStream((SessionOutputBuffer)new SessionOutputBufferMock(), 10L);
        in.close();
        try {
            new ContentLengthOutputStream(null, 10L);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            new ContentLengthOutputStream((SessionOutputBuffer)new SessionOutputBufferMock(), -10L);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testBasics() throws Exception {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        SessionOutputBufferMock datatransmitter = new SessionOutputBufferMock(buffer);
        ContentLengthOutputStream out = new ContentLengthOutputStream((SessionOutputBuffer)datatransmitter, 15L);
        byte[] tmp = new byte[10];
        out.write(tmp, 0, 10);
        out.write(1);
        out.write(tmp, 0, 10);
        out.write(tmp, 0, 10);
        out.write(tmp);
        out.write(1);
        out.write(2);
        out.flush();
        out.close();
        byte[] data = datatransmitter.getData();
        Assert.assertEquals((long)15L, (long)data.length);
    }

    @Test
    public void testClose() throws Exception {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        SessionOutputBufferMock datatransmitter = new SessionOutputBufferMock(buffer);
        ContentLengthOutputStream out = new ContentLengthOutputStream((SessionOutputBuffer)datatransmitter, 15L);
        out.close();
        out.close();
        byte[] tmp = new byte[10];
        try {
            out.write(tmp);
            Assert.fail((String)"IOException should have been thrown");
        }
        catch (IOException ex) {
            // empty catch block
        }
        try {
            out.write(1);
            Assert.fail((String)"IOException should have been thrown");
        }
        catch (IOException ex) {
            // empty catch block
        }
    }
}

