/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.io;

import org.apache.http.impl.SessionInputBufferMock;
import org.apache.http.impl.io.IdentityInputStream;
import org.apache.http.io.SessionInputBuffer;
import org.junit.Assert;
import org.junit.Test;

public class TestIdentityInputStream {
    @Test
    public void testConstructor() throws Exception {
        SessionInputBufferMock receiver = new SessionInputBufferMock(new byte[0]);
        IdentityInputStream in = new IdentityInputStream((SessionInputBuffer)receiver);
        in.close();
        try {
            new IdentityInputStream(null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testBasicRead() throws Exception {
        byte[] input = new byte[]{97, 98, 99};
        SessionInputBufferMock receiver = new SessionInputBufferMock(input);
        IdentityInputStream inStream = new IdentityInputStream((SessionInputBuffer)receiver);
        byte[] tmp = new byte[2];
        Assert.assertEquals((long)2L, (long)inStream.read(tmp, 0, tmp.length));
        Assert.assertEquals((long)97L, (long)tmp[0]);
        Assert.assertEquals((long)98L, (long)tmp[1]);
        Assert.assertEquals((long)99L, (long)inStream.read());
        Assert.assertEquals((long)-1L, (long)inStream.read(tmp, 0, tmp.length));
        Assert.assertEquals((long)-1L, (long)inStream.read());
        Assert.assertEquals((long)-1L, (long)inStream.read(tmp, 0, tmp.length));
        Assert.assertEquals((long)-1L, (long)inStream.read());
        inStream.close();
    }

    @Test
    public void testClosedCondition() throws Exception {
        byte[] input = new byte[]{97, 98, 99};
        SessionInputBufferMock receiver = new SessionInputBufferMock(input);
        IdentityInputStream inStream = new IdentityInputStream((SessionInputBuffer)receiver);
        inStream.close();
        inStream.close();
        Assert.assertEquals((long)0L, (long)inStream.available());
        byte[] tmp = new byte[2];
        Assert.assertEquals((long)-1L, (long)inStream.read(tmp, 0, tmp.length));
        Assert.assertEquals((long)-1L, (long)inStream.read());
        Assert.assertEquals((long)-1L, (long)inStream.read(tmp, 0, tmp.length));
        Assert.assertEquals((long)-1L, (long)inStream.read());
    }

    @Test
    public void testAvailable() throws Exception {
        byte[] input = new byte[]{97, 98, 99};
        SessionInputBufferMock receiver = new SessionInputBufferMock(input);
        IdentityInputStream inStream = new IdentityInputStream((SessionInputBuffer)receiver);
        inStream.read();
        Assert.assertEquals((long)2L, (long)inStream.available());
        inStream.close();
    }
}

