/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.http.impl.SessionOutputBufferMock;
import org.apache.http.impl.io.IdentityOutputStream;
import org.apache.http.io.SessionOutputBuffer;
import org.junit.Assert;
import org.junit.Test;

public class TestIdentityOutputStream {
    @Test
    public void testConstructors() throws Exception {
        new IdentityOutputStream((SessionOutputBuffer)new SessionOutputBufferMock()).close();
        try {
            new IdentityOutputStream(null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testBasics() throws Exception {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        SessionOutputBufferMock datatransmitter = new SessionOutputBufferMock(buffer);
        IdentityOutputStream out = new IdentityOutputStream((SessionOutputBuffer)datatransmitter);
        byte[] tmp = new byte[10];
        out.write(tmp, 0, 10);
        out.write(tmp);
        out.write(1);
        out.flush();
        out.close();
        byte[] data = datatransmitter.getData();
        Assert.assertEquals((long)21L, (long)data.length);
    }

    @Test
    public void testClose() throws Exception {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        SessionOutputBufferMock datatransmitter = new SessionOutputBufferMock(buffer);
        IdentityOutputStream out = new IdentityOutputStream((SessionOutputBuffer)datatransmitter);
        out.close();
        out.close();
        byte[] tmp = new byte[10];
        try {
            out.write(tmp);
            Assert.fail((String)"IOException should have been thrown");
        }
        catch (IOException ex) {
            // empty catch block
        }
        try {
            out.write(1);
            Assert.fail((String)"IOException should have been thrown");
        }
        catch (IOException ex) {
            // empty catch block
        }
    }

    @Test
    public void testConstructor() throws Exception {
        SessionOutputBufferMock transmitter = new SessionOutputBufferMock();
        new IdentityOutputStream((SessionOutputBuffer)transmitter).close();
        try {
            new IdentityOutputStream(null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testBasicWrite() throws Exception {
        SessionOutputBufferMock transmitter = new SessionOutputBufferMock();
        IdentityOutputStream outStream = new IdentityOutputStream((SessionOutputBuffer)transmitter);
        outStream.write(new byte[]{97, 98}, 0, 2);
        outStream.write(99);
        outStream.flush();
        byte[] input = transmitter.getData();
        Assert.assertNotNull((Object)input);
        byte[] expected = new byte[]{97, 98, 99};
        Assert.assertEquals((long)expected.length, (long)input.length);
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((long)expected[i], (long)input[i]);
        }
        outStream.close();
    }

    @Test
    public void testClosedCondition() throws Exception {
        SessionOutputBufferMock transmitter = new SessionOutputBufferMock();
        IdentityOutputStream outStream = new IdentityOutputStream((SessionOutputBuffer)transmitter);
        outStream.close();
        outStream.close();
        try {
            byte[] tmp = new byte[2];
            outStream.write(tmp, 0, tmp.length);
            Assert.fail((String)"IOException should have been thrown");
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            outStream.write(97);
            Assert.fail((String)"IOException should have been thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

