/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.io;

import java.io.IOException;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.NameValuePair;
import org.apache.http.ProtocolException;
import org.apache.http.impl.SessionInputBufferMock;
import org.apache.http.impl.io.AbstractMessageParser;
import org.apache.http.io.SessionInputBuffer;
import org.apache.http.message.BufferedHeader;
import org.junit.Assert;
import org.junit.Test;

public class TestMessageParser {
    @Test
    public void testInvalidInput() throws Exception {
        try {
            AbstractMessageParser.parseHeaders(null, (int)-1, (int)-1, null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            new BufferedHeader(null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testBasicHeaderParsing() throws Exception {
        String s = "header1: stuff\r\nheader2  : stuff \r\nheader3: stuff\r\n     and more stuff\r\n\t and even more stuff\r\n     \r\n\r\n";
        SessionInputBufferMock receiver = new SessionInputBufferMock("header1: stuff\r\nheader2  : stuff \r\nheader3: stuff\r\n     and more stuff\r\n\t and even more stuff\r\n     \r\n\r\n", Consts.ASCII);
        Header[] headers = AbstractMessageParser.parseHeaders((SessionInputBuffer)receiver, (int)-1, (int)-1, null);
        Assert.assertNotNull((Object)headers);
        Assert.assertEquals((long)3L, (long)headers.length);
        Assert.assertEquals((Object)"header1", (Object)headers[0].getName());
        Assert.assertEquals((Object)"stuff", (Object)headers[0].getValue());
        Assert.assertEquals((Object)"header2", (Object)headers[1].getName());
        Assert.assertEquals((Object)"stuff", (Object)headers[1].getValue());
        Assert.assertEquals((Object)"header3", (Object)headers[2].getName());
        Assert.assertEquals((Object)"stuff and more stuff and even more stuff", (Object)headers[2].getValue());
        Header h = headers[0];
        Assert.assertTrue((boolean)(h instanceof BufferedHeader));
        Assert.assertNotNull((Object)((BufferedHeader)h).getBuffer());
        Assert.assertEquals((Object)"header1: stuff", (Object)((BufferedHeader)h).toString());
        Assert.assertEquals((long)8L, (long)((BufferedHeader)h).getValuePos());
    }

    @Test
    public void testBufferedHeader() throws Exception {
        String s = "header1  : stuff; param1 = value1; param2 = \"value 2\" \r\n\r\n";
        SessionInputBufferMock receiver = new SessionInputBufferMock("header1  : stuff; param1 = value1; param2 = \"value 2\" \r\n\r\n", Consts.ASCII);
        Header[] headers = AbstractMessageParser.parseHeaders((SessionInputBuffer)receiver, (int)-1, (int)-1, null);
        Assert.assertNotNull((Object)headers);
        Assert.assertEquals((long)1L, (long)headers.length);
        Assert.assertEquals((Object)"header1  : stuff; param1 = value1; param2 = \"value 2\" ", (Object)headers[0].toString());
        HeaderElement[] elements = headers[0].getElements();
        Assert.assertNotNull((Object)elements);
        Assert.assertEquals((long)1L, (long)elements.length);
        Assert.assertEquals((Object)"stuff", (Object)elements[0].getName());
        Assert.assertEquals(null, (Object)elements[0].getValue());
        NameValuePair[] params = elements[0].getParameters();
        Assert.assertNotNull((Object)params);
        Assert.assertEquals((long)2L, (long)params.length);
        Assert.assertEquals((Object)"param1", (Object)params[0].getName());
        Assert.assertEquals((Object)"value1", (Object)params[0].getValue());
        Assert.assertEquals((Object)"param2", (Object)params[1].getName());
        Assert.assertEquals((Object)"value 2", (Object)params[1].getValue());
    }

    @Test
    public void testParsingInvalidHeaders() throws Exception {
        String s = "    stuff\r\nheader1: stuff\r\n\r\n";
        SessionInputBufferMock receiver = new SessionInputBufferMock(s, Consts.ASCII);
        try {
            AbstractMessageParser.parseHeaders((SessionInputBuffer)receiver, (int)-1, (int)-1, null);
            Assert.fail((String)"ProtocolException should have been thrown");
        }
        catch (ProtocolException ex) {
            // empty catch block
        }
        s = "  :  stuff\r\nheader1: stuff\r\n\r\n";
        receiver = new SessionInputBufferMock(s, Consts.ASCII);
        try {
            AbstractMessageParser.parseHeaders((SessionInputBuffer)receiver, (int)-1, (int)-1, null);
            Assert.fail((String)"ProtocolException should have been thrown");
        }
        catch (ProtocolException protocolException) {
            // empty catch block
        }
    }

    @Test
    public void testParsingMalformedFirstHeader() throws Exception {
        String s = "    header1: stuff\r\nheader2  : stuff \r\n";
        SessionInputBufferMock receiver = new SessionInputBufferMock("    header1: stuff\r\nheader2  : stuff \r\n", Consts.ASCII);
        Header[] headers = AbstractMessageParser.parseHeaders((SessionInputBuffer)receiver, (int)-1, (int)-1, null);
        Assert.assertNotNull((Object)headers);
        Assert.assertEquals((long)2L, (long)headers.length);
        Assert.assertEquals((Object)"header1", (Object)headers[0].getName());
        Assert.assertEquals((Object)"stuff", (Object)headers[0].getValue());
        Assert.assertEquals((Object)"header2", (Object)headers[1].getName());
        Assert.assertEquals((Object)"stuff", (Object)headers[1].getValue());
    }

    @Test
    public void testEmptyDataStream() throws Exception {
        String s = "";
        SessionInputBufferMock receiver = new SessionInputBufferMock("", Consts.ASCII);
        Header[] headers = AbstractMessageParser.parseHeaders((SessionInputBuffer)receiver, (int)-1, (int)-1, null);
        Assert.assertNotNull((Object)headers);
        Assert.assertEquals((long)0L, (long)headers.length);
    }

    @Test
    public void testMaxHeaderCount() throws Exception {
        String s = "header1: stuff\r\nheader2: stuff \r\nheader3: stuff\r\n\r\n";
        SessionInputBufferMock receiver = new SessionInputBufferMock("header1: stuff\r\nheader2: stuff \r\nheader3: stuff\r\n\r\n", Consts.ASCII);
        try {
            AbstractMessageParser.parseHeaders((SessionInputBuffer)receiver, (int)2, (int)-1, null);
            Assert.fail((String)"IOException should have been thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testMaxHeaderCountForFoldedHeader() throws Exception {
        String s = "header1: stuff\r\n stuff \r\n stuff\r\n\r\n";
        SessionInputBufferMock receiver = new SessionInputBufferMock("header1: stuff\r\n stuff \r\n stuff\r\n\r\n", Consts.ASCII);
        try {
            AbstractMessageParser.parseHeaders((SessionInputBuffer)receiver, (int)2, (int)15, null);
            Assert.fail((String)"IOException should have been thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

