/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.io;

import java.io.InterruptedIOException;
import org.apache.http.ConnectionClosedException;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.HttpVersion;
import org.apache.http.RequestLine;
import org.apache.http.impl.SessionInputBufferMock;
import org.apache.http.impl.io.DefaultHttpRequestParser;
import org.apache.http.impl.io.TimeoutByteArrayInputStream;
import org.apache.http.io.SessionInputBuffer;
import org.junit.Assert;
import org.junit.Test;

public class TestRequestParser {
    @Test(expected=IllegalArgumentException.class)
    public void testInvalidConstructorInput() throws Exception {
        new DefaultHttpRequestParser(null);
    }

    @Test
    public void testBasicMessageParsing() throws Exception {
        String s = "GET / HTTP/1.1\r\nHost: localhost\r\nUser-Agent: whatever\r\nCookie: c1=stuff\r\n\r\n";
        SessionInputBufferMock inBuffer = new SessionInputBufferMock("GET / HTTP/1.1\r\nHost: localhost\r\nUser-Agent: whatever\r\nCookie: c1=stuff\r\n\r\n", Consts.ASCII);
        DefaultHttpRequestParser parser = new DefaultHttpRequestParser((SessionInputBuffer)inBuffer);
        HttpRequest httprequest = (HttpRequest)parser.parse();
        RequestLine reqline = httprequest.getRequestLine();
        Assert.assertNotNull((Object)reqline);
        Assert.assertEquals((Object)"GET", (Object)reqline.getMethod());
        Assert.assertEquals((Object)"/", (Object)reqline.getUri());
        Assert.assertEquals((Object)HttpVersion.HTTP_1_1, (Object)reqline.getProtocolVersion());
        Header[] headers = httprequest.getAllHeaders();
        Assert.assertEquals((long)3L, (long)headers.length);
    }

    @Test
    public void testConnectionClosedException() throws Exception {
        SessionInputBufferMock inBuffer = new SessionInputBufferMock(new byte[0]);
        DefaultHttpRequestParser parser = new DefaultHttpRequestParser((SessionInputBuffer)inBuffer);
        try {
            parser.parse();
            Assert.fail((String)"ConnectionClosedException should have been thrown");
        }
        catch (ConnectionClosedException connectionClosedException) {
            // empty catch block
        }
    }

    @Test
    public void testMessageParsingTimeout() throws Exception {
        String s = "GET \u0000/ HTTP/1.1\r\u0000\nHost: loca\u0000lhost\r\nUser-Agent: whatever\r\nCoo\u0000kie: c1=stuff\r\n\u0000\r\n";
        SessionInputBufferMock inBuffer = new SessionInputBufferMock(new TimeoutByteArrayInputStream("GET \u0000/ HTTP/1.1\r\u0000\nHost: loca\u0000lhost\r\nUser-Agent: whatever\r\nCoo\u0000kie: c1=stuff\r\n\u0000\r\n".getBytes(Consts.ASCII)), 16);
        DefaultHttpRequestParser parser = new DefaultHttpRequestParser((SessionInputBuffer)inBuffer);
        int timeoutCount = 0;
        HttpRequest httprequest = null;
        for (int i = 0; i < 10; ++i) {
            try {
                httprequest = (HttpRequest)parser.parse();
                break;
            }
            catch (InterruptedIOException ex) {
                ++timeoutCount;
                continue;
            }
        }
        Assert.assertNotNull(httprequest);
        Assert.assertEquals((long)5L, (long)timeoutCount);
        RequestLine reqline = httprequest.getRequestLine();
        Assert.assertNotNull((Object)reqline);
        Assert.assertEquals((Object)"GET", (Object)reqline.getMethod());
        Assert.assertEquals((Object)"/", (Object)reqline.getUri());
        Assert.assertEquals((Object)HttpVersion.HTTP_1_1, (Object)reqline.getProtocolVersion());
        Header[] headers = httprequest.getAllHeaders();
        Assert.assertEquals((long)3L, (long)headers.length);
    }
}

