/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.io;

import java.io.InterruptedIOException;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.NoHttpResponseException;
import org.apache.http.StatusLine;
import org.apache.http.impl.SessionInputBufferMock;
import org.apache.http.impl.io.DefaultHttpResponseParser;
import org.apache.http.impl.io.TimeoutByteArrayInputStream;
import org.apache.http.io.SessionInputBuffer;
import org.junit.Assert;
import org.junit.Test;

public class TestResponseParser {
    @Test(expected=IllegalArgumentException.class)
    public void testInvalidConstructorInput() throws Exception {
        new DefaultHttpResponseParser(null);
    }

    @Test
    public void testBasicMessageParsing() throws Exception {
        String s = "HTTP/1.1 200 OK\r\nServer: whatever\r\nDate: some date\r\nSet-Cookie: c1=stuff\r\n\r\n";
        SessionInputBufferMock inBuffer = new SessionInputBufferMock("HTTP/1.1 200 OK\r\nServer: whatever\r\nDate: some date\r\nSet-Cookie: c1=stuff\r\n\r\n", Consts.ASCII);
        DefaultHttpResponseParser parser = new DefaultHttpResponseParser((SessionInputBuffer)inBuffer);
        HttpResponse httpresponse = (HttpResponse)parser.parse();
        StatusLine statusline = httpresponse.getStatusLine();
        Assert.assertNotNull((Object)statusline);
        Assert.assertEquals((long)200L, (long)statusline.getStatusCode());
        Assert.assertEquals((Object)"OK", (Object)statusline.getReasonPhrase());
        Assert.assertEquals((Object)HttpVersion.HTTP_1_1, (Object)statusline.getProtocolVersion());
        Header[] headers = httpresponse.getAllHeaders();
        Assert.assertEquals((long)3L, (long)headers.length);
    }

    @Test
    public void testConnectionClosedException() throws Exception {
        SessionInputBufferMock inBuffer = new SessionInputBufferMock(new byte[0]);
        DefaultHttpResponseParser parser = new DefaultHttpResponseParser((SessionInputBuffer)inBuffer);
        try {
            parser.parse();
            Assert.fail((String)"NoHttpResponseException should have been thrown");
        }
        catch (NoHttpResponseException noHttpResponseException) {
            // empty catch block
        }
    }

    @Test
    public void testMessageParsingTimeout() throws Exception {
        String s = "HTTP\u0000/1.1 200\u0000 OK\r\nServer: wha\u0000tever\r\nDate: some date\r\nSet-Coo\u0000kie: c1=stuff\r\n\u0000\r\n";
        SessionInputBufferMock inBuffer = new SessionInputBufferMock(new TimeoutByteArrayInputStream("HTTP\u0000/1.1 200\u0000 OK\r\nServer: wha\u0000tever\r\nDate: some date\r\nSet-Coo\u0000kie: c1=stuff\r\n\u0000\r\n".getBytes(Consts.ASCII)), 16);
        DefaultHttpResponseParser parser = new DefaultHttpResponseParser((SessionInputBuffer)inBuffer);
        int timeoutCount = 0;
        HttpResponse httpresponse = null;
        for (int i = 0; i < 10; ++i) {
            try {
                httpresponse = (HttpResponse)parser.parse();
                break;
            }
            catch (InterruptedIOException ex) {
                ++timeoutCount;
                continue;
            }
        }
        Assert.assertNotNull(httpresponse);
        Assert.assertEquals((long)5L, (long)timeoutCount);
        StatusLine statusline = httpresponse.getStatusLine();
        Assert.assertNotNull((Object)statusline);
        Assert.assertEquals((long)200L, (long)statusline.getStatusCode());
        Assert.assertEquals((Object)"OK", (Object)statusline.getReasonPhrase());
        Assert.assertEquals((Object)HttpVersion.HTTP_1_1, (Object)statusline.getProtocolVersion());
        Header[] headers = httpresponse.getAllHeaders();
        Assert.assertEquals((long)3L, (long)headers.length);
    }
}

