/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.integration;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Random;
import org.apache.http.Header;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpConnectionMetrics;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.DefaultBHttpClientConnection;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.protocol.HTTP;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpExpectationVerifier;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.protocol.ImmutableHttpProcessor;
import org.apache.http.protocol.RequestConnControl;
import org.apache.http.protocol.RequestExpectContinue;
import org.apache.http.protocol.RequestTargetHost;
import org.apache.http.protocol.RequestUserAgent;
import org.apache.http.testserver.HttpClient;
import org.apache.http.testserver.HttpServer;
import org.apache.http.util.EncodingUtils;
import org.apache.http.util.EntityUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestSyncHttp {
    private HttpServer server;
    private HttpClient client;

    @Before
    public void initServer() throws Exception {
        this.server = new HttpServer();
        this.server.setTimeout(5000);
    }

    @Before
    public void initClient() throws Exception {
        this.client = new HttpClient();
        this.client.setTimeout(5000);
    }

    @After
    public void shutDownServer() throws Exception {
        if (this.server != null) {
            this.server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleBasicHttpRequests() throws Exception {
        int reqNo = 20;
        Random rnd = new Random();
        final ArrayList<byte[]> testData = new ArrayList<byte[]>(20);
        for (int i = 0; i < 20; ++i) {
            int size = rnd.nextInt(5000);
            byte[] data = new byte[size];
            rnd.nextBytes(data);
            testData.add(data);
        }
        this.server.registerHandler("*", new HttpRequestHandler(){

            public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
                String s = request.getRequestLine().getUri();
                if (s.startsWith("/?")) {
                    s = s.substring(2);
                }
                int index = Integer.parseInt(s);
                byte[] data = (byte[])testData.get(index);
                ByteArrayEntity entity = new ByteArrayEntity(data);
                response.setEntity((HttpEntity)entity);
            }
        });
        this.server.start();
        DefaultBHttpClientConnection conn = this.client.createConnection();
        HttpHost host = new HttpHost("localhost", this.server.getPort());
        try {
            for (int r = 0; r < 20; ++r) {
                if (!conn.isOpen()) {
                    this.client.connect(host, conn);
                }
                BasicHttpRequest get = new BasicHttpRequest("GET", "/?" + r);
                HttpResponse response = this.client.execute((HttpRequest)get, host, (HttpClientConnection)conn);
                byte[] received = EntityUtils.toByteArray((HttpEntity)response.getEntity());
                byte[] expected = (byte[])testData.get(r);
                Assert.assertEquals((long)expected.length, (long)received.length);
                for (int i = 0; i < expected.length; ++i) {
                    Assert.assertEquals((long)expected[i], (long)received[i]);
                }
                if (this.client.keepAlive(response)) continue;
                conn.close();
            }
            HttpConnectionMetrics cm = conn.getMetrics();
            Assert.assertEquals((long)20L, (long)cm.getRequestCount());
            Assert.assertEquals((long)20L, (long)cm.getResponseCount());
        }
        finally {
            conn.close();
            this.server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleHttpPostsWithContentLength() throws Exception {
        int reqNo = 20;
        Random rnd = new Random();
        ArrayList<byte[]> testData = new ArrayList<byte[]>(20);
        for (int i = 0; i < 20; ++i) {
            int size = rnd.nextInt(5000);
            byte[] data = new byte[size];
            rnd.nextBytes(data);
            testData.add(data);
        }
        this.server.registerHandler("*", new HttpRequestHandler(){

            public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
                if (request instanceof HttpEntityEnclosingRequest) {
                    HttpEntity incoming = ((HttpEntityEnclosingRequest)request).getEntity();
                    byte[] data = EntityUtils.toByteArray((HttpEntity)incoming);
                    ByteArrayEntity outgoing = new ByteArrayEntity(data);
                    outgoing.setChunked(false);
                    response.setEntity((HttpEntity)outgoing);
                } else {
                    StringEntity outgoing = new StringEntity("No content");
                    response.setEntity((HttpEntity)outgoing);
                }
            }
        });
        this.server.start();
        DefaultBHttpClientConnection conn = this.client.createConnection();
        HttpHost host = new HttpHost("localhost", this.server.getPort());
        try {
            for (int r = 0; r < 20; ++r) {
                if (!conn.isOpen()) {
                    this.client.connect(host, conn);
                }
                BasicHttpEntityEnclosingRequest post = new BasicHttpEntityEnclosingRequest("POST", "/");
                byte[] data = (byte[])testData.get(r);
                ByteArrayEntity outgoing = new ByteArrayEntity(data);
                post.setEntity((HttpEntity)outgoing);
                HttpResponse response = this.client.execute((HttpRequest)post, host, (HttpClientConnection)conn);
                byte[] received = EntityUtils.toByteArray((HttpEntity)response.getEntity());
                byte[] expected = (byte[])testData.get(r);
                Assert.assertEquals((long)expected.length, (long)received.length);
                for (int i = 0; i < expected.length; ++i) {
                    Assert.assertEquals((long)expected[i], (long)received[i]);
                }
                if (this.client.keepAlive(response)) continue;
                conn.close();
            }
            HttpConnectionMetrics cm = conn.getMetrics();
            Assert.assertEquals((long)20L, (long)cm.getRequestCount());
            Assert.assertEquals((long)20L, (long)cm.getResponseCount());
        }
        finally {
            conn.close();
            this.server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleHttpPostsChunked() throws Exception {
        int reqNo = 20;
        Random rnd = new Random();
        ArrayList<byte[]> testData = new ArrayList<byte[]>(20);
        for (int i = 0; i < 20; ++i) {
            int size = rnd.nextInt(20000);
            byte[] data = new byte[size];
            rnd.nextBytes(data);
            testData.add(data);
        }
        this.server.registerHandler("*", new HttpRequestHandler(){

            public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
                if (request instanceof HttpEntityEnclosingRequest) {
                    HttpEntity incoming = ((HttpEntityEnclosingRequest)request).getEntity();
                    byte[] data = EntityUtils.toByteArray((HttpEntity)incoming);
                    ByteArrayEntity outgoing = new ByteArrayEntity(data);
                    outgoing.setChunked(true);
                    response.setEntity((HttpEntity)outgoing);
                } else {
                    StringEntity outgoing = new StringEntity("No content");
                    response.setEntity((HttpEntity)outgoing);
                }
            }
        });
        this.server.start();
        DefaultBHttpClientConnection conn = this.client.createConnection();
        HttpHost host = new HttpHost("localhost", this.server.getPort());
        try {
            for (int r = 0; r < 20; ++r) {
                if (!conn.isOpen()) {
                    this.client.connect(host, conn);
                }
                BasicHttpEntityEnclosingRequest post = new BasicHttpEntityEnclosingRequest("POST", "/");
                byte[] data = (byte[])testData.get(r);
                ByteArrayEntity outgoing = new ByteArrayEntity(data);
                outgoing.setChunked(true);
                post.setEntity((HttpEntity)outgoing);
                HttpResponse response = this.client.execute((HttpRequest)post, host, (HttpClientConnection)conn);
                byte[] received = EntityUtils.toByteArray((HttpEntity)response.getEntity());
                byte[] expected = (byte[])testData.get(r);
                Assert.assertEquals((long)expected.length, (long)received.length);
                for (int i = 0; i < expected.length; ++i) {
                    Assert.assertEquals((long)expected[i], (long)received[i]);
                }
                if (this.client.keepAlive(response)) continue;
                conn.close();
            }
            HttpConnectionMetrics cm = conn.getMetrics();
            Assert.assertEquals((long)20L, (long)cm.getRequestCount());
            Assert.assertEquals((long)20L, (long)cm.getResponseCount());
        }
        finally {
            conn.close();
            this.server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleHttpPostsHTTP10() throws Exception {
        int reqNo = 20;
        Random rnd = new Random();
        ArrayList<byte[]> testData = new ArrayList<byte[]>(20);
        for (int i = 0; i < 20; ++i) {
            int size = rnd.nextInt(5000);
            byte[] data = new byte[size];
            rnd.nextBytes(data);
            testData.add(data);
        }
        this.server.registerHandler("*", new HttpRequestHandler(){

            public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
                if (request instanceof HttpEntityEnclosingRequest) {
                    HttpEntity incoming = ((HttpEntityEnclosingRequest)request).getEntity();
                    byte[] data = EntityUtils.toByteArray((HttpEntity)incoming);
                    ByteArrayEntity outgoing = new ByteArrayEntity(data);
                    outgoing.setChunked(false);
                    response.setEntity((HttpEntity)outgoing);
                } else {
                    StringEntity outgoing = new StringEntity("No content");
                    response.setEntity((HttpEntity)outgoing);
                }
            }
        });
        this.server.start();
        DefaultBHttpClientConnection conn = this.client.createConnection();
        HttpHost host = new HttpHost("localhost", this.server.getPort());
        try {
            for (int r = 0; r < 20; ++r) {
                if (!conn.isOpen()) {
                    this.client.connect(host, conn);
                }
                BasicHttpEntityEnclosingRequest post = new BasicHttpEntityEnclosingRequest("POST", "/", (ProtocolVersion)HttpVersion.HTTP_1_0);
                byte[] data = (byte[])testData.get(r);
                ByteArrayEntity outgoing = new ByteArrayEntity(data);
                post.setEntity((HttpEntity)outgoing);
                HttpResponse response = this.client.execute((HttpRequest)post, host, (HttpClientConnection)conn);
                Assert.assertEquals((Object)HttpVersion.HTTP_1_1, (Object)response.getStatusLine().getProtocolVersion());
                byte[] received = EntityUtils.toByteArray((HttpEntity)response.getEntity());
                byte[] expected = (byte[])testData.get(r);
                Assert.assertEquals((long)expected.length, (long)received.length);
                for (int i = 0; i < expected.length; ++i) {
                    Assert.assertEquals((long)expected[i], (long)received[i]);
                }
                if (this.client.keepAlive(response)) continue;
                conn.close();
            }
            HttpConnectionMetrics cm = conn.getMetrics();
            Assert.assertEquals((long)20L, (long)cm.getRequestCount());
            Assert.assertEquals((long)20L, (long)cm.getResponseCount());
        }
        finally {
            conn.close();
            this.server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHttpPostsWithExpectContinue() throws Exception {
        int reqNo = 20;
        Random rnd = new Random();
        ArrayList<byte[]> testData = new ArrayList<byte[]>(20);
        for (int i = 0; i < 20; ++i) {
            int size = rnd.nextInt(5000);
            byte[] data = new byte[size];
            rnd.nextBytes(data);
            testData.add(data);
        }
        this.server.registerHandler("*", new HttpRequestHandler(){

            public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
                if (request instanceof HttpEntityEnclosingRequest) {
                    HttpEntity incoming = ((HttpEntityEnclosingRequest)request).getEntity();
                    byte[] data = EntityUtils.toByteArray((HttpEntity)incoming);
                    ByteArrayEntity outgoing = new ByteArrayEntity(data);
                    outgoing.setChunked(true);
                    response.setEntity((HttpEntity)outgoing);
                } else {
                    StringEntity outgoing = new StringEntity("No content");
                    response.setEntity((HttpEntity)outgoing);
                }
            }
        });
        this.server.start();
        DefaultBHttpClientConnection conn = this.client.createConnection();
        HttpHost host = new HttpHost("localhost", this.server.getPort());
        try {
            for (int r = 0; r < 20; ++r) {
                if (!conn.isOpen()) {
                    this.client.connect(host, conn);
                }
                BasicHttpEntityEnclosingRequest post = new BasicHttpEntityEnclosingRequest("POST", "/");
                byte[] data = (byte[])testData.get(r);
                ByteArrayEntity outgoing = new ByteArrayEntity(data);
                outgoing.setChunked(true);
                post.setEntity((HttpEntity)outgoing);
                HttpResponse response = this.client.execute((HttpRequest)post, host, (HttpClientConnection)conn);
                byte[] received = EntityUtils.toByteArray((HttpEntity)response.getEntity());
                byte[] expected = (byte[])testData.get(r);
                Assert.assertEquals((long)expected.length, (long)received.length);
                for (int i = 0; i < expected.length; ++i) {
                    Assert.assertEquals((long)expected[i], (long)received[i]);
                }
                if (this.client.keepAlive(response)) continue;
                conn.close();
            }
            HttpConnectionMetrics cm = conn.getMetrics();
            Assert.assertEquals((long)20L, (long)cm.getRequestCount());
            Assert.assertEquals((long)20L, (long)cm.getResponseCount());
        }
        finally {
            conn.close();
            this.server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHttpPostsWithExpectationVerification() throws Exception {
        int reqNo = 3;
        this.server.registerHandler("*", new HttpRequestHandler(){

            public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
                StringEntity outgoing = new StringEntity("No content");
                response.setEntity((HttpEntity)outgoing);
            }
        });
        this.server.setExpectationVerifier(new HttpExpectationVerifier(){

            public void verify(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException {
                Header someheader = request.getFirstHeader("Secret");
                if (someheader != null) {
                    int secretNumber;
                    try {
                        secretNumber = Integer.parseInt(someheader.getValue());
                    }
                    catch (NumberFormatException ex) {
                        response.setStatusCode(400);
                        return;
                    }
                    if (secretNumber < 2) {
                        response.setStatusCode(417);
                        ByteArrayEntity outgoing = new ByteArrayEntity(EncodingUtils.getAsciiBytes((String)"Wrong secret number"));
                        response.setEntity((HttpEntity)outgoing);
                    }
                }
            }
        });
        this.server.start();
        DefaultBHttpClientConnection conn = this.client.createConnection();
        HttpHost host = new HttpHost("localhost", this.server.getPort());
        try {
            for (int r = 0; r < 3; ++r) {
                if (!conn.isOpen()) {
                    this.client.connect(host, conn);
                }
                BasicHttpEntityEnclosingRequest post = new BasicHttpEntityEnclosingRequest("POST", "/");
                post.addHeader("Secret", Integer.toString(r));
                ByteArrayEntity outgoing = new ByteArrayEntity(EncodingUtils.getAsciiBytes((String)("No content " + r)));
                post.setEntity((HttpEntity)outgoing);
                HttpResponse response = this.client.execute((HttpRequest)post, host, (HttpClientConnection)conn);
                HttpEntity entity = response.getEntity();
                Assert.assertNotNull((Object)entity);
                EntityUtils.consume((HttpEntity)entity);
                if (r < 2) {
                    Assert.assertEquals((long)417L, (long)response.getStatusLine().getStatusCode());
                } else {
                    Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
                }
                if (this.client.keepAlive(response)) continue;
                conn.close();
            }
            HttpConnectionMetrics cm = conn.getMetrics();
            Assert.assertEquals((long)3L, (long)cm.getRequestCount());
            Assert.assertEquals((long)3L, (long)cm.getResponseCount());
        }
        finally {
            conn.close();
            this.server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHttpContent() throws Exception {
        String[] patterns = new String[]{"0123456789ABCDEF", "yadayada-blahblah-this-and-that-yadayada-blahblah-this-and-that-yadayada-blahblah-this-and-that-yadayada-blahblah-this-and-that-yadayada-blahblah-this-and-that-yadayada-blahblah-this-and-that-yadayada-blahblah-this-and-that-yadayada-blahblah-this-and-that-yadayada-blahblah-this-and-that-yadayada-blahblah-this-and-that-yadayada-blahblah-this-and-that-yadayada-blahblah-this-and-that-yadayada-blahblah-this-and-that-yadayada-blahblah-this-and-that-yadayada-blahblah-this-and-that-yadayada-blahblah-this-and-that-yadayada-blahblah-this-and-that-yadayada-blahblah-this-and-that-yadayada-blahblah-this-and-that-yadayada-blahblah-this-and-that-yadayada-blahblah-this-and-that-yadayada-blahblah-this-and-that-yadayada-blahblah-this-and-that-yadayada-blahblah-this-and-that-yadayada-blahblah-this-and-that-yadayada-blahblah-this-and-that-yadayada-blahblah-this-and-that-yadayada-blahblah-this-and-that-yadayada-blahblah-this-and-that-yadayada-blahblah-this-and-that"};
        this.server.registerHandler("*", new HttpRequestHandler(){

            public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
                Charset charset;
                String line;
                int n;
                if (request instanceof HttpEntityEnclosingRequest) {
                    n = 1;
                    String s = request.getRequestLine().getUri();
                    if (s.startsWith("/?n=")) {
                        s = s.substring(4);
                        try {
                            n = Integer.parseInt(s);
                            if (n <= 0) {
                                throw new HttpException("Invalid request: number of repetitions cannot be negative or zero");
                            }
                        }
                        catch (NumberFormatException ex) {
                            throw new HttpException("Invalid request: number of repetitions is invalid");
                        }
                    }
                    HttpEntity incoming = ((HttpEntityEnclosingRequest)request).getEntity();
                    line = EntityUtils.toString((HttpEntity)incoming);
                    ContentType contentType = ContentType.getOrDefault((HttpEntity)incoming);
                    charset = contentType.getCharset();
                    if (charset == null) {
                        charset = HTTP.DEF_CONTENT_CHARSET;
                    }
                } else {
                    throw new HttpException("Invalid request: POST request expected");
                }
                RepeatingEntity outgoing = new RepeatingEntity(line, charset, n);
                outgoing.setChunked(n % 2 == 0);
                response.setEntity((HttpEntity)outgoing);
            }
        });
        this.server.start();
        DefaultBHttpClientConnection conn = this.client.createConnection();
        HttpHost host = new HttpHost("localhost", this.server.getPort());
        try {
            for (String pattern : patterns) {
                for (int n = 1000; n < 1020; ++n) {
                    String line;
                    if (!conn.isOpen()) {
                        this.client.connect(host, conn);
                    }
                    BasicHttpEntityEnclosingRequest post = new BasicHttpEntityEnclosingRequest("POST", "/?n=" + n);
                    StringEntity outgoing = new StringEntity(pattern);
                    outgoing.setChunked(n % 2 == 0);
                    post.setEntity((HttpEntity)outgoing);
                    HttpResponse response = this.client.execute((HttpRequest)post, host, (HttpClientConnection)conn);
                    HttpEntity incoming = response.getEntity();
                    Assert.assertNotNull((Object)incoming);
                    InputStream inStream = incoming.getContent();
                    ContentType contentType = ContentType.getOrDefault((HttpEntity)incoming);
                    Charset charset = contentType.getCharset();
                    if (charset == null) {
                        charset = HTTP.DEF_CONTENT_CHARSET;
                    }
                    Assert.assertNotNull((Object)inStream);
                    BufferedReader reader = new BufferedReader(new InputStreamReader(inStream, charset));
                    int count = 0;
                    while ((line = reader.readLine()) != null) {
                        Assert.assertEquals((Object)pattern, (Object)line);
                        ++count;
                    }
                    Assert.assertEquals((long)n, (long)count);
                    if (this.client.keepAlive(response)) continue;
                    conn.close();
                }
            }
        }
        finally {
            conn.close();
            this.server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHttpPostNoEntity() throws Exception {
        this.server.registerHandler("*", new HttpRequestHandler(){

            public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
                if (request instanceof HttpEntityEnclosingRequest) {
                    HttpEntity incoming = ((HttpEntityEnclosingRequest)request).getEntity();
                    byte[] data = EntityUtils.toByteArray((HttpEntity)incoming);
                    ByteArrayEntity outgoing = new ByteArrayEntity(data);
                    response.setEntity((HttpEntity)outgoing);
                } else {
                    StringEntity outgoing = new StringEntity("No content");
                    response.setEntity((HttpEntity)outgoing);
                }
            }
        });
        this.server.start();
        DefaultBHttpClientConnection conn = this.client.createConnection();
        HttpHost host = new HttpHost("localhost", this.server.getPort());
        try {
            if (!conn.isOpen()) {
                this.client.connect(host, conn);
            }
            BasicHttpEntityEnclosingRequest post = new BasicHttpEntityEnclosingRequest("POST", "/");
            post.setEntity(null);
            HttpResponse response = this.client.execute((HttpRequest)post, host, (HttpClientConnection)conn);
            Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
            byte[] received = EntityUtils.toByteArray((HttpEntity)response.getEntity());
            Assert.assertEquals((long)0L, (long)received.length);
        }
        finally {
            conn.close();
            this.server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHttpPostNoContentLength() throws Exception {
        this.server.registerHandler("*", new HttpRequestHandler(){

            public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
                if (request instanceof HttpEntityEnclosingRequest) {
                    HttpEntity incoming = ((HttpEntityEnclosingRequest)request).getEntity();
                    byte[] data = EntityUtils.toByteArray((HttpEntity)incoming);
                    ByteArrayEntity outgoing = new ByteArrayEntity(data);
                    response.setEntity((HttpEntity)outgoing);
                } else {
                    StringEntity outgoing = new StringEntity("No content");
                    response.setEntity((HttpEntity)outgoing);
                }
            }
        });
        this.server.start();
        DefaultBHttpClientConnection conn = this.client.createConnection();
        HttpHost host = new HttpHost("localhost", this.server.getPort());
        try {
            if (!conn.isOpen()) {
                this.client.connect(host, conn);
            }
            BasicHttpEntityEnclosingRequest post = new BasicHttpEntityEnclosingRequest("POST", "/");
            post.setEntity(null);
            this.client = new HttpClient((HttpProcessor)new ImmutableHttpProcessor(new HttpRequestInterceptor[]{new RequestTargetHost(), new RequestConnControl(), new RequestUserAgent(), new RequestExpectContinue(true)}));
            HttpResponse response = this.client.execute((HttpRequest)post, host, (HttpClientConnection)conn);
            Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
            byte[] received = EntityUtils.toByteArray((HttpEntity)response.getEntity());
            Assert.assertEquals((long)0L, (long)received.length);
        }
        finally {
            conn.close();
            this.server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHttpPostIdentity() throws Exception {
        this.server.registerHandler("*", new HttpRequestHandler(){

            public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
                if (request instanceof HttpEntityEnclosingRequest) {
                    HttpEntity incoming = ((HttpEntityEnclosingRequest)request).getEntity();
                    byte[] data = EntityUtils.toByteArray((HttpEntity)incoming);
                    ByteArrayEntity outgoing = new ByteArrayEntity(data);
                    response.setEntity((HttpEntity)outgoing);
                } else {
                    StringEntity outgoing = new StringEntity("No content");
                    response.setEntity((HttpEntity)outgoing);
                }
            }
        });
        this.server.start();
        DefaultBHttpClientConnection conn = this.client.createConnection();
        HttpHost host = new HttpHost("localhost", this.server.getPort());
        try {
            if (!conn.isOpen()) {
                this.client.connect(host, conn);
            }
            BasicHttpEntityEnclosingRequest post = new BasicHttpEntityEnclosingRequest("POST", "/");
            post.setEntity(null);
            this.client = new HttpClient((HttpProcessor)new ImmutableHttpProcessor(new HttpRequestInterceptor[]{new HttpRequestInterceptor(){

                public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
                    request.addHeader("Transfer-Encoding", "identity");
                }
            }, new RequestTargetHost(), new RequestConnControl(), new RequestUserAgent(), new RequestExpectContinue(true)}));
            HttpResponse response = this.client.execute((HttpRequest)post, host, (HttpClientConnection)conn);
            Assert.assertEquals((long)400L, (long)response.getStatusLine().getStatusCode());
        }
        finally {
            conn.close();
            this.server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoContentResponse() throws Exception {
        int reqNo = 20;
        this.server.registerHandler("*", new HttpRequestHandler(){

            public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
                response.setStatusCode(204);
            }
        });
        this.server.start();
        DefaultBHttpClientConnection conn = this.client.createConnection();
        HttpHost host = new HttpHost("localhost", this.server.getPort());
        try {
            for (int r = 0; r < 20; ++r) {
                if (!conn.isOpen()) {
                    this.client.connect(host, conn);
                }
                BasicHttpRequest get = new BasicHttpRequest("GET", "/?" + r);
                HttpResponse response = this.client.execute((HttpRequest)get, host, (HttpClientConnection)conn);
                Assert.assertNull((Object)response.getEntity());
                if (this.client.keepAlive(response)) continue;
                conn.close();
                Assert.fail((String)"Connection expected to be re-usable");
            }
            HttpConnectionMetrics cm = conn.getMetrics();
            Assert.assertEquals((long)20L, (long)cm.getRequestCount());
            Assert.assertEquals((long)20L, (long)cm.getResponseCount());
        }
        finally {
            conn.close();
            this.server.shutdown();
        }
    }

    static class RepeatingEntity
    extends AbstractHttpEntity {
        private final byte[] raw;
        private final int n;

        public RepeatingEntity(String content, Charset charset, int n) {
            Charset cs = charset != null ? charset : Charset.forName("US-ASCII");
            byte[] b = content.getBytes(cs);
            this.raw = b;
            this.n = n;
        }

        public InputStream getContent() throws IOException, IllegalStateException {
            throw new IllegalStateException("This method is not implemented");
        }

        public long getContentLength() {
            return (this.raw.length + 2) * this.n;
        }

        public boolean isRepeatable() {
            return true;
        }

        public boolean isStreaming() {
            return false;
        }

        public void writeTo(OutputStream outStream) throws IOException {
            for (int i = 0; i < this.n; ++i) {
                outStream.write(this.raw);
                outStream.write(13);
                outStream.write(10);
            }
            outStream.flush();
        }
    }
}

