/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.message;

import java.util.NoSuchElementException;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHeaderIterator;
import org.junit.Assert;
import org.junit.Test;

public class TestBasicHeaderIterator {
    @Test
    public void testAllSame() {
        Header[] headers = new Header[]{new BasicHeader("Name", "value0"), new BasicHeader("nAme", "value1, value1.1"), new BasicHeader("naMe", "value2=whatever"), new BasicHeader("namE", "value3;tag=nil")};
        BasicHeaderIterator hit = new BasicHeaderIterator(headers, null);
        Assert.assertTrue((boolean)hit.hasNext());
        Assert.assertEquals((String)"0", (Object)headers[0], (Object)hit.nextHeader());
        Assert.assertTrue((boolean)hit.hasNext());
        Assert.assertEquals((String)"1", (Object)headers[1], (Object)hit.nextHeader());
        Assert.assertTrue((boolean)hit.hasNext());
        Assert.assertEquals((String)"2", (Object)headers[2], (Object)hit.nextHeader());
        Assert.assertTrue((boolean)hit.hasNext());
        Assert.assertEquals((String)"3", (Object)headers[3], (Object)hit.nextHeader());
        Assert.assertFalse((boolean)hit.hasNext());
        hit = new BasicHeaderIterator(headers, "name");
        Assert.assertTrue((boolean)hit.hasNext());
        Assert.assertEquals((String)"0", (Object)headers[0], (Object)hit.nextHeader());
        Assert.assertTrue((boolean)hit.hasNext());
        Assert.assertEquals((String)"1", (Object)headers[1], (Object)hit.nextHeader());
        Assert.assertTrue((boolean)hit.hasNext());
        Assert.assertEquals((String)"2", (Object)headers[2], (Object)hit.nextHeader());
        Assert.assertTrue((boolean)hit.hasNext());
        Assert.assertEquals((String)"3", (Object)headers[3], (Object)hit.nextHeader());
        Assert.assertFalse((boolean)hit.hasNext());
    }

    @Test
    public void testFirstLastOneNone() {
        Header[] headers = new Header[]{new BasicHeader("match", "value0"), new BasicHeader("mismatch", "value1, value1.1"), new BasicHeader("single", "value2=whatever"), new BasicHeader("match", "value3;tag=nil")};
        BasicHeaderIterator hit = new BasicHeaderIterator(headers, null);
        Assert.assertTrue((boolean)hit.hasNext());
        Assert.assertEquals((String)"0", (Object)headers[0], (Object)hit.nextHeader());
        Assert.assertTrue((boolean)hit.hasNext());
        Assert.assertEquals((String)"1", (Object)headers[1], (Object)hit.nextHeader());
        Assert.assertTrue((boolean)hit.hasNext());
        Assert.assertEquals((String)"2", (Object)headers[2], (Object)hit.nextHeader());
        Assert.assertTrue((boolean)hit.hasNext());
        Assert.assertEquals((String)"3", (Object)headers[3], (Object)hit.nextHeader());
        Assert.assertFalse((boolean)hit.hasNext());
        hit = new BasicHeaderIterator(headers, "match");
        Assert.assertTrue((boolean)hit.hasNext());
        Assert.assertEquals((String)"0", (Object)headers[0], (Object)hit.nextHeader());
        Assert.assertTrue((boolean)hit.hasNext());
        Assert.assertEquals((String)"3", (Object)headers[3], (Object)hit.nextHeader());
        Assert.assertFalse((boolean)hit.hasNext());
        hit = new BasicHeaderIterator(headers, "single");
        Assert.assertTrue((boolean)hit.hasNext());
        Assert.assertEquals((String)"2", (Object)headers[2], (Object)hit.nextHeader());
        Assert.assertFalse((boolean)hit.hasNext());
        hit = new BasicHeaderIterator(headers, "way-off");
        Assert.assertFalse((boolean)hit.hasNext());
    }

    @Test
    public void testInterspersed() {
        Header[] headers = new Header[]{new BasicHeader("yellow", "00"), new BasicHeader("maroon", "01"), new BasicHeader("orange", "02"), new BasicHeader("orange", "03"), new BasicHeader("orange", "04"), new BasicHeader("yellow", "05"), new BasicHeader("maroon", "06"), new BasicHeader("maroon", "07"), new BasicHeader("maroon", "08"), new BasicHeader("yellow", "09"), new BasicHeader("maroon", "0a"), new BasicHeader("yellow", "0b"), new BasicHeader("orange", "0c"), new BasicHeader("yellow", "0d"), new BasicHeader("orange", "0e")};
        BasicHeaderIterator hit = new BasicHeaderIterator(headers, null);
        Assert.assertTrue((boolean)hit.hasNext());
        Assert.assertEquals((String)"0", (Object)headers[0], (Object)hit.nextHeader());
        Assert.assertTrue((boolean)hit.hasNext());
        Assert.assertEquals((String)"1", (Object)headers[1], (Object)hit.nextHeader());
        Assert.assertTrue((boolean)hit.hasNext());
        Assert.assertEquals((String)"2", (Object)headers[2], (Object)hit.nextHeader());
        Assert.assertTrue((boolean)hit.hasNext());
        Assert.assertEquals((String)"3", (Object)headers[3], (Object)hit.nextHeader());
        Assert.assertTrue((boolean)hit.hasNext());
        Assert.assertEquals((String)"4", (Object)headers[4], (Object)hit.nextHeader());
        Assert.assertTrue((boolean)hit.hasNext());
        Assert.assertEquals((String)"5", (Object)headers[5], (Object)hit.nextHeader());
        Assert.assertTrue((boolean)hit.hasNext());
        Assert.assertEquals((String)"6", (Object)headers[6], (Object)hit.nextHeader());
        Assert.assertTrue((boolean)hit.hasNext());
        Assert.assertEquals((String)"7", (Object)headers[7], (Object)hit.nextHeader());
        Assert.assertTrue((boolean)hit.hasNext());
        Assert.assertEquals((String)"8", (Object)headers[8], (Object)hit.nextHeader());
        Assert.assertTrue((boolean)hit.hasNext());
        Assert.assertEquals((String)"9", (Object)headers[9], (Object)hit.nextHeader());
        Assert.assertTrue((boolean)hit.hasNext());
        Assert.assertEquals((String)"a", (Object)headers[10], (Object)hit.nextHeader());
        Assert.assertTrue((boolean)hit.hasNext());
        Assert.assertEquals((String)"b", (Object)headers[11], (Object)hit.nextHeader());
        Assert.assertTrue((boolean)hit.hasNext());
        Assert.assertEquals((String)"c", (Object)headers[12], (Object)hit.nextHeader());
        Assert.assertTrue((boolean)hit.hasNext());
        Assert.assertEquals((String)"d", (Object)headers[13], (Object)hit.nextHeader());
        Assert.assertTrue((boolean)hit.hasNext());
        Assert.assertEquals((String)"e", (Object)headers[14], (Object)hit.nextHeader());
        Assert.assertFalse((boolean)hit.hasNext());
        hit = new BasicHeaderIterator(headers, "Yellow");
        Assert.assertTrue((boolean)hit.hasNext());
        Assert.assertEquals((String)"0", (Object)headers[0], (Object)hit.nextHeader());
        Assert.assertTrue((boolean)hit.hasNext());
        Assert.assertEquals((String)"5", (Object)headers[5], (Object)hit.nextHeader());
        Assert.assertTrue((boolean)hit.hasNext());
        Assert.assertEquals((String)"9", (Object)headers[9], (Object)hit.nextHeader());
        Assert.assertTrue((boolean)hit.hasNext());
        Assert.assertEquals((String)"b", (Object)headers[11], (Object)hit.nextHeader());
        Assert.assertTrue((boolean)hit.hasNext());
        Assert.assertEquals((String)"d", (Object)headers[13], (Object)hit.nextHeader());
        Assert.assertFalse((boolean)hit.hasNext());
        hit = new BasicHeaderIterator(headers, "marOOn");
        Assert.assertTrue((boolean)hit.hasNext());
        Assert.assertEquals((String)"1", (Object)headers[1], (Object)hit.nextHeader());
        Assert.assertTrue((boolean)hit.hasNext());
        Assert.assertEquals((String)"6", (Object)headers[6], (Object)hit.nextHeader());
        Assert.assertTrue((boolean)hit.hasNext());
        Assert.assertEquals((String)"7", (Object)headers[7], (Object)hit.nextHeader());
        Assert.assertTrue((boolean)hit.hasNext());
        Assert.assertEquals((String)"8", (Object)headers[8], (Object)hit.nextHeader());
        Assert.assertTrue((boolean)hit.hasNext());
        Assert.assertEquals((String)"a", (Object)headers[10], (Object)hit.nextHeader());
        Assert.assertFalse((boolean)hit.hasNext());
        hit = new BasicHeaderIterator(headers, "OranGe");
        Assert.assertTrue((boolean)hit.hasNext());
        Assert.assertEquals((String)"2", (Object)headers[2], (Object)hit.nextHeader());
        Assert.assertTrue((boolean)hit.hasNext());
        Assert.assertEquals((String)"3", (Object)headers[3], (Object)hit.nextHeader());
        Assert.assertTrue((boolean)hit.hasNext());
        Assert.assertEquals((String)"4", (Object)headers[4], (Object)hit.nextHeader());
        Assert.assertTrue((boolean)hit.hasNext());
        Assert.assertEquals((String)"b", (Object)headers[12], (Object)hit.nextHeader());
        Assert.assertTrue((boolean)hit.hasNext());
        Assert.assertEquals((String)"e", (Object)headers[14], (Object)hit.nextHeader());
        Assert.assertFalse((boolean)hit.hasNext());
    }

    @Test
    public void testInvalid() {
        BasicHeaderIterator hit = null;
        try {
            hit = new BasicHeaderIterator(null, "whatever");
            Assert.fail((String)"null headers not detected");
        }
        catch (IllegalArgumentException iax) {
            // empty catch block
        }
        hit = new BasicHeaderIterator(new Header[0], "whatever");
        Assert.assertFalse((boolean)hit.hasNext());
        try {
            hit.nextHeader();
            Assert.fail((String)"next beyond end not detected");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testRemaining() {
        Header[] headers = new Header[]{new BasicHeader("Name", "value0"), new BasicHeader("nAme", "value1, value1.1"), new BasicHeader("naMe", "value2=whatever"), new BasicHeader("namE", "value3;tag=nil")};
        BasicHeaderIterator hit = new BasicHeaderIterator(headers, null);
        Assert.assertTrue((boolean)hit.hasNext());
        Assert.assertEquals((String)"0", (Object)headers[0], (Object)hit.next());
        Assert.assertTrue((boolean)hit.hasNext());
        Assert.assertEquals((String)"1", (Object)headers[1], (Object)hit.next());
        Assert.assertTrue((boolean)hit.hasNext());
        Assert.assertEquals((String)"2", (Object)headers[2], (Object)hit.next());
        Assert.assertTrue((boolean)hit.hasNext());
        Assert.assertEquals((String)"3", (Object)headers[3], (Object)hit.next());
        Assert.assertFalse((boolean)hit.hasNext());
        hit = new BasicHeaderIterator(headers, null);
        Assert.assertTrue((boolean)hit.hasNext());
        try {
            hit.remove();
            Assert.fail((String)"remove not detected");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        Assert.assertTrue((String)"no next", (hit.findNext(-3) < 0 ? 1 : 0) != 0);
    }
}

