/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.message;

import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.message.BasicStatusLine;
import org.junit.Assert;
import org.junit.Test;

public class TestBasicHttpResponse {
    @Test
    public void testBasics() {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        Assert.assertEquals((Object)HttpVersion.HTTP_1_1, (Object)response.getProtocolVersion());
        Assert.assertEquals((Object)HttpVersion.HTTP_1_1, (Object)response.getStatusLine().getProtocolVersion());
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        Assert.assertEquals((Object)"OK", (Object)response.getStatusLine().getReasonPhrase());
    }

    @Test
    public void testStatusLineMutation() {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        Assert.assertEquals((Object)HttpVersion.HTTP_1_1, (Object)response.getStatusLine().getProtocolVersion());
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        Assert.assertEquals((Object)"OK", (Object)response.getStatusLine().getReasonPhrase());
        response.setReasonPhrase("Kind of OK");
        Assert.assertEquals((Object)HttpVersion.HTTP_1_1, (Object)response.getStatusLine().getProtocolVersion());
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        Assert.assertEquals((Object)"Kind of OK", (Object)response.getStatusLine().getReasonPhrase());
        response.setStatusCode(299);
        Assert.assertEquals((Object)HttpVersion.HTTP_1_1, (Object)response.getStatusLine().getProtocolVersion());
        Assert.assertEquals((long)299L, (long)response.getStatusLine().getStatusCode());
        Assert.assertEquals(null, (Object)response.getStatusLine().getReasonPhrase());
        response.setStatusLine((ProtocolVersion)HttpVersion.HTTP_1_0, 298);
        Assert.assertEquals((Object)HttpVersion.HTTP_1_0, (Object)response.getStatusLine().getProtocolVersion());
        Assert.assertEquals((long)298L, (long)response.getStatusLine().getStatusCode());
        Assert.assertEquals(null, (Object)response.getStatusLine().getReasonPhrase());
        response.setStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        Assert.assertEquals((Object)HttpVersion.HTTP_1_1, (Object)response.getStatusLine().getProtocolVersion());
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        Assert.assertEquals((Object)"OK", (Object)response.getStatusLine().getReasonPhrase());
        response.setStatusLine((StatusLine)new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_0, 500, "Boom"));
        Assert.assertEquals((Object)HttpVersion.HTTP_1_0, (Object)response.getStatusLine().getProtocolVersion());
        Assert.assertEquals((long)500L, (long)response.getStatusLine().getStatusCode());
        Assert.assertEquals((Object)"Boom", (Object)response.getStatusLine().getReasonPhrase());
    }

    @Test
    public void testInvalidStatusCode() {
        try {
            new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, -200, "OK");
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        try {
            response.setStatusCode(-1);
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            response.setStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, -1);
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            response.setStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, -1, "not ok");
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

