/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.message;

import org.apache.http.HttpVersion;
import org.apache.http.ParseException;
import org.apache.http.RequestLine;
import org.apache.http.StatusLine;
import org.apache.http.message.BasicLineParser;
import org.apache.http.message.ParserCursor;
import org.apache.http.util.CharArrayBuffer;
import org.junit.Assert;
import org.junit.Test;

public class TestBasicLineParser {
    @Test
    public void testRLParseSuccess() throws Exception {
        RequestLine requestline = BasicLineParser.parseRequestLine((String)"GET /stuff HTTP/1.1", null);
        Assert.assertEquals((Object)"GET /stuff HTTP/1.1", (Object)requestline.toString());
        Assert.assertEquals((Object)"GET", (Object)requestline.getMethod());
        Assert.assertEquals((Object)"/stuff", (Object)requestline.getUri());
        Assert.assertEquals((Object)HttpVersion.HTTP_1_1, (Object)requestline.getProtocolVersion());
        requestline = BasicLineParser.parseRequestLine((String)"  GET    /stuff   HTTP/1.1   ", null);
        Assert.assertEquals((Object)"GET /stuff HTTP/1.1", (Object)requestline.toString());
        Assert.assertEquals((Object)"GET", (Object)requestline.getMethod());
        Assert.assertEquals((Object)"/stuff", (Object)requestline.getUri());
        Assert.assertEquals((Object)HttpVersion.HTTP_1_1, (Object)requestline.getProtocolVersion());
        requestline = BasicLineParser.parseRequestLine((String)"\rGET /stuff HTTP/1.1", null);
        Assert.assertEquals((Object)"GET", (Object)requestline.getMethod());
        Assert.assertEquals((Object)"/stuff", (Object)requestline.getUri());
        Assert.assertEquals((Object)HttpVersion.HTTP_1_1, (Object)requestline.getProtocolVersion());
    }

    @Test
    public void testRLParseFailure() throws Exception {
        try {
            BasicLineParser.parseRequestLine((String)"    ", null);
            Assert.fail();
        }
        catch (ParseException e) {
            // empty catch block
        }
        try {
            BasicLineParser.parseRequestLine((String)"  GET", null);
            Assert.fail();
        }
        catch (ParseException e) {
            // empty catch block
        }
        try {
            BasicLineParser.parseRequestLine((String)"GET /stuff", null);
            Assert.fail();
        }
        catch (ParseException e) {
            // empty catch block
        }
        try {
            BasicLineParser.parseRequestLine((String)"GET/stuff HTTP/1.1", null);
            Assert.fail();
        }
        catch (ParseException e) {
            // empty catch block
        }
        try {
            BasicLineParser.parseRequestLine((String)"GET /stuff HTTP/1.1 Oooooooooooppsie", null);
            Assert.fail();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    @Test
    public void testSLParseSuccess() throws Exception {
        StatusLine statusLine = BasicLineParser.parseStatusLine((String)"HTTP/1.1 200 OK", null);
        Assert.assertEquals((Object)"HTTP/1.1 200 OK", (Object)statusLine.toString());
        Assert.assertEquals((Object)HttpVersion.HTTP_1_1, (Object)statusLine.getProtocolVersion());
        Assert.assertEquals((long)200L, (long)statusLine.getStatusCode());
        Assert.assertEquals((Object)"OK", (Object)statusLine.getReasonPhrase());
        statusLine = BasicLineParser.parseStatusLine((String)"HTTP/1.1 404 Not Found", null);
        Assert.assertEquals((long)404L, (long)statusLine.getStatusCode());
        Assert.assertEquals((Object)"Not Found", (Object)statusLine.getReasonPhrase());
        statusLine = BasicLineParser.parseStatusLine((String)"HTTP/1.1 404 Non Trouve", null);
        Assert.assertEquals((Object)"Non Trouve", (Object)statusLine.getReasonPhrase());
        statusLine = BasicLineParser.parseStatusLine((String)"HTTP/1.1 404 Not Found\r\n", null);
        Assert.assertEquals((Object)"Not Found", (Object)statusLine.getReasonPhrase());
        statusLine = BasicLineParser.parseStatusLine((String)"HTTP/1.1 200 ", null);
        Assert.assertEquals((long)200L, (long)statusLine.getStatusCode());
        Assert.assertEquals((Object)"", (Object)statusLine.getReasonPhrase());
        statusLine = BasicLineParser.parseStatusLine((String)"HTTP/1.1 200", null);
        Assert.assertEquals((long)200L, (long)statusLine.getStatusCode());
        Assert.assertEquals((Object)"", (Object)statusLine.getReasonPhrase());
        statusLine = BasicLineParser.parseStatusLine((String)"HTTP/1.1     200 OK", null);
        Assert.assertEquals((long)200L, (long)statusLine.getStatusCode());
        Assert.assertEquals((Object)"OK", (Object)statusLine.getReasonPhrase());
        statusLine = BasicLineParser.parseStatusLine((String)"\rHTTP/1.1 200 OK", null);
        Assert.assertEquals((long)200L, (long)statusLine.getStatusCode());
        Assert.assertEquals((Object)"OK", (Object)statusLine.getReasonPhrase());
        Assert.assertEquals((Object)HttpVersion.HTTP_1_1, (Object)statusLine.getProtocolVersion());
        statusLine = BasicLineParser.parseStatusLine((String)"  HTTP/1.1 200 OK", null);
        Assert.assertEquals((long)200L, (long)statusLine.getStatusCode());
        Assert.assertEquals((Object)"OK", (Object)statusLine.getReasonPhrase());
        Assert.assertEquals((Object)HttpVersion.HTTP_1_1, (Object)statusLine.getProtocolVersion());
    }

    @Test
    public void testSLParseFailure() throws Exception {
        try {
            BasicLineParser.parseStatusLine((String)"xxx 200 OK", null);
            Assert.fail();
        }
        catch (ParseException e) {
            // empty catch block
        }
        try {
            BasicLineParser.parseStatusLine((String)"HTTP/1.1 xxx OK", null);
            Assert.fail();
        }
        catch (ParseException e) {
            // empty catch block
        }
        try {
            BasicLineParser.parseStatusLine((String)"HTTP/1.1    ", null);
            Assert.fail();
        }
        catch (ParseException e) {
            // empty catch block
        }
        try {
            BasicLineParser.parseStatusLine((String)"HTTP/1.1", null);
            Assert.fail();
        }
        catch (ParseException e) {
            // empty catch block
        }
        try {
            BasicLineParser.parseStatusLine((String)"HTTP/1.1 -200 OK", null);
            Assert.fail();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    @Test
    public void testHttpVersionParsing() throws Exception {
        String s = "HTTP/1.1";
        HttpVersion version = (HttpVersion)BasicLineParser.parseProtocolVersion((String)s, null);
        Assert.assertEquals((String)"HTTP protocol name", (Object)"HTTP", (Object)version.getProtocol());
        Assert.assertEquals((String)"HTTP major version number", (long)1L, (long)version.getMajor());
        Assert.assertEquals((String)"HTTP minor version number", (long)1L, (long)version.getMinor());
        Assert.assertEquals((String)"HTTP version number", (Object)s, (Object)version.toString());
        s = "HTTP/123.4567";
        version = (HttpVersion)BasicLineParser.parseProtocolVersion((String)s, null);
        Assert.assertEquals((String)"HTTP protocol name", (Object)"HTTP", (Object)version.getProtocol());
        Assert.assertEquals((String)"HTTP major version number", (long)123L, (long)version.getMajor());
        Assert.assertEquals((String)"HTTP minor version number", (long)4567L, (long)version.getMinor());
        Assert.assertEquals((String)"HTTP version number", (Object)s, (Object)version.toString());
    }

    @Test
    public void testHttpVersionParsingUsingCursor() throws Exception {
        String s = "HTTP/1.1";
        CharArrayBuffer buffer = new CharArrayBuffer(16);
        buffer.append(s);
        ParserCursor cursor = new ParserCursor(0, s.length());
        BasicLineParser parser = BasicLineParser.INSTANCE;
        HttpVersion version = (HttpVersion)parser.parseProtocolVersion(buffer, cursor);
        Assert.assertEquals((String)"HTTP protocol name", (Object)"HTTP", (Object)version.getProtocol());
        Assert.assertEquals((String)"HTTP major version number", (long)1L, (long)version.getMajor());
        Assert.assertEquals((String)"HTTP minor version number", (long)1L, (long)version.getMinor());
        Assert.assertEquals((String)"HTTP version number", (Object)"HTTP/1.1", (Object)version.toString());
        Assert.assertEquals((long)s.length(), (long)cursor.getPos());
        Assert.assertTrue((boolean)cursor.atEnd());
        s = "HTTP/1.123 123";
        buffer = new CharArrayBuffer(16);
        buffer.append(s);
        cursor = new ParserCursor(0, s.length());
        version = (HttpVersion)parser.parseProtocolVersion(buffer, cursor);
        Assert.assertEquals((String)"HTTP protocol name", (Object)"HTTP", (Object)version.getProtocol());
        Assert.assertEquals((String)"HTTP major version number", (long)1L, (long)version.getMajor());
        Assert.assertEquals((String)"HTTP minor version number", (long)123L, (long)version.getMinor());
        Assert.assertEquals((String)"HTTP version number", (Object)"HTTP/1.123", (Object)version.toString());
        Assert.assertEquals((long)32L, (long)buffer.charAt(cursor.getPos()));
        Assert.assertEquals((long)(s.length() - 4), (long)cursor.getPos());
        Assert.assertFalse((boolean)cursor.atEnd());
    }

    @Test
    public void testInvalidHttpVersionParsing() throws Exception {
        try {
            BasicLineParser.parseProtocolVersion((String)null, null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            BasicLineParser.parseProtocolVersion((String)"    ", null);
            Assert.fail((String)"ParseException should have been thrown");
        }
        catch (ParseException e) {
            // empty catch block
        }
        try {
            BasicLineParser.parseProtocolVersion((String)"HTT", null);
            Assert.fail((String)"ParseException should have been thrown");
        }
        catch (ParseException e) {
            // empty catch block
        }
        try {
            BasicLineParser.parseProtocolVersion((String)"crap", null);
            Assert.fail((String)"ParseException should have been thrown");
        }
        catch (ParseException e) {
            // empty catch block
        }
        try {
            BasicLineParser.parseProtocolVersion((String)"HTTP/crap", null);
            Assert.fail((String)"ParseException should have been thrown");
        }
        catch (ParseException e) {
            // empty catch block
        }
        try {
            BasicLineParser.parseProtocolVersion((String)"HTTP/1", null);
            Assert.fail((String)"ParseException should have been thrown");
        }
        catch (ParseException e) {
            // empty catch block
        }
        try {
            BasicLineParser.parseProtocolVersion((String)"HTTP/1234   ", null);
            Assert.fail((String)"ParseException should have been thrown");
        }
        catch (ParseException e) {
            // empty catch block
        }
        try {
            BasicLineParser.parseProtocolVersion((String)"HTTP/1.", null);
            Assert.fail((String)"ParseException should have been thrown");
        }
        catch (ParseException e) {
            // empty catch block
        }
        try {
            BasicLineParser.parseProtocolVersion((String)"HTTP/whatever.whatever whatever", null);
            Assert.fail((String)"ParseException should have been thrown");
        }
        catch (ParseException e) {
            // empty catch block
        }
        try {
            BasicLineParser.parseProtocolVersion((String)"HTTP/1.whatever whatever", null);
            Assert.fail((String)"ParseException should have been thrown");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }
}

