/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.message;

import java.util.NoSuchElementException;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.ParseException;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHeaderIterator;
import org.apache.http.message.BasicTokenIterator;
import org.junit.Assert;
import org.junit.Test;

public class TestBasicTokenIterator {
    @Test
    public void testSingleHeader() {
        Header[] headers = new Header[]{new BasicHeader("Name", "token0,token1, token2 , token3")};
        BasicHeaderIterator hit = new BasicHeaderIterator(headers, null);
        BasicTokenIterator ti = new BasicTokenIterator((HeaderIterator)hit);
        Assert.assertTrue((boolean)ti.hasNext());
        Assert.assertEquals((String)"token0", (Object)"token0", (Object)ti.nextToken());
        Assert.assertTrue((boolean)ti.hasNext());
        Assert.assertEquals((String)"token1", (Object)"token1", (Object)ti.nextToken());
        Assert.assertTrue((boolean)ti.hasNext());
        Assert.assertEquals((String)"token2", (Object)"token2", (Object)ti.nextToken());
        Assert.assertTrue((boolean)ti.hasNext());
        Assert.assertEquals((String)"token3", (Object)"token3", (Object)ti.nextToken());
        Assert.assertFalse((boolean)ti.hasNext());
        headers = new Header[]{new BasicHeader("Name", "token0")};
        hit = new BasicHeaderIterator(headers, null);
        ti = new BasicTokenIterator((HeaderIterator)hit);
        Assert.assertTrue((boolean)ti.hasNext());
        Assert.assertEquals((String)"token0", (Object)"token0", (Object)ti.nextToken());
        Assert.assertFalse((boolean)ti.hasNext());
    }

    @Test
    public void testMultiHeader() {
        Header[] headers = new Header[]{new BasicHeader("Name", "token0,token1"), new BasicHeader("Name", ""), new BasicHeader("Name", "token2"), new BasicHeader("Name", " "), new BasicHeader("Name", "token3 "), new BasicHeader("Name", ","), new BasicHeader("Name", "token4")};
        BasicHeaderIterator hit = new BasicHeaderIterator(headers, null);
        BasicTokenIterator ti = new BasicTokenIterator((HeaderIterator)hit);
        Assert.assertTrue((boolean)ti.hasNext());
        Assert.assertEquals((String)"token0", (Object)"token0", (Object)ti.nextToken());
        Assert.assertTrue((boolean)ti.hasNext());
        Assert.assertEquals((String)"token1", (Object)"token1", (Object)ti.nextToken());
        Assert.assertTrue((boolean)ti.hasNext());
        Assert.assertEquals((String)"token2", (Object)"token2", (Object)ti.nextToken());
        Assert.assertTrue((boolean)ti.hasNext());
        Assert.assertEquals((String)"token3", (Object)"token3", (Object)ti.nextToken());
        Assert.assertTrue((boolean)ti.hasNext());
        Assert.assertEquals((String)"token4", (Object)"token4", (Object)ti.nextToken());
        Assert.assertFalse((boolean)ti.hasNext());
    }

    @Test
    public void testEmpty() {
        Header[] headers = new Header[]{new BasicHeader("Name", " "), new BasicHeader("Name", ""), new BasicHeader("Name", ","), new BasicHeader("Name", " ,, ")};
        BasicHeaderIterator hit = new BasicHeaderIterator(headers, null);
        BasicTokenIterator ti = new BasicTokenIterator((HeaderIterator)hit);
        Assert.assertFalse((boolean)ti.hasNext());
        hit = new BasicHeaderIterator(headers, "empty");
        ti = new BasicTokenIterator((HeaderIterator)hit);
        Assert.assertFalse((boolean)ti.hasNext());
    }

    @Test
    public void testValueStart() {
        Header[] headers = new Header[]{new BasicHeader("Name", "token0"), new BasicHeader("Name", " token1"), new BasicHeader("Name", ",token2"), new BasicHeader("Name", " ,token3"), new BasicHeader("Name", ", token4"), new BasicHeader("Name", " , token5")};
        BasicHeaderIterator hit = new BasicHeaderIterator(headers, null);
        BasicTokenIterator ti = new BasicTokenIterator((HeaderIterator)hit);
        Assert.assertTrue((boolean)ti.hasNext());
        Assert.assertEquals((String)"token0", (Object)"token0", (Object)ti.nextToken());
        Assert.assertTrue((boolean)ti.hasNext());
        Assert.assertEquals((String)"token1", (Object)"token1", (Object)ti.nextToken());
        Assert.assertTrue((boolean)ti.hasNext());
        Assert.assertEquals((String)"token2", (Object)"token2", (Object)ti.nextToken());
        Assert.assertTrue((boolean)ti.hasNext());
        Assert.assertEquals((String)"token3", (Object)"token3", (Object)ti.nextToken());
        Assert.assertTrue((boolean)ti.hasNext());
        Assert.assertEquals((String)"token4", (Object)"token4", (Object)ti.nextToken());
        Assert.assertTrue((boolean)ti.hasNext());
        Assert.assertEquals((String)"token5", (Object)"token5", (Object)ti.nextToken());
        Assert.assertFalse((boolean)ti.hasNext());
    }

    @Test
    public void testValueEnd() {
        Header[] headers = new Header[]{new BasicHeader("Name", "token0"), new BasicHeader("Name", "token1 "), new BasicHeader("Name", "token2,"), new BasicHeader("Name", "token3 ,"), new BasicHeader("Name", "token4, "), new BasicHeader("Name", "token5 , ")};
        BasicHeaderIterator hit = new BasicHeaderIterator(headers, null);
        BasicTokenIterator ti = new BasicTokenIterator((HeaderIterator)hit);
        Assert.assertTrue((boolean)ti.hasNext());
        Assert.assertEquals((String)"token0", (Object)"token0", (Object)ti.nextToken());
        Assert.assertTrue((boolean)ti.hasNext());
        Assert.assertEquals((String)"token1", (Object)"token1", (Object)ti.nextToken());
        Assert.assertTrue((boolean)ti.hasNext());
        Assert.assertEquals((String)"token2", (Object)"token2", (Object)ti.nextToken());
        Assert.assertTrue((boolean)ti.hasNext());
        Assert.assertEquals((String)"token3", (Object)"token3", (Object)ti.nextToken());
        Assert.assertTrue((boolean)ti.hasNext());
        Assert.assertEquals((String)"token4", (Object)"token4", (Object)ti.nextToken());
        Assert.assertTrue((boolean)ti.hasNext());
        Assert.assertEquals((String)"token5", (Object)"token5", (Object)ti.nextToken());
        Assert.assertFalse((boolean)ti.hasNext());
    }

    @Test
    public void testTokenChar() {
        Header[] headers = new Header[]{new BasicHeader("Name", "token0")};
        BasicHeaderIterator hit = new BasicHeaderIterator(headers, null);
        BasicTokenIterator bti = new BasicTokenIterator((HeaderIterator)hit);
        Assert.assertTrue((String)"letter", (boolean)bti.isTokenChar('j'));
        Assert.assertFalse((String)"control", (boolean)bti.isTokenChar('\b'));
        Assert.assertFalse((String)"separator", (boolean)bti.isTokenChar('?'));
        Assert.assertTrue((String)"other", (boolean)bti.isTokenChar('-'));
    }

    @Test
    public void testInvalid() {
        Header[] headers = new Header[]{new BasicHeader("in", "token0=token1"), new BasicHeader("no", "token0 token1"), new BasicHeader("pre", "<token0,token1"), new BasicHeader("post", "token0,token1=")};
        BasicHeaderIterator hit = new BasicHeaderIterator(headers, "in");
        BasicTokenIterator ti = new BasicTokenIterator((HeaderIterator)hit);
        Assert.assertTrue((boolean)ti.hasNext());
        try {
            ti.nextToken();
            Assert.fail((String)"invalid infix character not detected");
        }
        catch (ParseException px) {
            // empty catch block
        }
        hit = new BasicHeaderIterator(headers, "no");
        ti = new BasicTokenIterator((HeaderIterator)hit);
        Assert.assertTrue((boolean)ti.hasNext());
        try {
            ti.nextToken();
            Assert.fail((String)"missing token separator not detected");
        }
        catch (ParseException px) {
            // empty catch block
        }
        hit = new BasicHeaderIterator(headers, "pre");
        try {
            new BasicTokenIterator((HeaderIterator)hit);
            Assert.fail((String)"invalid prefix character not detected");
        }
        catch (ParseException px) {
            // empty catch block
        }
        hit = new BasicHeaderIterator(headers, "post");
        ti = new BasicTokenIterator((HeaderIterator)hit);
        Assert.assertTrue((boolean)ti.hasNext());
        Assert.assertEquals((String)"token0", (Object)"token0", (Object)ti.nextToken());
        Assert.assertTrue((boolean)ti.hasNext());
        try {
            ti.nextToken();
            Assert.fail((String)"invalid postfix character not detected");
        }
        catch (ParseException px) {
            // empty catch block
        }
    }

    @Test
    public void testWrongPublic() {
        try {
            new BasicTokenIterator(null);
            Assert.fail((String)"null argument not detected");
        }
        catch (IllegalArgumentException iax) {
            // empty catch block
        }
        Header[] headers = new Header[]{new BasicHeader("Name", " "), new BasicHeader("Name", ""), new BasicHeader("Name", ","), new BasicHeader("Name", " ,, ")};
        BasicHeaderIterator hit = new BasicHeaderIterator(headers, null);
        BasicTokenIterator ti = new BasicTokenIterator((HeaderIterator)hit);
        try {
            ti.next();
            Assert.fail((String)"next after end not detected");
        }
        catch (NoSuchElementException nsx) {
            // empty catch block
        }
        try {
            ti.remove();
            Assert.fail((String)"unsupported remove not detected");
        }
        catch (UnsupportedOperationException uox) {
            // empty catch block
        }
    }

    @Test
    public void testWrongProtected() {
        Header[] headers = new Header[]{new BasicHeader("Name", "token1,token2")};
        BasicHeaderIterator hit = new BasicHeaderIterator(headers, null);
        BasicTokenIterator bti = new BasicTokenIterator((HeaderIterator)hit);
        try {
            bti.findTokenStart(-1);
            Assert.fail((String)"tokenStart: negative index not detected");
        }
        catch (IllegalArgumentException iax) {
            // empty catch block
        }
        try {
            bti.findTokenSeparator(-1);
            Assert.fail((String)"tokenSeparator: negative index not detected");
        }
        catch (IllegalArgumentException iax) {
            // empty catch block
        }
        try {
            bti.findTokenEnd(-1);
            Assert.fail((String)"tokenEnd: negative index not detected");
        }
        catch (IllegalArgumentException iax) {
            // empty catch block
        }
    }
}

