/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.message;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.http.HeaderElement;
import org.apache.http.message.BufferedHeader;
import org.apache.http.util.CharArrayBuffer;
import org.junit.Assert;
import org.junit.Test;

public class TestBufferedHeader {
    @Test
    public void testBasicConstructor() {
        CharArrayBuffer buf = new CharArrayBuffer(32);
        buf.append("name: value");
        BufferedHeader header = new BufferedHeader(buf);
        Assert.assertEquals((Object)"name", (Object)header.getName());
        Assert.assertEquals((Object)"value", (Object)header.getValue());
        Assert.assertSame((Object)buf, (Object)header.getBuffer());
        Assert.assertEquals((long)5L, (long)header.getValuePos());
    }

    @Test
    public void testInvalidName() {
        try {
            new BufferedHeader(null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testHeaderElements() {
        CharArrayBuffer buf = new CharArrayBuffer(32);
        buf.append("name: element1 = value1, element2; param1 = value1, element3");
        BufferedHeader header = new BufferedHeader(buf);
        HeaderElement[] elements = header.getElements();
        Assert.assertNotNull((Object)elements);
        Assert.assertEquals((long)3L, (long)elements.length);
        Assert.assertEquals((Object)"element1", (Object)elements[0].getName());
        Assert.assertEquals((Object)"value1", (Object)elements[0].getValue());
        Assert.assertEquals((Object)"element2", (Object)elements[1].getName());
        Assert.assertEquals(null, (Object)elements[1].getValue());
        Assert.assertEquals((Object)"element3", (Object)elements[2].getName());
        Assert.assertEquals(null, (Object)elements[2].getValue());
        Assert.assertEquals((long)1L, (long)elements[1].getParameters().length);
    }

    @Test
    public void testCloning() throws Exception {
        CharArrayBuffer buf = new CharArrayBuffer(32);
        buf.append("name: value");
        BufferedHeader orig = new BufferedHeader(buf);
        BufferedHeader clone = (BufferedHeader)orig.clone();
        Assert.assertEquals((Object)orig.getName(), (Object)clone.getName());
        Assert.assertEquals((Object)orig.getValue(), (Object)clone.getValue());
    }

    @Test
    public void testSerialization() throws Exception {
        CharArrayBuffer buf = new CharArrayBuffer(32);
        buf.append("name: value");
        BufferedHeader orig = new BufferedHeader(buf);
        ByteArrayOutputStream outbuffer = new ByteArrayOutputStream();
        ObjectOutputStream outStream = new ObjectOutputStream(outbuffer);
        outStream.writeObject(orig);
        outStream.close();
        byte[] raw = outbuffer.toByteArray();
        ByteArrayInputStream inBuffer = new ByteArrayInputStream(raw);
        ObjectInputStream inStream = new ObjectInputStream(inBuffer);
        BufferedHeader clone = (BufferedHeader)inStream.readObject();
        Assert.assertEquals((Object)orig.getName(), (Object)clone.getName());
        Assert.assertEquals((Object)orig.getValue(), (Object)clone.getValue());
    }
}

